/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import jdbc.sql.cli.oaclistmt;
import jdbc.sql.cli.oacliwarning;
import jdbc.sql.oaresultsetmetadata;
import jdbc.sql.oastatement;
import jdbc.sql.oautilobj;

public class oaresultset
extends oautilobj
implements ResultSet {
    private int _iWasNull = -1;
    private oaclistmt _oaCLIStmt;
    private oaresultsetmetadata _meta;
    private Hashtable _column_map = null;
    private oastatement _statement;
    private Connection _connection;

    protected oaresultset(oaclistmt oaclistmt2, Connection connection) {
        this(oaclistmt2, (oastatement)null);
        this._connection = connection;
    }

    protected oaresultset(oaclistmt oaclistmt2, oastatement oastatement2) {
        if (oaresultset.traceOn()) {
            oaresultset.trace("oaresultset(" + oaclistmt2 + "," + oastatement2 + ") called");
        }
        this._oaCLIStmt = oaclistmt2;
        this._meta = null;
        this._statement = oastatement2;
        if (oastatement2 != null) {
            this._connection = oastatement2._connection;
        }
        this._column_map = null;
        if (oaresultset.traceOn()) {
            oaresultset.trace("oaresultset() returns");
        }
    }

    private void throwErrorWhenClosed() throws SQLException {
        if (this._oaCLIStmt == null) {
            throw new SQLException("ResultSet closed", "08003", 0);
        }
        if (this._oaCLIStmt.isClosed() || this._connection.isClosed()) {
            throw new SQLException("Connection closed", "08003", 0);
        }
    }

    protected void CleanVarsForNextResultSet() {
        this._column_map = null;
    }

    public boolean next() throws SQLException {
        this.throwErrorWhenClosed();
        this._meta = null;
        return this._oaCLIStmt.nextLocked();
    }

    public void close() throws SQLException {
        if (this._oaCLIStmt != null && !this._oaCLIStmt.isClosed()) {
            if (this._meta != null) {
                this._meta.oaclose();
                this._meta = null;
            }
            if (this._statement == null) {
                this._oaCLIStmt.close();
            } else {
                this._oaCLIStmt.closeResultSet();
            }
            this._oaCLIStmt = null;
        }
    }

    public boolean wasNull() throws SQLException {
        this.throwErrorWhenClosed();
        boolean bl = this._iWasNull == -1 ? this._oaCLIStmt.wasNull() : this._iWasNull == 1;
        return bl;
    }

    public String getString(int n) throws SQLException {
        this.throwErrorWhenClosed();
        String string = this._oaCLIStmt.getString(n);
        this._iWasNull = string == null ? 1 : 0;
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this._oaCLIStmt.getString(n);
        int n2 = this._iWasNull = string == null ? 1 : 0;
        return string != null && !string.equals("") && !string.equals("0");
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getByte failed: " + numberFormatException.getMessage(), "22000", 0);
        }
    }

    public short getShort(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getLong failed: " + numberFormatException.getMessage(), "22000", 0);
        }
    }

    public float getFloat(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = -1;
        return this._oaCLIStmt.getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("getBigDecimal failed: " + numberFormatException.getMessage(), "22000", 0);
            }
            if (n2 < 0) {
                return bigDecimal;
            }
            try {
                return bigDecimal.setScale(n2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SQLException("getBigDecimal failed: " + arithmeticException.getMessage(), "22000", 0);
            }
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.throwErrorWhenClosed();
        byte[] byArray = this._oaCLIStmt.getBytes(n);
        int n2 = this._iWasNull = byArray == null ? 1 : 0;
        if (byArray == null) {
            return null;
        }
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = 1;
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = 1;
        return null;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._iWasNull = 1;
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), null);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getWarnings() called");
        }
        this.throwErrorWhenClosed();
        oacliwarning oacliwarning2 = this._oaCLIStmt.getWarnings();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getWarnings() return " + oacliwarning2);
        }
        return oacliwarning2;
    }

    public void clearWarnings() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("clearWarnings() called");
        }
        this.throwErrorWhenClosed();
        this._oaCLIStmt.clearWarnings();
        if (oaresultset.traceOn()) {
            oaresultset.trace("clearWarnings() return");
        }
    }

    public String getCursorName() throws SQLException {
        this.throwErrorWhenClosed();
        return this._oaCLIStmt.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwErrorWhenClosed();
        if (this._meta == null) {
            this._meta = new oaresultsetmetadata(this._oaCLIStmt, this._connection);
        }
        return this._meta;
    }

    public Object getObject(int n) throws SQLException {
        Comparable<Boolean> comparable;
        int n2 = this.getMetaData().getColumnType(n);
        switch (n2) {
            case -7: {
                comparable = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                comparable = new Integer(this.getByte(n));
                break;
            }
            case 5: {
                comparable = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                comparable = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                comparable = new Long(this.getLong(n));
                break;
            }
            case 7: {
                comparable = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                comparable = new Double(this.getDouble(n));
                break;
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n, null);
            }
            case 92: {
                return this.getTime(n, null);
            }
            case 93: {
                return this.getTimestamp(n, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            default: {
                throw new SQLException("Unsupported data type: " + n2, "22000", 0);
            }
        }
        return this.wasNull() ? null : comparable;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this._column_map == null) {
            oaresultset oaresultset2 = this;
            synchronized (oaresultset2) {
                if (this._column_map == null) {
                    ResultSetMetaData resultSetMetaData = this.getMetaData();
                    int n2 = resultSetMetaData.getColumnCount();
                    Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(n2);
                    for (int i = 0; i < n2; ++i) {
                        hashtable.put(resultSetMetaData.getColumnName(i + 1).toUpperCase(), new Integer(i + 1));
                    }
                    this._column_map = hashtable;
                }
            }
        }
        if ((n = (Integer)this._column_map.get(string.toUpperCase())) == null) {
            throw new SQLException("Invalid column name: " + string);
        }
        return n;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getCharacterStream(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getCharacterStream(int) is not yet supported.");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        this.throwErrorWhenClosed();
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), -1);
    }

    public boolean isBeforeFirst() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("isBeforeFirst() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("isBeforeFirst() is not yet supported.");
    }

    public boolean isAfterLast() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("isAfterLast() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("isAfterLast() is not yet supported.");
    }

    public boolean isFirst() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("isFirst() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("isFirst() is not yet supported.");
    }

    public boolean isLast() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("isLast() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("isLast() is not yet supported.");
    }

    public void beforeFirst() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("beforeFirst() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("beforeFirst() is not yet supported.");
    }

    public void afterLast() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("afterLast() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("afterLast() is not yet supported.");
    }

    public boolean first() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("first() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("first() is not yet supported.");
    }

    public boolean last() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("last() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("last() is not yet supported.");
    }

    public int getRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getRow() is not yet supported.");
    }

    public boolean absolute(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("absolute(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("absolute(int) is not yet supported.");
    }

    public boolean relative(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("relative(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("relative(int) is not yet supported.");
    }

    public boolean previous() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("previous() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("previous() is not yet supported.");
    }

    public void setFetchDirection(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("setFetchDirection(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("setFetchDirection(int) is not yet supported.");
    }

    public int getFetchDirection() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getFetchDirection() called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getFetchDirection() returns 1000");
        }
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("setFetchSize(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("setFetchSize() returns");
        }
    }

    public int getFetchSize() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getFetchSize() called");
        }
        this.throwErrorWhenClosed();
        int n = this._oaCLIStmt.getFetchSize();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getFetchSize() returns " + n);
        }
        return n;
    }

    public int getType() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getType() called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getType() returns 1003");
        }
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getConcurrency() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getConcurrency() is not yet supported.");
    }

    public boolean rowUpdated() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("rowUpdated() called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("rowUpdated() returns false");
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("rowInserted() called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("rowInserted() returns false");
        }
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("rowDeleted() called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("rowDeleted() returns false");
        }
        return false;
    }

    public void updateNull(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateNull() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateNull(int) is not yet supported.");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBoolean() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateBoolean(int,boolean) is not yet supported.");
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateByte(" + n + "," + by + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateByte(int,byte) is not yet supported.");
    }

    public void updateShort(int n, short s) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateShort(" + n + "," + s + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateShort(int,short) is not yet supported.");
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateInt(" + n + "," + n2 + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateInt(int,int) is not yet supported.");
    }

    public void updateLong(int n, long l) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateLong(" + n + "," + l + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateInt(int,long) is not yet supported.");
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateFloat(" + n + "," + f + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateFloat(int,float) is not yet supported.");
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateDouble(" + n + "," + d + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateFloat(int,double) is not yet supported.");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBigDecimal(" + n + "," + bigDecimal + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateBigDecimal(int,BigDecimal) is not yet supported.");
    }

    public void updateString(int n, String string) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateString(" + n + "," + string + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateString(int,String) is not yet supported.");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBytes(" + n + "," + byArray + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateBytes(int,byte[]) is not yet supported.");
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateDate(" + n + "," + date + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateDate(int,Date) is not yet supported.");
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateTime(" + n + "," + time + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateTime(int,Time) is not yet supported.");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateTimestamp(" + n + "," + timestamp + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateTimestamp(int,Timestamp) is not yet supported.");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateAsciiStream(" + n + "," + inputStream + "," + n2 + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateAsciiStream(int,InputStream,int) is not yet supported.");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBinaryStream(" + n + "," + inputStream + "," + n2 + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateBinaryStream(int,InputStream,int) is not yet supported.");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateCharacterStream(" + n + "," + reader + "," + n2 + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateCharacterStream(int,Reader,int) is not yet supported.");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateObject(" + n + "," + object + "," + n2 + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateObject(int,Object,int) is not yet supported.");
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateObject(" + n + "," + object + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateObject(int,Object) is not yet supported.");
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("insertRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("insertRow() is not yet supported.");
    }

    public void updateRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("updateRow() is not yet supported.");
    }

    public void deleteRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("deleteRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("deleteRow() is not yet supported.");
    }

    public void refreshRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("refreshRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("refreshRow() is not yet supported.");
    }

    public void cancelRowUpdates() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("cancelRowUpdates() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("cancelRowUpdates() is not yet supported.");
    }

    public void moveToInsertRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("moveToInsertRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("moveToInsertRow() is not yet supported.");
    }

    public void moveToCurrentRow() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("moveToCurrentRow() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("moveToCurrentRow() is not yet supported.");
    }

    public Statement getStatement() throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getStatement() called");
        }
        this.throwErrorWhenClosed();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getStatement() returns " + this._statement);
        }
        return this._statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getObject(" + n + "," + map + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getObject(int,Map) is not yet supported.");
    }

    public Ref getRef(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getRef(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getRef(int) is not yet supported.");
    }

    public Blob getBlob(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getBlob(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getBlob(int) is not yet supported.");
    }

    public Clob getClob(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getClob(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getClob(int) is not yet supported.");
    }

    public Array getArray(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getArray(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getArray(int) is not yet supported.");
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getBlob(" + string + ") called");
        }
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getClob(" + string + ") called");
        }
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getArray(" + string + ") called");
        }
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        int[] nArray = this._oaCLIStmt.getDate(n);
        int n2 = this._iWasNull = nArray == null ? 1 : 0;
        if (nArray != null) {
            calendar2.set(14, 0);
            calendar2.set(nArray[0], nArray[1] - 1, nArray[2], 0, 0, 0);
            long l = calendar2.getTime().getTime();
            Date date = new Date(l);
            return date;
        }
        return null;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        int[] nArray = this._oaCLIStmt.getTime(n);
        int n2 = this._iWasNull = nArray == null ? 1 : 0;
        if (nArray != null) {
            calendar2.set(14, 0);
            calendar2.set(1970, 0, 1, nArray[0], nArray[1], nArray[2]);
            long l = calendar2.getTime().getTime();
            Time time = new Time(l);
            return time;
        }
        return null;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        int[] nArray = this._oaCLIStmt.getTimestamp(n);
        int n2 = this._iWasNull = nArray == null ? 1 : 0;
        if (nArray != null) {
            calendar2.set(14, 0);
            calendar2.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
            long l = calendar2.getTime().getTime();
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos(nArray[6]);
            return timestamp;
        }
        return null;
    }

    public URL getURL(int n) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getURL(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getURL() returns null");
        }
        return null;
    }

    public URL getURL(String string) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("getURL(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("getURL() returns null");
        }
        return null;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateRef(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateRef(" + n + ") returns");
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateRef(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateRef(" + string + ") returns");
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBlob(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBlob(" + n + ") returns");
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBlob(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateBlob(" + string + ") returns");
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateClob(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateClob(" + n + ") returns");
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateClob(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateClob(" + string + ") returns");
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateArray(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateArray(" + n + ") returns");
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateArray(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oaresultset.traceOn()) {
            oaresultset.trace("updateArray(" + string + ") returns");
        }
    }
}

