/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import jdbc.sql.cli.oacli;
import jdbc.sql.cli.oaclistmt;
import jdbc.sql.oabaseconnection;
import jdbc.sql.oaresultset;
import jdbc.sql.oaresultsetmetadata;
import jdbc.sql.oastatement;

public class oaprepstatement
extends oastatement
implements PreparedStatement {
    private oaresultsetmetadata _meta;

    protected oaprepstatement(Connection connection, String string, oacli oacli2, oabaseconnection oabaseconnection2) throws SQLException {
        super(connection, string, oacli2, oabaseconnection2);
        if (oaprepstatement.traceOn()) {
            oaprepstatement.trace("oaprepstatement(" + connection + ",sql) called");
        }
        this._meta = null;
        if (oaprepstatement.traceOn()) {
            oaprepstatement.trace("oaprepstatement() returns");
        }
    }

    private oaclistmt oaExecute() throws SQLException {
        this._oaCLIStmt.ExecuteLocked();
        return this._oaCLIStmt;
    }

    public ResultSet executeQuery() throws SQLException {
        this.throwErrorWhenClosed();
        if (this._result != null) {
            this._result.close();
        }
        this._result = new oaresultset(this.oaExecute(), this);
        return this._result;
    }

    public int executeUpdate() throws SQLException {
        this.throwErrorWhenClosed();
        this.oaExecute();
        return this._oaCLIStmt.getRowCount();
    }

    public void close() throws SQLException {
        this.throwErrorWhenClosed();
        if (this._meta != null) {
            this._meta.oaclose();
            this._meta = null;
        }
        super.close();
    }

    public boolean execute() throws SQLException {
        this.throwErrorWhenClosed();
        this.internalCloseResult();
        this._bEndOfResult = false;
        return this._oaCLIStmt.ExecuteLocked();
    }

    private void internalCloseResult() throws SQLException {
        if (this._result != null) {
            this._result.close();
            this._result = null;
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.throwErrorWhenClosed();
        String string = bl ? new String("1") : new String("0");
        this._oaCLIStmt.setString(n, string);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setShort(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.setString(n, String.valueOf(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.throwErrorWhenClosed();
        if (bigDecimal == null) {
            this._oaCLIStmt.setNull(n, 12);
        } else {
            this._oaCLIStmt.setString(n, bigDecimal.toString());
        }
    }

    public void setString(int n, String string) throws SQLException {
        this.throwErrorWhenClosed();
        if (string == null) {
            this._oaCLIStmt.setNull(n, 12);
        } else {
            this._oaCLIStmt.setString(n, string);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.throwErrorWhenClosed();
        if (byArray == null) {
            this._oaCLIStmt.setNull(n, 12);
        } else {
            this._oaCLIStmt.setBytes(n, byArray);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        throw new SQLException("setAsciiStream is not yet supported.");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        throw new SQLException("setUnicodeStream is not yet supported.");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        throw new SQLException("setBinaryStream is not yet supported.");
    }

    public void clearParameters() throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLIStmt.clearParameters();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (oaprepstatement.traceOn()) {
            oaprepstatement.trace("setObject(int,Object,targetSqlType,int) called");
        }
        if (object == null) {
            this._oaCLIStmt.setNull(n, 12);
            return;
        }
        try {
            switch (n2) {
                case -7: {
                    if (object instanceof String) {
                        if (((String)object).equals("0")) {
                            this.setBoolean(n, false);
                        } else {
                            if (!((String)object).equals("1")) break;
                            this.setBoolean(n, true);
                        }
                        return;
                    }
                    if (object instanceof Boolean) {
                        this.setBoolean(n, (Boolean)object);
                        return;
                    }
                    if (object instanceof BigDecimal || object instanceof Long || object instanceof Float || object instanceof Double) {
                        int n4 = Integer.parseInt(object.toString());
                        if (n4 == 0) {
                            this.setBoolean(n, false);
                        } else if (n4 == 1) {
                            this.setBoolean(n, true);
                        }
                        return;
                    }
                    if (!(object instanceof Integer)) break;
                    int n5 = (Integer)object;
                    if (n5 == 0) {
                        this.setBoolean(n, false);
                    } else if (n5 == 1) {
                        this.setBoolean(n, true);
                    }
                    return;
                }
                case -6: {
                    byte by = Byte.parseByte(object.toString());
                    this.setInt(n, by);
                    return;
                }
                case 5: {
                    short s = Short.parseShort(object.toString());
                    this.setInt(n, s);
                    return;
                }
                case 4: {
                    int n6 = Integer.parseInt(object.toString());
                    this.setInt(n, n6);
                    return;
                }
                case -5: {
                    long l = Long.parseLong(object.toString());
                    this.setLong(n, l);
                    return;
                }
                case 7: {
                    float f = Float.parseFloat(object.toString());
                    this.setFloat(n, f);
                    return;
                }
                case 6: 
                case 8: {
                    double d = Double.parseDouble(object.toString());
                    this.setDouble(n, d);
                    return;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    if (n3 >= 0) {
                        bigDecimal = bigDecimal.setScale(n3);
                    }
                    this.setString(n, bigDecimal.toString());
                    return;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (object.getClass().isArray()) break;
                    this.setString(n, object.toString());
                    return;
                }
                case 91: {
                    this.setDate(n, Date.valueOf(object.toString()), null);
                    return;
                }
                case 92: {
                    this.setTime(n, Time.valueOf(object.toString()), null);
                    return;
                }
                case 93: {
                    this.setTimestamp(n, Timestamp.valueOf(object.toString()), null);
                    return;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(object instanceof byte[])) break;
                    this.setBytes(n, (byte[])object);
                    return;
                }
            }
            throw new SQLException("Unsupported conversion: " + n2, "22000", 0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Unsupported conversion: " + n2, "22000", 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException("Unsupported conversion: " + n2, "22000", 0);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (oaprepstatement.traceOn()) {
            oaprepstatement.trace("setObject(int,Object,targetSqlType) called");
        }
        this.setObject(n, object, n2, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(int n, Object object) throws SQLException {
        if (oaprepstatement.traceOn()) {
            oaprepstatement.trace("setObject(int,Object) called");
        }
        this.throwErrorWhenClosed();
        if (object != null) {
            if (object instanceof Integer) {
                this.setInt(n, (Integer)object);
                return;
            } else if (object instanceof Boolean) {
                this.setBoolean(n, (Boolean)object);
                return;
            } else if (object instanceof Byte) {
                this.setByte(n, (Byte)object);
                return;
            } else if (object instanceof byte[]) {
                this.setBytes(n, (byte[])object);
                return;
            } else if (object instanceof Short) {
                this.setShort(n, (Short)object);
                return;
            } else if (object instanceof Long) {
                this.setLong(n, (Long)object);
                return;
            } else if (object instanceof Float) {
                this.setFloat(n, ((Float)object).floatValue());
                return;
            } else if (object instanceof Double) {
                this.setDouble(n, (Double)object);
                return;
            } else if (object instanceof String) {
                this.setString(n, (String)object);
                return;
            } else if (object instanceof Date) {
                this.setDate(n, (Date)object, null);
                return;
            } else if (object instanceof Time) {
                this.setTime(n, (Time)object, null);
                return;
            } else {
                if (!(object instanceof Timestamp)) throw new SQLException("Unsupported object type in setObject.", "22000", 0);
                this.setTimestamp(n, (Timestamp)object, null);
            }
            return;
        } else {
            this.setNull(n, 12);
        }
    }

    public void addBatch() throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setCharacterStream(int n, char[] cArray, int n2) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwErrorWhenClosed();
        if (this._meta == null) {
            this._meta = new oaresultsetmetadata(this._oaCLIStmt, this._connection);
        }
        return this._meta;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        if (date == null) {
            this._oaCLIStmt.setNull(n, 12);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        calendar2.setTime(date);
        n2 = calendar2.get(1);
        n3 = calendar2.get(2) + 1;
        n4 = calendar2.get(5);
        this._oaCLIStmt.setDate(n, n2, n3, n4);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        if (time == null) {
            this._oaCLIStmt.setNull(n, 12);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        calendar2.setTime(time);
        n2 = calendar2.get(11);
        n3 = calendar2.get(12);
        n4 = calendar2.get(13);
        this._oaCLIStmt.setTime(n, n2, n3, n4);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.throwErrorWhenClosed();
        if (timestamp == null) {
            this._oaCLIStmt.setNull(n, 12);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone();
        calendar2.setTime(timestamp);
        n2 = calendar2.get(1);
        n3 = calendar2.get(2) + 1;
        n4 = calendar2.get(5);
        n5 = calendar2.get(11);
        n6 = calendar2.get(12);
        n7 = calendar2.get(13);
        this._oaCLIStmt.setTimestamp(n, n2, n3, n4, n5, n6, n7, timestamp.getNanos());
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        return null;
    }
}

