/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistryImpl
implements ServiceRegistry {
    protected HashMap publishedServicesByClass;
    protected ArrayList allPublishedServices;
    protected HashMap publishedServicesByContext;

    public void initialize() {
        this.publishedServicesByClass = new HashMap(50);
        this.publishedServicesByContext = new HashMap(50);
        this.allPublishedServices = new ArrayList(50);
    }

    public void publishService(BundleContext context, ServiceRegistration serviceReg) {
        ArrayList<ServiceRegistration> contextServices = (ArrayList<ServiceRegistration>)this.publishedServicesByContext.get(context);
        if (contextServices == null) {
            contextServices = new ArrayList<ServiceRegistration>(10);
            this.publishedServicesByContext.put(context, contextServices);
        }
        contextServices.add(serviceReg);
        for (String clazz : (String[])serviceReg.getReference().getProperty("objectClass")) {
            ArrayList<ServiceRegistration> services = (ArrayList<ServiceRegistration>)this.publishedServicesByClass.get(clazz);
            if (services == null) {
                services = new ArrayList<ServiceRegistration>(10);
                this.publishedServicesByClass.put(clazz, services);
            }
            services.add(serviceReg);
        }
        this.allPublishedServices.add(serviceReg);
    }

    public void unpublishService(BundleContext context, ServiceRegistration serviceReg) {
        ArrayList contextServices = (ArrayList)this.publishedServicesByContext.get(context);
        if (contextServices != null) {
            contextServices.remove(serviceReg);
        }
        for (String clazz : (String[])serviceReg.getReference().getProperty("objectClass")) {
            ArrayList services = (ArrayList)this.publishedServicesByClass.get(clazz);
            services.remove(serviceReg);
        }
        this.allPublishedServices.remove(serviceReg);
    }

    public void unpublishServices(BundleContext context) {
        ArrayList serviceRegs = (ArrayList)this.publishedServicesByContext.get(context);
        if (serviceRegs != null) {
            this.publishedServicesByContext.remove(context);
            int size = serviceRegs.size();
            for (int i = 0; i < size; ++i) {
                ServiceRegistration serviceReg = (ServiceRegistration)serviceRegs.get(i);
                this.allPublishedServices.remove(serviceReg);
                for (String clazz : (String[])serviceReg.getReference().getProperty("objectClass")) {
                    ArrayList services = (ArrayList)this.publishedServicesByClass.get(clazz);
                    services.remove(serviceReg);
                }
            }
        }
    }

    public ServiceReference[] lookupServiceReferences(String clazz, Filter filter) {
        ArrayList serviceRegs = clazz == null ? this.allPublishedServices : (ArrayList)this.publishedServicesByClass.get(clazz);
        if (serviceRegs == null) {
            return null;
        }
        int size = serviceRegs.size();
        if (size == 0) {
            return null;
        }
        ArrayList<ServiceReference> references = new ArrayList<ServiceReference>(size);
        for (int i = 0; i < size; ++i) {
            ServiceRegistration registration = (ServiceRegistration)serviceRegs.get(i);
            ServiceReference reference = registration.getReference();
            if (filter != null && !filter.match(reference)) continue;
            references.add(reference);
        }
        if (references.size() == 0) {
            return null;
        }
        return references.toArray(new ServiceReference[references.size()]);
    }

    public ServiceReference[] lookupServiceReferences(BundleContext context) {
        ArrayList serviceRegs = (ArrayList)this.publishedServicesByContext.get(context);
        if (serviceRegs == null) {
            return null;
        }
        int size = serviceRegs.size();
        if (size == 0) {
            return null;
        }
        ArrayList<ServiceReference> references = new ArrayList<ServiceReference>(size);
        for (int i = 0; i < size; ++i) {
            ServiceRegistration registration = (ServiceRegistration)serviceRegs.get(i);
            ServiceReference reference = registration.getReference();
            references.add(reference);
        }
        if (references.size() == 0) {
            return null;
        }
        return references.toArray(new ServiceReference[references.size()]);
    }
}

