/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    protected int operation;
    protected static final int EQUAL = 1;
    protected static final int APPROX = 2;
    protected static final int GREATER = 3;
    protected static final int LESS = 4;
    protected static final int PRESENT = 5;
    protected static final int SUBSTRING = 6;
    protected static final int AND = 7;
    protected static final int OR = 8;
    protected static final int NOT = 9;
    protected String attr;
    protected Object value;
    protected String filter;
    protected boolean topLevel;
    protected static final Class[] constructorType = new Class[]{String.class};

    public FilterImpl(String filter) throws InvalidSyntaxException {
        this.topLevel = true;
        new Parser(filter).parse(this);
    }

    public boolean match(ServiceReference reference) {
        return this.match0(((ServiceReferenceImpl)reference).registration.properties);
    }

    public boolean match(Dictionary dictionary) {
        if (dictionary != null) {
            dictionary = new Headers(dictionary);
        }
        return this.match0(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match0(dictionary);
    }

    public String toString() {
        if (this.filter == null) {
            StringBuffer filter = new StringBuffer();
            filter.append('(');
            switch (this.operation) {
                case 7: {
                    filter.append('&');
                    FilterImpl[] filters = (FilterImpl[])this.value;
                    int size = filters.length;
                    for (int i = 0; i < size; ++i) {
                        filter.append(filters[i].toString());
                    }
                    break;
                }
                case 8: {
                    filter.append('|');
                    FilterImpl[] filters = (FilterImpl[])this.value;
                    int size = filters.length;
                    for (int i = 0; i < size; ++i) {
                        filter.append(filters[i].toString());
                    }
                    break;
                }
                case 9: {
                    filter.append('!');
                    filter.append(this.value.toString());
                    break;
                }
                case 6: {
                    filter.append(this.attr);
                    filter.append('=');
                    for (String substr : (String[])this.value) {
                        if (substr == null) {
                            filter.append('*');
                            continue;
                        }
                        filter.append(FilterImpl.encodeValue(substr));
                    }
                    break;
                }
                case 1: {
                    filter.append(this.attr);
                    filter.append('=');
                    filter.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 3: {
                    filter.append(this.attr);
                    filter.append(">=");
                    filter.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 4: {
                    filter.append(this.attr);
                    filter.append("<=");
                    filter.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 2: {
                    filter.append(this.attr);
                    filter.append("~=");
                    filter.append(FilterImpl.encodeValue(FilterImpl.approxString(this.value.toString())));
                    break;
                }
                case 5: {
                    filter.append(this.attr);
                    filter.append("=*");
                }
            }
            filter.append(')');
            if (this.topLevel) {
                this.filter = filter.toString();
            } else {
                return filter.toString();
            }
        }
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilterImpl)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected FilterImpl() {
        this.topLevel = false;
    }

    protected void setFilter(int operation, String attr, Object value) {
        this.operation = operation;
        this.attr = attr;
        this.value = value;
    }

    protected boolean match(ServiceReferenceImpl reference) {
        return this.match0(reference.registration.properties);
    }

    protected boolean match0(Dictionary properties) {
        switch (this.operation) {
            case 7: {
                FilterImpl[] filters = (FilterImpl[])this.value;
                int size = filters.length;
                for (int i = 0; i < size; ++i) {
                    if (filters[i].match0(properties)) continue;
                    return false;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filters = (FilterImpl[])this.value;
                int size = filters.length;
                for (int i = 0; i < size; ++i) {
                    if (!filters[i].match0(properties)) continue;
                    return true;
                }
                return false;
            }
            case 9: {
                FilterImpl filter = (FilterImpl)this.value;
                return !filter.match0(properties);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object prop = properties == null ? null : properties.get(this.attr);
                return this.compare(this.operation, prop, this.value);
            }
            case 5: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("PRESENT(" + this.attr + ")");
                }
                Object prop = properties == null ? null : properties.get(this.attr);
                return prop != null;
            }
        }
        return false;
    }

    protected static String encodeValue(String value) {
        boolean encoded = false;
        int inlen = value.length();
        int outlen = inlen << 1;
        char[] output = new char[outlen];
        value.getChars(0, inlen, output, inlen);
        int cursor = 0;
        for (int i = inlen; i < outlen; ++i) {
            char c = output[i];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    output[cursor] = 92;
                    ++cursor;
                    encoded = true;
                }
            }
            output[cursor] = c;
            ++cursor;
        }
        return encoded ? new String(output, 0, cursor) : value;
    }

    protected boolean compare(int operation, Object value1, Object value2) {
        if (value1 == null) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("compare(" + value1 + "," + value2 + ")");
            }
            return false;
        }
        if (value1 instanceof String) {
            return this.compare_String(operation, (String)value1, value2);
        }
        Class<?> clazz = value1.getClass();
        if (clazz.isArray()) {
            Class<?> type = clazz.getComponentType();
            if (type.isPrimitive()) {
                return this.compare_PrimitiveArray(operation, type, value1, value2);
            }
            return this.compare_ObjectArray(operation, (Object[])value1, value2);
        }
        if (value1 instanceof Vector) {
            return this.compare_Vector(operation, (Vector)value1, value2);
        }
        if (value1 instanceof Integer) {
            return this.compare_Integer(operation, (Integer)value1, value2);
        }
        if (value1 instanceof Long) {
            return this.compare_Long(operation, (Long)value1, value2);
        }
        if (value1 instanceof Byte) {
            return this.compare_Byte(operation, (Byte)value1, value2);
        }
        if (value1 instanceof Short) {
            return this.compare_Short(operation, (Short)value1, value2);
        }
        if (value1 instanceof Character) {
            return this.compare_Character(operation, ((Character)value1).charValue(), value2);
        }
        if (value1 instanceof Float) {
            return this.compare_Float(operation, ((Float)value1).floatValue(), value2);
        }
        if (value1 instanceof Double) {
            return this.compare_Double(operation, (Double)value1, value2);
        }
        if (value1 instanceof Boolean) {
            return this.compare_Boolean(operation, (Boolean)value1, value2);
        }
        if (value1 instanceof Comparable) {
            return this.compare_Comparable(operation, (Comparable)value1, value2);
        }
        return this.compare_Unknown(operation, value1, value2);
    }

    protected boolean compare_Vector(int operation, Vector vector, Object value2) {
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            if (!this.compare(operation, vector.elementAt(i), value2)) continue;
            return true;
        }
        return false;
    }

    protected boolean compare_ObjectArray(int operation, Object[] array, Object value2) {
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (!this.compare(operation, array[i], value2)) continue;
            return true;
        }
        return false;
    }

    protected boolean compare_PrimitiveArray(int operation, Class type, Object primarray, Object value2) {
        if (Integer.TYPE.isAssignableFrom(type)) {
            int[] array = (int[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Integer(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            long[] array = (long[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Long(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            byte[] array = (byte[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Byte(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            short[] array = (short[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Short(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            char[] array = (char[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Character(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            float[] array = (float[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Float(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            double[] array = (double[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Double(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            boolean[] array = (boolean[])primarray;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (!this.compare_Boolean(operation, array[i], value2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean compare_String(int operation, String string, Object value2) {
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + string + "," + value2 + ")");
                }
                String[] substrings = (String[])value2;
                int pos = 0;
                int size = substrings.length;
                for (int i = 0; i < size; ++i) {
                    String substr = substrings[i];
                    if (i + 1 < size) {
                        if (substr == null) {
                            int index;
                            String substr2 = substrings[i + 1];
                            if (substr2 == null) continue;
                            if (Debug.DEBUG_FILTER) {
                                Debug.println("indexOf(\"" + substr2 + "\"," + pos + ")");
                            }
                            if ((index = string.indexOf(substr2, pos)) == -1) {
                                return false;
                            }
                            pos = index + substr2.length();
                            if (i + 2 >= size) continue;
                            ++i;
                            continue;
                        }
                        int len = substr.length();
                        if (Debug.DEBUG_FILTER) {
                            Debug.println("regionMatches(" + pos + ",\"" + substr + "\")");
                        }
                        if (string.regionMatches(pos, substr, 0, len)) {
                            pos += len;
                            continue;
                        }
                        return false;
                    }
                    if (substr == null) {
                        return true;
                    }
                    if (Debug.DEBUG_FILTER) {
                        Debug.println("regionMatches(" + pos + "," + substr + ")");
                    }
                    return string.endsWith(substr);
                }
                return true;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + string + "," + value2 + ")");
                }
                return string.equals(value2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + string + "," + value2 + ")");
                }
                string = FilterImpl.approxString(string);
                String string2 = FilterImpl.approxString((String)value2);
                return string.equalsIgnoreCase(string2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + string + "," + value2 + ")");
                }
                return string.compareTo((String)value2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + string + "," + value2 + ")");
                }
                return string.compareTo((String)value2) <= 0;
            }
        }
        return false;
    }

    protected boolean compare_Integer(int operation, int intval, Object value2) {
        int intval2 = Integer.parseInt(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + intval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + intval + "," + value2 + ")");
                }
                return intval == intval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + intval + "," + value2 + ")");
                }
                return intval == intval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + intval + "," + value2 + ")");
                }
                return intval >= intval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + intval + "," + value2 + ")");
                }
                return intval <= intval2;
            }
        }
        return false;
    }

    protected boolean compare_Long(int operation, long longval, Object value2) {
        long longval2 = Long.parseLong(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + longval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + longval + "," + value2 + ")");
                }
                return longval == longval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + longval + "," + value2 + ")");
                }
                return longval == longval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + longval + "," + value2 + ")");
                }
                return longval >= longval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + longval + "," + value2 + ")");
                }
                return longval <= longval2;
            }
        }
        return false;
    }

    protected boolean compare_Byte(int operation, byte byteval, Object value2) {
        byte byteval2 = Byte.parseByte(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + byteval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + byteval + "," + value2 + ")");
                }
                return byteval == byteval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + byteval + "," + value2 + ")");
                }
                return byteval == byteval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + byteval + "," + value2 + ")");
                }
                return byteval >= byteval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + byteval + "," + value2 + ")");
                }
                return byteval <= byteval2;
            }
        }
        return false;
    }

    protected boolean compare_Short(int operation, short shortval, Object value2) {
        short shortval2 = Short.parseShort(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + shortval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + shortval + "," + value2 + ")");
                }
                return shortval == shortval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + shortval + "," + value2 + ")");
                }
                return shortval == shortval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + shortval + "," + value2 + ")");
                }
                return shortval >= shortval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + shortval + "," + value2 + ")");
                }
                return shortval <= shortval2;
            }
        }
        return false;
    }

    protected boolean compare_Character(int operation, char charval, Object value2) {
        char charval2 = ((String)value2).trim().charAt(0);
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + charval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + charval + "," + value2 + ")");
                }
                return charval == charval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + charval + "," + value2 + ")");
                }
                return Character.toLowerCase(charval) == Character.toLowerCase(charval2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + charval + "," + value2 + ")");
                }
                return charval >= charval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + charval + "," + value2 + ")");
                }
                return charval <= charval2;
            }
        }
        return false;
    }

    protected boolean compare_Boolean(int operation, boolean boolval, Object value2) {
        boolean boolval2 = new Boolean(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + boolval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + boolval + "," + value2 + ")");
                }
                return boolval == boolval2;
            }
        }
        return false;
    }

    protected boolean compare_Float(int operation, float floatval, Object value2) {
        float floatval2 = Float.parseFloat(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + floatval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + floatval + "," + value2 + ")");
                }
                return floatval == floatval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + floatval + "," + value2 + ")");
                }
                return floatval == floatval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + floatval + "," + value2 + ")");
                }
                return floatval >= floatval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + floatval + "," + value2 + ")");
                }
                return floatval <= floatval2;
            }
        }
        return false;
    }

    protected boolean compare_Double(int operation, double doubleval, Object value2) {
        double doubleval2 = Double.parseDouble(((String)value2).trim());
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + doubleval + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + doubleval + "," + value2 + ")");
                }
                return doubleval == doubleval2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + doubleval + "," + value2 + ")");
                }
                return doubleval == doubleval2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + doubleval + "," + value2 + ")");
                }
                return doubleval >= doubleval2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + doubleval + "," + value2 + ")");
                }
                return doubleval <= doubleval2;
            }
        }
        return false;
    }

    protected boolean compare_Comparable(int operation, Comparable value1, Object value2) {
        Constructor<?> constructor;
        try {
            constructor = value1.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        try {
            value2 = constructor.newInstance(((String)value2).trim());
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + value1 + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + value1 + "," + value2 + ")");
                }
                return value1.compareTo(value2) <= 0;
            }
        }
        return false;
    }

    protected boolean compare_Unknown(int operation, Object value1, Object value2) {
        Constructor<?> constructor;
        try {
            constructor = value1.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException e) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("Type not supported");
            }
            return false;
        }
        try {
            value2 = constructor.newInstance(((String)value2).trim());
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        switch (operation) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + value1 + "," + value2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + value1 + "," + value2 + ")");
                }
                return value1.equals(value2);
            }
        }
        return false;
    }

    protected static String approxString(String input) {
        boolean changed = false;
        char[] output = input.toCharArray();
        int length = output.length;
        int cursor = 0;
        for (int i = 0; i < length; ++i) {
            char c = output[i];
            if (Character.isWhitespace(c)) {
                changed = true;
                continue;
            }
            output[cursor] = c;
            ++cursor;
        }
        return changed ? new String(output, 0, cursor) : input;
    }

    static class Parser {
        protected String filterstring;
        protected char[] filter;
        protected int pos;

        protected Parser(String filterstring) {
            this.filterstring = filterstring;
            this.filter = filterstring.toCharArray();
            this.pos = 0;
        }

        protected void parse(FilterImpl parent) throws InvalidSyntaxException {
            try {
                this.parse_filter(parent);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring);
            }
            if (this.pos != this.filter.length) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, String.valueOf(this.pos)), this.filterstring);
            }
        }

        protected void parse_filter(FilterImpl parent) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.parse_filtercomp(parent);
            this.skipWhiteSpace();
            if (this.filter[this.pos] != ')') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
        }

        protected void parse_filtercomp(FilterImpl parent) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filter[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    this.parse_and(parent);
                    break;
                }
                case '|': {
                    ++this.pos;
                    this.parse_or(parent);
                    break;
                }
                case '!': {
                    ++this.pos;
                    this.parse_not(parent);
                    break;
                }
                default: {
                    this.parse_item(parent);
                }
            }
        }

        protected void parse_and(FilterImpl parent) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            Vector<FilterImpl> operands = new Vector<FilterImpl>(10, 10);
            while (this.filter[this.pos] == '(') {
                FilterImpl child = new FilterImpl();
                this.parse_filter(child);
                operands.addElement(child);
            }
            int size = operands.size();
            Object[] children = new FilterImpl[size];
            operands.copyInto(children);
            parent.setFilter(7, null, children);
        }

        protected void parse_or(FilterImpl parent) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            Vector<FilterImpl> operands = new Vector<FilterImpl>(10, 10);
            while (this.filter[this.pos] == '(') {
                FilterImpl child = new FilterImpl();
                this.parse_filter(child);
                operands.addElement(child);
            }
            int size = operands.size();
            Object[] children = new FilterImpl[size];
            operands.copyInto(children);
            parent.setFilter(8, null, children);
        }

        protected void parse_not(FilterImpl parent) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            FilterImpl child = new FilterImpl();
            this.parse_filter(child);
            parent.setFilter(9, null, child);
        }

        protected void parse_item(FilterImpl parent) throws InvalidSyntaxException {
            String attr = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filter[this.pos]) {
                case '~': {
                    if (this.filter[this.pos + 1] != '=') break;
                    this.pos += 2;
                    parent.setFilter(2, attr, this.parse_value());
                    return;
                }
                case '>': {
                    if (this.filter[this.pos + 1] != '=') break;
                    this.pos += 2;
                    parent.setFilter(3, attr, this.parse_value());
                    return;
                }
                case '<': {
                    if (this.filter[this.pos + 1] != '=') break;
                    this.pos += 2;
                    parent.setFilter(4, attr, this.parse_value());
                    return;
                }
                case '=': {
                    if (this.filter[this.pos + 1] == '*') {
                        int oldpos = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filter[this.pos] == ')') {
                            parent.setFilter(5, attr, null);
                            return;
                        }
                        this.pos = oldpos;
                    }
                    ++this.pos;
                    Object string = this.parse_substring();
                    if (string instanceof String) {
                        parent.setFilter(1, attr, string);
                    } else {
                        parent.setFilter(6, attr, string);
                    }
                    return;
                }
            }
            throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, String.valueOf(this.pos)), this.filterstring);
        }

        protected String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int begin = this.pos;
            int end = this.pos;
            char c = this.filter[this.pos];
            while ("~<>=()".indexOf(c) == -1) {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    end = this.pos;
                }
                c = this.filter[this.pos];
            }
            int length = end - begin;
            if (length == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, String.valueOf(this.pos)), this.filterstring);
            }
            return new String(this.filter, begin, length);
        }

        protected String parse_value() throws InvalidSyntaxException {
            StringBuffer sb = new StringBuffer(this.filter.length - this.pos);
            block5: while (true) {
                char c = this.filter[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, String.valueOf(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filter[this.pos];
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (sb.length() == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, String.valueOf(this.pos)), this.filterstring);
            }
            return sb.toString();
        }

        protected Object parse_substring() throws InvalidSyntaxException {
            Object single;
            int size;
            StringBuffer sb = new StringBuffer(this.filter.length - this.pos);
            Vector<String> operands = new Vector<String>(10, 10);
            block6: while (true) {
                char c = this.filter[this.pos];
                switch (c) {
                    case ')': {
                        if (sb.length() <= 0) break block6;
                        operands.addElement(sb.toString());
                        break block6;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, String.valueOf(this.pos)), this.filterstring);
                    }
                    case '*': {
                        if (sb.length() > 0) {
                            operands.addElement(sb.toString());
                        }
                        sb.setLength(0);
                        operands.addElement(null);
                        ++this.pos;
                        continue block6;
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filter[this.pos];
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            if ((size = operands.size()) == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, String.valueOf(this.pos)), this.filterstring);
            }
            if (size == 1 && (single = operands.elementAt(0)) != null) {
                return single;
            }
            Object[] strings = new String[size];
            operands.copyInto(strings);
            return strings;
        }

        protected void skipWhiteSpace() {
            int length = this.filter.length;
            while (this.pos < length && Character.isWhitespace(this.filter[this.pos])) {
                ++this.pos;
            }
        }
    }
}

