/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.osgi.service.condpermadmin.BundleSignerCondition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionAdminImpl
implements ConditionalPermissionAdmin {
    Vector condPerms;
    Framework framework;
    PermissionStorage storage;

    public ConditionalPermissionAdminImpl(Framework framework, PermissionStorage permissionStorage) {
        ConditionalPermissionInfoImpl.setConditionalPermissionAdminImpl(this);
        this.framework = framework;
        this.storage = permissionStorage;
        try {
            this.condPerms = permissionStorage.deserializeConditionalPermissionInfos();
        }
        catch (IOException e) {
            framework.publishFrameworkEvent(2, framework.systemBundle, e);
            this.condPerms = new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conds, PermissionInfo[] perms) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        ConditionalPermissionInfoImpl condPermInfo = new ConditionalPermissionInfoImpl(conds, perms);
        Vector vector = this.condPerms;
        synchronized (vector) {
            this.condPerms.add(condPermInfo);
            try {
                this.storage.serializeConditionalPermissionInfos(this.condPerms);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            }
        }
        AbstractBundle[] bundles = this.framework.getAllBundles();
        for (int i = 0; i < bundles.length; ++i) {
            AbstractBundle bundle = bundles[i];
            if (bundle.domain == null) continue;
            BundleCombinedPermissions bcp = (BundleCombinedPermissions)bundle.domain.getPermissions();
            if (perms == null) continue;
            bcp.checkConditionalPermissionInfo(condPermInfo);
        }
        return condPermInfo;
    }

    public Enumeration getConditionalPermissionInfos() {
        return this.condPerms.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteConditionalPermissionInfo(ConditionalPermissionInfo cpi) {
        Vector vector = this.condPerms;
        synchronized (vector) {
            this.condPerms.remove(cpi);
            try {
                this.storage.serializeConditionalPermissionInfos(this.condPerms);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public AccessControlContext getAccessControlContext(String[] signers) {
        ProtectionDomain[] protectionDomainArray;
        BundlePermissionCollection collection;
        Enumeration infos = this.getConditionalPermissionInfos();
        ArrayList<PermissionInfo> permissionInfos = new ArrayList<PermissionInfo>();
        if (infos != null) {
            while (infos.hasMoreElements()) {
                ConditionalPermissionInfoImpl condPermInfo = (ConditionalPermissionInfoImpl)infos.nextElement();
                ConditionInfo[] condInfo = condPermInfo.getConditionInfos();
                boolean match = true;
                block1: for (int i = 0; i < condInfo.length; ++i) {
                    if (BundleSignerCondition.class.getName().equals(condInfo[i].getType())) {
                        String[] args = condInfo[i].getArgs();
                        for (int j = 0; j < args.length; ++j) {
                            if (this.framework.adaptor.matchDNChain(args[j], signers)) continue;
                            match = false;
                            continue block1;
                        }
                        continue;
                    }
                    match = false;
                    break;
                }
                if (!match) continue;
                PermissionInfo[] addPermInfos = condPermInfo.getPermissionInfos();
                for (int i = 0; i < addPermInfos.length; ++i) {
                    permissionInfos.add(addPermInfos[i]);
                }
            }
        }
        if ((collection = this.framework.permissionAdmin.createPermissions(permissionInfos.toArray(new PermissionInfo[permissionInfos.size()]), null)) == null) {
            protectionDomainArray = new ProtectionDomain[]{};
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = new ProtectionDomain(null, collection);
        }
        return new AccessControlContext(protectionDomainArray);
    }
}

