/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import org.eclipse.core.runtime.adaptor.FileManager;
import org.eclipse.core.runtime.adaptor.StreamManagerOutputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;

public class StreamManager {
    public static final int OPEN_BEST_AVAILABLE = 0;
    public static final int OPEN_FAIL_ON_PRIMARY = 1;
    private static boolean useReliableFilesDefault = Boolean.valueOf(System.getProperty("osgi.useReliableFiles"));
    private FileManager manager;
    private boolean useReliableFiles;
    private static final int ST_OPEN = 0;
    private static final int ST_CLOSED = 1;

    public StreamManager(FileManager manager) {
        this.manager = manager;
        this.useReliableFiles = useReliableFilesDefault;
    }

    public void setUseReliableFiles(boolean state) {
        this.useReliableFiles = state;
    }

    public InputStream getInputStream(String target) throws IOException {
        return this.getInputStream(target, 0);
    }

    public InputStream getInputStream(String target, int openMask) throws IOException {
        if (this.useReliableFiles) {
            int id = this.manager.getId(target);
            return new ReliableFileInputStream(new File(this.manager.getBase(), target), id, openMask);
        }
        File lookup = this.manager.lookup(target, false);
        if (lookup == null) {
            return null;
        }
        return new FileInputStream(lookup);
    }

    public StreamManagerOutputStream getOutputStream(String target) throws IOException {
        if (this.useReliableFiles) {
            ReliableFileOutputStream out = new ReliableFileOutputStream(new File(this.manager.getBase(), target));
            return new StreamManagerOutputStream(out, this, target, null, 0);
        }
        File tmpFile = this.manager.createTempFile(target);
        return new StreamManagerOutputStream(new FileOutputStream(tmpFile), this, target, tmpFile, 0);
    }

    public StreamManagerOutputStream[] getOutputStreamSet(String[] targets) throws IOException {
        int idx;
        int count = targets.length;
        StreamManagerOutputStream[] streams = new StreamManagerOutputStream[count];
        try {
            for (idx = 0; idx < count; ++idx) {
                StreamManagerOutputStream newStream = this.getOutputStream(targets[idx]);
                newStream.setStreamSet(streams);
                streams[idx] = newStream;
            }
        }
        catch (IOException e) {
            for (int jdx = 0; jdx < idx; ++jdx) {
                streams[jdx].abort();
            }
            throw e;
        }
        return streams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortOutputStream(StreamManagerOutputStream out) {
        StreamManagerOutputStream[] set = out.getStreamSet();
        if (set == null) {
            set = new StreamManagerOutputStream[]{out};
        }
        StreamManagerOutputStream[] streamManagerOutputStreamArray = set;
        synchronized (set) {
            for (int idx = 0; idx < set.length; ++idx) {
                out = set[idx];
                if (out.getOutputFile() == null) {
                    ReliableFileOutputStream rfos = (ReliableFileOutputStream)out.getOutputStream();
                    rfos.abort();
                } else {
                    if (out.getState() == 0) {
                        try {
                            out.getOutputStream().close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    out.getOutputFile().delete();
                }
                out.setState(1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeOutputStream(StreamManagerOutputStream smos) throws IOException {
        if (smos.getState() != 0) {
            return;
        }
        StreamManagerOutputStream[] streamSet = smos.getStreamSet();
        if (smos.getOutputFile() == null) {
            ReliableFileOutputStream rfos = (ReliableFileOutputStream)smos.getOutputStream();
            File file = rfos.closeIntermediateFile();
            smos.setState(1);
            String target = smos.getTarget();
            if (streamSet == null) {
                this.manager.add(target, 1);
                this.manager.update(new String[]{smos.getTarget()}, new String[]{file.getName()});
                ReliableFile.fileUpdated(new File(this.manager.getBase(), smos.getTarget()));
            }
        } else {
            OutputStream out = smos.getOutputStream();
            out.flush();
            try {
                ((FileOutputStream)out).getFD().sync();
            }
            catch (SyncFailedException e) {
                // empty catch block
            }
            out.close();
            smos.setState(1);
            String target = smos.getTarget();
            if (streamSet == null) {
                this.manager.add(target, 0);
                this.manager.update(new String[]{target}, new String[]{smos.getOutputFile().getName()});
            }
        }
        if (streamSet == null) return;
        StreamManagerOutputStream[] streamManagerOutputStreamArray = streamSet;
        synchronized (streamSet) {
            for (int idx = 0; idx < streamSet.length; ++idx) {
                if (streamSet[idx].getState() != 0) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            String[] targets = new String[streamSet.length];
            String[] sources = new String[streamSet.length];
            for (int idx = 0; idx < streamSet.length; ++idx) {
                smos = streamSet[idx];
                targets[idx] = smos.getTarget();
                File outputFile = smos.getOutputFile();
                if (outputFile == null) {
                    this.manager.add(smos.getTarget(), 1);
                    ReliableFileOutputStream rfos = (ReliableFileOutputStream)smos.getOutputStream();
                    File file = rfos.closeIntermediateFile();
                    sources[idx] = file.getName();
                    ReliableFile.fileUpdated(new File(this.manager.getBase(), smos.getTarget()));
                    continue;
                }
                this.manager.add(smos.getTarget(), 0);
                sources[idx] = outputFile.getName();
            }
            this.manager.update(targets, sources);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public FileManager getFileManager() {
        return this.manager;
    }
}

