/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElementSymbolOptimizer {
    private ElementSymbolOptimizer() {
    }

    private static void getExposedCommands(Command command, List commandList) {
        block3: {
            block2: {
                if (!(command instanceof SetQuery)) break block2;
                SetQuery setQuery = (SetQuery)command;
                for (Command setQueryCommand : setQuery.getQueries()) {
                    ElementSymbolOptimizer.getExposedCommands(setQueryCommand, commandList);
                }
                break block3;
            }
            commandList.add(command);
            List subCommands = CommandCollectorVisitor.getCommands(command, true);
            if (subCommands == null || subCommands.size() <= 0) break block3;
            for (int i = 0; i < subCommands.size(); ++i) {
                Command subCommand = (Command)subCommands.get(i);
                ElementSymbolOptimizer.getExposedCommands(subCommand, commandList);
            }
        }
    }

    public static void fullyQualifyElements(Command command) {
        ArrayList commandsToQualify = new ArrayList();
        ElementSymbolOptimizer.getExposedCommands(command, commandsToQualify);
        for (int i = 0; i < commandsToQualify.size(); ++i) {
            Command currentCommand = (Command)commandsToQualify.get(i);
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)currentCommand, false);
            for (ElementSymbol element : elements) {
                ElementSymbolOptimizer.fullyQualifyElement(element);
            }
        }
    }

    private static void fullyQualifyElement(ElementSymbol element) {
        element.setDisplayFullyQualified(true);
    }

    public static void optimizeElements(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList commandsToOptimize = new ArrayList();
        ElementSymbolOptimizer.getExposedCommands(command, commandsToOptimize);
        for (int i = 0; i < commandsToOptimize.size(); ++i) {
            Command currentCommand = (Command)commandsToOptimize.get(i);
            TempMetadataAdapter facade = new TempMetadataAdapter(metadata, new TempMetadataStore(currentCommand.getTemporaryMetadata()));
            List externalGroups = currentCommand.getAllExternalGroups();
            Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)currentCommand, false);
            ElementSymbolOptimizer.optimizeElements(currentCommand, groups, externalGroups, facade);
        }
    }

    private static boolean isXMLCommand(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, true);
        if (groups.size() != 1) {
            return false;
        }
        GroupSymbol group = (GroupSymbol)groups.iterator().next();
        return metadata.isXMLGroup(group.getMetadataID());
    }

    private static void optimizeElements(Command command, Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        switch (command.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                ElementSymbolOptimizer.optimizeCommand(command, groups, externalGroups, metadata);
                break;
            }
        }
    }

    private static void optimizeCommand(Command command, Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (ElementSymbolOptimizer.isXMLCommand(command, metadata)) {
            return;
        }
        boolean REMOVE_DUPLICATES = false;
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)command, false);
        Map shortNameMap = ElementSymbolOptimizer.mapShortNamesToGroups(groups, externalGroups, metadata);
        for (ElementSymbol element : elements) {
            String elementFullName = metadata.getFullName(element.getMetadataID());
            String shortNameKey = metadata.getShortElementName(elementFullName).toUpperCase();
            Set groupSet = (Set)shortNameMap.get(shortNameKey);
            if (groupSet == null || groupSet.size() > 1) continue;
            element.setDisplayFullyQualified(false);
        }
    }

    private static Map mapShortNamesToGroups(Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        HashMap<String, HashSet<GroupSymbol>> result = new HashMap<String, HashSet<GroupSymbol>>();
        ArrayList allGroups = new ArrayList(groups);
        allGroups.addAll(externalGroups);
        for (GroupSymbol group : allGroups) {
            Iterator elemIDs = metadata.getElementIDsInGroupID(group.getMetadataID()).iterator();
            while (elemIDs.hasNext()) {
                ElementSymbol element = new ElementSymbol(metadata.getFullName(elemIDs.next()));
                String shortNameKey = element.getShortName().toUpperCase();
                HashSet<GroupSymbol> groupSet = (HashSet<GroupSymbol>)result.get(shortNameKey);
                if (groupSet == null) {
                    groupSet = new HashSet<GroupSymbol>();
                    result.put(shortNameKey, groupSet);
                }
                groupSet.add(group);
            }
        }
        return result;
    }
}

