/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AggregateSymbol
extends ExpressionSymbol {
    private String aggregate;
    private boolean distinct;
    private static final Class COUNT_TYPE = DataTypeManager.getDataTypeClass("integer");
    private static final Set AGGREGATE_FUNCTIONS = new HashSet();
    private static final Map SUM_TYPES;
    private static final Map AVG_TYPES;

    protected AggregateSymbol(String name, String canonicalName, int hashcode, String aggregateFunction, boolean isDistinct, Expression expression) {
        super(name, canonicalName, hashcode, expression);
        this.setAggregateFunction(aggregateFunction);
        this.distinct = isDistinct;
    }

    public AggregateSymbol(String name, String aggregateFunction, boolean isDistinct, Expression expression) {
        super(name, expression);
        this.setAggregateFunction(aggregateFunction);
        this.distinct = isDistinct;
    }

    private void setAggregateFunction(String aggregateFunction) {
        if (!AGGREGATE_FUNCTIONS.contains(aggregateFunction)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0013", new Object[]{aggregateFunction, AGGREGATE_FUNCTIONS}));
        }
        this.aggregate = aggregateFunction;
    }

    public String getAggregateFunction() {
        return this.aggregate;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Class getType() {
        if (this.aggregate.equals("COUNT")) {
            return COUNT_TYPE;
        }
        if (this.aggregate.equals("SUM")) {
            Class expressionType = this.getExpression().getType();
            return (Class)SUM_TYPES.get(expressionType);
        }
        if (this.aggregate.equals("AVG")) {
            Class expressionType = this.getExpression().getType();
            return (Class)AVG_TYPES.get(expressionType);
        }
        return this.getExpression().getType();
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        AggregateSymbol copy = null;
        copy = this.getExpression() != null ? new AggregateSymbol(this.getName(), this.getCanonical(), this.getHash(), this.getAggregateFunction(), this.isDistinct(), (Expression)this.getExpression().clone()) : new AggregateSymbol(this.getName(), this.getCanonicalName(), this.hashCode(), this.getAggregateFunction(), this.isDistinct(), null);
        return copy;
    }

    public int hashCode() {
        int hasCode = HashCodeUtil.hashCode(this.aggregate.hashCode(), this.distinct);
        return HashCodeUtil.hashCode(hasCode, this.getExpression());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AggregateSymbol)) {
            return false;
        }
        AggregateSymbol other = (AggregateSymbol)obj;
        return this.aggregate.equals(other.aggregate) && this.distinct == other.distinct;
    }

    static {
        AGGREGATE_FUNCTIONS.add("COUNT");
        AGGREGATE_FUNCTIONS.add("SUM");
        AGGREGATE_FUNCTIONS.add("AVG");
        AGGREGATE_FUNCTIONS.add("MIN");
        AGGREGATE_FUNCTIONS.add("MAX");
        SUM_TYPES = new HashMap();
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES = new HashMap();
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
    }
}

