/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.List;

public class TranslateCriteria
extends PredicateCriteria {
    private CriteriaSelector criteriaSelector;
    private List translations;

    public TranslateCriteria() {
    }

    public TranslateCriteria(CriteriaSelector selector) {
        this.criteriaSelector = selector;
    }

    public TranslateCriteria(CriteriaSelector selector, List translations) {
        this.criteriaSelector = selector;
        this.translations = translations;
    }

    public CriteriaSelector getSelector() {
        return this.criteriaSelector;
    }

    public void setSelector(CriteriaSelector selector) {
        this.criteriaSelector = selector;
    }

    public boolean hasTranslations() {
        if (this.translations != null) {
            return this.translations.size() > 0;
        }
        return false;
    }

    public void setTranslations(List translations) {
        this.translations = translations;
    }

    public void addTranslation(CompareCriteria criteria) {
        if (this.translations == null) {
            this.translations = new ArrayList();
        }
        this.translations.add(criteria);
    }

    public List getTranslations() {
        return this.translations;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        TranslateCriteria copy = new TranslateCriteria();
        copy.setSelector((CriteriaSelector)this.criteriaSelector.clone());
        if (this.hasTranslations()) {
            ArrayList<Criteria> newTrans = new ArrayList<Criteria>(this.getTranslations().size());
            for (Criteria crit : this.getTranslations()) {
                newTrans.add(crit);
            }
            copy.setTranslations(newTrans);
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TranslateCriteria other = (TranslateCriteria)obj;
        return EquivalenceUtil.areEqual(this.getSelector(), other.getSelector()) && EquivalenceUtil.areEqual(this.getTranslations(), other.getTranslations());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.getSelector());
        myHash = HashCodeUtil.hashCode(myHash, this.getTranslations());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

