/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.PreparedBatchUpdate;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Insert
extends PreparedBatchUpdate {
    private GroupSymbol group;
    private List variables = new LinkedList();
    private List values = new LinkedList();
    private Command query;

    public Insert() {
    }

    public int getType() {
        return 2;
    }

    public Insert(GroupSymbol group, List variables, List values) {
        this.group = group;
        this.variables = variables;
        this.values = values;
    }

    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public List getVariables() {
        return this.variables;
    }

    public void addVariable(ElementSymbol var) {
        this.variables.add(var);
    }

    public void addVariables(Collection vars) {
        this.variables.addAll(vars);
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void setVariables(Collection vars) {
        this.variables.clear();
        this.variables.addAll(vars);
    }

    public void addValue(Expression value) {
        this.values.add(value);
    }

    public void setQuery(Command query) {
        this.query = query;
    }

    public Command getQuery() {
        return this.query;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.group);
        myHash = HashCodeUtil.hashCode(myHash, this.variables);
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Insert other = (Insert)obj;
        return EquivalenceUtil.areEqual(this.getGroup(), other.getGroup()) && EquivalenceUtil.areEqual(this.getValues(), other.getValues()) && EquivalenceUtil.areEqual(this.getVariables(), other.getVariables()) && EquivalenceUtil.areEqual(this.getQuery(), other.getQuery());
    }

    public Object clone() {
        GroupSymbol copyGroup = null;
        if (this.group != null) {
            copyGroup = (GroupSymbol)this.group.clone();
        }
        LinkedList<Object> copyVars = new LinkedList<Object>();
        for (ElementSymbol element : this.getVariables()) {
            copyVars.add(element.clone());
        }
        LinkedList<Object> copyVals = new LinkedList<Object>();
        if (this.getValues() != null && this.getValues().size() > 0) {
            for (Expression expression : this.getValues()) {
                copyVals.add(expression.clone());
            }
        }
        Insert copy = new Insert(copyGroup, copyVars, copyVals);
        this.copyMetadataState(copy);
        copy.setParameterReferences(this.getParameterReferences());
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    public boolean areResultsCachable() {
        return false;
    }
}

