/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metabase.repository.api;

import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.impl.local.LocalServerConnectionFactory;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactoryImpl;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactoryImpl;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.common.comm.service.ILogin;
import com.metamatrix.common.comm.service.LoginFactory;
import com.metamatrix.common.comm.service.MessageClientInterceptor;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.core.factory.FastSingletonFactoryStrategy;
import com.metamatrix.core.factory.ShortCircuitedFactoryStrategy;
import com.metamatrix.core.proxy.ClientSecurityServiceInterceptor;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.core.proxy.SecurityContextFactory;
import com.metamatrix.core.proxy.ServiceEndpoint;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metabase.repository.api.IRepository;
import com.metamatrix.metabase.repository.api.RepositorySession;
import java.util.Properties;

public class RepositoryManagerRepositoryFactory {
    private static SocketServerConnectionFactory connectionFactory = null;

    public static RepositorySession createRepository(String serverUrl, String userName, String password, ClassLoader cl) throws CommunicationException, ConnectionException {
        ArgCheck.isNotNull(cl);
        if (serverUrl.equals("localhost")) {
            return RepositoryManagerRepositoryFactory.createLocalRepositorySession();
        }
        RepositoryManagerRepositoryFactory.initServerConnectionFactory(cl);
        return RepositoryManagerRepositoryFactory.createServerRepositorySession(serverUrl, userName, password);
    }

    private static RepositorySession createLocalRepositorySession() {
        LoginFactory loginFactory = new LoginFactory(new FastSingletonFactoryStrategy());
        ILogin login = loginFactory.create();
        LocalServerConnectionFactory connectionFactory = new LocalServerConnectionFactory(null);
        ServiceInterceptor[] interceptors = new ServiceInterceptor[]{new ClientSecurityServiceInterceptor(login.toSecurityContextFactory())};
        MessageClientInterceptor terminalInterceptor = new MessageClientInterceptor(new Properties(), connectionFactory, null, "DirectoryService", null, "Modeler");
        IRepository repository = (IRepository)new ServiceProxyFactory().create(IRepository.class, interceptors, terminalInterceptor);
        return new RepositorySession(repository, terminalInterceptor);
    }

    private static synchronized void initServerConnectionFactory(ClassLoader cl) {
        if (connectionFactory == null) {
            ClientSideLogonFactoryImpl clientSideLogonFactory = ClientSideLogonFactoryImpl.getInstance();
            ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactory();
            ObjectSocketFactoryImpl objectSocketFactory = ObjectSocketFactoryImpl.getInstance();
            connectionFactory = new SocketServerConnectionFactory(SocketConstants.getMaxThreads(), SocketConstants.getTTL(), SocketConstants.getSynchronousTTL(), SocketConstants.getLog("Modeler"), cl, SocketConstants.getInputBufferSize(), SocketConstants.getOutputBufferSize(), SocketConstants.getConserveBandwidth(), clientSideLogonFactory, serviceProxyFactory, objectSocketFactory);
        }
    }

    private static RepositorySession createServerRepositorySession(String serverUrl, String userName, String password) throws CommunicationException, ConnectionException {
        MMURL mmURL = new MMURL(serverUrl);
        SocketServerConnection serverConnection = (SocketServerConnection)connectionFactory.establishConnection(mmURL, "Repository", "Modeler", "DirectoryService", userName, password.toCharArray());
        if (serverConnection != null) {
            SecurityContext securityContext = serverConnection.getClientSideLogon().getSecurityContext();
            SecurityContextFactory factory = new SecurityContextFactory(new ShortCircuitedFactoryStrategy(securityContext), userName);
            ServiceInterceptor[] interceptors = new ServiceInterceptor[]{ServiceEndpoint.getAttributeSettingInterceptor(IRepository.class), new ClientSecurityServiceInterceptor(factory)};
            Properties properties = new Properties();
            properties.setProperty("host", NetUtils.parseHost(serverUrl));
            properties.setProperty("port", NetUtils.parsePort(serverUrl));
            properties.setProperty("ApplicationName", "Modeler");
            properties.setProperty("user", userName);
            properties.setProperty("password", String.valueOf(password));
            properties.setProperty("serviceType", "DirectoryService");
            properties.setProperty("serverURL", serverUrl);
            MessageClientInterceptor terminalInterceptor = new MessageClientInterceptor(properties, connectionFactory, null, "DirectoryService", null, "Modeler");
            terminalInterceptor.setServerConnection(serverConnection);
            IRepository repository = (IRepository)new ServiceProxyFactory().create(IRepository.class, interceptors, terminalInterceptor);
            return new RepositorySession(repository, terminalInterceptor);
        }
        throw new ConnectionException(new LogonException("Could not connect to Server " + serverUrl));
    }
}

