/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.xa.MMXid;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import javax.transaction.xa.Xid;

public class TransactionHelper {
    public static void startTransaction(ServerConnection serverConn, MMXid arg0, int arg1, int timeout) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(7);
        msg.setXid(arg0);
        msg.setParameter(arg1);
        msg.setTxnTimeout(timeout);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static void commitTransaction(ServerConnection serverConn, MMXid arg0, boolean arg1) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(8);
        msg.setXid(arg0);
        msg.setParameter(arg1 ? 1 : 0);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static void endTransaction(ServerConnection serverConn, MMXid arg0, int arg1) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(11);
        msg.setXid(arg0);
        msg.setParameter(arg1);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static void forgetTransaction(ServerConnection serverConn, MMXid arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(10);
        msg.setXid(arg0);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static int prepareTransaction(ServerConnection serverConn, MMXid arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(12);
        msg.setXid(arg0);
        return TransactionHelper.sendMessage(msg, serverConn).getParameter();
    }

    public static Xid[] recoverTransaction(ServerConnection serverConn, int arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(13);
        return TransactionHelper.sendMessage(msg, serverConn).getRecoveredXids();
    }

    public static void rollbackTransaction(ServerConnection serverConn, MMXid arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(9);
        msg.setXid(arg0);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static void commit(ServerConnection serverConn) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(3);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static void rollback(ServerConnection serverConn) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(4);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    public static void begin(ServerConnection serverConn) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestType(2);
        TransactionHelper.sendMessage(msg, serverConn);
    }

    private static TransactionMessage sendMessage(TransactionMessage msg, ServerConnection connection) throws MMSQLException {
        try {
            Message returnedMsg = connection.send(msg, connection.selectServerInstance(null));
            if (returnedMsg instanceof TransactionMessage) {
                msg = (TransactionMessage)returnedMsg;
            } else if (returnedMsg instanceof MessageHolder) {
                ExceptionHolder contents = (ExceptionHolder)((MessageHolder)returnedMsg).contents;
                msg.setException(contents.exception);
            } else {
                msg.setException(new MetaMatrixRuntimeException(JDBCPlugin.Util.getString("UserTransactionProxy.Unknown_msg_type", new Object[]{returnedMsg})));
            }
        }
        catch (CommunicationException e) {
            throw MMSQLException.create(e);
        }
        catch (ApplicationException e) {
            throw MMSQLException.create(e);
        }
        if (msg.getException() != null) {
            throw MMSQLException.create(msg.getException());
        }
        return msg;
    }
}

