/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlpreprocessor;

import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.api.SQLPreProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;

public class MMPreProcessorManager {
    private ArrayList preProcessorList = new ArrayList();
    private Logger logger;

    public MMPreProcessorManager(String propFile, Logger logger) throws SQLException {
        this.logger = logger;
        this.loadPreProcessors(propFile);
    }

    private void loadPreProcessors(String propFile) throws SQLException {
        Properties preProcessorProperties;
        block8: {
            preProcessorProperties = new Properties();
            try {
                File file = new File(propFile);
                if (file.exists()) {
                    preProcessorProperties.load(new FileInputStream(file));
                    break block8;
                }
                InputStream in = this.getClass().getResourceAsStream(propFile);
                if (in != null) {
                    preProcessorProperties.load(in);
                    break block8;
                }
                throw new SQLException(JDBCPlugin.Util.getString("MMPreProcessorManager.preprocessor_file_not_found", propFile));
            }
            catch (IOException ioe) {
                throw MMSQLException.create(ioe);
            }
        }
        TreeMap<Integer, String> propMap = new TreeMap<Integer, String>();
        for (Object index : preProcessorProperties.keySet()) {
            propMap.put(Integer.valueOf((String)index), preProcessorProperties.getProperty((String)index));
        }
        for (Object index : propMap.keySet()) {
            String preProcessorStr = (String)propMap.get(index);
            if (preProcessorStr == null) continue;
            SQLPreProcessor preprocessClass = null;
            try {
                preprocessClass = (SQLPreProcessor)Class.forName(preProcessorStr).newInstance();
            }
            catch (Exception e) {
                throw MMSQLException.create(e);
            }
            this.preProcessorList.add(preprocessClass);
            this.logger.log(5, JDBCPlugin.Util.getString("MMPreProcessorManager.loaded_preprocessor", preprocessClass.getClass().getName()));
        }
    }

    public String getPreProcessorString(String string) throws SQLException {
        String preProcessedStr = string;
        if (!this.preProcessorList.isEmpty()) {
            for (int i = 0; i < this.preProcessorList.size(); ++i) {
                SQLPreProcessor preProcessor = (SQLPreProcessor)this.preProcessorList.get(i);
                if (preProcessor == null) continue;
                preProcessedStr = preProcessor.preprocessSQL(preProcessedStr);
            }
        }
        return preProcessedStr;
    }
}

