/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.admin.api.embedded.EmbeddedAdmin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.util.AdminExceptionConverter;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.admin.DQPConfigAdminImpl;
import com.metamatrix.dqp.embedded.admin.DQPMonitoringAdminImpl;
import com.metamatrix.dqp.embedded.admin.DQPRuntimeStateAdminImpl;
import com.metamatrix.dqp.embedded.admin.DQPSecurityAdminImpl;
import com.metamatrix.jdbc.ConnectionListener;
import com.metamatrix.jdbc.EmbeddedDriver;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class EmbeddedConnection
extends MMConnection {
    private static final String SERVER_NAME = "MetaMatrix Query";
    DQPEmbeddedManager manager = null;
    ConnectionListener listener = null;
    Properties properties = null;

    public static EmbeddedConnection newInstance(DQPEmbeddedManager manager, ServerConnection serverConn, Properties info, ConnectionListener listner) {
        if (AOP.useproxy()) {
            return (EmbeddedConnection)ProxyFactory.extend(EmbeddedConnection.class, new Class[]{DQPEmbeddedManager.class, ServerConnection.class, Properties.class, ConnectionListener.class}, new Object[]{manager, serverConn, info, listner});
        }
        return new EmbeddedConnection(manager, serverConn, info, listner);
    }

    public EmbeddedConnection(DQPEmbeddedManager manager, ServerConnection serverConn, Properties info, ConnectionListener listner) {
        super(serverConn, info, null);
        this.manager = manager;
        this.listener = listner;
        this.properties = info;
        this.listener.connectionAdded(this.getConectionID(), this);
    }

    public Admin getAdminAPI() throws SQLException {
        InvocationHandler handler = new InvocationHandler(){
            Object[] implementors;
            {
                this.implementors = new Object[]{new DQPConfigAdminImpl(EmbeddedConnection.this.manager), new DQPMonitoringAdminImpl(EmbeddedConnection.this.manager), new DQPRuntimeStateAdminImpl(EmbeddedConnection.this.manager), new DQPSecurityAdminImpl(EmbeddedConnection.this.manager)};
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ClassLoader callingClassLoader;
                block11: {
                    IllegalArgumentException ex = null;
                    if (!EmbeddedConnection.this.manager.isDQPAlive()) {
                        throw new AdminProcessingException(JDBCPlugin.Util.getString("EmbeddedConnection.DQP_shutDown"));
                    }
                    callingClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    for (int i = 0; i < this.implementors.length; ++i) {
                        try {
                            Object object = method.invoke(this.implementors[i], args);
                            return object;
                        }
                        catch (IllegalArgumentException e) {
                        }
                        catch (IllegalAccessException e) {
                            throw e;
                        }
                        catch (InvocationTargetException e) {
                            Throwable target = e.getTargetException();
                            if (target instanceof AdminException) {
                                throw target;
                            }
                            throw AdminExceptionConverter.convertToComponentException(e, e.getMessage());
                        }
                        {
                            ex = e;
                            continue;
                        }
                    }
                    if (ex == null) break block11;
                    throw ex;
                }
                Object var6_7 = null;
                return var6_7;
                finally {
                    Thread.currentThread().setContextClassLoader(callingClassLoader);
                }
            }
        };
        return (EmbeddedAdmin)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EmbeddedAdmin.class}, handler);
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.listener.connectionRemoved(this.getConectionID(), this);
    }

    String getConectionID() {
        return (String)this.properties.get("connectionID");
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return super.getMetaData(new EmbeddedDriver());
    }

    String getDatabaseName() {
        return SERVER_NAME;
    }
}

