/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.CommonPlugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Intervals
implements Serializable {
    static int BEFORE_FIRST = 0;
    static int WITHIN_INTERVAL = 1;
    static int BETWEEN_INTERVALS = 2;
    static int AFTER_LAST = 3;
    private LinkedList intervals;

    public Intervals() {
        this.intervals = new LinkedList();
    }

    public Intervals(int begin, int end) {
        this();
        this.addInterval(begin, end);
    }

    private Intervals(Collection i) {
        this.intervals = new LinkedList(i);
    }

    public boolean hasIntervals() {
        return this.intervals.size() > 0;
    }

    public void addInterval(int begin, int end) {
        if (begin > end) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0023"));
        }
        if (this.intervals.size() == 0) {
            this.intervals.add(new Integer(begin));
            this.intervals.add(new Integer(end));
        } else {
            int[] locations = Intervals.findLocations(this.intervals, begin, end);
            if (locations[0] == BEFORE_FIRST) {
                if (locations[2] == BEFORE_FIRST) {
                    this.intervals.addFirst(new Integer(end));
                    this.intervals.addFirst(new Integer(begin));
                    Intervals.condense(this.intervals);
                    return;
                }
                if (locations[2] == AFTER_LAST) {
                    this.intervals.clear();
                    this.intervals.add(new Integer(begin));
                    this.intervals.add(new Integer(end));
                    return;
                }
            } else {
                if (locations[0] == AFTER_LAST) {
                    this.intervals.addLast(new Integer(begin));
                    this.intervals.addLast(new Integer(end));
                    Intervals.condense(this.intervals);
                    return;
                }
                if (locations[0] == BETWEEN_INTERVALS && locations[2] == BETWEEN_INTERVALS && locations[1] > locations[3]) {
                    this.intervals.add(locations[1], new Integer(end));
                    this.intervals.add(locations[1], new Integer(begin));
                    Intervals.condense(this.intervals);
                    return;
                }
            }
            Intervals.mergeIntervals(this.intervals, locations[1], locations[3]);
            Intervals.expandInterval(this.intervals, locations[1], begin, end);
            Intervals.condense(this.intervals);
        }
    }

    static int[] findLocations(LinkedList intervals, int beginValue, int endValue) {
        int[] locations = new int[4];
        locations[0] = -1;
        locations[2] = -1;
        int interval = -1;
        Iterator iter = intervals.iterator();
        while (iter.hasNext()) {
            int intervalBegin = (Integer)iter.next();
            int intervalEnd = (Integer)iter.next();
            ++interval;
            if (locations[0] == -1) {
                if (beginValue < intervalBegin) {
                    locations[0] = BETWEEN_INTERVALS;
                    locations[1] = interval * 2;
                } else if (beginValue >= intervalBegin && beginValue <= intervalEnd) {
                    locations[0] = WITHIN_INTERVAL;
                    locations[1] = interval * 2;
                }
            }
            if (endValue < intervalBegin) {
                locations[2] = BETWEEN_INTERVALS;
                locations[3] = (interval - 1) * 2 + 1;
                break;
            }
            if (endValue < intervalBegin || endValue > intervalEnd) continue;
            locations[2] = WITHIN_INTERVAL;
            locations[3] = interval * 2 + 1;
            break;
        }
        if (locations[2] == -1) {
            locations[2] = AFTER_LAST;
            locations[3] = intervals.size() - 1;
            if (locations[0] == -1) {
                locations[0] = AFTER_LAST;
                locations[1] = intervals.size() - 2;
            }
        }
        if (locations[0] == BETWEEN_INTERVALS && locations[1] == 0) {
            locations[0] = BEFORE_FIRST;
        }
        if (locations[2] == BETWEEN_INTERVALS && locations[3] < 0) {
            locations[2] = BEFORE_FIRST;
        }
        return locations;
    }

    static void mergeIntervals(LinkedList intervals, int firstIntervalIndex, int lastIntervalIndex) {
        intervals.subList(firstIntervalIndex + 1, lastIntervalIndex).clear();
    }

    static void expandInterval(LinkedList intervals, int firstIntervalIndex, int begin, int end) {
        ListIterator<Integer> iter = intervals.listIterator(firstIntervalIndex);
        int mergedBegin = (Integer)iter.next();
        int mergedEnd = (Integer)iter.next();
        int newBegin = Math.min(begin, mergedBegin);
        int newEnd = Math.max(end, mergedEnd);
        iter.previous();
        iter.set(new Integer(newEnd));
        iter.previous();
        iter.set(new Integer(newBegin));
    }

    static void reduceInterval(LinkedList intervals, int firstIntervalIndex, int begin, int end) {
        ListIterator<Integer> iter = intervals.listIterator(firstIntervalIndex);
        int mergedBegin = (Integer)iter.next();
        int mergedEnd = (Integer)iter.next();
        if (begin <= mergedBegin) {
            if (end >= mergedEnd) {
                iter.previous();
                iter.remove();
                iter.previous();
                iter.remove();
                return;
            }
            iter.previous();
            iter.previous();
            iter.set(new Integer(end + 1));
        } else if (end >= mergedEnd) {
            iter.previous();
            iter.set(new Integer(begin - 1));
        } else {
            iter.previous();
            iter.add(new Integer(end + 1));
            iter.previous();
            iter.add(new Integer(begin - 1));
        }
    }

    static void condense(LinkedList intervals) {
        if (intervals.size() <= 2) {
            return;
        }
        ListIterator iter = intervals.listIterator();
        iter.next();
        int lastEnd = (Integer)iter.next();
        while (iter.hasNext()) {
            int begin = (Integer)iter.next();
            if (begin == lastEnd + 1) {
                iter.remove();
                iter.previous();
                iter.remove();
            }
            lastEnd = (Integer)iter.next();
        }
    }

    public void removeInterval(int begin, int end) {
        if (begin > end) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0024"));
        }
        if (this.intervals.size() == 0) {
            return;
        }
        int[] locations = Intervals.findLocations(this.intervals, begin, end);
        if (locations[0] == BEFORE_FIRST) {
            if (locations[2] == BEFORE_FIRST) {
                return;
            }
            if (locations[2] == AFTER_LAST) {
                this.intervals.clear();
                return;
            }
        } else {
            if (locations[0] == AFTER_LAST) {
                return;
            }
            if (locations[0] == BETWEEN_INTERVALS && locations[2] == BETWEEN_INTERVALS && locations[1] > locations[3]) {
                return;
            }
        }
        Intervals.mergeIntervals(this.intervals, locations[1], locations[3]);
        Intervals.reduceInterval(this.intervals, locations[1], begin, end);
        Intervals.condense(this.intervals);
    }

    public Intervals removeIntervals(Intervals intervalsToRemove) {
        List intervalList = intervalsToRemove.getIntervals();
        for (int[] interval : intervalList) {
            this.removeInterval(interval[0], interval[1]);
        }
        return this;
    }

    public boolean containsInterval(int begin, int end) {
        if (begin > end) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0025"));
        }
        int size = this.intervals.size();
        if (size == 0) {
            return false;
        }
        if (size == 2) {
            return begin >= (Integer)this.intervals.getFirst() && end <= (Integer)this.intervals.getLast();
        }
        int[] locations = Intervals.findLocations(this.intervals, begin, end);
        return locations[0] == WITHIN_INTERVAL && locations[2] == WITHIN_INTERVAL && locations[1] + 1 == locations[3];
    }

    public Intervals getIntersection(int begin, int end) {
        if (begin > end) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0026"));
        }
        Intervals overlap = new Intervals();
        if (this.intervals.size() == 0) {
            return overlap;
        }
        int[] locations = Intervals.findLocations(this.intervals, begin, end);
        if (locations[2] == BEFORE_FIRST || locations[0] == AFTER_LAST) {
            return overlap;
        }
        if (locations[0] == BETWEEN_INTERVALS && locations[2] == BETWEEN_INTERVALS && locations[1] > locations[3]) {
            return overlap;
        }
        if (locations[0] == WITHIN_INTERVAL && locations[2] == WITHIN_INTERVAL && locations[1] + 1 == locations[3]) {
            overlap.addInterval(begin, end);
            return overlap;
        }
        int startIndex = locations[1];
        int endIndex = locations[3];
        overlap.addInterval(Math.max((Integer)this.intervals.get(startIndex), begin), Math.min((Integer)this.intervals.get(startIndex + 1), end));
        int diff = endIndex - startIndex;
        if (diff > 3) {
            ListIterator internalIter = this.intervals.listIterator(startIndex + 2);
            int stop = diff - 3;
            for (int i = 0; i < stop; i += 2) {
                overlap.addInterval((Integer)internalIter.next(), (Integer)internalIter.next());
            }
        }
        if (diff > 1) {
            overlap.addInterval(Math.max((Integer)this.intervals.get(endIndex - 1), begin), Math.min((Integer)this.intervals.get(endIndex), end));
        }
        return overlap;
    }

    public Intervals getIntersectionIntervals(Intervals intersectionIntervals) {
        Intervals result = new Intervals();
        List intervalList = intersectionIntervals.getIntervals();
        for (int[] interval : intervalList) {
            result.addIntervals(this.getIntersection(interval[0], interval[1]));
        }
        return result;
    }

    public Intervals addIntervals(Intervals additionalIntervals) {
        List intervalList = additionalIntervals.getIntervals();
        for (int[] interval : intervalList) {
            this.addInterval(interval[0], interval[1]);
        }
        return this;
    }

    public List getIntervals() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            list.add(new int[]{(Integer)iter.next(), (Integer)iter.next()});
        }
        return list;
    }

    public boolean isContiguous() {
        return this.intervals.size() <= 2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Intervals)) {
            return false;
        }
        Intervals other = (Intervals)obj;
        List thisIntervals = this.getIntervals();
        List otherIntervals = other.getIntervals();
        if (thisIntervals.size() != otherIntervals.size()) {
            return false;
        }
        for (int i = 0; i < thisIntervals.size(); ++i) {
            int[] otherInt;
            int[] thisInt = (int[])thisIntervals.get(i);
            if (thisInt[0] == (otherInt = (int[])otherIntervals.get(i))[0] && thisInt[1] == otherInt[1]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.intervals.size() == 0) {
            return 0;
        }
        return this.intervals.getLast().hashCode();
    }

    public String toString() {
        return this.intervals.toString();
    }

    public int[] getBoundingInterval() {
        int[] result = new int[2];
        if (this.hasIntervals()) {
            result[0] = (Integer)this.intervals.getFirst();
            result[1] = (Integer)this.intervals.getLast();
        } else {
            result[0] = Integer.MIN_VALUE;
            result[1] = Integer.MAX_VALUE;
        }
        return result;
    }

    public Intervals copy() {
        return new Intervals(this.intervals);
    }
}

