/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.AbstractTransform;
import com.metamatrix.common.types.TransformationException;
import java.math.BigDecimal;

public class BigDecimalToBooleanTransform
extends AbstractTransform {
    private static final BigDecimal FALSE = new BigDecimal("0");
    private static final BigDecimal TRUE = new BigDecimal("1");

    public Object transform(Object value) throws TransformationException {
        if (value == null) {
            return value;
        }
        if (value.equals(FALSE)) {
            return Boolean.FALSE;
        }
        if (value.equals(TRUE)) {
            return Boolean.TRUE;
        }
        throw new TransformationException("ERR.003.029.0007", CommonPlugin.Util.getString("ERR.003.029.0007", value));
    }

    public Class getSourceType() {
        return BigDecimal.class;
    }

    public Class getTargetType() {
        return Boolean.class;
    }

    public boolean isNarrowing() {
        return true;
    }
}

