/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.client.IConnectionInstanceMgr;
import com.metamatrix.platform.security.api.FindResourcesRequest;
import com.metamatrix.platform.security.api.FindResourcesResult;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClientHeartbeat {
    static final int DEFAULT_RETRY_WAIT = 1000;
    static final int DEFAULT_RETRY_COUNT = 5;
    private static Map threadMap = Collections.synchronizedMap(new HashMap(5));
    private IConnectionInstanceMgr instanceMgr;
    private ILogon remoteProxy;
    private long betweenHeartbeats;
    int retryCount = 5;
    int retryWait = 1000;
    private MetaMatrixSessionID sessionID;
    private static Object lockObject = new Object();
    private String clusterName = null;
    private String serviceType = null;
    private boolean stickyConnections;

    ClientHeartbeat(ILogon logonAPI, MetaMatrixSessionID sessionID, String clusterName, String serviceType, IConnectionInstanceMgr instanceMgr, boolean stickyConnections) {
        this.remoteProxy = logonAPI;
        this.sessionID = sessionID;
        this.instanceMgr = instanceMgr;
        this.clusterName = clusterName;
        this.serviceType = serviceType;
        this.betweenHeartbeats = sessionID.getClientPingInterval();
        this.stickyConnections = stickyConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startHeartbeat() throws CommunicationException {
        Object object = lockObject;
        synchronized (object) {
            ClientHeartBeatThread thread = (ClientHeartBeatThread)threadMap.get(this.clusterName);
            if (thread == null) {
                thread = new ClientHeartBeatThread(this.clusterName);
                threadMap.put(this.clusterName, thread);
                thread.start();
            }
            thread.addSession(this.sessionID, this.remoteProxy, this.serviceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopHeartbeat() {
        if (CommPlatformPlugin.DEBUG) {
            CommPlatformPlugin.Util.log(1, "Stopping heartbeat for sessionID=" + this.sessionID);
        }
        Object object = lockObject;
        synchronized (object) {
            ClientHeartBeatThread thread = (ClientHeartBeatThread)threadMap.get(this.clusterName);
            if (thread != null) {
                thread.removeSession(this.sessionID);
                if (!thread.keepAlive()) {
                    threadMap.remove(this.clusterName);
                    thread.endThread();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientHeartBeatThread getClientHeartBeatThread() {
        Object object = lockObject;
        synchronized (object) {
            return (ClientHeartBeatThread)threadMap.get(this.clusterName);
        }
    }

    static boolean isHeartbeatAlive(String clsName) {
        ClientHeartBeatThread thread = (ClientHeartBeatThread)threadMap.get(clsName);
        if (thread != null) {
            return thread.keepAlive();
        }
        return false;
    }

    private void refreshConnectionResources(String resourceType, List resources, String clusterName) throws CommunicationException {
        this.instanceMgr.loadServerInstances(resources, resourceType, clusterName);
    }

    private boolean isConnectionAlive() {
        try {
            this.instanceMgr.getServerInstance(this.clusterName, this.serviceType, this.stickyConnections, true);
            return true;
        }
        catch (CommunicationException e) {
            return false;
        }
    }

    class ClientHeartBeatThread
    extends Thread {
        private String clustername;
        private Map proxyMap = Collections.synchronizedMap(new HashMap());
        private Map sessionMap = Collections.synchronizedMap(new HashMap(15));
        private Map resourceMap = Collections.synchronizedMap(new HashMap(5));
        private Set badSessionIDs = new HashSet();
        private boolean endThread = false;

        public ClientHeartBeatThread(String clusterName) {
            this.clustername = clusterName;
            this.setName(this.clustername + "_ClientHeartBeat");
            this.setDaemon(true);
        }

        public synchronized void addSession(MetaMatrixSessionID sessionID, ILogon logonAPI, String resourceType) {
            Set<MetaMatrixSessionID> sessionSet = null;
            if (this.sessionMap.containsKey(resourceType)) {
                sessionSet = (Set)this.sessionMap.get(resourceType);
                if (!sessionSet.contains(sessionID)) {
                    sessionSet.add(sessionID);
                }
            } else {
                sessionSet = new HashSet(10);
                sessionSet.add(sessionID);
            }
            this.sessionMap.put(resourceType, sessionSet);
            this.proxyMap.put(sessionID, logonAPI);
            this.resourceMap.put(resourceType, Collections.EMPTY_LIST);
        }

        public synchronized void removeSession(MetaMatrixSessionID sessionID) {
            HashSet keyCopy = new HashSet(this.sessionMap.keySet());
            for (String resourceType : keyCopy) {
                Set sessionSet = (Set)this.sessionMap.get(resourceType);
                if (sessionSet == null) {
                    return;
                }
                sessionSet.remove(sessionID);
                if (!sessionSet.isEmpty()) continue;
                this.sessionMap.remove(resourceType);
            }
            this.proxyMap.remove(sessionID);
        }

        public synchronized List getResources(String type) throws ApplicationException {
            if (this.resourceMap.containsKey(type)) {
                return (List)this.resourceMap.get(type);
            }
            return Collections.EMPTY_LIST;
        }

        public void endThread() {
            this.endThread = true;
            this.interrupt();
        }

        public synchronized boolean keepAlive() {
            return !this.sessionMap.isEmpty();
        }

        public void run() {
            while (!this.endThread) {
                try {
                    Thread.sleep(ClientHeartbeat.this.betweenHeartbeats);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.endThread) break;
                if (!ClientHeartbeat.this.isConnectionAlive()) {
                    ClientHeartbeat.this.stopHeartbeat();
                    CommPlatformPlugin.Util.log(1, "Pinging server lost connection, stopping Ping for this Session!");
                    if (this.endThread) break;
                }
                String resourceType2 = "";
                try {
                    for (String resourceType2 : this.resourceMap.keySet()) {
                        Set sessionSet = (Set)this.sessionMap.get(resourceType2);
                        if (sessionSet == null || sessionSet.size() <= 0) continue;
                        List resources = new ArrayList();
                        try {
                            resources = this.findResources(sessionSet, resourceType2);
                        }
                        catch (CommunicationException e) {
                            ClientHeartbeat.this.stopHeartbeat();
                        }
                        ClientHeartbeat.this.refreshConnectionResources(resourceType2, resources, this.clustername);
                    }
                }
                catch (CommunicationException err) {
                    CommPlatformPlugin.Util.log(4, CommPlatformPlugin.Util.getString("ClientHeartbeat.Error_refreshing_resources", resourceType2));
                }
                this.removeBadSessionIDs();
            }
        }

        private synchronized void flagBadSessionIDs(Collection sessionIDs) {
            if (sessionIDs.size() > 0) {
                CommPlatformPlugin.Util.log(1, "Sessions invalid - removing: " + this.idsToString(sessionIDs));
            }
            this.badSessionIDs.addAll(sessionIDs);
        }

        private synchronized String idsToString(Collection collection) {
            StringBuffer result = new StringBuffer();
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                result.append(((MetaMatrixSessionID)iter.next()).getValue());
                result.append(", ");
            }
            return result.toString();
        }

        private synchronized void removeBadSessionIDs() {
            for (MetaMatrixSessionID sessionID : this.badSessionIDs) {
                this.removeSession(sessionID);
            }
            this.badSessionIDs.clear();
        }

        private synchronized List findResources(Set sessionSet, String resourceType) throws CommunicationException {
            if (sessionSet == null || sessionSet.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            MetaMatrixSessionID firstSessionID = (MetaMatrixSessionID)sessionSet.iterator().next();
            ILogon api = (ILogon)this.proxyMap.get(firstSessionID);
            Throwable pingError = null;
            boolean success = false;
            List resources = null;
            for (int i = 0; i < ClientHeartbeat.this.retryCount; ++i) {
                try {
                    if (CommPlatformPlugin.DEBUG) {
                        CommPlatformPlugin.Util.log(0, "Pinging server (try #" + (i + 1) + " of " + ClientHeartbeat.this.retryCount + ")");
                    }
                    FindResourcesRequest request = new FindResourcesRequest(resourceType, sessionSet);
                    String hostAddress = ClientHeartbeat.this.instanceMgr.getLogonHostAddress(this.clustername, resourceType);
                    request.setConnectedAddress(hostAddress);
                    FindResourcesResult result = api.findResources(request);
                    resources = result.getResources();
                    this.resourceMap.put(resourceType, resources);
                    this.flagBadSessionIDs(result.getInvalidSessionIDs());
                    success = true;
                    break;
                }
                catch (Throwable e) {
                    pingError = e;
                    if (e instanceof CommunicationException || e.getCause() instanceof CommunicationException) break;
                    try {
                        Thread.sleep(ClientHeartbeat.this.retryWait);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (!success) {
                Object[] params = new Object[]{new Integer(ClientHeartbeat.this.retryCount)};
                CommPlatformPlugin.Util.log(4, pingError, CommPlatformPlugin.Util.getString("ClientHeartbeat.Pinging_server_failed_after_{0}_retries.__Notifying_connection.", params));
                this.flagBadSessionIDs(sessionSet);
                throw new CommunicationException();
            }
            return resources;
        }
    }
}

