/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.NewCalculateCostUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleBreakCriteria;
import com.metamatrix.query.optimizer.relational.rules.RuleChooseDependent;
import com.metamatrix.query.optimizer.relational.rules.RulePlanJoins;
import com.metamatrix.query.resolver.util.AccessPattern;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JoinRegion {
    private PlanNode joinRoot;
    public static final int UNKNOWN_TUPLE_EST = 100000;
    private LinkedHashMap dependentJoinSourceNodes = new LinkedHashMap();
    private LinkedHashMap joinSourceNodes = new LinkedHashMap();
    private List dependentCritieraNodes = new ArrayList();
    private List criteriaNodes = new ArrayList();
    private List unsatisfiedAccessPatterns = new LinkedList();
    private Map dependentCriteriaElements = null;
    private Map critieriaToSourceMap = null;

    JoinRegion() {
    }

    public PlanNode getJoinRoot() {
        return this.joinRoot;
    }

    public List getUnsatisfiedAccessPatterns() {
        return this.unsatisfiedAccessPatterns;
    }

    public Map getJoinSourceNodes() {
        return this.joinSourceNodes;
    }

    public Map getDependentJoinSourceNodes() {
        return this.dependentJoinSourceNodes;
    }

    public List getCriteriaNodes() {
        return this.criteriaNodes;
    }

    public List getDependentCriteriaNodes() {
        return this.dependentCritieraNodes;
    }

    public Map getDependentCriteriaElements() {
        return this.dependentCriteriaElements;
    }

    public Map getCritieriaToSourceMap() {
        return this.critieriaToSourceMap;
    }

    public void addJoinSourceNode(PlanNode sourceNode) {
        PlanNode root = sourceNode;
        while (root.getParent() != null && root.getParent().getType() == 13) {
            root = root.getParent();
        }
        if (sourceNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            Collection aps = (Collection)sourceNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
            this.unsatisfiedAccessPatterns.add(aps);
            this.dependentJoinSourceNodes.put(sourceNode, root);
        } else {
            this.joinSourceNodes.put(sourceNode, root);
        }
        if (this.joinRoot == null) {
            this.joinRoot = root;
        }
    }

    public PlanNode addParentCriteria(PlanNode sourceNode) {
        PlanNode parent;
        for (parent = sourceNode.getParent(); parent != null && parent.getType() == 13; parent = parent.getParent()) {
            this.criteriaNodes.add(parent);
            sourceNode = parent;
        }
        if (this.joinRoot == null) {
            this.joinRoot = sourceNode;
        }
        return parent;
    }

    public void addJoinCriteriaList(List joinCriteria) {
        if (joinCriteria == null || joinCriteria.isEmpty()) {
            return;
        }
        for (Criteria crit : joinCriteria) {
            this.criteriaNodes.add(RuleBreakCriteria.createSelectNode((Criteria)crit));
        }
    }

    public void reconstructJoinRegoin() {
        LinkedHashMap combined = new LinkedHashMap(this.joinSourceNodes);
        combined.putAll(this.dependentJoinSourceNodes);
        PlanNode root = null;
        if (combined.size() < 2) {
            root = (PlanNode)combined.values().iterator().next();
        } else {
            root = RulePlanJoins.createJoinNode();
            for (Map.Entry entry : combined.entrySet()) {
                PlanNode joinSourceRoot = (PlanNode)entry.getValue();
                if (root.getChildCount() == 2) {
                    PlanNode parentJoin = RulePlanJoins.createJoinNode();
                    parentJoin.addFirstChild(root);
                    parentJoin.addGroups((Collection)root.getGroups());
                    root.setParent(parentJoin);
                    root = parentJoin;
                }
                root.addLastChild(joinSourceRoot);
                root.addGroups((Collection)((PlanNode)entry.getKey()).getGroups());
                joinSourceRoot.setParent(root);
            }
        }
        LinkedList<PlanNode> temp = new LinkedList<PlanNode>();
        temp.add(root);
        while (!temp.isEmpty()) {
            PlanNode node = (PlanNode)temp.removeLast();
            if (node.getType() == 19 && node.getChildCount() == 0) continue;
            node.removeProperty((Object)NodeConstants.Info.EST_CARDINALITY);
            temp.addAll(node.getChildren());
        }
        LinkedList criteria = new LinkedList(this.dependentCritieraNodes);
        criteria.addAll(this.criteriaNodes);
        PlanNode parent = this.joinRoot.getParent();
        boolean isLeftChild = parent.getFirstChild() == this.joinRoot;
        parent.removeChild(this.joinRoot);
        for (PlanNode critNode : criteria) {
            critNode.setParent(null);
            critNode.getChildren().clear();
            critNode.addFirstChild(root);
            root.setParent(critNode);
            root = critNode;
            critNode.removeProperty((Object)NodeConstants.Info.IS_COPIED);
            critNode.removeProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        }
        if (isLeftChild) {
            parent.addFirstChild(root);
        } else {
            parent.addLastChild(root);
        }
        root.setParent(parent);
        this.joinRoot = root;
    }

    public double scoreRegion(Object[] joinOrder, QueryMetadataInterface metadata) {
        ArrayList joinSourceEntries = new ArrayList(this.joinSourceNodes.entrySet());
        double totalIntermediatCost = 0.0;
        double cost = 1.0;
        HashSet criteria = new HashSet(this.criteriaNodes);
        HashSet groups = new HashSet(this.joinSourceNodes.size());
        for (int i = 0; i < joinOrder.length; ++i) {
            PlanNode joinSource;
            Collection requiredGroups;
            Integer source = (Integer)joinOrder[i];
            Map.Entry entry = (Map.Entry)joinSourceEntries.get(source);
            PlanNode joinSourceRoot = (PlanNode)entry.getValue();
            if (!this.unsatisfiedAccessPatterns.isEmpty() && (requiredGroups = (Collection)(joinSource = (PlanNode)entry.getKey()).getProperty((Object)NodeConstants.Info.REQUIRED_ACCESS_PATTERN_GROUPS)) != null && !groups.containsAll(requiredGroups)) {
                return Double.MAX_VALUE;
            }
            groups.addAll(joinSourceRoot.getGroups());
            float sourceCost = ((Float)joinSourceRoot.getProperty((Object)NodeConstants.Info.EST_CARDINALITY)).floatValue();
            if (sourceCost == -1.0f) {
                sourceCost = 100000.0f;
            } else if (Double.isInfinite(sourceCost) || Double.isNaN(sourceCost)) {
                sourceCost = 1000000.0f;
            }
            cost *= (double)sourceCost;
            if (!criteria.isEmpty() && i > 0) {
                List applicableCriteria = this.getJoinCriteriaForGroups(groups, criteria);
                for (PlanNode criteriaNode : applicableCriteria) {
                    float filter = ((Float)criteriaNode.getProperty((Object)NodeConstants.Info.EST_SELECTIVITY)).floatValue();
                    cost *= (double)filter;
                }
                criteria.removeAll(applicableCriteria);
            }
            totalIntermediatCost += cost;
        }
        return totalIntermediatCost;
    }

    public boolean isSatisfiable() {
        if (this.getUnsatisfiedAccessPatterns().isEmpty()) {
            return true;
        }
        for (Collection accessPatterns : this.getUnsatisfiedAccessPatterns()) {
            boolean matchedAll = false;
            for (AccessPattern ap : accessPatterns) {
                if (!this.dependentCriteriaElements.keySet().containsAll(ap.getUnsatisfied())) continue;
                matchedAll = true;
                break;
            }
            if (matchedAll) continue;
            return false;
        }
        return true;
    }

    public void initializeCostingInformation(QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        for (PlanNode node : this.joinSourceNodes.values()) {
            float value = NewCalculateCostUtil.computeCostForTree(node, metadata);
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Float(value));
        }
        this.estimateCriteriaSelectivity(metadata);
    }

    private void estimateCriteriaSelectivity(QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        for (PlanNode node : this.criteriaNodes) {
            Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            float[] baseCosts = new float[]{100.0f, 10000.0f, 1000000.0f};
            float filterValue = 0.0f;
            for (int j = 0; j < baseCosts.length; ++j) {
                float filter = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(baseCosts[j], node, crit, metadata);
                filterValue += filter / baseCosts[j];
            }
            node.setProperty((Object)NodeConstants.Info.EST_SELECTIVITY, (Object)new Float(filterValue /= (float)baseCosts.length));
        }
    }

    public void initializeJoinInformation() {
        this.critieriaToSourceMap = new HashMap();
        LinkedList crits = new LinkedList(this.criteriaNodes);
        crits.addAll(this.dependentCritieraNodes);
        LinkedHashMap source = new LinkedHashMap(this.joinSourceNodes);
        source.putAll(this.dependentJoinSourceNodes);
        for (PlanNode critNode : crits) {
            block1: for (GroupSymbol group : critNode.getGroups()) {
                for (PlanNode node : source.keySet()) {
                    if (!node.getGroups().contains(group)) continue;
                    HashSet<PlanNode> sources = (HashSet<PlanNode>)this.critieriaToSourceMap.get(critNode);
                    if (sources == null) {
                        sources = new HashSet<PlanNode>();
                        this.critieriaToSourceMap.put(critNode, sources);
                    }
                    sources.add(node);
                    continue block1;
                }
            }
        }
        if (this.unsatisfiedAccessPatterns.isEmpty()) {
            return;
        }
        HashMap<GroupSymbol, PlanNode> dependentGroupToSourceMap = new HashMap<GroupSymbol, PlanNode>();
        for (PlanNode node : this.dependentJoinSourceNodes.keySet()) {
            for (GroupSymbol symbol : node.getGroups()) {
                dependentGroupToSourceMap.put(symbol, node);
            }
        }
        Iterator<Object> i = this.getCriteriaNodes().iterator();
        block5: while (i.hasNext()) {
            PlanNode node;
            node = (PlanNode)i.next();
            for (GroupSymbol symbol : node.getGroups()) {
                if (!dependentGroupToSourceMap.containsKey(symbol)) continue;
                i.remove();
                this.dependentCritieraNodes.add(node);
                continue block5;
            }
        }
        this.dependentCriteriaElements = new HashMap();
        for (PlanNode critNode : this.dependentCritieraNodes) {
            Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            Collection[] groups = RuleChooseDependent.isEqualityCriteria((Criteria)crit);
            if (groups == null) continue;
            CompareCriteria compareCriteria = (CompareCriteria)crit;
            Collection[] critElements = new Collection[]{ElementCollectorVisitor.getElements((LanguageObject)compareCriteria.getLeftExpression(), (boolean)true), ElementCollectorVisitor.getElements((LanguageObject)compareCriteria.getRightExpression(), (boolean)true)};
            for (int expr = 0; expr < critElements.length; ++expr) {
                ElementSymbol elem;
                if (critElements[expr].size() != 1 || !dependentGroupToSourceMap.containsKey((elem = (ElementSymbol)critElements[expr].iterator().next()).getGroupSymbol()) || JoinRegion.containsFunctionsThatCannotBePushed(expr == 0 ? compareCriteria.getRightExpression() : compareCriteria.getLeftExpression())) continue;
                HashSet<Collection> independentGroups = (HashSet<Collection>)this.dependentCriteriaElements.get(elem);
                if (independentGroups == null) {
                    independentGroups = new HashSet<Collection>();
                    this.dependentCriteriaElements.put(elem, independentGroups);
                }
                independentGroups.add(groups[(expr + 1) % 2]);
            }
        }
    }

    private static boolean containsFunctionsThatCannotBePushed(Expression expression) {
        for (Function function : FunctionCollectorVisitor.getFunctions((LanguageObject)expression, (boolean)true)) {
            if (function.getFunctionDescriptor().getPushdown() != 1) continue;
            return true;
        }
        return false;
    }

    public List getJoinCriteriaForGroups(Set groups) {
        return this.getJoinCriteriaForGroups(groups, this.getCriteriaNodes());
    }

    protected List getJoinCriteriaForGroups(Set groups, Collection nodes) {
        LinkedList<PlanNode> result = new LinkedList<PlanNode>();
        for (PlanNode critNode : nodes) {
            if (!groups.containsAll(critNode.getGroups())) continue;
            result.add(critNode);
        }
        return result;
    }

    public void changeJoinOrder(Object[] joinOrder) {
        ArrayList joinSourceEntries = new ArrayList(this.joinSourceNodes.entrySet());
        for (int i = 0; i < joinOrder.length; ++i) {
            Integer source = (Integer)joinOrder[i];
            Map.Entry entry = (Map.Entry)joinSourceEntries.get(source);
            this.joinSourceNodes.remove(entry.getKey());
            this.joinSourceNodes.put(entry.getKey(), entry.getValue());
        }
    }
}

