/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.ui.wizards;

import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.MetamodelDescriptor;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.jdbc.ui.util.JdbcUiUtil;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportWizard;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelProjectSelectionStatusValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelResourceSelectionValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelWorkspaceViewerFilter;
import com.metamatrix.modeler.jdbc.CaseConversion;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.SourceNames;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.ui.viewsupport.ModelingResourceFilter;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.dialog.FolderSelectionDialog;
import com.metamatrix.ui.internal.product.ProductCustomizerMgr;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.util.WizardUtil;
import com.metamatrix.ui.internal.widget.Label;
import com.metamatrix.ui.internal.wizard.IPersistentWizardPage;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JdbcImportOptionsPage
extends WizardPage
implements InternalUiConstants.Widgets,
IPersistentWizardPage,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcImportOptionsPage.class);
    private static final String TITLE = JdbcImportOptionsPage.getString("title");
    private static final int COLUMN_COUNT = 3;
    private static final String INITIAL_MESSAGE_ID = "initialMessage";
    private static final String INITIAL_MESSAGE_HIDDEN_PROJECT_ID = "initialMessageHiddenProject";
    private static final String NO_NODEL_TO_UPDATE_MESSAGE_ID = "noModelToUpdateMessage";
    private static final String NAME_LABEL = JdbcImportOptionsPage.getString("nameLabel");
    private static final String FOLDER_LABEL = JdbcImportOptionsPage.getString("folderLabel");
    private static final String UPDATE_CHECKBOX = JdbcImportOptionsPage.getString("updateCheckBox");
    private static final String VIRTUAL_MODEL_CHECKBOX = "Make target model virtual";
    private static final String INCLUDE_GROUP = JdbcImportOptionsPage.getString("includeGroup");
    private static final String MODEL_OBJECT_NAMES_GROUP = JdbcImportOptionsPage.getString("modelObjectNamesGroup");
    private static final String SOURCE_OBJECT_NAMES_GROUP = JdbcImportOptionsPage.getString("sourceObjectNamesGroup");
    private static final String NONE_BUTTON = JdbcImportOptionsPage.getString("noneButton");
    private static final String UPPERCASE_BUTTON = JdbcImportOptionsPage.getString("uppercaseButton");
    private static final String LOWERCASE_BUTTON = JdbcImportOptionsPage.getString("lowercaseButton");
    private static final String EMPTY_BUTTON = JdbcImportOptionsPage.getString("emptyButton");
    private static final String UNQUALIFIED_BUTTON = JdbcImportOptionsPage.getString("unqualifiedSourceNamesButton");
    private static final String QUALIFIED_BUTTON = JdbcImportOptionsPage.getString("qualifiedSourceNamesButton");
    private static final String INCLUDE_DESCRIPTION = JdbcImportOptionsPage.getString("includeDescription");
    private static final String MODEL_OBJECT_NAMES_DESCRIPTION = JdbcImportOptionsPage.getString("modelObjectNamesDescription");
    private static final String SOURCE_OBJECT_NAMES_DESCRIPTION = JdbcImportOptionsPage.getString("sourceObjectNamesDescription");
    private static final String FILE_EXISTS_MESSAGE = JdbcImportOptionsPage.getString("fileExistsMessage", UPDATE_CHECKBOX);
    private static final String NOT_MODEL_PROJECT_MESSAGE = JdbcImportOptionsPage.getString("notModelProjectMessage");
    private static final String NOT_RELATIONAL_MODEL_MESSAGE = JdbcImportOptionsPage.getString("notRelationalModelMessage");
    private static final String READ_ONLY_MODEL_MESSAGE = JdbcImportOptionsPage.getString("readOnlyModelMessage");
    private static final String VIRTUAL_MODEL_MESSAGE = JdbcImportOptionsPage.getString("virtualModelMessage");
    private static final String PHYSICAL_MODEL_MESSAGE = "The model to update is not a virtual model.";
    private JdbcDatabase db;
    private JdbcImportSettings importSettings;
    private Text nameText;
    private Text folderText;
    private Button updateCheckBox;
    private Button catalogCheckBox;
    private Button schemaCheckBox;
    private Button noneButton;
    private Button uppercaseButton;
    private Button lowercaseButton;
    private Button emptyButton;
    private Button unqualifiedButton;
    private Button qualifiedButton;
    private Button virtualModelBox;
    private boolean initd;
    private IContainer folder;
    private boolean usesHiddenProject = false;
    private IFile selectedModel;
    private boolean isVirtual = false;

    private static String getString(String id) {
        return Util.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, Object parameter) {
        return Util.getString(I18N_PREFIX + id, parameter);
    }

    protected JdbcImportOptionsPage() {
        super(ClassUtil.getSimpleClassName(JdbcImportOptionsPage.class), TITLE, null);
    }

    public void createControl(Composite parent) {
        this.usesHiddenProject = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric();
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)pg);
        WidgetFactory.createLabel((Composite)pg, (String)NAME_LABEL);
        this.nameText = WidgetFactory.createTextField((Composite)pg, (int)768);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcImportOptionsPage.this.nameModified();
            }
        });
        Button btn = WidgetFactory.createButton((Composite)pg, (String)BROWSE_BUTTON);
        btn.setToolTipText(JdbcImportOptionsPage.getString("browseModelButton.tip"));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.browseModelSelected();
            }
        });
        Label folderLabel = WidgetFactory.createLabel((Composite)pg, (String)FOLDER_LABEL);
        IContainer folder = ((JdbcImportWizard)this.getWizard()).getFolder();
        String name = folder == null ? null : folder.getFullPath().makeRelative().toString();
        this.folderText = WidgetFactory.createTextField((Composite)pg, (int)768, (String)name);
        if (this.usesHiddenProject) {
            this.folderText.setEditable(false);
            this.folderText.setVisible(false);
            folderLabel.setVisible(false);
        }
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcImportOptionsPage.this.folderModified();
            }
        });
        if (!this.usesHiddenProject) {
            WidgetFactory.createButton((Composite)pg, (String)BROWSE_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JdbcImportOptionsPage.this.browseButtonSelected();
                }
            });
        }
        this.virtualModelBox = WidgetFactory.createCheckBox((Composite)pg, (String)VIRTUAL_MODEL_CHECKBOX, (int)0, (int)3);
        this.virtualModelBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.virtualModelBoxSelected();
            }
        });
        this.virtualModelBox.setSelection(this.isVirtual);
        this.updateCheckBox = WidgetFactory.createCheckBox((Composite)pg, (String)UPDATE_CHECKBOX, (int)0, (int)3);
        this.updateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.updateCheckBoxSelected();
            }
        });
        Group inclGroup = WidgetFactory.createGroup((Composite)pg, (String)INCLUDE_GROUP, (int)256, (int)3);
        WidgetFactory.createLabel((Composite)inclGroup, (int)768, (String)INCLUDE_DESCRIPTION, (int)64);
        this.catalogCheckBox = WidgetFactory.createCheckBox((Composite)inclGroup, (int)768);
        this.catalogCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.catalogCheckBoxSelected();
            }
        });
        this.schemaCheckBox = WidgetFactory.createCheckBox((Composite)inclGroup, (int)768);
        this.schemaCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.schemaCheckBoxSelected();
            }
        });
        Group modelObjNamesGroup = WidgetFactory.createGroup((Composite)pg, (String)MODEL_OBJECT_NAMES_GROUP, (int)256, (int)3);
        WidgetFactory.createLabel((Composite)modelObjNamesGroup, (int)768, (String)MODEL_OBJECT_NAMES_DESCRIPTION, (int)64);
        this.noneButton = WidgetFactory.createRadioButton((Composite)modelObjNamesGroup, (String)NONE_BUTTON);
        this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.noneButtonSelected();
            }
        });
        this.uppercaseButton = WidgetFactory.createRadioButton((Composite)modelObjNamesGroup, (String)UPPERCASE_BUTTON);
        this.uppercaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.uppercaseButtonSelected();
            }
        });
        this.lowercaseButton = WidgetFactory.createRadioButton((Composite)modelObjNamesGroup, (String)LOWERCASE_BUTTON);
        this.lowercaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.lowercaseButtonSelected();
            }
        });
        Group srcObjNamesGroup = WidgetFactory.createGroup((Composite)pg, (String)SOURCE_OBJECT_NAMES_GROUP, (int)256, (int)3);
        WidgetFactory.createLabel((Composite)srcObjNamesGroup, (int)768, (String)SOURCE_OBJECT_NAMES_DESCRIPTION, (int)64);
        this.emptyButton = WidgetFactory.createRadioButton((Composite)srcObjNamesGroup, (String)EMPTY_BUTTON);
        this.emptyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.emptyButtonSelected();
            }
        });
        this.unqualifiedButton = WidgetFactory.createRadioButton((Composite)srcObjNamesGroup, (String)UNQUALIFIED_BUTTON);
        this.unqualifiedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.unqualifiedButtonSelected();
            }
        });
        this.qualifiedButton = WidgetFactory.createRadioButton((Composite)srcObjNamesGroup, (String)QUALIFIED_BUTTON);
        this.qualifiedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.qualifiedButtonSelected();
            }
        });
    }

    public void saveSettings() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        JdbcImportWizard wizard = (JdbcImportWizard)this.getWizard();
        JdbcImportSettings importSettings = wizard.getSource().getImportSettings();
        try {
            DatabaseMetaData metadata = wizard.getDatabase().getDatabaseMetaData();
            dlgSettings.put(metadata.getCatalogTerm(), importSettings.isCreateCatalogsInModel());
            dlgSettings.put(metadata.getSchemaTerm(), importSettings.isCreateSchemasInModel());
        }
        catch (Exception err) {
            Util.log((Throwable)err);
            WidgetUtil.showError((Throwable)err);
        }
        dlgSettings.put(MODEL_OBJECT_NAMES_GROUP, importSettings.getConvertCaseInModel().getName());
        dlgSettings.put(SOURCE_OBJECT_NAMES_GROUP, importSettings.getGenerateSourceNamesInModel().getName());
    }

    public boolean updateSelected() {
        if (this.updateCheckBox != null) {
            return this.updateCheckBox.getSelection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        if (visible) {
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Initializing Optioin Settings", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.initializeInTransaction();
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        super.setVisible(visible);
    }

    void initializeInTransaction() {
        JdbcImportWizard wizard = (JdbcImportWizard)this.getWizard();
        this.db = wizard.getDatabase();
        String name = wizard.getModelName();
        this.nameText.setText(name);
        try {
            JdbcSource src = wizard.getSource();
            JdbcPlugin.recordJdbcDatabaseSelections((JdbcSource)src, (JdbcDatabase)this.db);
            this.importSettings = src.getImportSettings();
            if (!this.initd) {
                this.setInitd(true);
                IDialogSettings dlgSettings = this.getDialogSettings();
                DatabaseMetaData metadata = this.db.getDatabaseMetaData();
                String catalogTerm = metadata.getCatalogTerm();
                String schemaTerm = metadata.getSchemaTerm();
                if (!((JdbcImportWizard)this.getWizard()).isUpdatedModel() && dlgSettings.get(catalogTerm) != null) {
                    this.importSettings.setCreateCatalogsInModel(dlgSettings.getBoolean(catalogTerm));
                    this.importSettings.setCreateSchemasInModel(dlgSettings.getBoolean(schemaTerm));
                    this.importSettings.setConvertCaseInModel(CaseConversion.get((String)dlgSettings.get(MODEL_OBJECT_NAMES_GROUP)));
                    this.importSettings.setGenerateSourceNamesInModel(SourceNames.get((String)dlgSettings.get(SOURCE_OBJECT_NAMES_GROUP)));
                }
                boolean supportsCatalogs = false;
                ResultSet resultSet = metadata.getCatalogs();
                while (resultSet.next()) {
                    String catalogName = resultSet.getString(1);
                    if (catalogName.length() <= 0) continue;
                    supportsCatalogs = true;
                }
                Composite parent = null;
                if (this.catalogCheckBox != null && !this.catalogCheckBox.isDisposed()) {
                    parent = this.catalogCheckBox.getParent();
                } else if (this.schemaCheckBox != null && !this.schemaCheckBox.isDisposed()) {
                    parent = this.schemaCheckBox.getParent();
                }
                if (parent != null) {
                    String finalCatalogTerm = catalogTerm;
                    if (!supportsCatalogs) {
                        finalCatalogTerm = "";
                    }
                    this.initializeIncludeCheckBox(this.catalogCheckBox, finalCatalogTerm, this.importSettings.isCreateCatalogsInModel());
                    this.initializeIncludeCheckBox(this.schemaCheckBox, schemaTerm, this.importSettings.isCreateSchemasInModel());
                    if (this.catalogCheckBox.isDisposed() && this.schemaCheckBox.isDisposed()) {
                        parent.dispose();
                        ((Composite)this.getControl()).layout();
                    }
                }
            }
            switch (this.importSettings.getConvertCaseInModel().getValue()) {
                case 0: {
                    this.noneButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.uppercaseButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.lowercaseButton.setSelection(true);
                }
            }
            switch (this.importSettings.getGenerateSourceNamesInModel().getValue()) {
                case 0: {
                    this.emptyButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.unqualifiedButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.qualifiedButton.setSelection(true);
                }
            }
        }
        catch (Exception err) {
            JdbcUiUtil.showAccessError((Throwable)err);
        }
        this.validatePage();
        if (this.isPageComplete()) {
            if (this.usesHiddenProject) {
                this.setMessage(JdbcImportOptionsPage.getString(INITIAL_MESSAGE_HIDDEN_PROJECT_ID, name));
            } else {
                this.setMessage(JdbcImportOptionsPage.getString(INITIAL_MESSAGE_ID, name));
            }
        }
    }

    protected JdbcImportSettings getImportSettings() {
        return this.importSettings;
    }

    void browseModelSelected() {
        MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/Relational");
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)JdbcImportOptionsPage.getString("dialog.modelChooser.title"), (String)JdbcImportOptionsPage.getString("dialog.modelChooser.msg"), (boolean)false, (Object)((JdbcImportWizard)this.getWizard()).getFolder(), (ViewerFilter)new ModelWorkspaceViewerFilter(true), (ISelectionStatusValidator)new ModelResourceSelectionValidator(descriptor, false));
        if (resources != null && resources.length > 0) {
            IFile model = (IFile)resources[0];
            try {
                ModelResource mr = ModelUtilities.getModelResource((IFile)model, (boolean)true);
                this.isVirtual = mr.getModelAnnotation().getModelType().equals(ModelType.VIRTUAL_LITERAL);
                this.virtualModelBox.setSelection(this.isVirtual);
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
            this.selectedModel = model;
            IContainer folder = model.getParent();
            this.nameText.setText(model.getName());
            this.folderText.setText(folder == null ? "" : folder.getFullPath().makeRelative().toString());
            this.updateCheckBox.setSelection(true);
            this.updateCheckBoxSelected();
        } else {
            this.selectedModel = null;
        }
    }

    void browseButtonSelectedOLD() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                try {
                    return ((IContainer)element).getProject().getNature("com.metamatrix.modeler.core.modelNature") != null;
                }
                catch (CoreException err) {
                    UiConstants.Util.log((Throwable)err);
                    return false;
                }
            }
        };
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((JdbcImportWizard)this.getWizard()).getFolder(), (ViewerFilter)new ModelingResourceFilter(filter), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null) {
            this.folderText.setText(folder.getFullPath().makeRelative().toString());
            this.validatePage();
        }
    }

    void browseButtonSelected() {
        IContainer folder = this.getFolder();
        if (folder != null) {
            this.folderText.setText(folder.getFullPath().makeRelative().toString());
            this.validatePage();
        }
    }

    private IContainer getFolder() {
        ViewerFilter filter = this.getFilter();
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)((JdbcImportWizard)this.getWizard()).getFolder());
        dlg.addFilter((ViewerFilter)new ModelingResourceFilter(filter));
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        return objs.length == 0 ? null : (IContainer)objs[0];
    }

    private ViewerFilter getFilter() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean projectOpen;
                boolean result = false;
                if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                    if (element instanceof IProject) {
                        result = true;
                    } else if (element instanceof IFolder) {
                        result = true;
                    }
                }
                return result;
            }
        };
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void catalogCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Catalog Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.importSettings.setCreateCatalogsInModel(this.catalogCheckBox.getSelection());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emptyButtonSelected() {
        if (this.emptyButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Empty Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setGenerateSourceNamesInModel(SourceNames.NONE_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    void folderModified() {
        this.validatePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lowercaseButtonSelected() {
        if (this.lowercaseButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Lower Case Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setConvertCaseInModel(CaseConversion.TO_LOWERCASE_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    void nameModified() {
        this.validatePage();
    }

    protected void newFolderButtonSelected(TreeViewer viewer, IContainer folder) {
        NewFolderDialog dlg = new NewFolderDialog(this.getShell(), folder);
        if (dlg.open() == 0) {
            viewer.refresh((Object)folder);
            Object newFolder = dlg.getResult()[0];
            viewer.setSelection((ISelection)new StructuredSelection(newFolder), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noneButtonSelected() {
        if (this.noneButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set None Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setConvertCaseInModel(CaseConversion.NONE_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void qualifiedButtonSelected() {
        if (this.qualifiedButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Qualified Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setGenerateSourceNamesInModel(SourceNames.FULLY_QUALIFIED_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schemaCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Schema Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.importSettings.setCreateSchemasInModel(this.schemaCheckBox.getSelection());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unqualifiedButtonSelected() {
        if (this.unqualifiedButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Unqualified Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setGenerateSourceNamesInModel(SourceNames.UNQUALIFIED_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    void updateCheckBoxSelected() {
        if (this.updateCheckBox.getSelection()) {
            try {
                ModelResource model = this.getSelectedModelResource();
                if (model != null && !model.isReadOnly() && model.getModelType().getValue() != 1) {
                    this.nameText.setText(model.getItemName());
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
        }
        this.validatePage();
    }

    void virtualModelBoxSelected() {
        this.isVirtual = this.virtualModelBox.getSelection();
        this.validatePage();
    }

    private ModelResource getSelectedModelResource() throws ModelWorkspaceException {
        ModelResource model = null;
        if (this.selectedModel != null) {
            model = ModelUtil.getModel((Object)this.selectedModel);
        } else {
            IStructuredSelection selection = UiUtil.getStructuredSelection();
            if (selection.size() == 1) {
                model = ModelUtil.getModel((Object)selection.getFirstElement());
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uppercaseButtonSelected() {
        if (this.uppercaseButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Uppercase Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setConvertCaseInModel(CaseConversion.TO_UPPERCASE_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void initializeIncludeCheckBox(Button checkBox, String term, boolean selected) {
        if (term.length() == 0) {
            checkBox.dispose();
            ((Composite)this.getControl()).layout();
        } else {
            checkBox.setText(StringUtil.computeDisplayableForm((String)term));
            checkBox.setSelection(selected);
        }
    }

    private void validatePage() {
        block17: {
            boolean updating = this.updateCheckBox.getSelection();
            try {
                String name;
                String problem;
                this.folder = WizardUtil.validateFileAndFolder((Text)this.nameText, (Text)this.folderText, (WizardPage)this, (String)".xmi", (int)(updating ? 0 : 3));
                if (this.folder != null && this.folder.getProject().getNature("com.metamatrix.modeler.core.modelNature") == null) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)NOT_MODEL_PROJECT_MESSAGE, (int)3);
                    this.folder = null;
                }
                if ((problem = ModelUtilities.validateModelName((String)(name = this.nameText.getText()), (String)".xmi")) != null) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)(INVALID_FILE_MESSAGE + '\n' + problem), (int)3);
                    this.folder = null;
                }
                if (this.isPageComplete()) {
                    name = FileUtils.toFileNameWithExtension((String)name, (String)".xmi");
                    IFile file = this.folder.getFile((IPath)new Path(name));
                    ModelResource model = null;
                    if (file.exists()) {
                        try {
                            model = ModelerCore.getModelEditor().findModelResource(file);
                            if (model.isReadOnly()) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)READ_ONLY_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (!"http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)NOT_RELATIONAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (!this.isVirtual() && model.getModelType().getValue() == 1) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)VIRTUAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (this.isVirtual() && model.getModelType().getValue() == 0) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)PHYSICAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                        }
                        catch (ModelWorkspaceException err) {
                            Util.log((Throwable)err);
                            WidgetUtil.showError((String)err.getLocalizedMessage());
                        }
                    } else if (updating) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)JdbcImportOptionsPage.getString(NO_NODEL_TO_UPDATE_MESSAGE_ID, file.getFullPath().makeRelative()), (int)3);
                        return;
                    }
                    JdbcImportWizard wizard = (JdbcImportWizard)this.getWizard();
                    wizard.setModelName(name);
                    wizard.setFolder(this.folder);
                    if (model != wizard.getUpdatedModel()) {
                        ArrayList newlySelectedNodes = new ArrayList();
                        this.collectNewlySelectedNodes(this.db.getChildren(), newlySelectedNodes, this.getOriginalImportSettings(model));
                        wizard.setUpdatedModel(model);
                        this.removeExcludedNodes(newlySelectedNodes);
                    }
                    this.getContainer().updateButtons();
                    break block17;
                }
                if (this.folder != null) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)(this.getMessage() + '\n' + FILE_EXISTS_MESSAGE), (int)this.getMessageType());
                }
            }
            catch (CoreException err) {
                Util.log((Throwable)err);
                WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
            }
        }
    }

    private void collectNewlySelectedNodes(JdbcNode[] children, List newlySelectedNodes, JdbcImportSettings settings) throws CoreException {
        if (children == null) {
            return;
        }
        if (settings != null) {
            int ndx = children.length;
            while (--ndx >= 0) {
                JdbcNode child = children[ndx];
                if (child.getSelectionMode() == 1) {
                    Iterator objIter = settings.getExcludedObjectPaths().iterator();
                    while (objIter.hasNext()) {
                        Path path = new Path((String)objIter.next());
                        if (!child.equals(((JdbcImportWizard)this.getWizard()).findNode((IPath)path, (JdbcNode)this.db))) continue;
                        newlySelectedNodes.add(child);
                        break;
                    }
                }
                if (child.getSelectionMode() != 1 && child.getSelectionMode() != 2) continue;
                this.collectNewlySelectedNodes(child.getChildren(), newlySelectedNodes, settings);
            }
        }
    }

    private JdbcImportSettings getOriginalImportSettings(ModelResource model) throws CoreException {
        if (model != null) {
            for (Object obj : model.getAllRootEObjects()) {
                if (!(obj instanceof JdbcSource)) continue;
                return ((JdbcSource)obj).getImportSettings();
            }
        }
        return ((JdbcImportWizard)this.getWizard()).getSource().getImportSettings();
    }

    private void removeExcludedNodes(List nodes) throws CoreException {
        if (nodes.isEmpty()) {
            return;
        }
        JdbcImportSettings settings = ((JdbcImportWizard)this.getWizard()).getSource().getImportSettings();
        if (settings != null) {
            block0: for (JdbcNode node : nodes) {
                node.setSelected(true);
                Iterator objIter = settings.getExcludedObjectPaths().iterator();
                while (objIter.hasNext()) {
                    Path path = new Path((String)objIter.next());
                    if (!node.equals(((JdbcImportWizard)this.getWizard()).findNode((IPath)path, (JdbcNode)this.db))) continue;
                    objIter.remove();
                    continue block0;
                }
            }
        }
    }

    public boolean canFlipToNextPage() {
        boolean updating = this.updateCheckBox.getSelection();
        IFile file = null;
        if (this.folder != null) {
            String name = this.nameText.getText();
            name = FileUtils.toFileNameWithExtension((String)name, (String)".xmi");
            file = this.folder.getFile((IPath)new Path(name));
        }
        return this.folder != null && file != null && updating && this.isPageComplete() && file.exists();
    }

    public void setInitd(boolean initd) {
        this.initd = initd;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }
}

