/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource.xmi;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.AssertionException;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.Identifiable;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.MetamodelDescriptor;
import com.metamatrix.modeler.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiSaveImpl;
import com.metamatrix.modeler.internal.core.resource.xmi.ProxyReferenceHolder;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.xml.sax.Attributes;

public class MtkXmiHandler
extends SAXXMIHandler {
    private static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    private static final String XSD_URI = "http://www.eclipse.org/xsd/2002/XSD";
    private static final String TARGET_NS_ATTRIBUTE_NAME = "targetNamespace";
    private static final String SDT_DOMAIN_INSTANCE_CLASS_NAME = "com.metamatrix.metamodels.sdt.Domain";
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd")};
    private final MetamodelRegistry registry;
    private final IDGenerator idGenerator;
    private final Container container;
    private final Resource resource;
    private final Collection roots;
    private boolean isXsdResource;
    private List xmlSchemaProxies;
    private List targetNamespaces;
    private final Collection proxyResourceURIs;
    private final Collection modelImportsToConvert;

    public MtkXmiHandler(XMIResource xmiResource, XMLHelper helper, Container container, Map options) {
        super((XMLResource)xmiResource, helper, options);
        if (xmiResource == null) {
            String msg = ModelerCore.Util.getString("MtkXmiHandler.The_XMIResource_reference_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        if (!(xmiResource instanceof MtkXmiResourceImpl)) {
            String msg = ModelerCore.Util.getString("MtkXmiHandler.The_XMIResource_must_be_an_instance_of_MtkXMIResourceImpl_2");
            throw new IllegalArgumentException(msg);
        }
        MtkXmiResourceImpl mtkResource = (MtkXmiResourceImpl)xmiResource;
        this.resource = mtkResource;
        this.registry = mtkResource.getMetamodelRegistry();
        this.idGenerator = IDGenerator.getInstance();
        this.container = container;
        this.xmlSchemaProxies = new LinkedList();
        this.targetNamespaces = new LinkedList();
        this.roots = new ArrayList();
        this.proxyResourceURIs = new HashSet();
        this.modelImportsToConvert = new HashSet();
    }

    public void startElement(String uri, String localName, String name) {
        super.startElement(uri, localName, name);
    }

    protected void handleFeature(String prefix, String name) {
        if ("".equals(prefix) && ("containers".equals(name) || "elements".equals(name)) && this.objects.peek().getClass().getName().startsWith("com.metamatrix.metamodels.xml.impl.")) {
            name = "entities";
        }
        super.handleFeature(prefix, name);
    }

    protected EPackage getPackageForURI(String uriString) {
        if (uriString == null) {
            return null;
        }
        if (this.registry != null && this.registry.containsURI(uriString)) {
            this.ensureMetamodelIsLoaded(this.registry.getURI(uriString));
        }
        return super.getPackageForURI(uriString);
    }

    private void ensureMetamodelIsLoaded(URI metamodelURI) {
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MtkXmiHandler.The_URI_reference_may_not_be_null_3");
            throw new IllegalArgumentException(msg);
        }
        Resource resource = this.registry.getResource(metamodelURI);
        Assertion.assertTrue((boolean)resource.isLoaded());
    }

    private boolean isXsdPrefix(String prefix) {
        MetamodelDescriptor descriptor;
        URI nsUri = ModelerCore.getMetamodelRegistry().getURI(XSD_URI);
        return nsUri != null && (descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(nsUri)) != null && descriptor.getNamespacePrefix().equalsIgnoreCase(prefix);
    }

    protected void createTopObject(String prefix, String name) {
        Object[] params;
        if (this.isXsdPrefix(prefix)) {
            this.isXsdResource = true;
        }
        EFactory eFactory = this.getFactoryForPrefix(prefix);
        EObject newObject = null;
        try {
            newObject = this.createObjectFromFactory(eFactory, name);
        }
        catch (Throwable t) {
            Object[] params2 = new Object[]{prefix, name};
            ModelerCore.Util.log(4, t, ModelerCore.Util.getString("MtkXmiHandler.Error_in_MtkXmiHandler.createTopObject()_1", params2));
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            Object[] params3 = new Object[]{newObject, prefix, name, eFactory};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiHandler.DEBUG.Created_new_EObject_from_prefix,_name,_and_EFactory_1", params3));
        }
        URI uri = this.xmlResource.getURI();
        if (newObject instanceof EPackage && this.registry != null && this.registry.containsURI(uri)) {
            try {
                MetamodelDescriptor descriptor = this.registry.getMetamodelDescriptor(uri);
                if (descriptor == null) {
                    String msg = ModelerCore.Util.getString("MtkXmiHandler.No_metamodel_descriptor_was_found");
                    throw new AssertionException(msg);
                }
                EPackage ePackage = (EPackage)newObject;
                ePackage.setNsPrefix(descriptor.getNamespacePrefix());
                ePackage.setNsURI(uri.toString());
            }
            catch (Throwable t) {
                params = new Object[]{prefix, name};
                ModelerCore.Util.log(4, t, ModelerCore.Util.getString("MtkXmiHandler.Error_in_MtkXmiHandler.createTopObject()_1", params));
            }
        }
        try {
            this.processTopObject(newObject);
        }
        catch (Throwable t) {
            params = new Object[]{prefix, name};
            ModelerCore.Util.log(4, t, ModelerCore.Util.getString("MtkXmiHandler.Error_in_MtkXmiHandler.createTopObject()_1", params));
        }
    }

    protected void processTopObject(EObject object) {
        super.processObject(object);
        this.roots.add(object);
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int size = this.attribs.getLength();
            for (int i = 0; i < size; ++i) {
                String targetNamespace;
                String name = this.attribs.getQName(i);
                if (name.equals("xmi:id")) {
                    this.xmlResource.setID((EObject)internalEObject, this.attribs.getValue(i));
                } else if (name.equals("xmi:uuid") && this.idGenerator != null) {
                    MtkXmiResourceImpl xmiResource = (MtkXmiResourceImpl)this.xmlResource;
                    ObjectID uuid = null;
                    try {
                        String uuidStr = this.attribs.getValue(i);
                        uuid = this.idGenerator.stringToObject(uuidStr);
                        if (obj instanceof ModelImport) {
                            ModelImport modelImport = (ModelImport)obj;
                            String uuidOfRefedModel = modelImport.getUuid();
                            if (uuidOfRefedModel == null) {
                                String uuidAttributeName = CorePackage.eINSTANCE.getModelImport_Uuid().getName();
                                for (int k = i + 1; k < size; ++k) {
                                    String attributeName = this.attribs.getQName(k);
                                    if (!uuidAttributeName.equals(attributeName)) continue;
                                    uuidOfRefedModel = this.attribs.getValue(k);
                                }
                            }
                            if (uuidStr.equals(uuidOfRefedModel)) {
                                uuid = this.idGenerator.create();
                            }
                        }
                        obj.setObjectId(uuid);
                        xmiResource.recordUUID(obj, false);
                    }
                    catch (InvalidIDException e) {
                        ModelerCore.Util.log(4, ModelerCore.Util.getString("MtkXmiHandler.Error_handling_Object_attributes_for_-_5", new Object[]{obj, e.getMessage()}));
                    }
                } else if (name.equals("href")) {
                    String uri = this.attribs.getValue(i);
                    if (uri.startsWith("#")) {
                        uri = this.resourceURI.toString() + uri;
                    }
                    this.handleProxy(internalEObject, uri);
                } else if (!name.startsWith("xmlns") && !this.notFeatures.contains(name)) {
                    EStructuralFeature feature = obj.eClass().getEStructuralFeature(name);
                    if (feature != null && feature.isChangeable()) {
                        this.setAttribValue(obj, name, this.attribs.getValue(i));
                    } else if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(2, ModelerCore.Util.getString("MtkXmiHandler.DEBUG.Unable_to_set_the_value_on_EAttribute_since_it_is_unchangeable._1", (Object)name));
                    }
                    if (obj instanceof EPackage && EcorePackage.eINSTANCE.getEPackage_NsURI().equals(feature)) {
                        EPackage.Registry.INSTANCE.put((Object)this.attribs.getValue(i), (Object)obj);
                    }
                }
                if (name.equalsIgnoreCase("uuid") && this.idGenerator != null) {
                    boolean treatAsObjectId = true;
                    if (obj instanceof ModelImport) {
                        treatAsObjectId = false;
                    } else if (obj instanceof Identifiable) {
                        treatAsObjectId = true;
                    } else if (obj.eClass().getEPackage().getNsURI().equals("http://www.metamatrix.com/metamodels/VirtualDatabase")) {
                        treatAsObjectId = true;
                    } else {
                        treatAsObjectId = false;
                        Object[] params = new Object[]{obj.eClass().getEPackage(), obj.eClass()};
                        String msg = ModelerCore.Util.getString("MtkXmiHandler.UnexpectedUuidFeature", params);
                        ModelerCore.Util.log(4, msg);
                    }
                    if (treatAsObjectId) {
                        MtkXmiResourceImpl xmiResource = (MtkXmiResourceImpl)this.xmlResource;
                        ObjectID uuid = null;
                        try {
                            uuid = this.idGenerator.stringToObject(this.attribs.getValue(i));
                            obj.setObjectId(uuid);
                            xmiResource.recordUUID(obj, false);
                        }
                        catch (InvalidIDException e) {
                            ModelerCore.Util.log(4, ModelerCore.Util.getString("MtkXmiHandler.Error_handling_Object_attributes_for_-_5", new Object[]{obj, e.getMessage()}));
                        }
                    }
                }
                if (!name.equals(TARGET_NS_ATTRIBUTE_NAME) || !SDT_DOMAIN_INSTANCE_CLASS_NAME.equals(obj.eClass().getInstanceClassName()) || (targetNamespace = this.attribs.getValue(i)) == null || targetNamespace.length() <= 0) continue;
                this.targetNamespaces.add(this.attribs.getValue(i));
            }
        }
        this.patchA_modelImport(obj, this.attribs);
    }

    protected void handleProxy(InternalEObject proxy, String uriLiteral) {
        super.handleProxy(proxy, uriLiteral);
        this.proxyResourceURIs.add(proxy.eProxyURI().trimFragment());
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
        try {
            URI proxyURI;
            if (value instanceof EObject && ((EObject)value).eIsProxy() && (proxyURI = ((InternalEObject)value).eProxyURI()) != null && proxyURI.toString().startsWith(MtkXmiSaveImpl.XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX)) {
                ProxyReferenceHolder refHolder = new ProxyReferenceHolder(object, feature, (EObject)value, position);
                this.xmlSchemaProxies.add(refHolder);
            }
            if (this.isXsdResource || this.isXsdPrefix(object.eClass().getEPackage().getNsPrefix())) {
                this.setValue(object, feature, value, position);
                return;
            }
            if (feature instanceof EAttribute && value instanceof String && Date.class.equals((Object)((EAttribute)feature).getEAttributeType().getInstanceClass())) {
                value = this.convertDateFormat((String)value);
            }
            super.setFeatureValue(object, feature, value, position);
        }
        catch (RuntimeException e) {
            this.error((XMIException)new IllegalValueException(object, feature, value, (Exception)e, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
    }

    private String convertDateFormat(String value) {
        Date valueAsDate = null;
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            try {
                valueAsDate = DATE_FORMATS[i].parse(value);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        if (valueAsDate == null) {
            String msg = ModelerCore.Util.getString("MtkXmiHandler.Error_parsing_date_String", (Object)value);
            ModelerCore.Util.log(4, msg);
            return value;
        }
        return DateUtil.getDateAsString(valueAsDate);
    }

    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
        EObject newObject = null;
        if (factory != null) {
            newObject = this.helper.createObject(factory, typeName);
            if (newObject != null) {
                if (this.disableNotify) {
                    newObject.eSetDeliver(false);
                }
                this.handleObjectAttribs(newObject);
                newObject = this.handleEcoreProxy(newObject, this.attribs);
            } else {
                super.error((XMIException)new ClassNotFoundException(typeName, factory, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            }
        }
        return newObject;
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        int kind = this.helper.getFeatureKind(feature);
        switch (kind) {
            case 1: 
            case 2: {
                EClassifier eMetaObject = feature.getEType();
                EDataType eDataType = (EDataType)eMetaObject;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                if (kind == 2) {
                    BasicEList list = (BasicEList)object.eGet(feature);
                    if (position == -2) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)value, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken();
                            list.addUnique(eFactory.createFromString(eDataType, token));
                        }
                        if (!list.isEmpty()) break;
                        list.clear();
                        break;
                    }
                    if (value == null) {
                        list.addUnique(null);
                        break;
                    }
                    list.addUnique(eFactory.createFromString(eDataType, (String)value));
                    break;
                }
                if (value == null) {
                    object.eSet(feature, null);
                    break;
                }
                object.eSet(feature, eFactory.createFromString(eDataType, (String)value));
                break;
            }
            case 3: 
            case 4: {
                BasicEList list = (BasicEList)object.eGet(feature);
                if (position == -1) {
                    list.addUnique(value);
                    break;
                }
                if (position == -2) {
                    list.clear();
                    break;
                }
                if (kind == 3) {
                    list.addUnique(position, value);
                    break;
                }
                list.move(position, value);
                break;
            }
            default: {
                object.eSet(feature, value);
            }
        }
    }

    public void endDocument() {
        this.addNamespaceConversions();
        if (this.isXsdResource) {
            EList topObjects = this.xmlResource.getContents();
            Iterator iter = topObjects.iterator();
            while (iter.hasNext()) {
                this.updateSchema((EObject)iter.next());
            }
        }
        this.resource.getContents().addAll(this.roots);
        this.patchB_modelImport();
        super.endDocument();
    }

    private void addNamespaceConversions() {
        XMLResource resource = this.xmlResource;
        ResourceSet resourceSet = this.resourceSet;
        for (String targetNamespace : this.targetNamespaces) {
            URI logicalURI = URI.createURI((String)targetNamespace);
            URI physicalURI = resource.getURI();
            resourceSet.getURIConverter().getURIMap().put(logicalURI, physicalURI);
        }
    }

    private EObject handleEcoreProxy(EObject obj, Attributes atts) {
        if (atts != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int size = atts.getLength();
            for (int i = 0; i < size; ++i) {
                URI uri;
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (!name.equals("href") || !"http://www.eclipse.org/emf/2002/Ecore".equals((uri = URI.createURI((String)value)).trimFragment().toString()) || this.container == null) continue;
                return EcoreUtil.resolve((EObject)internalEObject, (Resource)this.container.getMetamodelRegistry().getResource(uri));
            }
        }
        return obj;
    }

    private void updateSchema(EObject topObject) {
        Object[] args = new Object[]{};
        Class<?> xmlSchemaClass = topObject.getClass();
        ReflectionHelper helper = new ReflectionHelper(xmlSchemaClass);
        Method updateSchemaMethod = null;
        try {
            updateSchemaMethod = helper.findBestMethodOnTarget("update", args);
        }
        catch (SecurityException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("MtkXmiHandler.Error_execute_the_XSDSchema.update()_method_for_1", (Object)topObject));
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (updateSchemaMethod != null) {
            try {
                updateSchemaMethod.invoke((Object)topObject, args);
            }
            catch (Throwable t) {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("MtkXmiHandler.Error_execute_the_XSDSchema.update()_method_for_2", (Object)topObject));
            }
        }
    }

    protected EObject patchA_modelImport(EObject obj, Attributes attribs) {
        if (obj instanceof ModelImport && attribs != null) {
            int size = attribs.getLength();
            for (int i = 0; i < size; ++i) {
                String qName = attribs.getQName(i);
                String value = attribs.getValue(i);
                if (!qName.equals("path")) continue;
                ((ModelImport)obj).setModelLocation(value);
                this.modelImportsToConvert.add(obj);
            }
        }
        return obj;
    }

    protected void patchB_modelImport() {
        URI deresolvedURI;
        boolean deresolve;
        String uriString;
        String modelLocation;
        if (this.modelImportsToConvert.isEmpty()) {
            return;
        }
        URI eResourceURI = this.resource.getURI();
        if (MANIFEST_MODEL_NAME.equals(eResourceURI.lastSegment())) {
            return;
        }
        this.removeBadProxyResourceUris(this.proxyResourceURIs);
        HashSet unconvertedImports = new HashSet(this.modelImportsToConvert);
        block0: for (ModelImport modelImport : this.modelImportsToConvert) {
            modelLocation = modelImport.getModelLocation().toLowerCase();
            if (modelLocation.startsWith("http") || modelLocation.startsWith("mtkplugin://") || modelLocation.startsWith("pathmap://UML2_METAMODELS/")) {
                unconvertedImports.remove(modelImport);
                continue;
            }
            for (URI importURI : this.proxyResourceURIs) {
                uriString = URI.decode((String)importURI.toString()).toLowerCase();
                if (uriString.startsWith("http") && !uriString.endsWith("xmi") || !uriString.endsWith(modelLocation)) continue;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setModelLocation(URI.decode((String)importURI.toString()));
                unconvertedImports.remove(modelImport);
                continue block0;
            }
        }
        Iterator i = unconvertedImports.iterator();
        block2: while (i.hasNext()) {
            ModelImport modelImport;
            modelImport = (ModelImport)i.next();
            modelLocation = this.removeProjectNameFromLocation(modelImport.getModelLocation()).toLowerCase();
            for (URI importURI : this.proxyResourceURIs) {
                uriString = URI.decode((String)importURI.toString()).toLowerCase();
                if (uriString.startsWith("http") && !uriString.endsWith("xmi") || !uriString.endsWith(modelLocation)) continue;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setModelLocation(URI.decode((String)importURI.toString()));
                i.remove();
                continue block2;
            }
        }
        for (ModelImport modelImport : unconvertedImports) {
            modelImport.setModel(null);
        }
    }

    protected String removeProjectNameFromLocation(String location) {
        String newLocation = location;
        URI uri = URI.createURI((String)location);
        if (uri.segmentCount() > 1) {
            StringBuffer sb = new StringBuffer(location.length());
            String[] segments = uri.segments();
            for (int i = 1; i != segments.length; ++i) {
                sb.append("/");
                sb.append(segments[i]);
            }
            newLocation = sb.toString();
        }
        return newLocation;
    }

    protected void removeBadProxyResourceUris(Collection proxyResourceUris) {
        String uriString;
        if (proxyResourceUris == null || proxyResourceUris.isEmpty()) {
            return;
        }
        ArrayList<URI> badUris = new ArrayList<URI>(proxyResourceUris.size());
        Iterator i = proxyResourceUris.iterator();
        while (i.hasNext()) {
            URI uri = (URI)i.next();
            uriString = uri.toString();
            if (uriString.charAt(0) != '/') continue;
            badUris.add(uri);
            i.remove();
        }
        if (badUris.isEmpty()) {
            return;
        }
        for (URI uri : proxyResourceUris) {
            uriString = URI.decode((String)uri.toString()).toLowerCase();
            Iterator j = badUris.iterator();
            while (j.hasNext()) {
                URI badUri = (URI)j.next();
                String badUriString = URI.decode((String)badUri.toString()).toLowerCase();
                if (!uriString.endsWith(badUriString)) continue;
                j.remove();
            }
        }
        if (!badUris.isEmpty()) {
            proxyResourceUris.addAll(badUris);
        }
    }
}

