/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.host;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.StartupStateController;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.registry.MetaMatrixRegistry;
import com.metamatrix.platform.registry.MetaMatrixVMRegistry;
import com.metamatrix.platform.registry.VMRegistryBinding;
import com.metamatrix.platform.util.MetaMatrixController;
import com.metamatrix.platform.util.VMResources;
import com.metamatrix.platform.vm.util.VMUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HostController
extends Thread {
    private static final int COMMAND_START_ALL_VMS = 0;
    private static final int COMMAND_START_VM = 1;
    private static final int COMMAND_KILL_ALL_VMS = 2;
    private static final int COMMAND_KILL_VM = 3;
    private static final int COMMAND_PING = 4;
    private static final int COMMAND_EXIT = 5;
    private static final int COMMAND_INVALID = 6;
    public static final String START_ALL_VMS = "StartAllVMs";
    public static final String START_VM = "StartVM";
    public static final String KILL_ALL_VMS = "KillAllVMs";
    public static final String KILL_VM = "KillVM";
    public static final String EXIT = "Exit";
    public static final String PING = "Ping";
    public static final int DEFAULT_WAIT_TIME = 60;
    public static final int DEFAULT_PORT = 15001;
    private int port = 15001;
    private static final String[] commands = new String[]{"StartAllVMs", "StartVM", "KillAllVMs", "KillVM", "Ping", "Exit"};
    private static Host host = null;
    private Map processMap = new HashMap(3);
    private ServerSocket serverSocket;
    boolean hcKilled = false;
    private boolean isListening = false;
    private StarterThread starterThread = null;
    private MetaMatrixRegistry registry;

    public HostController(String hostname, boolean startProcesses, int wait) throws Exception {
        super("HostControllerThread");
        this.init();
        this.verifyLicenseFileExist();
        this.registry = MetaMatrixVMRegistry.getInstance();
        this.port = this.getPortNumber();
        VMNaming.setVMPort((int)this.port);
        this.addShutdown();
        if (startProcesses) {
            this.starterThread = new StarterThread(this, wait);
            this.starterThread.start();
        }
    }

    private void init() {
        try {
            VMNaming.setLogicalHostName((String)host.getFullName());
            VMNaming.setHostAddress((String)host.getHostAddress());
            VMNaming.setBindAddress((String)host.getBindAddress());
            String jgba = host.getProperty("jgroups.bind.address");
            if (jgba != null && jgba.length() > 0) {
                VMNaming.setJGroupsBindAddress((String)jgba);
            }
            String hostFileName = StringUtil.replaceAll((String)host.getFullName(), (String)".", (String)"_");
            VMUtils.initializeVMLogFile((String)host.getLogDirectory(), (String)(hostFileName + "_hc.log"));
            if (!this.isAProcessRunning()) {
                String dataDir;
                File dataF;
                String temp_dir = host.getTempDirectory();
                File tempDir = new File(temp_dir);
                if (tempDir.exists()) {
                    FileUtils.removeDirectoryAndChildren((File)tempDir);
                }
                if ((dataF = new File(dataDir = host.getDataDirectory())).exists()) {
                    FileUtils.removeDirectoryAndChildren((File)dataF);
                    dataF.mkdirs();
                }
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
            }
        }
        catch (Exception e) {
            this.logMessage(PlatformPlugin.Util.getString("ERR.014.005.0001", (Object)host.getFullName()));
        }
    }

    private void addShutdown() {
        try {
            HostController.logInfo(PlatformPlugin.Util.getString("MSG.014.005.0001"));
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        }
        catch (Exception e) {
            HostController.logInfo(PlatformPlugin.Util.getString("MSG.014.005.0002"));
        }
    }

    void closeServerSocket() {
        try {
            HostController.logInfo(PlatformPlugin.Util.getString("MSG.014.005.0003"));
            this.serverSocket.close();
        }
        catch (Exception e) {
            HostController.logCritical("ERROR " + PlatformPlugin.Util.getString("ERR.014.005.0002"));
        }
    }

    boolean isListening() {
        return this.isListening;
    }

    String getHostname() {
        return host.getFullName();
    }

    Host getHost() {
        return host;
    }

    boolean isAProcessRunning() {
        try {
            List vms = this.registry.getVMControllerBindings();
            for (VMRegistryBinding vm : vms) {
                if (!this.getHostname().equalsIgnoreCase(vm.getHostName())) continue;
                try {
                    return true;
                }
                catch (Exception e) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void run() {
        String msg;
        HostController.logInfo(PlatformPlugin.Util.getString("MSG.014.005.0004", (Object)this.getHostname()));
        try {
            InetAddress inet = InetAddress.getByName(this.getHost().getBindAddress());
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.005.0012", (Object)Integer.toString(this.port), (Object)this.getHost().getBindAddress()));
            this.serverSocket = SocketHelper.getInternalServerSocket((int)this.port, (int)50, (InetAddress)inet, (boolean)false);
        }
        catch (Exception e) {
            msg = PlatformPlugin.Util.getString("ERR.014.005.0003", this.port);
            HostController.logCritical("ERROR " + msg);
            System.exit(1);
        }
        this.isListening = true;
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.005.0005", this.port));
        try {
            while (true) {
                Socket socket = this.serverSocket.accept();
                ServerThread thread = new ServerThread(this, socket);
                thread.start();
            }
        }
        catch (Exception e) {
            if (!this.hcKilled) {
                msg = PlatformPlugin.Util.getString("ERR.014.005.0004");
                HostController.logCritical("ERROR " + msg);
                e.printStackTrace();
            }
            return;
        }
    }

    private int getPortNumber() throws Exception {
        try {
            String portString = host.getPort();
            return Integer.parseInt(portString);
        }
        catch (Exception e) {
            this.logMessage(PlatformPlugin.Util.getString("ERR.014.005.0005"));
            throw e;
        }
    }

    public static void logInfo(String msg) {
        System.out.println(new Date(System.currentTimeMillis()) + " : " + msg);
    }

    public static void logCritical(String msg) {
        System.out.println("-------------------------------------------------------\n");
        System.out.println(new Date(System.currentTimeMillis()) + " : " + msg);
        System.out.println("-------------------------------------------------------\n");
    }

    private void logMessage(String msg) {
        System.out.println(new Date(System.currentTimeMillis()) + " : " + msg);
    }

    private static void printUsage() {
        String msg = "java com.metamatrix.platform.host.HostController [-port portNum] [-startProcesses] [-wait] [-help]\nWhere:\n                  -help\n                  -host hostName (deprecated, see -config)\n                  -config hostName\n                  -noprocesses";
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyLicenseFileExist() {
        boolean lfexist = false;
        String licenseFile = LicenseChecker.getLicenseFileName();
        InputStream input = null;
        try {
            input = ClassLoader.getSystemResourceAsStream(licenseFile);
            if (input != null) {
                lfexist = true;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ioe) {}
            }
        }
        if (!lfexist) {
            HostController.logCritical(PlatformPlugin.Util.getString("HostController.License_file_not_found", (Object)licenseFile));
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        HostController controller = null;
        String hostname = null;
        int wait = 60;
        boolean startProcesses = true;
        int parmIndex = args.length;
        for (int i = 0; i < parmIndex; ++i) {
            String command = args[i];
            if (command.equalsIgnoreCase("-config") || command.equalsIgnoreCase("-host")) {
                if (++i == parmIndex) {
                    HostController.printUsage();
                    System.exit(-1);
                    continue;
                }
                hostname = args[i];
                continue;
            }
            if (command.equalsIgnoreCase("-noprocesses")) {
                startProcesses = false;
                continue;
            }
            if (!command.equalsIgnoreCase("-help")) continue;
            HostController.printUsage();
            System.exit(-1);
        }
        String logMsg = "startserver ";
        for (int i = 0; i < args.length; ++i) {
            logMsg = logMsg + args[i] + " ";
        }
        try {
            if (hostname == null) {
                hostname = NetUtils.getHostname();
                logMsg = logMsg + "resolved host " + hostname;
            }
            HostController.logCritical(logMsg);
            host = CurrentConfiguration.findHost((String)hostname);
            if (host != null) {
                hostname = host.getFullName();
                if (NetUtils.ping((String)host.getHostAddress(), (int)Integer.parseInt(host.getPort()))) {
                    HostController.logCritical(PlatformPlugin.Util.getString("HostController.Host_is_already_running_startprocesses", (Object)hostname));
                    MetaMatrixController.startHost((String)host.getName());
                    System.exit(1);
                }
            }
            HostController.checkToPromoteNextStartupConfig(hostname);
            if (host == null) {
                host = CurrentConfiguration.findHost((String)hostname);
                if (host == null) {
                    HostController.logCritical("ERROR " + PlatformPlugin.Util.getString("ERR.014.005.0001", (Object)hostname));
                    System.exit(-1);
                }
                hostname = host.getFullName();
            }
            controller = new HostController(hostname, startProcesses, wait);
            controller.start();
        }
        catch (Exception e) {
            HostController.logCritical("ERROR " + PlatformPlugin.Util.getString("ERR.014.005.0011"));
            System.exit(1);
        }
    }

    private static boolean checkToPromoteNextStartupConfig(String hostname) {
        try {
            if (!HostController.isAHostRunning(hostname)) {
                StartupStateController.performSystemInitialization((boolean)true);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isAHostRunning(String hostname) {
        try {
            Collection hosts = CurrentConfiguration.getConfigurationModel().getHosts();
            if (hosts.size() > 1) {
                for (Host h : hosts) {
                    if (!NetUtils.ping((String)h.getHostAddress(), (int)Integer.parseInt(h.getPort()))) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        VMResources.initResourceBundles();
    }

    private class ServerThread
    extends Thread {
        private BufferedReader in;
        private Socket socket;
        private HostController hc;

        public ServerThread(HostController hostController2, Socket socket) throws Exception {
            this.socket = socket;
            this.hc = hostController2;
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        public void run() {
            boolean done = false;
            while (!done) {
                String command = this.readCommand();
                if (command != null) {
                    this.processCommand(command);
                    continue;
                }
                done = true;
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String readCommand() {
            try {
                String line = this.in.readLine();
                return line;
            }
            catch (IOException e) {
                e.printStackTrace();
                HostController.this.logMessage(PlatformPlugin.Util.getString("ERR.014.005.0008"));
                return null;
            }
        }

        private void processCommand(String commandLine) {
            List parsedCommand = StringUtil.split((String)commandLine, (String)" \t");
            int numTokens = parsedCommand.size();
            if (numTokens == 0) {
                return;
            }
            String command = parsedCommand.get(0).toString().toLowerCase();
            int commandType = 6;
            for (int i = 0; i < 6; ++i) {
                if (!command.equalsIgnoreCase(commands[i])) continue;
                commandType = i;
                break;
            }
            switch (commandType) {
                case 0: {
                    this.doStartAllVMs();
                    break;
                }
                case 1: {
                    if (numTokens < 2) {
                        HostController.this.logMessage(PlatformPlugin.Util.getString("MSG.014.005.0010"));
                        break;
                    }
                    String vmName = (String)parsedCommand.get(1);
                    this.doStartVM(vmName);
                    break;
                }
                case 2: {
                    this.doKillAllVMs();
                    break;
                }
                case 3: {
                    if (numTokens < 2) {
                        HostController.this.logMessage(PlatformPlugin.Util.getString("MSG.014.005.0010"));
                        break;
                    }
                    String vmName = (String)parsedCommand.get(1);
                    this.doKillVM(vmName);
                    break;
                }
                case 4: {
                    this.doPing();
                    break;
                }
                case 5: {
                    this.doExit();
                    break;
                }
            }
        }

        void doStartAllVMs() {
            HostController.this.logMessage(HostController.START_ALL_VMS);
            try {
                String hostname = this.hc.getHostname();
                CurrentConfiguration.verifyBootstrapProperties();
                ConfigurationModelContainer currentConfig = CurrentConfiguration.getConfigurationModel();
                Collection deployedVMs = currentConfig.getConfiguration().getVMsForHost(hostname);
                if (deployedVMs != null && deployedVMs.size() > 0) {
                    for (VMComponentDefn deployedVM : deployedVMs) {
                        Properties vmPropsAndConfigProps = new Properties();
                        Properties props = currentConfig.getDefaultPropertyValues(deployedVM.getComponentTypeID());
                        Properties vmProps = currentConfig.getConfiguration().getAllPropertiesForComponent(deployedVM.getID());
                        vmPropsAndConfigProps.putAll((Map<?, ?>)props);
                        vmPropsAndConfigProps.putAll((Map<?, ?>)this.hc.getHost().getProperties());
                        vmPropsAndConfigProps.putAll((Map<?, ?>)vmProps);
                        this.startVM(deployedVM.getID().getName(), hostname, deployedVM.isEnabled(), vmPropsAndConfigProps);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                HostController.this.logMessage(e.getMessage());
            }
        }

        private void doStartVM(String vmName) {
            HostController.this.logMessage("StartVM " + vmName);
            try {
                Host h = this.hc.getHost();
                CurrentConfiguration.verifyBootstrapProperties();
                ConfigurationModelContainer currentConfig = CurrentConfiguration.getConfigurationModel();
                VMComponentDefn deployedVM = currentConfig.getConfiguration().getVMForHost(h.getFullName(), vmName);
                if (deployedVM != null) {
                    Properties vmPropsAndConfigProps = new Properties();
                    Properties props = currentConfig.getDefaultPropertyValues(deployedVM.getComponentTypeID());
                    Properties vmProps = currentConfig.getConfiguration().getAllPropertiesForComponent(deployedVM.getID());
                    vmPropsAndConfigProps.putAll((Map<?, ?>)props);
                    vmPropsAndConfigProps.putAll((Map<?, ?>)this.hc.getHost().getProperties());
                    vmPropsAndConfigProps.putAll((Map<?, ?>)vmProps);
                    this.startVM(deployedVM.getID().getName(), h.getFullName(), deployedVM.isEnabled(), vmPropsAndConfigProps);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void doKillAllVMs() {
            HostController.this.logMessage(HostController.KILL_ALL_VMS);
            HashMap copyMap = new HashMap();
            copyMap.putAll(HostController.this.processMap);
            for (String vmName : copyMap.keySet()) {
                this.doKillVM(vmName);
            }
            HostController.this.processMap.clear();
        }

        private void doKillVM(String vmName) {
            Process process;
            HostController.this.logMessage("KillVM " + vmName);
            for (VMRegistryBinding binding : HostController.this.registry.getVMControllerBindings()) {
                if (!binding.getHostName().equalsIgnoreCase(this.hc.getHostname()) || !binding.getVMName().equalsIgnoreCase(vmName)) continue;
                try {
                    binding.getVMController().shutdownNow();
                }
                catch (Exception e) {}
                break;
            }
            if ((process = (Process)HostController.this.processMap.get(vmName.toUpperCase())) != null) {
                HostController.this.processMap.remove(vmName.toUpperCase());
                process.destroy();
            }
        }

        private void doPing() {
        }

        private void doExit() {
            this.doKillAllVMs();
            System.exit(0);
        }

        private void startVM(String vmName, String hostName, boolean enabled, Properties props) throws Exception {
            String name = vmName.toUpperCase();
            if (HostController.this.processMap.containsKey(name)) {
                HostController.this.logMessage(PlatformPlugin.Util.getString("MSG.014.005.0011", (Object)vmName));
                this.doKillVM(vmName);
            }
            if (enabled) {
                HostController.this.processMap.put(name, VMUtils.startDeployVM((String)vmName, (String)hostName, (Properties)props, (Host)host));
            } else {
                HostController.this.logMessage(PlatformPlugin.Util.getString("HostController.VM_is_not_enabled_to_start", (Object)vmName));
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        private HostController hostController;

        public ShutdownThread(HostController hc) {
            super("ShutdownTread");
            this.hostController = hc;
        }

        public void run() {
            this.hostController.hcKilled = true;
            this.hostController.closeServerSocket();
            try {
                List vms = HostController.this.registry.getVMControllerBindings();
                for (VMRegistryBinding vm : vms) {
                    if (!this.hostController.getHostname().equalsIgnoreCase(vm.getHostName())) continue;
                    try {
                        vm.getVMController().shutdown();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable err) {
                // empty catch block
            }
            for (String vmName : HostController.this.processMap.keySet()) {
                HostController.this.logMessage(PlatformPlugin.Util.getString("MSG.014.005.0009", (Object)vmName));
                Process process = (Process)HostController.this.processMap.get(vmName);
                process.destroy();
                Object var3_4 = null;
            }
            HostController.this.processMap.clear();
        }
    }

    public class StarterThread
    extends Thread {
        private HostController hc;
        private int wait;

        public StarterThread(HostController hc, int wait) {
            super("StarterThread");
            this.hc = hc;
            this.wait = wait;
        }

        public void run() {
            while (!this.hc.isListening()) {
                try {
                    Thread.sleep(this.wait);
                }
                catch (Exception e) {}
            }
            try {
                String host = this.hc.getHostname();
                HostController.logInfo(PlatformPlugin.Util.getString("MSG.014.005.0008", (Object)host));
                MetaMatrixController.startHost((String)host);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.005.0007"));
            }
        }
    }
}

