/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.function.aggregate.AggregateFunction;
import com.metamatrix.query.function.aggregate.Avg;
import com.metamatrix.query.function.aggregate.ConstantFunction;
import com.metamatrix.query.function.aggregate.Count;
import com.metamatrix.query.function.aggregate.Max;
import com.metamatrix.query.function.aggregate.Min;
import com.metamatrix.query.function.aggregate.NullFilter;
import com.metamatrix.query.function.aggregate.Sum;
import com.metamatrix.query.processor.relational.DuplicateFilter;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.SortUtility;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GroupingNode
extends RelationalNode {
    private List sortElements;
    private List sortTypes;
    private int phase = 1;
    private Map elementMap;
    private List collectedExpressions;
    private TupleBatch sourceBatch;
    private int sourceRow;
    private List[] collectedRows;
    private TupleSourceID collectionID;
    private int rowCount;
    private SortUtility sortUtility;
    private TupleSourceID sortedID;
    private Map expressionMap;
    private AggregateFunction[] functions;
    private TupleBatch groupBatch;
    private int groupBegin = 1;
    private int groupBatchIndex = 1;
    private List lastRow;
    private TupleSourceID outputID;
    private List outputRows;
    private int outputRow = 1;
    private int outputCount = 0;
    private static final int COLLECTION = 1;
    private static final int SORT = 2;
    private static final int GROUP = 3;
    private static final int OUTPUT = 4;

    public GroupingNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.phase = 1;
        this.elementMap = null;
        this.collectedExpressions = null;
        this.sourceBatch = null;
        this.sourceRow = -1;
        this.collectedRows = null;
        this.collectionID = null;
        this.rowCount = 0;
        this.sortUtility = null;
        this.sortedID = null;
        this.expressionMap = null;
        this.functions = null;
        this.groupBatch = null;
        this.groupBegin = 1;
        this.groupBatchIndex = 1;
        this.lastRow = null;
        this.outputID = null;
        this.outputRows = null;
        this.outputRow = 1;
        this.outputCount = 0;
    }

    public void setGroupingElements(List groupingElements) {
        this.sortElements = groupingElements;
        if (groupingElements != null) {
            this.sortTypes = new ArrayList(groupingElements.size());
            for (int i = 0; i < groupingElements.size(); ++i) {
                this.sortTypes.add(OrderBy.ASC);
            }
        }
    }

    public void open() throws MetaMatrixComponentException {
        super.open();
        List sourceElements = this.getChildren()[0].getElements();
        this.elementMap = this.createLookupMap(sourceElements);
        this.collectExpressions();
        this.collectionID = this.getBufferManager().createTupleSource(this.collectedExpressions, TypeRetrievalUtil.getTypeNames((List)this.collectedExpressions), this.getConnectionID(), 1);
        this.initializeFunctionAccumulators();
    }

    private void collectExpressions() {
        if (this.sortElements != null) {
            this.collectedExpressions = new ArrayList(this.sortElements.size() + this.getElements().size());
            this.collectedExpressions.addAll(this.sortElements);
        } else {
            this.collectedExpressions = new ArrayList(this.getElements().size());
        }
        for (Object outputSymbol : this.getElements()) {
            AggregateSymbol agg;
            Expression expr;
            if (!(outputSymbol instanceof AggregateSymbol) || (expr = (agg = (AggregateSymbol)outputSymbol).getExpression()) == null || this.collectedExpressions.contains(expr)) continue;
            this.collectedExpressions.add(expr);
        }
        this.expressionMap = this.createLookupMap(this.collectedExpressions);
    }

    private void initializeFunctionAccumulators() {
        this.functions = new AggregateFunction[this.getElements().size()];
        for (int i = 0; i < this.getElements().size(); ++i) {
            Object symbol = this.getElements().get(i);
            if (symbol instanceof AggregateSymbol) {
                AggregateSymbol aggSymbol = (AggregateSymbol)symbol;
                if (aggSymbol.getExpression() == null) {
                    this.functions[i] = new Count();
                    this.functions[i].initialize(null);
                    continue;
                }
                String function = aggSymbol.getAggregateFunction();
                this.functions[i] = function.equals("COUNT") ? new Count() : (function.equals("SUM") ? new Sum() : (function.equals("AVG") ? new Avg() : (function.equals("MIN") ? new Min() : new Max())));
                if (aggSymbol.isDistinct()) {
                    this.functions[i] = new DuplicateFilter(this.functions[i], this.getBufferManager(), this.getConnectionID(), this.getBatchSize());
                }
                this.functions[i] = new NullFilter(this.functions[i]);
                this.functions[i].initialize(aggSymbol.getType());
                continue;
            }
            this.functions[i] = new ConstantFunction();
            this.functions[i].initialize(((SingleElementSymbol)symbol).getType());
        }
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        try {
            if (this.phase == 1) {
                this.collectionPhase();
            }
            if (this.phase == 2) {
                this.sortPhase();
            }
            if (this.phase == 3) {
                this.groupPhase();
            }
            if (this.phase == 4) {
                return this.outputPhase();
            }
        }
        catch (TupleSourceNotFoundException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        TupleBatch terminationBatch = new TupleBatch(1, Collections.EMPTY_LIST);
        terminationBatch.setTerminationFlag(true);
        return terminationBatch;
    }

    private void collectionPhase() throws BlockedException, TupleSourceNotFoundException, MetaMatrixComponentException, MetaMatrixProcessingException {
        RelationalNode sourceNode = this.getChildren()[0];
        try {
            while (true) {
                if (this.sourceBatch == null) {
                    this.sourceBatch = sourceNode.nextBatch();
                }
                if (this.sourceBatch.getRowCount() > 0) {
                    this.rowCount = this.sourceBatch.getEndRow();
                    this.sourceRow = this.sourceBatch.getBeginRow();
                    this.collectedRows = new List[this.sourceBatch.getRowCount()];
                    for (int row = this.sourceRow; row <= this.sourceBatch.getEndRow(); ++row) {
                        List tuple = this.sourceBatch.getTuple(row);
                        int columns = this.collectedExpressions.size();
                        ArrayList<Object> exprTuple = new ArrayList<Object>(columns);
                        for (int col = 0; col < columns; ++col) {
                            Object value = ExpressionEvaluator.evaluate((Expression)((Expression)this.collectedExpressions.get(col)), (Map)this.elementMap, (List)tuple, (LookupEvaluator)this.getDataManager(), (CommandContext)this.getContext());
                            exprTuple.add(value);
                        }
                        this.collectedRows[row - this.sourceBatch.getBeginRow()] = exprTuple;
                    }
                    TupleBatch exprBatch = new TupleBatch(this.sourceBatch.getBeginRow(), this.collectedRows);
                    this.getBufferManager().addTupleBatch(this.collectionID, exprBatch);
                }
                this.sourceRow = -1;
                this.collectedRows = null;
                if (this.sourceBatch.getTerminationFlag()) {
                    this.sourceBatch = null;
                    break;
                }
                this.sourceBatch = null;
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        if (this.sortElements == null || this.rowCount == 0) {
            this.sortedID = this.collectionID;
            this.collectionID = null;
            this.phase = 3;
        } else {
            this.sortUtility = new SortUtility(this.collectionID, this.collectedExpressions, this.sortElements, this.sortTypes, false, this.getBufferManager(), this.getConnectionID());
            this.phase = 2;
        }
    }

    private void sortPhase() throws BlockedException, TupleSourceNotFoundException, MetaMatrixComponentException {
        this.sortedID = this.sortUtility.sort();
        this.phase = 3;
    }

    private void groupPhase() throws BlockedException, TupleSourceNotFoundException, MetaMatrixComponentException {
        if (this.outputID == null) {
            List elements = this.getElements();
            this.outputID = this.getBufferManager().createTupleSource(elements, TypeRetrievalUtil.getTypeNames((List)elements), this.getConnectionID(), 1);
        }
        try {
            while (this.groupBegin <= this.rowCount) {
                if (this.groupBatch == null || this.groupBatchIndex > this.groupBatch.getEndRow()) {
                    if (this.groupBatch != null) {
                        this.getBufferManager().unpinTupleBatch(this.sortedID, this.groupBatch.getBeginRow(), this.groupBatch.getEndRow());
                    }
                    TupleBatch newBatch = null;
                    try {
                        newBatch = this.getBufferManager().pinTupleBatch(this.sortedID, this.groupBegin, this.groupBegin + this.getBatchSize());
                    }
                    catch (MemoryNotAvailableException e) {
                        throw BlockedOnMemoryException.INSTANCE;
                    }
                    this.groupBatch = newBatch;
                    this.groupBegin += this.groupBatch.getRowCount();
                    if (this.groupBatch.getRowCount() == 0) continue;
                }
                while (this.groupBatchIndex <= this.groupBatch.getEndRow()) {
                    List tuple = this.groupBatch.getTuple(this.groupBatchIndex);
                    ++this.groupBatchIndex;
                    if (this.lastRow == null) {
                        this.lastRow = tuple;
                    } else if (!this.sameGroup(tuple, this.lastRow)) {
                        int i;
                        ArrayList<Object> row = new ArrayList<Object>(this.functions.length);
                        for (i = 0; i < this.functions.length; ++i) {
                            row.add(this.functions[i].getResult());
                        }
                        this.addOutputRow(row);
                        for (i = 0; i < this.functions.length; ++i) {
                            this.functions[i].reset();
                        }
                        this.lastRow = tuple;
                    }
                    this.updateAggregates(tuple);
                }
            }
            if (this.rowCount != 0 || this.sortElements == null) {
                ArrayList<Object> row = new ArrayList<Object>(this.functions.length);
                for (int i = 0; i < this.functions.length; ++i) {
                    row.add(this.functions[i].getResult());
                }
                this.addOutputRow(row);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        this.closeOutputBatch(true);
        this.getBufferManager().setStatus(this.outputID, 2);
        this.outputRow = 1;
        this.outputCount = this.getBufferManager().getRowCount(this.outputID);
        this.phase = 4;
    }

    private void addOutputRow(List row) throws TupleSourceNotFoundException, TupleSourceNotFoundException, MetaMatrixComponentException {
        if (this.outputRows == null) {
            this.outputRows = new ArrayList(this.getBatchSize());
        }
        this.outputRows.add(row);
        this.closeOutputBatch(false);
    }

    private void closeOutputBatch(boolean force) throws TupleSourceNotFoundException, TupleSourceNotFoundException, MetaMatrixComponentException {
        if (this.outputRows != null && (force || this.outputRows.size() == this.getBatchSize())) {
            TupleBatch outputBatch = new TupleBatch(this.outputRow, this.outputRows);
            this.getBufferManager().addTupleBatch(this.outputID, outputBatch);
            this.outputRow += outputBatch.getRowCount();
            this.outputRows = null;
        }
    }

    private boolean sameGroup(List newTuple, List oldTuple) {
        if (this.sortElements == null) {
            return true;
        }
        for (int i = this.sortElements.size() - 1; i >= 0; --i) {
            Object oldValue = oldTuple.get(i);
            Object newValue = newTuple.get(i);
            if (oldValue == null) {
                if (newValue == null) continue;
                return false;
            }
            if (newValue == null) {
                return false;
            }
            if (oldValue.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private void updateAggregates(List tuple) throws MetaMatrixComponentException, ExpressionEvaluationException {
        for (int i = 0; i < this.functions.length; ++i) {
            SingleElementSymbol expression = (SingleElementSymbol)this.getElements().get(i);
            if (expression instanceof AggregateSymbol) {
                expression = ((AggregateSymbol)expression).getExpression();
            }
            if (expression instanceof ExpressionSymbol && !(expression instanceof AggregateSymbol)) {
                expression = ((ExpressionSymbol)expression).getExpression();
            }
            Object value = null;
            if (expression != null) {
                Integer exprIndex = (Integer)this.expressionMap.get(expression);
                value = tuple.get(exprIndex);
            }
            this.functions[i].addInput(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleBatch outputPhase() throws BlockedException, TupleSourceNotFoundException, MetaMatrixComponentException {
        if (this.outputCount == 0 || this.outputRow > this.outputCount) {
            TupleBatch terminationBatch = new TupleBatch(1, Collections.EMPTY_LIST);
            terminationBatch.setTerminationFlag(true);
            return terminationBatch;
        }
        int beginPinned = this.outputRow;
        int endPinned = this.outputRow + this.getBatchSize() - 1;
        TupleBatch outputBatch = null;
        try {
            outputBatch = this.getBufferManager().pinTupleBatch(this.outputID, beginPinned, endPinned);
        }
        catch (MemoryNotAvailableException e) {
            throw BlockedOnMemoryException.INSTANCE;
        }
        try {
            this.outputRow += outputBatch.getRowCount();
            if (this.outputRow > this.outputCount) {
                outputBatch.setTerminationFlag(true);
            }
            TupleBatch tupleBatch = outputBatch;
            return tupleBatch;
        }
        finally {
            this.getBufferManager().unpinTupleBatch(this.outputID, beginPinned, endPinned);
        }
    }

    public void close() throws MetaMatrixComponentException {
        if (!this.isClosed()) {
            super.close();
            try {
                if (this.collectionID != null) {
                    this.getBufferManager().removeTupleSource(this.collectionID);
                }
                if (this.sortedID != null) {
                    this.getBufferManager().removeTupleSource(this.sortedID);
                }
                if (this.outputID != null) {
                    this.getBufferManager().removeTupleSource(this.outputID);
                }
            }
            catch (TupleSourceNotFoundException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
        }
    }

    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.sortElements);
    }

    public Object clone() {
        GroupingNode clonedNode = new GroupingNode(super.getID());
        super.copy(this, clonedNode);
        if (this.sortElements != null) {
            clonedNode.sortElements = new ArrayList(this.sortElements);
        }
        if (this.sortTypes != null) {
            clonedNode.sortTypes = new ArrayList(this.sortTypes);
        }
        return clonedNode;
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Grouping");
        if (this.sortElements != null) {
            int elements = this.sortElements.size();
            ArrayList<String> groupCols = new ArrayList<String>(elements);
            for (int i = 0; i < elements; ++i) {
                groupCols.add(this.sortElements.get(i).toString());
            }
            props.put("groupCols", groupCols);
        }
        return props;
    }
}

