/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.UnresolvedSymbolDescription;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.CommandResolver;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolveVirtualGroupCriteriaVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.GroupContext;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UpdateProcedureResolver
implements CommandResolver {
    public void resolveVirtualGroupElements(CreateUpdateProcedureCommand procCommand, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        GroupSymbol virtualGroup = procCommand.getVirtualGroup();
        if (virtualGroup == null) {
            for (GroupSymbol groupSymbol : procCommand.getAllExternalGroups()) {
                String groupName = groupSymbol.getName();
                if (groupName.equalsIgnoreCase("INPUT") || groupName.equalsIgnoreCase("CHANGING")) continue;
                ResolveGroupsVisitor.resolveGroups((LanguageObject)groupSymbol, (QueryMetadataInterface)metadata);
                procCommand.setVirtualGroup(groupSymbol);
                virtualGroup = groupSymbol;
                break;
            }
        }
        if (virtualGroup == null) {
            throw new QueryResolverException("ERR.015.008.0012", QueryPlugin.Util.getString("ERR.015.008.0012"));
        }
        ResolveVirtualGroupCriteriaVisitor.resolveCriteria((LanguageObject)procCommand, (GroupSymbol)virtualGroup, (QueryMetadataInterface)metadata);
        if (useMetadataCommands) {
            Command transformCmd = this.getQueryTransformCmd(virtualGroup, metadata);
            ArrayList<Map> symbolMaps = new ArrayList<Map>();
            if (transformCmd instanceof SetQuery) {
                SetQuery setQuery = (SetQuery)transformCmd;
                Iterator iter = setQuery.getQueries().iterator();
                while (iter.hasNext()) {
                    symbolMaps.add(this.createSymbolMap(virtualGroup, (Command)iter.next(), metadata));
                }
            } else {
                symbolMaps.add(this.createSymbolMap(virtualGroup, transformCmd, metadata));
            }
            procCommand.setSymbolMaps(symbolMaps);
        }
    }

    private Command getQueryTransformCmd(GroupSymbol virtualGroup, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Command transformCmd = null;
        QueryNode queryNode = metadata.getVirtualPlan(virtualGroup.getMetadataID());
        String transformQuery = queryNode.getQuery();
        QueryParser parser = new QueryParser();
        try {
            transformCmd = parser.parseCommand(transformQuery);
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)e, "ERR.015.008.0013", QueryPlugin.Util.getString("ERR.015.008.0013", (Object)virtualGroup));
        }
        QueryResolver.resolveCommand((Command)transformCmd, (QueryMetadataInterface)metadata);
        return transformCmd;
    }

    private Map createSymbolMap(GroupSymbol virtualGroup, Command transformCmd, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException {
        String virtualGroupName = virtualGroup.getName();
        HashMap<ElementSymbol, SingleElementSymbol> symbolMap = new HashMap<ElementSymbol, SingleElementSymbol>();
        List projectCols = transformCmd.getProjectedSymbols();
        for (SingleElementSymbol symbol : projectCols) {
            String shortName = symbol.getShortName();
            String virtualElementName = virtualGroupName + QueryPlugin.Util.getString("UpdateProcedureResolver.._1") + shortName;
            ElementSymbol virtualElement = new ElementSymbol(virtualElementName);
            virtualElement.setGroupSymbol(virtualGroup);
            ResolverVisitor.resolveLanguageObject((LanguageObject)virtualElement, (QueryMetadataInterface)metadata);
            SingleElementSymbol mappedExpr = symbol;
            if (symbol instanceof AliasSymbol) {
                mappedExpr = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                mappedExpr = ((ExpressionSymbol)symbol).getExpression();
            }
            symbolMap.put(virtualElement, mappedExpr);
        }
        return symbolMap;
    }

    public void resolveCommand(Command command, boolean useMetadataCommands, TempMetadataAdapter metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
        GroupContext externalGroups = command.getExternalGroupContexts();
        LinkedList<ElementSymbol> symbols = new LinkedList<ElementSymbol>();
        if (procCommand.isUpdateProcedure()) {
            this.resolveVirtualGroupElements(procCommand, useMetadataCommands, (QueryMetadataInterface)metadata);
            String countVar = "VARIABLES.ROWS_UPDATED";
            ElementSymbol updateCount = new ElementSymbol(countVar);
            updateCount.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            symbols.add(updateCount);
        }
        GroupSymbol variables = new GroupSymbol("VARIABLES");
        externalGroups.addGroup(variables);
        metadata.getMetadataStore().addTempGroup("VARIABLES", symbols);
        variables.setMetadataID((Object)metadata.getMetadataStore().getTempGroupID(variables.getCanonicalName()));
        ResolverUtil.resolveElementsInGroup((GroupSymbol)variables, (QueryMetadataInterface)metadata);
        this.resolveBlock(procCommand, procCommand.getBlock(), externalGroups, metadata, useMetadataCommands, procCommand.isUpdateProcedure(), analysis);
    }

    private void resolveBlock(CreateUpdateProcedureCommand command, Block block, GroupContext externalGroups, TempMetadataAdapter metadata, boolean useMetadataCommands, boolean isUpdateProcedure, AnalysisRecord analysis) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        LogManager.logTrace((String)"QUERY_RESOLVER", (Object[])new Object[]{"Resolving block", block});
        TempMetadataStore store = new TempMetadataStore(this.cloneMapValues(metadata.getMetadataStore().getData()));
        metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
        externalGroups = new GroupContext(externalGroups, null);
        GroupSymbol variables = new GroupSymbol("VARIABLES");
        variables.setMetadataID((Object)metadata.getMetadataStore().getTempGroupID("VARIABLES"));
        variables.setResolvedElements(new LinkedList());
        externalGroups.addGroup(variables);
        Iterator stmtIter = block.getStatements().iterator();
        while (stmtIter.hasNext()) {
            this.resolveStatement(command, (Statement)stmtIter.next(), externalGroups, variables, metadata, useMetadataCommands, isUpdateProcedure, analysis);
        }
    }

    private void resolveStatement(CreateUpdateProcedureCommand command, Statement statement, GroupContext externalGroups, GroupSymbol variables, TempMetadataAdapter metadata, boolean expandCommand, boolean isUpdateProcedure, AnalysisRecord analysis) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        LogManager.logTrace((String)"QUERY_RESOLVER", (Object[])new Object[]{"Resolving statement", statement});
        switch (statement.getType()) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                ResolverVisitor.resolveLanguageObject((LanguageObject)ifCrit, null, (GroupContext)externalGroups, (QueryMetadataInterface)metadata);
                this.resolveBlock(command, ifStmt.getIfBlock(), externalGroups, metadata, expandCommand, isUpdateProcedure, analysis);
                if (!ifStmt.hasElseBlock()) break;
                this.resolveBlock(command, ifStmt.getElseBlock(), externalGroups, metadata, expandCommand, isUpdateProcedure, analysis);
                break;
            }
            case 2: {
                DynamicCommand dynamicCommand;
                DynamicCommand dynCommand;
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command subCommand = cmdStmt.getCommand();
                TempMetadataStore discoveredMetadata = this.resolveEmbeddedCommand(metadata, externalGroups, subCommand, expandCommand, analysis);
                if (discoveredMetadata != null) {
                    metadata.getMetadataStore().getData().putAll(discoveredMetadata.getData());
                }
                if (subCommand instanceof DynamicCommand && (dynCommand = (DynamicCommand)subCommand).getIntoGroup() == null && !command.isUpdateProcedure() && !dynCommand.isAsClauseSet()) {
                    if (command.getProjectedSymbols().size() > 0) {
                        dynCommand.setAsColumns(command.getProjectedSymbols());
                    } else if (command.getParentProjectSymbols() != null) {
                        dynCommand.setAsColumns(command.getParentProjectSymbols());
                    }
                }
                if (command.isUpdateProcedure()) break;
                if (command.getResultsCommand() != null && command.getResultsCommand().getType() == 10 && !(dynamicCommand = (DynamicCommand)command.getResultsCommand()).isAsClauseSet()) {
                    dynamicCommand.setAsColumns(Collections.EMPTY_LIST);
                }
                command.setResultsCommand(subCommand);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Expression expr;
                AssignmentStatement assStmt = (AssignmentStatement)statement;
                if (assStmt.getValue() != null) {
                    if (assStmt.hasCommand()) {
                        Command cmd = assStmt.getCommand();
                        this.resolveEmbeddedCommand(metadata, externalGroups, cmd, expandCommand, analysis);
                    } else if (assStmt.hasExpression()) {
                        expr = assStmt.getExpression();
                        ResolverVisitor.resolveLanguageObject((LanguageObject)expr, null, (GroupContext)externalGroups, (QueryMetadataInterface)metadata);
                    }
                }
                if (statement.getType() == 3) {
                    this.collectDeclareVariable((DeclareStatement)statement, variables, metadata);
                } else {
                    ResolverVisitor.resolveLanguageObject((LanguageObject)assStmt.getVariable(), null, (GroupContext)externalGroups, (QueryMetadataInterface)metadata);
                    if (statement.getType() == 5 && !assStmt.getVariable().getGroupSymbol().getCanonicalName().equals("VARIABLES")) {
                        throw new QueryResolverException(QueryPlugin.Util.getString("UpdateProcedureResolver.only_variables", (Object)assStmt.getVariable()));
                    }
                    assStmt.getVariable().setIsExternalReference(false);
                }
                if (!assStmt.hasExpression()) break;
                expr = assStmt.getExpression();
                Class varType = assStmt.getVariable().getType();
                Class exprType = expr.getType();
                if (exprType == null) {
                    throw new QueryResolverException(QueryPlugin.Util.getString("ResolveVariablesVisitor.datatype_for_the_expression_not_resolvable"));
                }
                String varTypeName = DataTypeManager.getDataTypeName((Class)varType);
                assStmt.setExpression(ResolverUtil.convertExpression((Expression)expr, (String)varTypeName));
                break;
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Criteria whileCrit = whileStmt.getCondition();
                ResolverVisitor.resolveLanguageObject((LanguageObject)whileCrit, null, (GroupContext)externalGroups, (QueryMetadataInterface)metadata);
                this.resolveBlock(command, whileStmt.getBlock(), externalGroups, metadata, expandCommand, isUpdateProcedure, analysis);
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                String groupName = loopStmt.getCursorName();
                if (metadata.getMetadataStore().getTempGroupID(groupName) != null) {
                    throw new QueryResolverException(QueryPlugin.Util.getString("ERR.015.012.0065"));
                }
                if (GroupSymbol.isTempGroupName((String)loopStmt.getCursorName())) {
                    String errorMsg = QueryPlugin.Util.getString("ResolveVariablesVisitor.reserved_word_for_temporary_used", (Object)loopStmt.getCursorName());
                    throw new QueryResolverException(errorMsg);
                }
                Command cmd = loopStmt.getCommand();
                this.resolveEmbeddedCommand(metadata, externalGroups, cmd, expandCommand, analysis);
                List symbols = cmd.getProjectedSymbols();
                TempMetadataStore store = new TempMetadataStore(new HashMap(metadata.getMetadataStore().getData()));
                metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
                externalGroups = new GroupContext(externalGroups, null);
                GroupSymbol symbol = new GroupSymbol(groupName);
                metadata.getMetadataStore().addTempGroup(symbol.getName(), symbols);
                externalGroups.addGroup(symbol);
                ResolveGroupsVisitor.resolveGroups((LanguageObject)symbol, (QueryMetadataInterface)metadata);
                this.resolveBlock(command, loopStmt.getBlock(), externalGroups, metadata, expandCommand, isUpdateProcedure, analysis);
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new QueryResolverException("ERR.015.008.0015", QueryPlugin.Util.getString("ERR.015.008.0015", statement.getType()));
            }
        }
    }

    private TempMetadataStore resolveEmbeddedCommand(TempMetadataAdapter metadata, GroupContext groupContext, Command cmd, boolean expandCommand, AnalysisRecord analysis) throws MetaMatrixComponentException, QueryResolverException {
        QueryResolver.setChildMetadata((Command)cmd, (Map)metadata.getMetadataStore().getData(), (GroupContext)groupContext);
        return QueryResolver.resolveCommand((Command)cmd, (Map)Collections.EMPTY_MAP, (boolean)expandCommand, (QueryMetadataInterface)metadata.getMetadata(), (AnalysisRecord)analysis);
    }

    private void collectDeclareVariable(DeclareStatement obj, GroupSymbol variables, TempMetadataAdapter metadata) throws QueryResolverException {
        ElementSymbol variable = obj.getVariable();
        String typeName = obj.getVariableType();
        String varName = variable.getName();
        int sepIndex = varName.indexOf(".");
        if (sepIndex < 0) {
            varName = "VARIABLES." + varName;
            variable.setName(varName);
        } else {
            sepIndex = varName.lastIndexOf(".");
            String groupName = varName.substring(0, sepIndex);
            if (!groupName.equals("VARIABLES")) {
                this.handleUnresolvableDeclaration(variable, QueryPlugin.Util.getString("ERR.015.010.0031", new Object[]{"VARIABLES", variable}));
            }
        }
        if (metadata.getMetadataStore().getTempElementID(varName) != null) {
            this.handleUnresolvableDeclaration(variable, QueryPlugin.Util.getString("ERR.015.010.0032", (Object)variable));
        }
        variable.setType(DataTypeManager.getDataTypeClass((String)typeName));
        variable.setGroupSymbol(variables);
        variable.setMetadataID((Object)new TempMetadataID(variable.getName(), variable.getType()));
        if (variables.getResolvedElements() != null) {
            variables.getResolvedElements().add(variable);
        }
        metadata.getMetadataStore().addElementToTempGroup("VARIABLES", variable);
    }

    private void handleUnresolvableDeclaration(ElementSymbol variable, String description) throws QueryResolverException {
        UnresolvedSymbolDescription symbol = new UnresolvedSymbolDescription((Symbol)variable, description);
        QueryResolverException e = new QueryResolverException(symbol.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(symbol));
        throw e;
    }

    private Map cloneMapValues(Map map) {
        HashMap clonedMap = new HashMap();
        for (Object key : map.keySet()) {
            clonedMap.put(key, ((TempMetadataID)map.get(key)).clone());
        }
        return clonedMap;
    }
}

