/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.platform.server.ClientConnectionManager;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.dqp.service.AuthorizationService;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.MetaBasePermissionFactory;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.ServerSessionService;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.server.ServerPlugin;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

public class PlatformAuthorizationService
implements AuthorizationService {
    private static final BasicAuthorizationPermissionFactory PERMISSION_FACTORY = new BasicAuthorizationPermissionFactory();
    static boolean USE_ENTITLEMENTS = Boolean.valueOf(CurrentConfiguration.getProperty("metamatrix.authorization.dataaccess.CheckingEnabled"));
    private AuthorizationServiceInterface authInterface;
    private ServerSessionService sessionInterface;

    public PlatformAuthorizationService(AuthorizationServiceInterface authInterface, ServerSessionService sessionInterface, ClientConnectionManager connMgr) {
        this.authInterface = authInterface;
        this.sessionInterface = sessionInterface;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bind() throws ApplicationLifecycleException {
    }

    public void unbind() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
    }

    public Collection getInaccessibleResources(String connectionID, int action, Collection resources, int context) throws MetaMatrixComponentException {
        SessionToken token = this.getToken(connectionID);
        AuthorizationRealm realm = this.getRealm(token);
        AuthorizationActions actions = this.getActions(action);
        Collection permissions = this.createPermissions(realm, resources, actions);
        String auditContext = this.getAuditContext(context);
        Collection inaccessableResources = Collections.EMPTY_LIST;
        try {
            inaccessableResources = this.authInterface.getInaccessibleResources(token, auditContext, permissions);
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixComponentException((Throwable)e, ServerPlugin.Util.getString("PlatformAuthorizationService.Invalid_session"));
        }
        catch (AuthorizationMgmtException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        ArrayList<String> inaccessableResourceNames = Collections.EMPTY_LIST;
        if (inaccessableResources != null && inaccessableResources.size() > 0) {
            inaccessableResourceNames = new ArrayList<String>();
            for (AuthorizationPermission permission : inaccessableResources) {
                inaccessableResourceNames.add(permission.getResourceName());
            }
        }
        return inaccessableResourceNames;
    }

    public boolean hasRole(String connectionID, String roleType, String roleName) throws MetaMatrixComponentException {
        SessionToken token = this.getToken(connectionID);
        AuthorizationRealm realm = null;
        if ("admin".equalsIgnoreCase(roleType)) {
            realm = RolePermissionFactory.getRealm();
        } else if ("repository".equalsIgnoreCase(roleType)) {
            realm = MetaBasePermissionFactory.getRealm();
        } else if ("data".equalsIgnoreCase(roleType)) {
            realm = this.getRealm(token);
        } else {
            return false;
        }
        try {
            return this.authInterface.hasPolicy(token, realm, roleName);
        }
        catch (AuthorizationMgmtException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (InvalidUserException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (MembershipServiceException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (ServiceException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (RemoteException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
    }

    public boolean checkingEntitlements() {
        return USE_ENTITLEMENTS;
    }

    private SessionToken getToken(String connectionID) throws MetaMatrixComponentException {
        SessionToken token;
        try {
            long id = Long.parseLong(connectionID);
            MetaMatrixSessionID sessionID = new MetaMatrixSessionID(id);
            token = this.sessionInterface.validateSession(sessionID);
        }
        catch (NumberFormatException e) {
            MetaMatrixComponentException e2 = new MetaMatrixComponentException((Throwable)e, ServerPlugin.Util.getString("PlatformAuthorizationService.Parse_conn_id", (Object)connectionID));
            LogManager.logError((String)"QUERY_SERVICE", (Throwable)e2, (String)e2.getMessage());
            throw e2;
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixComponentException((Throwable)e, ServerPlugin.Util.getString("PlatformAuthorizationService.Invalid_session"));
        }
        catch (SessionServiceException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        return token;
    }

    private AuthorizationRealm getRealm(SessionToken token) {
        return new AuthorizationRealm(token.getProductInfo(0), token.getProductInfo(1));
    }

    private AuthorizationActions getActions(int actionCode) {
        switch (actionCode) {
            case 0: {
                return StandardAuthorizationActions.DATA_READ;
            }
            case 1: {
                return StandardAuthorizationActions.DATA_CREATE;
            }
            case 2: {
                return StandardAuthorizationActions.DATA_UPDATE;
            }
            case 3: {
                return StandardAuthorizationActions.DATA_DELETE;
            }
        }
        return StandardAuthorizationActions.DATA_READ;
    }

    private Collection createPermissions(AuthorizationRealm realm, Collection resources, AuthorizationActions actions) {
        ArrayList<BasicAuthorizationPermission> permissions = new ArrayList<BasicAuthorizationPermission>(resources.size());
        for (String resource : resources) {
            BasicAuthorizationPermission permission = (BasicAuthorizationPermission)PERMISSION_FACTORY.create(resource, realm, actions);
            permissions.add(permission);
        }
        return permissions;
    }

    private String getAuditContext(int auditCode) {
        switch (auditCode) {
            case 0: {
                return "QUERY";
            }
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
            case 4: {
                return "STORED_PROCEDURE";
            }
        }
        return "QUERY";
    }

    public boolean disableXQuery() {
        return Boolean.valueOf(CurrentConfiguration.getProperty("metamatrix.security.disableXQuery"));
    }
}

