/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.optimizer.relational.rules.RuleAssignOutputElements;
import com.metamatrix.query.optimizer.relational.rules.RuleMergeVirtual;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class RuleRaiseNull
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List nodes = NodeEditor.findAllNodes(plan, 31);
        for (PlanNode nullNode : new LinkedList(nodes)) {
            PlanNode newRoot;
            while (nodes.contains(nullNode) && nullNode.getParent() != null && (newRoot = this.raiseNullNode(plan, nodes, nullNode, metadata, capFinder)) != null) {
                plan = newRoot;
            }
            if (nullNode.getParent() != null) continue;
            nodes.remove(nullNode);
        }
        if (plan.getChildCount() == 0) {
            PlanNode projectNode = NodeFactory.getNewNode((int)11);
            projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, plan.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
            if (plan.hasCollectionProperty((Object)NodeConstants.Info.TOP_COLS)) {
                projectNode.setProperty((Object)NodeConstants.Info.TOP_COLS, plan.getProperty((Object)NodeConstants.Info.TOP_COLS));
            } else {
                projectNode.setProperty((Object)NodeConstants.Info.TOP_COLS, plan.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
            }
            projectNode.addFirstChild(plan);
            plan.setParent(projectNode);
            return projectNode;
        }
        return plan;
    }

    PlanNode raiseNullNode(PlanNode rootNode, List nodes, PlanNode nullNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode parentNode = nullNode.getParent();
        switch (parentNode.getType()) {
            case 7: {
                JoinType jt = (JoinType)parentNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
                    return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                }
                if (jt == JoinType.JOIN_LEFT_OUTER) {
                    if (nullNode == parentNode.getFirstChild()) {
                        return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                    }
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getLastChild());
                    return null;
                }
                if (jt == JoinType.JOIN_RIGHT_OUTER) {
                    if (nullNode == parentNode.getLastChild()) {
                        return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                    }
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getFirstChild());
                    return null;
                }
                if (jt != JoinType.JOIN_FULL_OUTER) break;
                if (nullNode == parentNode.getLastChild()) {
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getLastChild());
                } else {
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getFirstChild());
                }
                return null;
            }
            case 29: {
                PlanNode firstProject;
                PlanNode sourceNode;
                boolean removeSource;
                boolean isLeftChild = parentNode.getChildren().indexOf(nullNode) == 0;
                NodeEditor.removeChildNode(parentNode, nullNode);
                nullNode.setParent(null);
                PlanNode setOpRoot = parentNode;
                boolean bl = removeSource = parentNode.getFirstChild().getType() != 29;
                for (sourceNode = parentNode.getParent(); sourceNode != null && sourceNode.getType() == 29; sourceNode = sourceNode.getParent()) {
                    setOpRoot = sourceNode;
                    removeSource = false;
                }
                boolean needsDupRemoval = false;
                if (removeSource && !Boolean.TRUE.equals(setOpRoot.getProperty((Object)NodeConstants.Info.USE_ALL))) {
                    removeSource = false;
                    needsDupRemoval = true;
                }
                if ((firstProject = NodeEditor.findNodePreOrder(setOpRoot, 11)) == null) {
                    return this.raiseNullNode(rootNode, setOpRoot, nullNode, nodes);
                }
                boolean needsProjectCorrection = isLeftChild && firstProject == NodeEditor.findNodePreOrder(parentNode.getFirstChild(), 11);
                List newProjectSymbols = (List)firstProject.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                if (sourceNode != null && sourceNode.getType() == 19) {
                    Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                    if (needsProjectCorrection) {
                        List oldProjectSymbols = (List)nullNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                        List projectOrder = RuleAssignOutputElements.reverseSymbolLookup(oldProjectSymbols, symbolMap);
                        for (Map.Entry entry : symbolMap.entrySet()) {
                            SingleElementSymbol expr;
                            SingleElementSymbol virtualSymbol = (SingleElementSymbol)entry.getKey();
                            int index = projectOrder.indexOf(virtualSymbol);
                            if (index == -1) {
                                if (QueryRewriter.isNull((Expression)entry.getValue())) continue;
                                return null;
                            }
                            SingleElementSymbol mappedExpr = expr = (SingleElementSymbol)newProjectSymbols.get(index);
                            if (expr instanceof AliasSymbol || !expr.getShortCanonicalName().equals(virtualSymbol.getShortCanonicalName())) {
                                AliasSymbol symbol;
                                if (expr instanceof AliasSymbol) {
                                    symbol = (AliasSymbol)expr;
                                    symbol.setName(virtualSymbol.getShortName());
                                    expr = symbol.getSymbol();
                                } else {
                                    symbol = new AliasSymbol(virtualSymbol.getShortName(), expr);
                                    newProjectSymbols.set(index, symbol);
                                }
                            }
                            if (mappedExpr instanceof AliasSymbol) {
                                mappedExpr = ((AliasSymbol)mappedExpr).getSymbol();
                            }
                            if (mappedExpr instanceof ExpressionSymbol && !(mappedExpr instanceof AggregateSymbol)) {
                                ExpressionSymbol exprSymbol = (ExpressionSymbol)mappedExpr;
                                mappedExpr = exprSymbol.getExpression();
                            }
                            entry.setValue(mappedExpr);
                        }
                        PlanNode theNode = NodeEditor.findNodePreOrder(sourceNode, 11);
                        if (theNode != null) {
                            theNode.setProperty((Object)NodeConstants.Info.TOP_COLS, theNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
                        }
                    }
                    if (removeSource) {
                        NodeEditor.removeChildNode(parentNode.getParent(), parentNode);
                        QueryFrame frame = FrameUtil.findQueryFrame(sourceNode);
                        if (RuleMergeVirtual.canMerge(frame, metadata, capFinder)) {
                            RuleMergeVirtual.doMerge(frame, metadata, capFinder);
                        }
                        return null;
                    }
                }
                PlanNode newRoot = parentNode.getFirstChild();
                if (needsDupRemoval) {
                    PlanNode dupRemove = NodeFactory.getNewNode((int)5);
                    if (parentNode.hasCollectionProperty((Object)NodeConstants.Info.TOP_COLS)) {
                        newRoot.setProperty((Object)NodeConstants.Info.TOP_COLS, parentNode.getProperty((Object)NodeConstants.Info.TOP_COLS));
                    }
                    NodeEditor.insertNode(parentNode, newRoot, dupRemove);
                    newRoot = dupRemove;
                }
                if (parentNode.hasCollectionProperty((Object)NodeConstants.Info.TOP_COLS)) {
                    newRoot.setProperty((Object)NodeConstants.Info.TOP_COLS, parentNode.getProperty((Object)NodeConstants.Info.TOP_COLS));
                }
                if (parentNode.getParent() == null) {
                    newRoot.setParent(null);
                    return newRoot;
                }
                NodeEditor.removeChildNode(parentNode.getParent(), parentNode);
                return null;
            }
            case 23: {
                break;
            }
            case 11: {
                PlanNode upperProject;
                for (upperProject = parentNode.getParent(); upperProject != null && upperProject.getType() != 11; upperProject = upperProject.getParent()) {
                }
                if (upperProject != null && upperProject.getProperty((Object)NodeConstants.Info.INTO_GROUP) != null) break;
                return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
            }
            default: {
                return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
            }
        }
        return null;
    }

    private PlanNode raiseNullNode(PlanNode rootNode, PlanNode parentNode, PlanNode nullNode, List nodes) {
        if (parentNode.getType() == 19) {
            nullNode.getGroups().clear();
        } else if (parentNode.getType() == 11) {
            nullNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, parentNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
        }
        if (parentNode.hasCollectionProperty((Object)NodeConstants.Info.TOP_COLS)) {
            nullNode.setProperty((Object)NodeConstants.Info.TOP_COLS, parentNode.getProperty((Object)NodeConstants.Info.TOP_COLS));
        }
        nullNode.addGroups((Collection)parentNode.getGroups());
        parentNode.removeChild(nullNode);
        nodes.removeAll(NodeEditor.findAllNodes(parentNode, 31));
        parentNode.getChildren().clear();
        nullNode.setParent(parentNode.getParent());
        if (parentNode.getParent() != null) {
            NodeEditor.replaceNode(parentNode, nullNode);
        } else {
            rootNode = nullNode;
        }
        parentNode.setParent(null);
        return rootNode;
    }

    static void raiseNullThroughJoin(QueryMetadataInterface metadata, PlanNode joinNode, PlanNode nullNode) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Assertion.assertTrue((joinNode.getType() == 7 ? 1 : 0) != 0);
        Assertion.assertTrue((nullNode.getType() == 31 ? 1 : 0) != 0);
        Assertion.assertTrue((nullNode.getParent() == joinNode ? 1 : 0) != 0);
        NodeEditor.removeChildNode(joinNode, nullNode);
        NodeEditor.removeChildNode(joinNode.getParent(), joinNode);
        QueryFrame frame = FrameUtil.findQueryFrame(joinNode);
        HashSet groups = nullNode.getGroups();
        groups = new HashSet(groups);
        for (GroupSymbol group : groups) {
            Map nullSymbolMap = FrameUtil.buildSymbolMap(group, null, metadata);
            FrameUtil.convertFrame(frame, nullNode, group, null, nullSymbolMap, metadata);
        }
        nullNode.setParent(null);
    }

    public String toString() {
        return "RaiseNull";
    }
}

