/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server.local;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.internal.server.IAdmin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.ServerSessionService;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.query.service.QueryServiceInterface;
import com.metamatrix.server.util.ServerProxyHelper;

public class LocalAdminImpl
extends ServerAdminImpl
implements IAdmin {
    private ServerSessionService sessionServiceProxy = null;
    private ConfigurationServiceInterface configurationServiceProxy = null;
    private QueryServiceInterface queryServiceProxy = null;
    private ExtensionModuleManager extensionModuleManager = null;
    private IAdminHelper adminRoleHelper = null;
    private AdminMethodRoleResolver adminRoleResolver = null;

    public LocalAdminImpl() {
    }

    public LocalAdminImpl(IAdminHelper adminHelper, AdminMethodRoleResolver adminRoleResolver) {
        this.adminRoleHelper = adminHelper;
        this.adminRoleResolver = adminRoleResolver;
    }

    public void close() {
    }

    protected synchronized ServerSessionService getSessionServiceProxy() throws ServiceException {
        if (this.sessionServiceProxy == null) {
            this.sessionServiceProxy = PlatformProxyHelper.getSessionServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        }
        return this.sessionServiceProxy;
    }

    protected synchronized ConfigurationServiceInterface getConfigurationServiceProxy() throws ServiceException {
        if (this.configurationServiceProxy == null) {
            this.configurationServiceProxy = PlatformProxyHelper.getConfigurationServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        }
        return this.configurationServiceProxy;
    }

    protected synchronized QueryServiceInterface getQueryServiceProxy() throws ServiceException {
        if (this.queryServiceProxy == null) {
            this.queryServiceProxy = ServerProxyHelper.getQueryServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        }
        return this.queryServiceProxy;
    }

    protected ExtensionModuleManager getExtensionSourceManager() {
        if (this.extensionModuleManager == null) {
            this.extensionModuleManager = ExtensionModuleManager.getInstance();
        }
        return this.extensionModuleManager;
    }

    public boolean isUserAuthorizedToCallMethod(String method) {
        MetaMatrixSessionID id = this.getSessionID();
        SessionToken st = new SessionToken(id);
        String role = null;
        try {
            role = this.adminRoleResolver.getRoleNameForMethod(method);
        }
        catch (AdminException err1) {
            // empty catch block
        }
        if (role == null) {
            return false;
        }
        try {
            this.adminRoleHelper.checkForRequiredRole(st, role, method);
        }
        catch (AuthorizationException err) {
            return false;
        }
        catch (ComponentNotFoundException err) {
            return false;
        }
        return true;
    }
}

