/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.URLConnection;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContentHandlerProxy
extends ContentHandler
implements ServiceTrackerCustomizer {
    protected ContentHandler realHandler;
    protected ServiceTracker contentHandlerServiceTracker;
    protected BundleContext context;
    protected ServiceReference contentHandlerServiceReference;
    protected String contentType;
    protected int ranking = -1;

    public ContentHandlerProxy(String contentType, ServiceReference reference, BundleContext context) {
        this.context = context;
        this.contentType = contentType;
        if (reference != null) {
            this.setNewHandler(reference, this.getRank(reference));
        } else {
            this.realHandler = new DefaultContentHandler();
        }
        this.contentHandlerServiceTracker = new ServiceTracker(context, ContentHandler.class.getName(), (ServiceTrackerCustomizer)this);
        this.contentHandlerServiceTracker.open();
    }

    private void setNewHandler(ServiceReference reference, int rank) {
        this.contentHandlerServiceReference = reference;
        this.ranking = rank;
        this.realHandler = (ContentHandler)StreamHandlerFactory.secureAction.getService(reference, this.context);
    }

    public Object addingService(ServiceReference reference) {
        Object prop = reference.getProperty("url.content.mimetype");
        if (!(prop instanceof String[])) {
            return null;
        }
        String[] contentTypes = (String[])prop;
        for (int i = 0; i < contentTypes.length; ++i) {
            if (!contentTypes[i].equals(this.contentType)) continue;
            int newServiceRanking = this.getRank(reference);
            if (newServiceRanking > this.ranking) {
                this.setNewHandler(reference, newServiceRanking);
            }
            return reference;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        int newrank = this.getRank(reference);
        if (reference == this.contentHandlerServiceReference) {
            ServiceReference newReference;
            if (newrank < this.ranking && (newReference = this.contentHandlerServiceTracker.getServiceReference()) != this.contentHandlerServiceReference && newReference != null) {
                this.setNewHandler(newReference, (Integer)newReference.getProperty("service.ranking"));
            }
        } else if (newrank > this.ranking) {
            this.setNewHandler(reference, newrank);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        if (reference == this.contentHandlerServiceReference) {
            ServiceReference newReference = this.contentHandlerServiceTracker.getServiceReference();
            if (newReference != null) {
                this.setNewHandler(newReference, this.getRank(newReference));
            } else {
                this.ranking = -1;
                this.realHandler = new DefaultContentHandler();
            }
        }
    }

    public Object getContent(URLConnection uConn) throws IOException {
        return this.realHandler.getContent(uConn);
    }

    private int getRank(ServiceReference reference) {
        Object property = reference.getProperty("service.ranking");
        return property instanceof Integer ? (Integer)property : 0;
    }

    class DefaultContentHandler
    extends ContentHandler {
        DefaultContentHandler() {
        }

        public Object getContent(URLConnection uConn) throws IOException {
            return uConn.getInputStream();
        }
    }
}

