/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandInterpreter;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FrameworkConsole
implements Runnable {
    protected Reader in;
    protected PrintWriter out;
    protected BundleContext context;
    protected OSGi osgi;
    protected String[] args;
    protected CommandProvider osgicp;
    protected CommandProviderTracker cptracker;
    static String defaultEncoding = "iso8859-1";
    static String encoding = System.getProperty("file.encoding", defaultEncoding);
    protected boolean useSocketStream = false;
    protected boolean disconnect = false;
    protected int port = 0;
    protected ServerSocket ss = null;
    protected ConsoleSocketGetter scsg = null;
    protected Socket s;

    public FrameworkConsole(OSGi osgi, String[] args) {
        this.getDefaultStreams();
        this.args = args;
        this.osgi = osgi;
        this.initialize();
    }

    public FrameworkConsole(OSGi osgi, int port, String[] args) {
        this.getSocketStream(port);
        this.useSocketStream = true;
        this.port = port;
        this.args = args;
        this.osgi = osgi;
        this.initialize();
    }

    private void getDefaultStreams() {
        this.in = this.createBufferedReader(System.in);
        this.out = this.createPrintWriter(System.out);
    }

    private void getSocketStream(int port) {
        try {
            System.out.println(NLS.bind(ConsoleMsg.CONSOLE_LISTENING_ON_PORT, String.valueOf(port)));
            if (this.ss == null) {
                this.ss = new ServerSocket(port);
                this.scsg = new ConsoleSocketGetter(this.ss);
            }
            this.scsg.setAcceptConnections(true);
            this.s = this.scsg.getSocket();
            this.in = this.createBufferedReader(this.s.getInputStream());
            this.out = this.createPrintWriter(this.s.getOutputStream());
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BufferedReader createBufferedReader(InputStream _in) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(_in, encoding));
        }
        catch (UnsupportedEncodingException uee) {
            reader = new BufferedReader(new InputStreamReader(_in));
        }
        return reader;
    }

    private PrintWriter createPrintWriter(OutputStream _out) {
        PrintWriter writer;
        try {
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(_out, encoding)), true);
        }
        catch (UnsupportedEncodingException uee) {
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(_out)), true);
        }
        return writer;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public BufferedReader getReader() {
        return (BufferedReader)this.in;
    }

    public boolean getUseSocketStream() {
        return this.useSocketStream;
    }

    private void initialize() {
        this.context = this.osgi.getBundleContext();
        this.cptracker = new CommandProviderTracker(this.context, CommandProvider.class.getName(), this);
        this.cptracker.open();
        this.osgicp = new FrameworkCommandProvider(this.osgi);
    }

    public void run() {
        try {
            this.console(this.args);
            if (this.useSocketStream) {
                while (true) {
                    this.getSocketStream(this.port);
                    this.console();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.out);
        }
    }

    public void console(String[] args) throws IOException {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.docommand(args[i]);
            }
        }
        this.console();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void console() throws IOException {
        boolean block;
        Object lock = new Object();
        this.disconnect = false;
        BufferedReader br = (BufferedReader)this.in;
        String consolePrompt = "\r\n" + ConsoleMsg.CONSOLE_PROMPT;
        boolean bl = block = System.getProperty("osgi.dev") != null;
        while (!this.disconnect) {
            this.out.print(consolePrompt);
            this.out.flush();
            String cmdline = null;
            if (block) {
                try {
                    Object object = lock;
                    synchronized (object) {
                        while (!br.ready()) {
                            lock.wait(300L);
                        }
                    }
                    cmdline = br.readLine();
                }
                catch (InterruptedException e) {}
            } else {
                cmdline = br.readLine();
            }
            if (cmdline == null) break;
            this.docommand(cmdline);
        }
    }

    protected void docommand(String cmdline) {
        FrameworkCommandInterpreter intcp;
        String command;
        if (cmdline != null && cmdline.length() > 0 && (command = (intcp = new FrameworkCommandInterpreter(cmdline, this.cptracker.getServices(), this)).nextArgument()) != null) {
            intcp.execute(command);
        }
    }

    void disconnect() throws IOException {
        this.disconnect = true;
        this.out.close();
        this.in.close();
        this.s.close();
    }

    public String getInput() {
        String input;
        try {
            input = ((BufferedReader)this.in).readLine();
            System.out.println("<" + input + ">");
        }
        catch (IOException e) {
            input = "";
        }
        return input;
    }

    class CommandProviderTracker
    extends ServiceTracker {
        FrameworkConsole con;

        CommandProviderTracker(BundleContext context, String clazz, FrameworkConsole con) {
            super(context, clazz, null);
            this.con = con;
        }

        public Object addingService(ServiceReference reference) {
            CommandProvider cp = (CommandProvider)super.addingService(reference);
            return cp;
        }

        public Object[] getServices() {
            Object[] serviceRefs = super.getServiceReferences();
            Util.dsort(serviceRefs, 0, serviceRefs.length);
            Object[] serviceObjects = new Object[serviceRefs.length];
            for (int i = 0; i < serviceRefs.length; ++i) {
                serviceObjects[i] = FrameworkConsole.this.context.getService((ServiceReference)serviceRefs[i]);
            }
            return serviceObjects;
        }
    }

    class ConsoleSocketGetter
    implements Runnable {
        ServerSocket server;
        Socket socket;
        boolean acceptConnections = true;
        Object lock = new Object();

        ConsoleSocketGetter(ServerSocket server) {
            this.server = server;
            Thread t = new Thread((Runnable)this, "ConsoleSocketGetter");
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Object o;
                    while (true) {
                        this.socket = FrameworkConsole.this.ss.accept();
                        if (this.acceptConnections) break;
                        o = FrameworkConsole.this.createPrintWriter(this.socket.getOutputStream());
                        ((PrintWriter)o).println(ConsoleMsg.CONSOLE_TELNET_CONNECTION_REFUSED);
                        ((PrintWriter)o).println(ConsoleMsg.CONSOLE_TELNET_CURRENTLY_USED);
                        ((PrintWriter)o).println(ConsoleMsg.CONSOLE_TELNET_ONE_CLIENT_ONLY);
                        ((PrintWriter)o).close();
                        this.socket.close();
                    }
                    o = this.lock;
                    synchronized (o) {
                        this.lock.notify();
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
            this.setAcceptConnections(false);
            return this.socket;
        }

        public void setAcceptConnections(boolean acceptConnections) {
            this.acceptConnections = acceptConnections;
        }
    }
}

