/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.PreparedBatchUpdate;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.List;

public class Update
extends PreparedBatchUpdate {
    private GroupSymbol group;
    private List changeList;
    private Criteria criteria;

    public Update() {
        this.changeList = new ArrayList();
    }

    public int getType() {
        return 3;
    }

    public Update(GroupSymbol group, List changeList) {
        this.group = group;
        this.changeList = changeList;
    }

    public Update(GroupSymbol group, List changeList, Criteria criteria) {
        this(group, changeList);
        this.criteria = criteria;
    }

    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public void setChangeList(List changeList) {
        this.changeList = changeList;
    }

    public List getChangeList() {
        return this.changeList;
    }

    public void addChange(ElementSymbol id, Expression value) {
        CompareCriteria cc = new CompareCriteria(id, 1, value);
        this.changeList.add(cc);
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.group);
        myHash = HashCodeUtil.hashCode(myHash, this.changeList);
        if (this.criteria != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.criteria);
        }
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Update other = (Update)obj;
        return EquivalenceUtil.areEqual(this.getGroup(), other.getGroup()) && this.getChangeList().containsAll(other.getChangeList()) && other.getChangeList().containsAll(this.getChangeList()) && EquivalenceUtil.areEqual(this.getCriteria(), other.getCriteria());
    }

    public Object clone() {
        GroupSymbol copyGroup = null;
        if (this.group != null) {
            copyGroup = (GroupSymbol)this.group.clone();
        }
        ArrayList<Object> copyChanges = new ArrayList<Object>(this.changeList.size());
        for (Criteria change : this.changeList) {
            copyChanges.add(change.clone());
        }
        Criteria copyCrit = null;
        if (this.criteria != null) {
            copyCrit = (Criteria)this.criteria.clone();
        }
        Update copy = new Update(copyGroup, copyChanges, copyCrit);
        this.copyMetadataState(copy);
        copy.setParameterReferences(this.getParameterReferences());
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    public boolean areResultsCachable() {
        return false;
    }
}

