/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.GroupContext;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Command
implements LanguageObject {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_QUERY = 1;
    public static final int TYPE_INSERT = 2;
    public static final int TYPE_UPDATE = 3;
    public static final int TYPE_DELETE = 4;
    public static final int TYPE_SQL = 5;
    public static final int TYPE_STORED_PROCEDURE = 6;
    public static final int TYPE_UPDATE_PROCEDURE = 7;
    public static final int TYPE_XQUERY = 8;
    public static final int TYPE_BATCHED_UPDATE = 9;
    public static final int TYPE_DYNAMIC = 10;
    public static final int TYPE_CREATE = 11;
    public static final int TYPE_DROP = 12;
    private static List updateCommandSymbol = null;
    private static List updatesCommandSymbol = null;
    protected Map tempGroupIDs;
    private transient GroupContext externalGroups = null;
    private boolean isResolved = false;
    private GroupSymbol virtualGroup;
    private Map variableValues = new HashMap();
    private Option option;

    public abstract int getType();

    public List getSubCommands() {
        return CommandCollectorVisitor.getCommands(this);
    }

    public void setTemporaryMetadata(Map metadata) {
        this.tempGroupIDs = metadata;
    }

    public Map getTemporaryMetadata() {
        return this.tempGroupIDs;
    }

    public void addExternalGroupToContext(GroupSymbol group) {
        this.getExternalGroupContexts().addGroup(group);
    }

    public void addExternalGroupsToContext(Collection groups) {
        this.getExternalGroupContexts().getGroups().addAll(groups);
    }

    public void setExternalGroupContexts(GroupContext root) {
        this.externalGroups = root == null ? null : (GroupContext)root.clone();
    }

    public void pushNewResolvingContext(Collection groups) {
        this.externalGroups = new GroupContext(this.externalGroups, new LinkedList(groups));
    }

    public GroupContext getExternalGroupContexts() {
        if (this.externalGroups == null) {
            this.externalGroups = new GroupContext();
        }
        return this.externalGroups;
    }

    public List getAllExternalGroups() {
        if (this.externalGroups == null) {
            return Collections.EMPTY_LIST;
        }
        return this.externalGroups.getAllGroups();
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved(boolean isResolved) {
        this.isResolved = isResolved;
    }

    public abstract Object clone();

    protected void copyMetadataState(Command copy) {
        if (this.getExternalGroupContexts() != null) {
            copy.externalGroups = (GroupContext)this.externalGroups.clone();
        }
        if (this.tempGroupIDs != null) {
            copy.setTemporaryMetadata(new HashMap(this.tempGroupIDs));
        }
        copy.setVirtualGroup(this.getVirtualGroup());
        if (this.variableValues != null) {
            copy.setVariableValues(new HashMap(this.variableValues));
        }
        copy.setIsResolved(this.isResolved());
    }

    public String printCommandTree() {
        StringBuffer str = new StringBuffer();
        this.printCommandTree(str, 0);
        return str.toString();
    }

    protected void printCommandTree(StringBuffer str, int tabLevel) {
        for (int i = 0; i < tabLevel; ++i) {
            str.append("\t");
        }
        str.append(this.toString());
        str.append("\n");
        ++tabLevel;
        for (Command subCommand : this.getSubCommands()) {
            subCommand.printCommandTree(str, tabLevel);
        }
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public abstract List getProjectedSymbols();

    public abstract boolean areResultsCachable();

    public static List getUpdateCommandSymbol() {
        if (updateCommandSymbol == null) {
            ElementSymbol symbol = new ElementSymbol("Count");
            symbol.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            updateCommandSymbol = Arrays.asList(symbol);
        }
        return updateCommandSymbol;
    }

    public static List getUpdatesCommandSymbol() {
        if (updatesCommandSymbol == null) {
            ElementSymbol symbol = new ElementSymbol("Counts");
            symbol.setType(int[].class);
            updatesCommandSymbol = Arrays.asList(symbol);
        }
        return updatesCommandSymbol;
    }

    public abstract int updatingModelCount(QueryMetadataInterface var1) throws MetaMatrixComponentException;

    protected int getSubCommandsUpdatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        List subCommands = this.getSubCommands();
        int numCommands = subCommands.size();
        for (Command command : subCommands) {
            if (numCommands == 1) {
                return command.updatingModelCount(metadata);
            }
            if (command.updatingModelCount(metadata) <= 0) continue;
            return 2;
        }
        return 0;
    }

    public GroupSymbol getVirtualGroup() {
        return this.virtualGroup;
    }

    public void setVirtualGroup(GroupSymbol virtualGroup) {
        this.virtualGroup = virtualGroup;
    }

    public Map getVariableValues() {
        return this.variableValues;
    }

    public void setVariableValues(Map parameters) {
        this.variableValues = parameters;
    }
}

