/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AuthorizationPolicyFactory {
    private static final String GROUP = "group";
    private static final String PRINCIPALS = "principals";
    private static final String ALLOW = "allow-";
    private static final String RESOURCE_NAME = "resource-name";
    private static final String PERMISSION = "permission";
    private static final String PERMISSIONS = "permissions";
    private static final String DESCRIPTION = "description";
    private static final String VDB_VERSION = "vdb-version";
    private static final String VDB_NAME = "vdb-name";
    private static final String NAME = "name";
    private static final String DATA_ROLE = "data-role";
    private static final String ROLES = "roles";
    private static final String REALM = "realm";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static String[] ALLOW_TYPES = new String[]{"Create", "Delete", "Update", "Read"};

    public static Collection buildPolicies(String vdbName, String vdbVersion, char[] xmlContents) throws SAXException, IOException, ParserConfigurationException {
        DOMBuilder builder = new DOMBuilder();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, AuthorizationPolicyFactory.class.getResourceAsStream("authorizations.xsd"));
        documentBuilderFactory.setValidating(true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        docBuilder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException arg0) throws SAXException {
                LogManager.logWarning("AUTHORIZATION", (Throwable)arg0, PlatformPlugin.Util.getString("AuthorizationPolicyFactory.parsing_warning", arg0.getMessage()));
            }

            public void error(SAXParseException arg0) throws SAXException {
                throw new SAXException(PlatformPlugin.Util.getString("AuthorizationPolicyFactory.parsing_error", arg0.getMessage()), arg0);
            }

            public void fatalError(SAXParseException arg0) throws SAXException {
                throw new SAXException(PlatformPlugin.Util.getString("AuthorizationPolicyFactory.parsing_error", arg0.getMessage()), arg0);
            }
        });
        Document doc = builder.build(docBuilder.parse(new InputSource(new CharArrayReader(xmlContents))));
        Element root = doc.getRootElement();
        Element roles = root.getChild(ROLES);
        List dataRoles = roles.getChildren(DATA_ROLE);
        AuthorizationRealm realm = new AuthorizationRealm(vdbName, vdbVersion);
        BasicAuthorizationPermissionFactory bapf = new BasicAuthorizationPermissionFactory();
        ArrayList<AuthorizationPolicy> result = new ArrayList<AuthorizationPolicy>();
        for (Element role : dataRoles) {
            Element principalsElem;
            Element permsElem;
            Element name = role.getChild(NAME);
            AuthorizationPolicyID policyID = new AuthorizationPolicyID(name.getText(), vdbName, vdbVersion);
            AuthorizationPolicy policy = new AuthorizationPolicy(policyID);
            result.add(policy);
            Element description = role.getChild(DESCRIPTION);
            if (description != null) {
                policy.setDescription(description.getText());
            }
            if ((permsElem = role.getChild(PERMISSIONS)) != null) {
                List perms = permsElem.getChildren(PERMISSION);
                for (Element perm : perms) {
                    Element resourceElem = perm.getChild(RESOURCE_NAME);
                    String resourceName = resourceElem.getText();
                    int actionsValue = 0;
                    for (int i = 0; i < ALLOW_TYPES.length; ++i) {
                        if (perm.getChild(ALLOW + ALLOW_TYPES[i].toLowerCase()) == null) continue;
                        AuthorizationActions action = StandardAuthorizationActions.getAuthorizationActions(ALLOW_TYPES[i]);
                        actionsValue |= action.getValue();
                    }
                    AuthorizationPermission permission = bapf.create(resourceName, realm, StandardAuthorizationActions.getAuthorizationActions(actionsValue));
                    policy.addPermission(permission);
                }
            }
            if ((principalsElem = role.getChild(PRINCIPALS)) == null) continue;
            List groups = principalsElem.getChildren(GROUP);
            for (Element group : groups) {
                policy.addPrincipal(new MetaMatrixPrincipalName(group.getText(), 1));
            }
        }
        return result;
    }

    public static char[] exportPolicies(Collection roles) throws IOException {
        Document doc = new Document(new Element(REALM));
        Element rolesElement = new Element(ROLES);
        doc.getRootElement().addContent((Content)rolesElement);
        for (AuthorizationPolicy policy : roles) {
            Set principals;
            AuthorizationPolicyID policyId = policy.getAuthorizationPolicyID();
            Element roleElement = new Element(DATA_ROLE);
            rolesElement.addContent((Content)roleElement);
            roleElement.addContent((Content)new Element(NAME).setText(policyId.getDisplayName()));
            AuthorizationRealm realm = policyId.getRealm();
            roleElement.addContent((Content)new Element(VDB_NAME).setText(realm.getSuperRealmName()));
            roleElement.addContent((Content)new Element(VDB_VERSION).setText(realm.getSubRealmName()));
            roleElement.addContent((Content)new Element(DESCRIPTION).setText(policy.getDescription()));
            Set permissions = policy.getPermissions();
            if (!permissions.isEmpty()) {
                Element permissionsElement = new Element(PERMISSIONS);
                roleElement.addContent((Content)permissionsElement);
                for (BasicAuthorizationPermission permission : permissions) {
                    Element permissionElement = new Element(PERMISSION);
                    permissionsElement.addContent((Content)permissionElement);
                    permissionElement.addContent((Content)new Element(RESOURCE_NAME).setText(permission.getResourceName()));
                    String[] labels = permission.getActions().getLabels();
                    for (int i = 0; i < labels.length; ++i) {
                        permissionElement.addContent((Content)new Element(ALLOW + labels[i].toLowerCase()));
                    }
                }
            }
            if ((principals = policy.getPrincipals()).isEmpty()) continue;
            Element principalsElement = new Element(PRINCIPALS);
            roleElement.addContent((Content)principalsElement);
            for (MetaMatrixPrincipalName principal : principals) {
                principalsElement.addContent((Content)new Element(GROUP).setText(principal.getName()));
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(doc, (OutputStream)baos);
        return baos.toString().toCharArray();
    }
}

