/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.platform.client.ServerAdminFactory;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class MMServerConnection
extends MMConnection {
    private static final String SERVER_NAME = "MetaMatrix Enterprise";
    ServerAdmin serverAdmin;

    public static MMServerConnection newInstance(ServerConnection serverConn, Properties info, String url) {
        if (AOP.useproxy()) {
            return (MMServerConnection)ProxyFactory.extend(MMServerConnection.class, new Class[]{ServerConnection.class, Properties.class, String.class}, new Object[]{serverConn, info, url});
        }
        return new MMServerConnection(serverConn, info, url);
    }

    public MMServerConnection(ServerConnection serverConn, Properties info, String url) {
        super(serverConn, info, url);
    }

    public synchronized Admin getAdminAPI() throws SQLException {
        try {
            if (this.serverAdmin == null) {
                String serverUrl = MMServerConnection.getServerURL(this.getUrl());
                ServerAdminFactory factory = ServerAdminFactory.getInstance();
                this.serverAdmin = factory.createAdmin(this.getUserName(), this.getPassword().toCharArray(), serverUrl);
            }
        }
        catch (AdminException e) {
            throw new SQLException(e.getMessage());
        }
        catch (LogonException e) {
            throw new SQLException(e.getMessage());
        }
        return this.serverAdmin;
    }

    public synchronized void close() throws SQLException {
        super.close();
        if (this.serverAdmin != null) {
            this.serverAdmin.close();
        }
    }

    protected static String getServerURL(String jdbcURLString) {
        MMJDBCURL jdbcURL = new MMJDBCURL(jdbcURLString);
        return jdbcURL.getConnectionURL();
    }

    String getDatabaseName() {
        return SERVER_NAME;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return super.getMetaData(new MMDriver());
    }
}

