/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.SystemLogWriter;
import com.metamatrix.internal.core.log.ShutdownThread;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformLog
implements LogListener {
    private static final PlatformLog INSTANCE = new PlatformLog();
    private static ShutdownThread SHUTDOWNTHREAD = null;
    private static final String SHUTDOWN_HOOK_INSTALLED_PROPERTY = "shutdownHookInstalled";
    private static final String DEFAULT_LOG_WORKER_THREAD_NAME = "LogWorker";
    private static final long DEFAULT_TIMEOUT = 60000L;
    private static final long SHUTDOWN_TIMEOUT = 20000L;
    private static boolean DEBUG_PLATFORM_LOG;
    private static final PrintStream DEBUG_STREAM;
    private final List<LogListener> logListeners = new ArrayList<LogListener>();
    private volatile ThreadPoolExecutor executor;
    private String name;
    private boolean shutdownRequested = false;

    public static PlatformLog getInstance() {
        return INSTANCE;
    }

    public PlatformLog() {
        this(DEFAULT_LOG_WORKER_THREAD_NAME);
    }

    public PlatformLog(String name) {
        this.name = name;
        this.init();
    }

    private synchronized ThreadPoolExecutor init() {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.shutdownRequested) {
            return null;
        }
        this.executor = new ThreadPoolExecutor(1, 1, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                if (DEBUG_PLATFORM_LOG) {
                    DEBUG_STREAM.println("Creating and starting a new LogWorker");
                }
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(PlatformLog.this.name);
                return t;
            }
        });
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogListener> getLogListeners() {
        List<LogListener> list = this.logListeners;
        synchronized (list) {
            return new ArrayList<LogListener>(this.logListeners);
        }
    }

    public static void deregisterShutdownHook() {
        try {
            if (SHUTDOWNTHREAD != null) {
                Runtime.getRuntime().removeShutdownHook(SHUTDOWNTHREAD);
            }
        }
        catch (IllegalStateException e) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean processRemainingContent) {
        if (this.shutdownRequested) {
            return;
        }
        this.shutdownRequested = true;
        if (this.executor != null) {
            block13: {
                if (processRemainingContent) {
                    this.executor.shutdown();
                } else {
                    this.executor.shutdownNow();
                }
                try {
                    this.executor.awaitTermination(20000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (!DEBUG_PLATFORM_LOG) break block13;
                    DEBUG_STREAM.println("PlatformLog.waitMethod returning because timeout exceeded");
                }
            }
            this.executor = null;
        }
        if (DEBUG_PLATFORM_LOG) {
            DEBUG_STREAM.println("PlatformLog has been shutdown");
        }
        List<LogListener> list = this.logListeners;
        synchronized (list) {
            for (LogListener listener : this.logListeners) {
                try {
                    listener.shutdown();
                }
                catch (Throwable t) {}
            }
            this.logListeners.clear();
        }
    }

    public synchronized void start() {
        if (!this.shutdownRequested) {
            return;
        }
        this.shutdownRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addListener(LogListener listener) {
        if (listener != null) {
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("Adding to PlatformLog a new log listener " + listener);
            }
            List<LogListener> list = this.logListeners;
            synchronized (list) {
                this.logListeners.remove(listener);
                this.logListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(LogListener listener) {
        if (listener != null) {
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("Removing from PlatformLog log listener " + listener);
            }
            List<LogListener> list = this.logListeners;
            synchronized (list) {
                this.logListeners.remove(listener);
            }
            listener.shutdown();
        }
    }

    @Override
    public void logMessage(IStatus status, long timestamp, String pluginID, String threadName) {
        ThreadPoolExecutor exe;
        Message messageObj = new Message(status, pluginID, threadName);
        if (DEBUG_PLATFORM_LOG) {
            DEBUG_STREAM.println("Enqueuing message " + messageObj);
        }
        if ((exe = this.executor) == null && (exe = this.init()) == null) {
            return;
        }
        exe.execute(messageObj);
    }

    static {
        String hook = System.getProperty(SHUTDOWN_HOOK_INSTALLED_PROPERTY);
        if (hook == null || hook.equalsIgnoreCase(String.valueOf(Boolean.FALSE))) {
            SHUTDOWNTHREAD = new ShutdownThread(INSTANCE);
            INSTANCE.addListener(new SystemLogWriter());
            try {
                Runtime.getRuntime().addShutdownHook(SHUTDOWNTHREAD);
                System.setProperty(SHUTDOWN_HOOK_INSTALLED_PROPERTY, Boolean.TRUE.toString());
            }
            catch (IllegalStateException e) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        DEBUG_PLATFORM_LOG = false;
        DEBUG_STREAM = System.err;
    }

    class Message
    implements Runnable {
        private IStatus status;
        private String pluginID;
        private String threadName;
        private long timestamp = System.currentTimeMillis();

        public Message(IStatus status, String pluginID, String threadName) {
            this.status = status;
            this.pluginID = pluginID;
            this.threadName = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = PlatformLog.this.logListeners;
            synchronized (list) {
                int size = PlatformLog.this.logListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((LogListener)PlatformLog.this.logListeners.get(i)).logMessage(this.status, this.timestamp, this.pluginID, this.threadName);
                }
            }
        }

        public String toString() {
            return this.status.getMessage();
        }
    }
}

