/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixCoreException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Status;

public class ReflectionHelper {
    private Class targetClass;
    private Map methodMap = null;

    public ReflectionHelper(Class targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ReflectionHelper.errorConstructing"));
        }
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Method[] findMethods(String methodName) {
        Method[] allMethods = this.targetClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!m.getName().equals(methodName)) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public Method findFirstMethod(String methodName) {
        Method[] allMethods = this.targetClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public Method findBestMethodOnTarget(String methodName, Object[] arguments) throws NoSuchMethodException, SecurityException {
        return this.findBestMethodOnTarget(methodName, arguments, false);
    }

    private Method findBestMethodOnTarget(String methodName, Object[] arguments, boolean convertAllArgsToPrimitives) throws NoSuchMethodException, SecurityException {
        List argumentClasses = ReflectionHelper.buildArgumentClasses(arguments);
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Object[] argumentsClasses) throws NoSuchMethodException, SecurityException {
        List<Object> argumentClassesList = Arrays.asList(argumentsClasses);
        return this.findBestMethodWithSignature(methodName, argumentClassesList);
    }

    public Method findBestMethodWithSignature(String methodName, List argumentsClasses) throws NoSuchMethodException, SecurityException {
        Class[] classArgs = new Class[argumentsClasses.size()];
        try {
            argumentsClasses.toArray(classArgs);
            Method result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException e) {
            List argumentsClassList = ReflectionHelper.convertArgumentClassesToPrimitives(argumentsClasses);
            argumentsClassList.toArray(classArgs);
            try {
                Method result = this.targetClass.getMethod(methodName, classArgs);
                return result;
            }
            catch (NoSuchMethodException e2) {
                LinkedList methodsWithSameName;
                if (this.methodMap == null) {
                    this.methodMap = new HashMap();
                    Method[] methods = this.targetClass.getMethods();
                    for (int i = 0; i != methods.length; ++i) {
                        Method method = methods[i];
                        methodsWithSameName = (LinkedList)this.methodMap.get(method.getName());
                        if (methodsWithSameName == null) {
                            methodsWithSameName = new LinkedList();
                            this.methodMap.put(method.getName(), methodsWithSameName);
                        }
                        methodsWithSameName.addFirst(method);
                    }
                }
                for (int j = 0; j != 2; ++j) {
                    methodsWithSameName = (LinkedList)this.methodMap.get(methodName);
                    if (methodsWithSameName == null) {
                        throw new NoSuchMethodException(methodName);
                    }
                    for (Method method : methodsWithSameName) {
                        Class<?>[] args = method.getParameterTypes();
                        if (args.length != argumentsClasses.size()) continue;
                        boolean allMatch = true;
                        for (int i = 0; i < args.length && allMatch; ++i) {
                            Class primitiveClazz = (Class)argumentsClassList.get(i);
                            Class objectClazz = (Class)argumentsClasses.get(i);
                            if (objectClazz != null) {
                                if (args[i].equals(primitiveClazz) || args[i].isAssignableFrom(objectClazz)) continue;
                                allMatch = false;
                                continue;
                            }
                            if (!args[i].isPrimitive()) continue;
                            allMatch = false;
                        }
                        if (!allMatch) continue;
                        return method;
                    }
                }
                throw new NoSuchMethodException(methodName + " Args: " + argumentsClasses);
            }
        }
    }

    private static List buildArgumentClasses(Object[] arguments) {
        int size = arguments.length;
        ArrayList result = new ArrayList(size);
        for (int i = 0; i != size; ++i) {
            if (arguments[i] != null) {
                Class<?> clazz = arguments[i].getClass();
                result.add(clazz);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private static List convertArgumentClassesToPrimitives(List arguments) {
        ArrayList<Class<Boolean>> result = new ArrayList<Class<Boolean>>(arguments.size());
        ListIterator iter = arguments.listIterator();
        while (iter.hasNext()) {
            Class<Object> clazz = (Class<Boolean>)iter.next();
            if (clazz == Boolean.class) {
                clazz = Boolean.TYPE;
            } else if (clazz == Character.class) {
                clazz = Character.TYPE;
            } else if (clazz == Byte.class) {
                clazz = Byte.TYPE;
            } else if (clazz == Short.class) {
                clazz = Short.TYPE;
            } else if (clazz == Integer.class) {
                clazz = Integer.TYPE;
            } else if (clazz == Long.class) {
                clazz = Long.TYPE;
            } else if (clazz == Float.class) {
                clazz = Float.TYPE;
            } else if (clazz == Double.class) {
                clazz = Double.TYPE;
            } else if (clazz == Void.class) {
                clazz = Void.TYPE;
            }
            result.add(clazz);
        }
        return result;
    }

    public static final Class loadClass(String className, ClassLoader classLoader) throws MetaMatrixCoreException {
        try {
            Class<?> cls = null;
            cls = classLoader == null ? Class.forName(className.trim()) : Class.forName(className.trim(), true, classLoader);
            return cls;
        }
        catch (NullPointerException e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.nullPointer"), e));
        }
        catch (ClassNotFoundException e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.classNotFound", className), e));
        }
        catch (LinkageError e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.linkageError", className), e));
        }
        catch (Exception e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.exception", className), e));
        }
    }

    public static final Object create(String className, Collection ctorObjs, ClassLoader classLoader) throws MetaMatrixCoreException {
        try {
            int size = ctorObjs == null ? 0 : ctorObjs.size();
            Class[] names = new Class[size];
            Object[] objArray = new Object[size];
            int i = 0;
            if (size > 0) {
                for (Object obj : ctorObjs) {
                    names[i] = ReflectionHelper.loadClass(obj.getClass().getName(), classLoader);
                    objArray[i] = obj;
                    ++i;
                }
            }
            Class cls = ReflectionHelper.loadClass(className, classLoader);
            Constructor ctor = cls.getDeclaredConstructor(names);
            return ctor.newInstance(objArray);
        }
        catch (NullPointerException e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.nullPointer"), e));
        }
        catch (InstantiationException e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.instantiationError", className), e));
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.illegalAccess", className), e));
        }
        catch (MetaMatrixCoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaMatrixCoreException(new Status(4, "com.metamatrix.core", 0, CorePlugin.Util.getString("ReflectionHelper.exception", className), e));
        }
    }

    public static final Object create(String className, Collection ctorObjs) throws MetaMatrixCoreException {
        return ReflectionHelper.create(className, ctorObjs, null);
    }
}

