/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.id;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.Assertion;
import java.io.Serializable;

public class UUID
implements ObjectID,
Serializable {
    private static final String NOT_UUID_MESSAGE = CorePlugin.Util.getString("UUID.ID_must_be_of_type_UUID_1");
    private static final String UNPARSABLE_MESSAGE = CorePlugin.Util.getString("UUID.ID_must_be_of_type_UUID_to_parse_2");
    public static final String PROTOCOL = "mmuuid";
    public static final String PROTOCOL_UCASE = "mmuuid".toUpperCase();
    private static final char INTERNAL_DELIM = '-';
    private static final int BASE_16 = 16;
    private static final int ID_STRING_LEN = 36;
    public static final int FQ_LENGTH = "mmuuid".length() + 1 + 36;
    private final long mostSig;
    private final long leastSig;
    private String cachedExportableFormUuidString;

    public UUID(long mostSig, long leastSig) {
        this.mostSig = mostSig;
        this.leastSig = leastSig;
    }

    public static long getPart1(ObjectID id) {
        Assertion.assertTrue(id instanceof UUID, UNPARSABLE_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.mostSig;
    }

    public static long getPart2(ObjectID id) {
        Assertion.assertTrue(id instanceof UUID, UNPARSABLE_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.leastSig;
    }

    public static int getVariant(ObjectID id) {
        Assertion.assertTrue(id instanceof UUID, NOT_UUID_MESSAGE);
        UUID uuid = (UUID)id;
        return (int)((uuid.leastSig & 0xC000000000000000L) >>> 48);
    }

    public static int getVersion(ObjectID id) {
        Assertion.assertTrue(id instanceof UUID, NOT_UUID_MESSAGE);
        UUID uuid = (UUID)id;
        return (int)((uuid.mostSig & 0xF000L) >>> 12);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UUID) {
            UUID that = (UUID)obj;
            return this.mostSig == that.mostSig && this.leastSig == that.leastSig;
        }
        return false;
    }

    public int compareTo(Object obj) {
        UUID that = (UUID)obj;
        Assertion.isNotNull(obj);
        long diff = this.mostSig - that.mostSig;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        diff = this.leastSig - that.leastSig;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public static boolean validate(ObjectID id) {
        if (id instanceof UUID) {
            UUID uuid = (UUID)id;
            return UUID.getVariant(uuid) == 32768 && UUID.getVersion(uuid) == 1;
        }
        return false;
    }

    public String toString() {
        return this.toString(':');
    }

    public String toString(char delim) {
        return new StringBuffer(43).append(PROTOCOL).append(delim).append(this.exportableForm()).toString();
    }

    public String toStringTest() {
        return this.exportableForm() + '(' + this.mostSig + ',' + this.leastSig + ')';
    }

    public static boolean testStringToObject(UUID id1) {
        String uuidString = id1.exportableForm();
        UUID id2 = null;
        try {
            id2 = (UUID)UUID.stringToObject(uuidString);
        }
        catch (InvalidIDException e) {
            e.printStackTrace();
        }
        boolean match = true;
        if (id1.mostSig != id2.mostSig) {
            match = false;
        }
        if (id1.leastSig != id2.leastSig) {
            match = false;
        }
        return match;
    }

    public String exportableForm() {
        if (this.cachedExportableFormUuidString == null) {
            this.cachedExportableFormUuidString = UUID.toHex(this.mostSig >> 32, 8) + '-' + UUID.toHex(this.mostSig >> 16, 4) + '-' + UUID.toHex(this.mostSig, 4) + '-' + UUID.toHex(this.leastSig >> 48, 4) + '-' + UUID.toHex(this.leastSig, 12);
        }
        return this.cachedExportableFormUuidString;
    }

    private static String toHex(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static ObjectID stringToObject(String value) throws InvalidIDException {
        if (value.length() != 36) {
            throw new InvalidIDException(CorePlugin.Util.getString("UUID.InvalidLengthForProtocol", value, PROTOCOL));
        }
        try {
            long part1 = Long.parseLong(value.substring(0, 8), 16);
            long part2 = Long.parseLong(value.substring(9, 13), 16);
            long part3 = Long.parseLong(value.substring(14, 18), 16);
            long part4 = Long.parseLong(value.substring(19, 23), 16);
            long part5 = Long.parseLong(value.substring(24), 16);
            long most = part1 << 32 | part2 << 16 | part3;
            long least = part4 << 48 | part5;
            return new UUID(most, least);
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("UUID.InvalidFormatForProtocol", value, PROTOCOL));
        }
    }

    public class Version {
        public static final int TIME_BASED = 1;
        public static final int DCE_RESERVED = 2;
        public static final int NAME_BASED = 3;
        public static final int PSEUDO_RANDOM = 4;
    }

    public class Variant {
        public static final int NSC_COMPATIBLE = 0;
        public static final int STANDARD = 32768;
        public static final int MICROSOFT = 49152;
        public static final int RESERVED_FUTURE = 57344;
    }
}

