/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.Base64ByteEncoder;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.cipher.BasicCryptor;
import com.metamatrix.common.util.crypto.cipher.SerializableEncryptor;
import com.metamatrix.common.util.crypto.keymanage.AsymKeyStoreManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.Key;

public class CryptoFactory {
    private Cryptor cryptor;
    private SerializableEncryptor serializableEncryptor;
    private CryptoKeyManager keyManager;

    CryptoFactory(CryptoKeyManager keyManager) throws CryptoException {
        this.keyManager = keyManager;
        Key encryptKey = keyManager.getEncryptKey();
        Key decryptKey = keyManager.getDecryptKey();
        this.cryptor = new BasicCryptor(encryptKey, decryptKey);
        this.serializableEncryptor = new SerializableEncryptor(encryptKey);
    }

    public static CryptoFactory init(String storeFile, char[] storePass, String keyName) throws CryptoException, FileNotFoundException, IOException {
        return CryptoFactory.init(storeFile, storePass, keyName, true);
    }

    public static CryptoFactory init(String storeFile, char[] storePass, String keyName, boolean readFromCP) throws CryptoException, FileNotFoundException, IOException {
        CryptoUtil.initJCEProvider();
        return new CryptoFactory(new AsymKeyStoreManager(storeFile, CryptoFactory.deArgle(storePass), keyName, readFromCP));
    }

    public static CryptoFactory init(URL storeFile, char[] storePass, String keyName) throws CryptoException, FileNotFoundException, IOException {
        CryptoUtil.initJCEProvider();
        return new CryptoFactory(new AsymKeyStoreManager(storeFile, CryptoFactory.deArgle(storePass), keyName));
    }

    public Cryptor getCryptor() throws CryptoException {
        return this.cryptor;
    }

    public static char[] argle(char[] deArgled) {
        String deArgledStr = new String(deArgled);
        byte[] deArgledByte = deArgledStr.getBytes();
        return CryptoFactory.encodeBytes(deArgledByte);
    }

    public static char[] deArgle(char[] argled) {
        return new String(CryptoFactory.decodeBytes(argled)).toCharArray();
    }

    public static char[] encodeBytes(byte[] bytes) {
        return Base64ByteEncoder.encode(bytes).toCharArray();
    }

    public static byte[] decodeBytes(char[] encodedBytes) {
        try {
            return Base64ByteEncoder.decode(new String(encodedBytes));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0057", new String(encodedBytes), e.getMessage()));
        }
    }

    public SerializableEncryptor getSerializableEncryptor() {
        return this.serializableEncryptor;
    }

    public CryptoKeyManager getKeyManager() {
        return this.keyManager;
    }
}

