/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(PreferencePage.class);
    private PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();

    private String getString(String id) {
        return this.util.getString(I18N_PREFIX + id);
    }

    public PreferencePage() {
        super(1);
        this.setPreferenceStore(XmlImporterUiPlugin.getDefault().getPreferenceStore());
        this.setDescription(this.getString("description"));
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String cDefault = this.getString("C_threshold.default");
        String pDefault = this.getString("P_threshold.default");
        String fDefault = this.getString("F_threshold.default");
        store.setDefault("c_Threshold", cDefault);
        store.setDefault("p_Threshold", pDefault);
        store.setDefault("f_Threshold", fDefault);
        String requestTableDefault = this.getString("requestTable.default");
        store.setDefault("requestTable", requestTableDefault);
        String mergedChildSepDefault = this.getString("mergedChildSep.default");
        store.setDefault("mergedChildSep", mergedChildSepDefault);
        String xsdLibraryDefault = Platform.getLocation().toOSString();
        store.setDefault("xsdLibrary", xsdLibraryDefault);
    }

    public void createFieldEditors() {
        String pLabel = this.getString("P_threshold.label");
        String cLabel = this.getString("C_threshold.label");
        String fLabel = this.getString("F_threshold.label");
        this.addField((FieldEditor)new IntegerFieldEditor("c_Threshold", cLabel, this.getFieldEditorParent(), 4));
        this.addField((FieldEditor)new IntegerFieldEditor("p_Threshold", pLabel, this.getFieldEditorParent(), 4));
        this.addField((FieldEditor)new IntegerFieldEditor("f_Threshold", fLabel, this.getFieldEditorParent(), 4));
        String requestTableLabel = this.getString("requestTable.label");
        this.addField((FieldEditor)new StringFieldEditor("requestTable", requestTableLabel, this.getFieldEditorParent()));
        String mergedChildSepLabel = this.getString("mergedChildSep.label");
        this.addField((FieldEditor)new StringFieldEditor("mergedChildSep", mergedChildSepLabel, this.getFieldEditorParent()));
        String xsdLibraryLabel = this.getString("xsdLibrary.label");
        this.addField((FieldEditor)new StringFieldEditor("xsdLibrary", xsdLibraryLabel, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

