/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce.connection;

import com.metamatrix.connector.salesforce.Messages;
import com.metamatrix.connector.salesforce.SalesforceCapabilities;
import com.metamatrix.connector.salesforce.connection.impl.ConnectionImpl;
import com.metamatrix.connector.salesforce.execution.DataPayload;
import com.metamatrix.connector.salesforce.execution.QueryExecutionImpl;
import com.metamatrix.connector.salesforce.execution.UpdateExecutionParent;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.SourceConnection;
import com.sforce.soap.partner.QueryResult;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesforceConnection
implements Connection {
    private SalesforceCapabilities salesforceCapabilites;
    private ConnectorEnvironment connectorEnv;
    private ConnectionImpl connection;
    private ConnectionPool pool;
    private SourceConnection sourceConnection;

    public SalesforceConnection(String username, String password, URL url, ConnectorEnvironment env, ConnectionPool pool, SourceConnection srcConn) throws ConnectorException {
        try {
            this.pool = pool;
            this.sourceConnection = srcConn;
            this.connectorEnv = env;
            String capabilitiesClass = env.getProperties().getProperty("ConnectorCapabilities");
            if (capabilitiesClass != null) {
                try {
                    this.salesforceCapabilites = (SalesforceCapabilities)Class.forName(capabilitiesClass).newInstance();
                }
                catch (Exception e) {
                    throw new ConnectorException((Throwable)e, "Unable to load Capabilities Class");
                }
            } else {
                throw new ConnectorException("Capabilities Class name not found");
            }
            try {
                String inLimitString = env.getProperties().getProperty("InLimit");
                int inLimit = inLimitString == null ? -1 : Integer.decode(inLimitString);
                this.salesforceCapabilites.setMaxInCriteriaSize(inLimit);
            }
            catch (NumberFormatException e) {
                throw new ConnectorException(Messages.getString((String)"SalesforceConnection.bad.IN.value"));
            }
            long pingInterval = 5000L;
            try {
                String pingIntervalString = env.getProperties().getProperty("SourceConnectionTestInterval");
                if (null != pingIntervalString) {
                    pingInterval = Long.decode(pingIntervalString);
                }
            }
            catch (NumberFormatException e) {
                throw new ConnectorException(Messages.getString((String)"SalesforceConnection.bad.ping.value"));
            }
            int timeout = 120000;
            try {
                String timeoutString = env.getProperties().getProperty("SourceConnectionTimeout");
                if (null != timeoutString) {
                    timeout = Integer.decode(timeoutString);
                }
            }
            catch (NumberFormatException e) {
                throw new ConnectorException(Messages.getString((String)"SalesforceConnection.bad.timeout.value"));
            }
            this.connection = new ConnectionImpl(username, password, url, pingInterval, env.getLogger(), timeout);
        }
        catch (Throwable t) {
            env.getLogger().logError("SalesforceConnection() ErrorMessage: " + t.getMessage());
            if (t instanceof ConnectorException) {
                throw (ConnectorException)t;
            }
            throw new ConnectorException(t);
        }
    }

    public Execution createExecution(int executionMode, ExecutionContext context, RuntimeMetadata metadata) throws ConnectorException {
        try {
            QueryExecutionImpl retVal = null;
            String errKey = null;
            switch (executionMode) {
                case 0: {
                    retVal = new QueryExecutionImpl(this, metadata, context, this.connectorEnv);
                    break;
                }
                case 1: {
                    retVal = new UpdateExecutionParent(this, metadata, context, this.connectorEnv);
                    break;
                }
                case 2: {
                    errKey = Messages.getString((String)"SalesforceConnection.procedures.not.supported");
                    break;
                }
                default: {
                    errKey = Messages.getString((String)"SalesforceConnection.invalid.execution.mode");
                }
            }
            if (errKey != null) {
                throw new ConnectorException(errKey);
            }
            return retVal;
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public ConnectorCapabilities getCapabilities() {
        return this.salesforceCapabilites;
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
        this.pool.release(this.sourceConnection);
    }

    public QueryResult query(String queryString, int maxBatchSize) throws ConnectorException {
        return this.connection.query(queryString, maxBatchSize);
    }

    public QueryResult queryMore(String queryLocator) throws ConnectorException {
        return this.connection.queryMore(queryLocator);
    }

    public boolean isAlive() {
        return this.connection.isAlive();
    }

    public void close() {
    }

    public int delete(String[] ids) throws ConnectorException {
        return this.connection.delete(ids);
    }

    public int create(DataPayload data) throws ConnectorException {
        return this.connection.create(data);
    }

    public int update(List<DataPayload> updateDataList) throws ConnectorException {
        return this.connection.update(updateDataList);
    }
}

