/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.base;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriver;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseURLParser;
import com.metamatrix.jdbcx.base.BaseClassUtilityX;
import com.metamatrix.jdbcx.base.BaseLog;
import com.metamatrix.jdbcx.base.BasePooledConnection;
import com.metamatrix.util.UtilDebug;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class BaseDataSource
implements DataSource,
ConnectionPoolDataSource,
Referenceable,
Serializable {
    private static String footprint = "$Revision:   3.36.1.1  $";
    protected transient BaseExceptions exceptions;
    public transient UtilDebug debug;
    private transient PrintWriter printWriter;
    protected transient Object spyLogger;
    private transient boolean internalConnectionCallDoNotLog = false;
    Integer queryTimeout = null;
    protected String databaseName;
    String dataSourceName = "";
    String description;
    String password;
    String portNumber;
    String roleName;
    String serverName;
    String importStatementPool;
    String user;
    String extendedOptions;
    Integer loginTimeout = null;
    Boolean batchPerformanceWorkaround = null;
    String spyAttributes;
    Boolean embedded = null;
    Integer maxPooledStatements = null;
    Integer initialPoolSize = null;
    Integer minPoolSize = null;
    Integer maxPoolSize = null;
    Integer maxIdleTime = null;
    Integer propertyCycle = null;
    Integer insensitiveResultSetBufferSize = null;
    String alternateServers;
    Integer connectionRetryCount = null;
    Integer connectionRetryDelay = null;
    Boolean loadBalancing = null;
    Boolean JavaDoubleToString = null;
    Integer resultsetMetaDataOptions = null;
    String initializationString;
    String loadLibraryPath;
    Integer workarounds = null;
    Integer convertNull = null;
    Integer catalogOptions = null;
    boolean ignoreCatalogIncludesSynonymsSetting = false;

    public int getCatalogOptions() {
        if (this.catalogOptions != null) {
            return this.catalogOptions;
        }
        return 2;
    }

    public void setCatalogOptions(int n) {
        this.catalogOptions = new Integer(n);
        this.ignoreCatalogIncludesSynonymsSetting = true;
    }

    public boolean getCatalogIncludesSynonyms() {
        if (this.catalogOptions == null) {
            return false;
        }
        return (this.catalogOptions & 2) > 0;
    }

    public void setCatalogIncludesSynonyms(boolean bl) {
        if (!this.ignoreCatalogIncludesSynonymsSetting) {
            this.catalogOptions = new Integer(bl ? 2 : 0);
        }
    }

    public final String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public int getPortNumber() {
        if (this.portNumber == null) {
            return 0;
        }
        return Integer.parseInt(this.portNumber);
    }

    public final void setPortNumber(int n) {
        this.portNumber = new Integer(n).toString();
    }

    public final String getRoleName() {
        return this.roleName;
    }

    public final void setRoleName(String string) {
        this.roleName = string;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final String getImportStatementPool() {
        return this.importStatementPool;
    }

    public final void setImportStatementPool(String string) {
        this.importStatementPool = string;
    }

    public final String getExtendedOptions() {
        return this.extendedOptions;
    }

    public final void setExtendedOptions(String string) {
        this.extendedOptions = string;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String string) {
        this.user = string;
    }

    public final boolean getBatchPerformanceWorkaround() {
        if (this.batchPerformanceWorkaround != null) {
            return this.batchPerformanceWorkaround;
        }
        return false;
    }

    public final void setBatchPerformanceWorkaround(boolean bl) {
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            this.batchPerformanceWorkaround = new Boolean(bl);
        }
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = new Integer(n);
    }

    public int getQueryTimeout() {
        if (this.queryTimeout != null) {
            return this.queryTimeout;
        }
        return 0;
    }

    public final int getLoginTimeout() {
        if (this.loginTimeout != null) {
            return this.loginTimeout;
        }
        return 0;
    }

    public final void setLoginTimeout(int n) {
        this.loginTimeout = new Integer(n);
    }

    public final String getSpyAttributes() {
        return this.spyAttributes;
    }

    public final void setSpyAttributes(String string) {
        this.spyAttributes = string;
        if (this.spyAttributes != null) {
            if (this.spyAttributes.charAt(0) == '(') {
                this.spyAttributes = this.spyAttributes.substring(1);
            }
            if (this.spyAttributes.charAt(this.spyAttributes.length() - 1) == ')') {
                this.spyAttributes = this.spyAttributes.substring(0, this.spyAttributes.length() - 1);
            }
        }
    }

    public final boolean getEmbedded() {
        if (this.embedded != null) {
            return this.embedded;
        }
        return false;
    }

    public final void setEmbedded(boolean bl) {
        this.embedded = new Boolean(bl);
    }

    public void setMaxStatements(int n) {
        this.maxPooledStatements = new Integer(n);
    }

    public void setMaxPooledStatements(int n) {
        this.maxPooledStatements = new Integer(n);
    }

    public int getMaxStatements() {
        if (this.maxPooledStatements != null) {
            return this.maxPooledStatements;
        }
        return 0;
    }

    public int getMaxPooledStatements() {
        if (this.maxPooledStatements != null) {
            return this.maxPooledStatements;
        }
        return 0;
    }

    public void setInitialPoolSize(int n) {
        this.initialPoolSize = new Integer(n);
    }

    public int getInitialPoolSize() {
        if (this.initialPoolSize != null) {
            return this.initialPoolSize;
        }
        return 0;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = new Integer(n);
    }

    public int getMinPoolSize() {
        if (this.minPoolSize != null) {
            return this.minPoolSize;
        }
        return 0;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = new Integer(n);
    }

    public int getMaxPoolSize() {
        if (this.maxPoolSize != null) {
            return this.maxPoolSize;
        }
        return 0;
    }

    public void setMaxIdleTime(int n) {
        this.maxIdleTime = new Integer(n);
    }

    public int getMaxIdleTime() {
        if (this.maxIdleTime != null) {
            return this.maxIdleTime;
        }
        return 0;
    }

    public void setPropertyCycle(int n) {
        this.propertyCycle = new Integer(n);
    }

    public int getPropertyCycle() {
        if (this.propertyCycle != null) {
            return this.propertyCycle;
        }
        return 0;
    }

    public void setInsensitiveResultSetBufferSize(int n) {
        this.insensitiveResultSetBufferSize = new Integer(n);
    }

    public int getInsensitiveResultSetBufferSize() {
        if (this.insensitiveResultSetBufferSize != null) {
            return this.insensitiveResultSetBufferSize;
        }
        return 2048;
    }

    public final String getAlternateServers() {
        return this.alternateServers;
    }

    public final void setAlternateServers(String string) {
        this.alternateServers = string;
    }

    public final void setConnectionRetryCount(int n) {
        this.connectionRetryCount = new Integer(n);
    }

    public final int getConnectionRetryCount() {
        if (this.connectionRetryCount != null) {
            return this.connectionRetryCount;
        }
        return 5;
    }

    public final void setConnectionRetryDelay(int n) {
        this.connectionRetryDelay = new Integer(n);
    }

    public final int getConnectionRetryDelay() {
        if (this.connectionRetryDelay != null) {
            return this.connectionRetryDelay;
        }
        return 1;
    }

    public final void setLoadBalancing(boolean bl) {
        this.loadBalancing = new Boolean(bl);
    }

    public final boolean getLoadBalancing() {
        if (this.loadBalancing != null) {
            return this.loadBalancing;
        }
        return false;
    }

    public final void setJavaDoubleToString(boolean bl) {
        this.JavaDoubleToString = new Boolean(bl);
    }

    public final boolean getJavaDoubleToString() {
        if (this.JavaDoubleToString != null) {
            return this.JavaDoubleToString;
        }
        return false;
    }

    public final void setResultsetMetaDataOptions(int n) {
        this.resultsetMetaDataOptions = new Integer(n);
    }

    public final int getResultsetMetaDataOptions() {
        if (this.resultsetMetaDataOptions != null) {
            return this.resultsetMetaDataOptions;
        }
        return 0;
    }

    public final String getInitializationString() {
        return this.initializationString;
    }

    public final void setInitializationString(String string) {
        this.initializationString = string;
    }

    public final String getLoadLibraryPath() {
        return this.loadLibraryPath;
    }

    public final void setLoadLibraryPath(String string) {
        this.loadLibraryPath = string;
    }

    public final int getWorkarounds() {
        if (this.workarounds != null) {
            return this.workarounds;
        }
        return 0;
    }

    public final void setWorkarounds(int n) {
        this.workarounds = new Integer(n);
    }

    public int getConvertNull() {
        if (this.convertNull != null) {
            return this.convertNull;
        }
        return 1;
    }

    public void setConvertNull(int n) {
        this.convertNull = new Integer(n);
    }

    private void setupLogger() {
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
    }

    protected BaseConnection getBaseConnection() throws SQLException {
        BaseExceptions baseExceptions = this.setupExceptionHandling();
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.getPropertyInfo();
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseDriverPropertyInfos, baseConnection, baseExceptions);
        this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
        baseConnectionProperties.validate(baseDriverPropertyInfos, baseExceptions);
        baseConnection.open(baseConnectionProperties, baseExceptions, this.debug);
        return baseConnection;
    }

    protected BaseConnection getBaseConnection(String string, String string2) throws SQLException {
        BaseExceptions baseExceptions = this.setupExceptionHandling();
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.getPropertyInfo();
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseDriverPropertyInfos, baseConnection, baseExceptions);
        baseConnectionProperties.put("user", string);
        baseConnectionProperties.put("password", string2);
        this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
        baseConnectionProperties.validate(baseDriverPropertyInfos, baseExceptions);
        baseConnection.open(baseConnectionProperties, baseExceptions, this.debug);
        return baseConnection;
    }

    public final Connection getConnection() throws SQLException {
        BaseConnection baseConnection;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection()");
        }
        try {
            baseConnection = this.getBaseConnection();
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        BaseConnection baseConnection;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            baseConnection = this.getBaseConnection(string, string2);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    public final String getAuthenticatedUser() throws SQLException {
        return this.getAuthenticatedUser(this.user);
    }

    public String getAuthenticatedUser(String string) throws SQLException {
        return "";
    }

    public final PooledConnection getPooledConnection() throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection()");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection();
            basePooledConnection = basePooledConnection2 = new BasePooledConnection((BaseConnection)object);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    public final PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection(string, string2);
            basePooledConnection = basePooledConnection2 = new BasePooledConnection((BaseConnection)object);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    public final PrintWriter getLogWriter() throws SQLException {
        this.setupExceptionHandling();
        return this.printWriter;
    }

    public final void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.setupExceptionHandling();
        this.printWriter = printWriter;
        this.spyLogger = printWriter == null ? null : BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
    }

    public final Reference getReference() throws NamingException {
        String string = BaseClassUtilityX.getRootName(this);
        String string2 = "com.metamatrix.jdbcx." + string.toLowerCase() + "." + string + "DataSource";
        Reference reference = new Reference(string2, string2 + "Factory", null);
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        if (this.portNumber != null) {
            reference.add(new StringRefAddr("portNumber", this.portNumber));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.importStatementPool != null) {
            reference.add(new StringRefAddr("importStatementPool", this.importStatementPool));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.loginTimeout != null) {
            reference.add(new StringRefAddr("loginTimeout", this.loginTimeout.toString()));
        }
        if (this.embedded != null) {
            reference.add(new StringRefAddr("embedded", this.embedded.toString()));
        }
        if (this.spyAttributes != null) {
            reference.add(new StringRefAddr("spyAttributes", this.spyAttributes));
        }
        if (this.alternateServers != null) {
            reference.add(new StringRefAddr("alternateServers", this.alternateServers));
        }
        if (this.resultsetMetaDataOptions != null) {
            reference.add(new StringRefAddr("resultsetMetaDataOptions", this.resultsetMetaDataOptions.toString()));
        }
        if (this.initializationString != null) {
            reference.add(new StringRefAddr("initializationString", this.initializationString));
        }
        if (this.loadLibraryPath != null) {
            reference.add(new StringRefAddr("loadLibraryPath", this.loadLibraryPath));
        }
        if (this.workarounds != null) {
            reference.add(new StringRefAddr("workarounds", this.workarounds.toString()));
        }
        if (this.connectionRetryCount != null) {
            reference.add(new StringRefAddr("connectionRetryCount", this.connectionRetryCount.toString()));
        }
        if (this.connectionRetryDelay != null) {
            reference.add(new StringRefAddr("connectionRetryDelay", this.connectionRetryDelay.toString()));
        }
        if (this.queryTimeout != null) {
            reference.add(new StringRefAddr("queryTimeout", this.queryTimeout.toString()));
        }
        if (this.loadBalancing != null) {
            reference.add(new StringRefAddr("loadBalancing", this.loadBalancing.toString()));
        }
        if (this.JavaDoubleToString != null) {
            reference.add(new StringRefAddr("JavaDoubleToString", this.JavaDoubleToString.toString()));
        }
        if (this.maxPooledStatements != null) {
            reference.add(new StringRefAddr("maxPooledStatements", this.maxPooledStatements.toString()));
        }
        if (this.initialPoolSize != null) {
            reference.add(new StringRefAddr("initialPoolSize", this.initialPoolSize.toString()));
        }
        if (this.minPoolSize != null) {
            reference.add(new StringRefAddr("minPoolSize", this.minPoolSize.toString()));
        }
        if (this.maxPoolSize != null) {
            reference.add(new StringRefAddr("maxPoolSize", this.maxPoolSize.toString()));
        }
        if (this.maxIdleTime != null) {
            reference.add(new StringRefAddr("maxIdleTime", this.maxIdleTime.toString()));
        }
        if (this.propertyCycle != null) {
            reference.add(new StringRefAddr("propertyCycle", this.propertyCycle.toString()));
        }
        if (this.insensitiveResultSetBufferSize != null) {
            reference.add(new StringRefAddr("insensitiveResultSetBufferSize", this.insensitiveResultSetBufferSize.toString()));
        }
        if (this.convertNull != null) {
            reference.add(new StringRefAddr("convertNull", this.convertNull.toString()));
        }
        if (this.extendedOptions != null) {
            reference.add(new StringRefAddr("extendedOptions", this.extendedOptions));
        }
        if (this.catalogOptions != null) {
            reference.add(new StringRefAddr("catalogOptions", this.catalogOptions.toString()));
            reference.add(new StringRefAddr("CatalogIncludesSynonyms", "false"));
        }
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        if (this.batchPerformanceWorkaround != null) {
            reference.add(new StringRefAddr("batchPerformanceWorkaround", this.batchPerformanceWorkaround.toString()));
        }
        this.implAddProperties(reference);
        return reference;
    }

    protected void implAddProperties(Reference reference) {
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        return null;
    }

    protected synchronized BaseExceptions setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = new BaseExceptions(BaseClassUtilityX.getRootName(this));
            return this.exceptions;
        }
        return new BaseExceptions(this.exceptions.getMessages(), this.exceptions.getReturnVendorCode());
    }

    protected BaseConnectionProperties getConnectionProperties(BaseDriverPropertyInfos baseDriverPropertyInfos, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        String string;
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        String string2 = BaseClassUtilityX.getRootName(this);
        String string3 = "jdbc:mmx:" + string2 + ":";
        if (this.serverName == null) {
            if (this.portNumber != null) {
                throw baseExceptions.getException(6101);
            }
        } else {
            string3 = string3 + "//" + this.serverName;
            if (this.portNumber != null) {
                string3 = string3 + ":" + this.portNumber;
            }
        }
        if (this.user != null) {
            string3 = string3 + ";user=" + this.user;
        }
        if (this.password != null) {
            string3 = string3 + ";password=" + this.password;
        }
        if (this.databaseName != null) {
            string3 = string3 + ";databaseName=" + this.databaseName;
        }
        if (this.loginTimeout != null) {
            string3 = string3 + ";loginTimeout=" + this.loginTimeout.toString();
        }
        if (this.maxPooledStatements != null) {
            string3 = string3 + ";maxPooledStatements=" + this.maxPooledStatements.toString();
        }
        if (this.importStatementPool != null) {
            string3 = string3 + ";importStatementPool=" + this.importStatementPool;
        }
        if (this.embedded != null) {
            string3 = string3 + ";embedded=" + this.embedded.toString();
        }
        if (this.alternateServers != null) {
            string3 = string3 + ";alternateServers=" + this.alternateServers;
        }
        if (this.batchPerformanceWorkaround != null) {
            string3 = string3 + ";batchPerformanceWorkaround=" + this.batchPerformanceWorkaround.toString();
        }
        if (this.insensitiveResultSetBufferSize != null) {
            string3 = string3 + ";insensitiveResultSetBufferSize=" + this.insensitiveResultSetBufferSize.toString();
        }
        if (this.connectionRetryCount != null) {
            string3 = string3 + ";connectionRetryCount=" + this.connectionRetryCount.toString();
        }
        if (this.connectionRetryDelay != null) {
            string3 = string3 + ";connectionRetryDelay=" + this.connectionRetryDelay.toString();
        }
        if (this.loadBalancing != null) {
            string3 = string3 + ";loadBalancing=" + this.loadBalancing.toString();
        }
        if (this.JavaDoubleToString != null) {
            string3 = string3 + ";JavaDoubleToString=" + this.JavaDoubleToString.toString();
        }
        if (this.resultsetMetaDataOptions != null) {
            string3 = string3 + ";resultsetMetaDataOptions=" + this.resultsetMetaDataOptions.toString();
        }
        if (this.convertNull != null) {
            string3 = string3 + ";convertNull=" + this.convertNull.toString();
        }
        if (this.queryTimeout != null) {
            string3 = string3 + ";queryTimeout=" + this.queryTimeout.toString();
        }
        if (this.initializationString != null) {
            string3 = string3 + ";initializationString=(" + this.initializationString + ")";
        }
        if (this.loadLibraryPath != null) {
            string3 = string3 + ";loadLibraryPath=(" + this.loadLibraryPath + ")";
        }
        if (this.workarounds != null) {
            string3 = string3 + ";workarounds=" + this.workarounds.toString();
        }
        if (this.extendedOptions != null) {
            string3 = string3 + ";" + this.extendedOptions;
        }
        if (this.catalogOptions != null) {
            string3 = string3 + ";CatalogIncludesSynonyms=" + ((this.catalogOptions & 2) > 0 ? "TRUE" : "FALSE") + ";catalogOptions=" + this.catalogOptions;
        }
        if ((string = this.implGetPropertyNameValuePairs()) != null) {
            string3 = string3 + ";" + string;
        }
        BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
        baseURLParser.parse(string2, string3, baseConnectionProperties);
        baseConnection.modifyUserSpecifiedConnectProperties(baseConnectionProperties);
        baseConnectionProperties.mergeDefaultProperties(baseDriverPropertyInfos);
        return baseConnectionProperties;
    }

    private String getBooleanString(boolean bl) {
        return bl ? "true" : "false";
    }
}

