/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilSnoopIndirection;
import com.metamatrix.util.UtilTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;

public final class SQLServerByteOrderedDataWriter {
    private static String footprint = "$Revision:   3.15.1.1  $";
    private Socket socket;
    private OutputStream socketOutputStream;
    public int messageType;
    private int packetSize;
    private static final int DEFAULT_PACKET_SIZE = 4096;
    private int numPacketsToBuffer;
    private int numPacketsBuffered;
    private byte[] requestBuffer;
    public int numBytesPlacedInBuffer;
    private int savedStatusFieldPos;
    private int numBytesInCurrentPacket;
    private int numPacketsInRequest;
    public UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int[] returnedLength;
    private UtilTempBuffer tempBuffer;
    private boolean debuggingSocket = false;
    private char[] ucs2Buffer;
    private int TDS_Version = 0x71000000;
    private long transactionDescriptor = 0L;
    private int _lenBytes;

    public SQLServerByteOrderedDataWriter(Socket socket, UtilTransliterator utilTransliterator, boolean bl, boolean bl2) {
        this.socket = socket;
        this.debuggingSocket = bl;
        this.transliterator = utilTransliterator;
        this.staticByteArray = new byte[256];
        this.returnedLength = new int[1];
        try {
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPacketSize(4096, bl2);
    }

    public void close() {
        if (this.tempBuffer != null) {
            try {
                this.tempBuffer.truncate(true);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
    }

    public final void writeInt8(int n) throws UtilException {
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)n;
        ++this.numBytesInCurrentPacket;
    }

    public final void writeInt16(int n) throws UtilException {
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        if (this.packetSize - this.numBytesInCurrentPacket >= 2) {
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)n;
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 8);
            this.numBytesInCurrentPacket += 2;
        } else {
            this.putByte((byte)n);
            this.putByte((byte)(n >> 8));
        }
    }

    public final void writeBigEndianInt16(int n) throws UtilException {
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        if (this.packetSize - this.numBytesInCurrentPacket >= 2) {
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 8);
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)n;
            this.numBytesInCurrentPacket += 2;
        } else {
            this.putByte((byte)(n >> 8));
            this.putByte((byte)n);
        }
    }

    public final void writeInt32(int n) throws UtilException {
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        if (this.packetSize - this.numBytesInCurrentPacket >= 4) {
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)n;
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 8);
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 16);
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 24);
            this.numBytesInCurrentPacket += 4;
        } else {
            this.putByte((byte)n);
            this.putByte((byte)(n >> 8));
            this.putByte((byte)(n >> 16));
            this.putByte((byte)(n >> 24));
        }
    }

    public final void writeBigEndianInt32(int n) throws UtilException {
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        if (this.packetSize - this.numBytesInCurrentPacket >= 4) {
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 24);
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 16);
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(n >> 8);
            this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)n;
            this.numBytesInCurrentPacket += 4;
        } else {
            this.putByte((byte)(n >> 24));
            this.putByte((byte)(n >> 16));
            this.putByte((byte)(n >> 8));
            this.putByte((byte)n);
        }
    }

    public final void writeIEEE32BitFloat(float f) throws UtilException {
        this.writeInt32(Float.floatToIntBits(f));
    }

    public final void writeInt64(long l) throws UtilException {
        this.staticByteArray[0] = (byte)l;
        this.staticByteArray[1] = (byte)(l >> 8);
        this.staticByteArray[2] = (byte)(l >> 16);
        this.staticByteArray[3] = (byte)(l >> 24);
        this.staticByteArray[4] = (byte)(l >> 32);
        this.staticByteArray[5] = (byte)(l >> 40);
        this.staticByteArray[6] = (byte)(l >> 48);
        this.staticByteArray[7] = (byte)(l >> 56);
        this.putArrayOfBytes(this.staticByteArray, 0, 8);
    }

    public final void writeIEEE64BitDouble(double d) throws UtilException {
        this.writeInt64(Double.doubleToLongBits(d));
    }

    public final void writeString(String string) throws UtilException {
        if (string == null) {
            return;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.putArrayOfBytes(byArray, 0, n);
    }

    public final void writeStringWithLength16(String string) throws UtilException {
        if (string == null) {
            return;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt16(n);
        this.putArrayOfBytes(byArray, 0, n);
    }

    public final void writeStringWithLength32(String string) throws UtilException {
        if (string == null) {
            return;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt32(n);
        this.putArrayOfBytes(byArray, 0, n);
    }

    public final void writeStringAsUCS2(String string) throws UtilException {
        if (string == null) {
            return;
        }
        this.putUCS2String(string);
    }

    public final void writeStringAsUCS2WithLength16(String string) throws UtilException {
        if (string == null) {
            return;
        }
        this.writeInt16(string.length() * 2);
        this.putUCS2String(string);
    }

    public final void writeStringAsUCS2WithLength32(String string) throws UtilException {
        if (string == null) {
            return;
        }
        this.writeInt32(string.length() * 2);
        this.putUCS2String(string);
    }

    public final void writeBytes(byte[] byArray) throws UtilException {
        if (byArray == null) {
            return;
        }
        this.putArrayOfBytes(byArray, 0, byArray.length);
    }

    public final void writeBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (byArray == null || n2 <= 0) {
            return;
        }
        this.putArrayOfBytes(byArray, n, n2);
    }

    public final OutputStream getOutputStream(int n) throws UtilException {
        this._lenBytes = n;
        return new OutputStream(){
            private int totalLen;
            private int writtenSoFar;
            {
                this.totalLen = SQLServerByteOrderedDataWriter.this._lenBytes;
            }

            public void write(int n) throws IOException {
                if (this.writtenSoFar >= this.totalLen) {
                    throw new IOException();
                }
                try {
                    SQLServerByteOrderedDataWriter.this.writeInt8(n);
                    ++this.writtenSoFar;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.writtenSoFar;
                try {
                    if (n2 > n3) {
                        SQLServerByteOrderedDataWriter.this.writeBytes(byArray, n, n3);
                        this.writtenSoFar = this.totalLen;
                        throw new IOException();
                    }
                    SQLServerByteOrderedDataWriter.this.writeBytes(byArray, n, n2);
                    this.writtenSoFar += n2;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }
        };
    }

    public final void writeStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        this.writeInt16(n);
        try {
            int n2;
            for (int i = n; i > 0; i -= n2) {
                int n3 = Math.min(i, this.staticByteArray.length);
                n2 = inputStream.read(this.staticByteArray, 0, n3);
                if (n2 == -1) {
                    throw new UtilException(1002);
                }
                this.putArrayOfBytes(this.staticByteArray, 0, n2);
            }
        }
        catch (UtilException utilException) {
            throw new UtilException(1030);
        }
        catch (IOException iOException) {
            throw new UtilException(1030);
        }
    }

    public final void writeStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        this.writeInt32(n);
        try {
            int n2;
            for (int i = n; i > 0; i -= n2) {
                int n3 = Math.min(i, this.staticByteArray.length);
                n2 = inputStream.read(this.staticByteArray, 0, n3);
                if (n2 == -1) {
                    throw new UtilException(1002);
                }
                this.putArrayOfBytes(this.staticByteArray, 0, n2);
            }
        }
        catch (UtilException utilException) {
            throw new UtilException(1030);
        }
        catch (IOException iOException) {
            throw new UtilException(1030);
        }
    }

    public final void writeAsciiStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        try {
            if (!this.transliterator.isFixedBytesPerChar()) {
                if (this.tempBuffer == null) {
                    this.tempBuffer = new UtilPagedTempBuffer();
                }
                this.transliterator.encode(inputStream, n, this.tempBuffer.getOutputStream());
                this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                this.tempBuffer.truncate();
                return;
            }
            int n2 = n * this.transliterator.getMaxBytesPerChar();
            this.writeInt16(n2);
            this.transliterator.encode(inputStream, n, this.getOutputStream(n2));
        }
        catch (UtilException utilException) {
            throw new UtilException(1030);
        }
    }

    public final void writeAsciiStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        try {
            if (!this.transliterator.isFixedBytesPerChar()) {
                if (this.tempBuffer == null) {
                    this.tempBuffer = new UtilPagedTempBuffer();
                }
                this.transliterator.encode(inputStream, n, this.tempBuffer.getOutputStream());
                this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                this.tempBuffer.truncate();
                return;
            }
            int n2 = n * this.transliterator.getMaxBytesPerChar();
            this.writeInt32(n2);
            this.transliterator.encode(inputStream, n, this.getOutputStream(n2));
        }
        catch (UtilException utilException) {
            throw new UtilException(1030);
        }
    }

    public final void writeReaderWithLength16(Reader reader, int n) throws UtilException {
        try {
            if (!this.transliterator.isFixedBytesPerChar()) {
                if (this.tempBuffer == null) {
                    this.tempBuffer = new UtilPagedTempBuffer();
                }
                this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
                this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                this.tempBuffer.truncate();
                return;
            }
            int n2 = n * this.transliterator.getMaxBytesPerChar();
            this.writeInt16(n2);
            this.transliterator.encode(reader, n, this.getOutputStream(n2));
        }
        catch (UtilException utilException) {
            throw new UtilException(1030);
        }
    }

    public final void writeReaderWithLength32(Reader reader, int n) throws UtilException {
        try {
            if (!this.transliterator.isFixedBytesPerChar()) {
                if (this.tempBuffer == null) {
                    this.tempBuffer = new UtilPagedTempBuffer();
                }
                this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
                this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
                this.tempBuffer.truncate();
                return;
            }
            int n2 = n * this.transliterator.getMaxBytesPerChar();
            this.writeInt32(n2);
            this.transliterator.encode(reader, n, this.getOutputStream(n2));
        }
        catch (UtilException utilException) {
            throw new UtilException(1030);
        }
    }

    public final void writePLPBody(Object object, int n, boolean bl) throws UtilException {
        if (object == null) {
            return;
        }
        if (!bl) {
            if (object instanceof byte[]) {
                this.writeInt64(n);
                if (n != 0) {
                    this.writeInt32(n);
                    this.writeBytes((byte[])object, 0, n);
                }
            } else if (object instanceof InputStream) {
                if (n != 0) {
                    this.writeInt64(n);
                    this.writeStreamWithLength32((InputStream)object, n);
                }
            } else {
                UtilDebug.assert((String)"unexpected object in WritePlpBody", (boolean)false);
            }
        } else if (object instanceof String) {
            this.writeInt64(-2L);
            String string = (String)object;
            if (string.length() != 0) {
                this.writeStringWithLength32((String)object);
            }
        } else if (object instanceof Reader) {
            this.writeInt64(-2L);
            if (n != 0) {
                this.writeReaderWithLength32((Reader)object, n);
            }
        } else if (object instanceof InputStream) {
            this.writeInt64(-2L);
            if (n != 0) {
                this.writeAsciiStreamWithLength32((InputStream)object, n);
            }
        } else {
            UtilDebug.assert((String)"unexpected object in WritePlpBody", (boolean)false);
        }
        this.writeInt32(0);
    }

    private final void checkForStartOfPacket() throws UtilException {
        if (this.numBytesInCurrentPacket == 0) {
            this.signalStartOfPacket();
        } else if (this.numBytesInCurrentPacket == this.packetSize) {
            if (this.numPacketsBuffered < this.numPacketsToBuffer - 1) {
                ++this.numPacketsBuffered;
            } else {
                try {
                    this.socketOutputStream.write(this.requestBuffer, 0, this.numBytesPlacedInBuffer);
                }
                catch (InterruptedIOException interruptedIOException) {
                    String string = UtilException.getLocalizedReason((int)1033, (String)null);
                    throw new UtilException(1018, string);
                }
                catch (IOException iOException) {
                    throw new UtilException(1018, iOException.getMessage());
                }
                this.numPacketsBuffered = 0;
                this.numBytesPlacedInBuffer = 0;
            }
            ++this.numPacketsInRequest;
            this.numBytesInCurrentPacket = 0;
            this.signalStartOfPacket();
        }
    }

    public final void setPacketSize(int n, boolean bl) {
        this.packetSize = n;
        this.numPacketsToBuffer = this.packetSize > 16384 || !bl ? 1 : 16384 / this.packetSize;
        if (this.requestBuffer == null || this.requestBuffer.length < this.packetSize * this.numPacketsToBuffer) {
            this.requestBuffer = new byte[this.packetSize * this.numPacketsToBuffer];
        }
    }

    private final void signalStartOfPacket() throws UtilException {
        if (this.debuggingSocket) {
            UtilSnoopIndirection.addTextToSendStream((Socket)this.socket, (int)this.numBytesPlacedInBuffer, (String)"Start of Packet", (boolean)true);
        }
        this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)this.messageType;
        this.savedStatusFieldPos = this.numBytesPlacedInBuffer;
        this.requestBuffer[this.numBytesPlacedInBuffer++] = 4;
        this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(this.packetSize >> 8);
        this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)this.packetSize;
        this.requestBuffer[this.numBytesPlacedInBuffer++] = 0;
        this.requestBuffer[this.numBytesPlacedInBuffer++] = 0;
        this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(this.numPacketsInRequest + 1);
        this.requestBuffer[this.numBytesPlacedInBuffer++] = 0;
        this.numBytesInCurrentPacket += 8;
        if (this.TDS_Version == 1913192450 && this.numPacketsInRequest == 0 && (this.messageType == 1 || this.messageType == 3 || this.messageType == 14)) {
            int n = 22;
            byte[] byArray = new byte[]{22, 0, 0, 0, 18, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0};
            this.writeInt32(n);
            this.writeInt32(n - 4);
            this.writeInt16(2);
            this.writeInt64(this.transactionDescriptor);
            this.writeInt32(1);
        }
    }

    private final void signalEndOfPacket() throws UtilException {
        this.requestBuffer[this.savedStatusFieldPos] = 1;
        this.requestBuffer[this.savedStatusFieldPos + 1] = (byte)(this.numBytesInCurrentPacket >> 8);
        this.requestBuffer[this.savedStatusFieldPos + 2] = (byte)this.numBytesInCurrentPacket;
    }

    public final void putByte(byte by) throws UtilException {
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        this.requestBuffer[this.numBytesPlacedInBuffer++] = by;
        ++this.numBytesInCurrentPacket;
    }

    public final void putUCS2String(String string) throws UtilException {
        int n = string.length();
        int n2 = 0;
        if (this.numBytesInCurrentPacket % this.packetSize == 0) {
            this.checkForStartOfPacket();
        }
        if (this.ucs2Buffer == null || this.ucs2Buffer.length < this.packetSize) {
            this.ucs2Buffer = new char[this.packetSize];
        }
        while (true) {
            int n3 = (this.packetSize - this.numBytesInCurrentPacket) / 2;
            int n4 = Math.min(n - n2, n3);
            string.getChars(n2, n2 + n4, this.ucs2Buffer, 0);
            for (int i = 0; i < n4; ++i) {
                this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)this.ucs2Buffer[i];
                this.requestBuffer[this.numBytesPlacedInBuffer++] = (byte)(this.ucs2Buffer[i] >>> 8);
            }
            this.numBytesInCurrentPacket += n4 * 2;
            if ((n2 += n4) == n) break;
            char c = string.charAt(n2);
            this.putByte((byte)c);
            this.putByte((byte)(c >>> 8));
            ++n2;
        }
    }

    public final void putArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return;
        }
        int n3 = n2;
        while (n3 != 0) {
            this.checkForStartOfPacket();
            int n4 = this.packetSize - this.numBytesInCurrentPacket;
            int n5 = n3 <= n4 ? n3 : n4;
            int n6 = n + (n2 - n3);
            if (n5 < 15) {
                for (int i = n5 - 1; i >= 0; --i) {
                    this.requestBuffer[this.numBytesPlacedInBuffer + i] = byArray[n6 + i];
                }
            } else {
                System.arraycopy(byArray, n6, this.requestBuffer, this.numBytesPlacedInBuffer, n5);
            }
            n3 -= n5;
            this.numBytesInCurrentPacket += n5;
            this.numBytesPlacedInBuffer += n5;
        }
    }

    public final void send() throws UtilException {
        if (this.messageType == 13 || this.messageType == 6) {
            this.signalStartOfPacket();
        }
        if (this.numBytesInCurrentPacket > 0) {
            this.signalEndOfPacket();
        }
        try {
            this.socketOutputStream.write(this.requestBuffer, 0, this.numBytesPlacedInBuffer);
            this.socketOutputStream.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            String string = UtilException.getLocalizedReason((int)1033, (String)null);
            throw new UtilException(1018, string);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
        this.numBytesPlacedInBuffer = 0;
        this.numPacketsInRequest = 0;
        this.numBytesInCurrentPacket = 0;
        this.numPacketsBuffered = 0;
    }

    public boolean getDebuggingSocket() {
        return this.debuggingSocket;
    }

    public void setSocket(Socket socket) throws UtilException {
        try {
            this.socket = socket;
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            throw new UtilException(1018, exception.toString());
        }
    }

    public void setTDSVersion(int n) {
        this.TDS_Version = n;
    }

    public void setTransactionDescriptor(long l) {
        this.transactionDescriptor = l;
    }
}

