/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataConsumer;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

public class UtilSocketDataConsumer
implements UtilDataConsumer {
    private static String footprint = "$Revision:   3.3.3.0  $";
    private Socket destinationSocket;
    private OutputStream socketOutputStream = null;

    public UtilSocketDataConsumer(Socket socket) {
        this.destinationSocket = socket;
    }

    private OutputStream getSocketOutputStream() throws IOException {
        if (this.socketOutputStream == null) {
            this.socketOutputStream = this.destinationSocket.getOutputStream();
        }
        return this.socketOutputStream;
    }

    public void putByte(byte by) throws UtilException {
        try {
            this.getSocketOutputStream().write(by);
        }
        catch (InterruptedIOException interruptedIOException) {
            String string = UtilException.getLocalizedReason(1033, (String)null);
            throw new UtilException(1018, string);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    public void putArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return;
        }
        try {
            this.getSocketOutputStream().write(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            String string = UtilException.getLocalizedReason(1033, (String)null);
            throw new UtilException(1018, string);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    public int getPosition() throws UtilException {
        throw new UtilException(1022);
    }

    public void setPosition(int n) throws UtilException {
        throw new UtilException(1022);
    }

    public void send() throws UtilException {
        try {
            this.getSocketOutputStream().flush();
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }
}

