/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

public class SingleInvokationProxy
extends ServiceProxy {
    private volatile ServiceInterface stickyService;
    private Object lock = new Object();

    SingleInvokationProxy(String serviceType) {
        super(serviceType);
    }

    private Object invoke0(Object proxy, Method m, Object[] args) throws Throwable {
        Throwable exception;
        do {
            exception = null;
            ServiceInterface service = null;
            service = this.getStickyFlag() && this.stickyService != null ? this.stickyService : this.getNextInstance();
            try {
                int i = 0;
                while (i <= this.getRetryLimit()) {
                    try {
                        try {
                            Object result = m.invoke((Object)service, args);
                            this.stickyService = service;
                            return result;
                        }
                        catch (InvocationTargetException err) {
                            throw err.getTargetException();
                        }
                    }
                    catch (MarshalException e) {
                        if (e.getCause() instanceof NotSerializableException) {
                            throw e;
                        }
                        exception = e;
                    }
                    catch (RemoteException e) {
                        exception = e;
                        if (!(e instanceof ConnectException || e instanceof ConnectIOException || e instanceof UnmarshalException)) {
                            this.logException(e);
                            break;
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++i;
                }
                this.markInstanceAsBad(service);
            }
            catch (ServiceNotInitializedException e) {
                exception = e;
            }
            catch (ServiceException e) {
                exception = e;
                this.markInstanceAsBad(service);
            }
            this.logException(exception);
        } while (!this.getStickyFlag() || this.stickyService == null);
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (this.stickyService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.stickyService == null) {
                    return this.invoke0(proxy, m, args);
                }
            }
        }
        return this.invoke0(proxy, m, args);
    }
}

