/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.dqp.internal.transaction.TransactionProvider;
import com.metamatrix.dqp.internal.transaction.TransactionServerImpl;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.transaction.TransactionServer;
import com.metamatrix.dqp.transaction.XAServer;
import com.metamatrix.platform.vm.controller.VMController;
import com.metamatrix.xa.arjuna.ArjunaTransactionProvider;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;

public class PlatformTransactionService
implements TransactionService {
    private TransactionServerImpl arjunaTs = new TransactionServerImpl();
    private TransactionServer ts;
    static /* synthetic */ Class class$com$metamatrix$dqp$transaction$TransactionServer;
    static /* synthetic */ Class class$com$metamatrix$dqp$transaction$XAServer;

    public void initialize(Properties props) throws ApplicationInitializationException {
        try {
            Host host;
            try {
                host = CurrentConfiguration.getHost();
            }
            catch (ConfigurationException e) {
                throw new ApplicationInitializationException((CoreException)((Object)e));
            }
            catch (UnknownHostException e) {
                throw new ApplicationInitializationException((Throwable)e);
            }
            Properties env = null;
            try {
                env = CurrentConfiguration.getResourceProperties((String)"XATransactionManager");
            }
            catch (ConfigurationException e) {
                throw new ApplicationInitializationException((CoreException)((Object)e));
            }
            String hostLogDir = host.getLogDirectory();
            String txnLogDir = env.getProperty("metamatrix.xatxnmgr.log_base_dir", "txnlog");
            String logDir = FileUtils.buildDirectoryPath((String[])new String[]{hostLogDir, txnLogDir});
            props.putAll((Map<?, ?>)env);
            props.setProperty("metamatrix.xatxnmgr.log_base_dir", logDir);
            props.setProperty("metamatrix.xatxnmgr.hostname", host.getFullName());
            props.setProperty("metamatrix.xatxnmgr.vmname", VMController.getVMName());
            props.setProperty("metamatrix.xatxnmgr.txnstore_dir", host.getDataDirectory());
            this.arjunaTs.init(props, (TransactionProvider)new ArjunaTransactionProvider());
            Class[] interfaces = new Class[]{class$com$metamatrix$dqp$transaction$TransactionServer == null ? (class$com$metamatrix$dqp$transaction$TransactionServer = PlatformTransactionService.class$("com.metamatrix.dqp.transaction.TransactionServer")) : class$com$metamatrix$dqp$transaction$TransactionServer, class$com$metamatrix$dqp$transaction$XAServer == null ? (class$com$metamatrix$dqp$transaction$XAServer = PlatformTransactionService.class$("com.metamatrix.dqp.transaction.XAServer")) : class$com$metamatrix$dqp$transaction$XAServer};
            this.ts = (TransactionServer)LogManager.createLoggingProxy((String)"XA_TXN", (Object)this.arjunaTs, (Class[])interfaces, (int)5);
        }
        catch (XATransactionException err) {
            throw new ApplicationInitializationException((CoreException)((Object)err));
        }
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bind() throws ApplicationLifecycleException {
    }

    public void unbind() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
        try {
            this.arjunaTs.shutdown(true);
        }
        catch (XATransactionException err) {
            throw new ApplicationLifecycleException((CoreException)((Object)err));
        }
    }

    public TransactionServer getTransactionServer() {
        return this.ts;
    }

    public XAServer getXAServer() {
        return (XAServer)this.ts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

