/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.CommandPlanner;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.proc.AssignmentInstruction;
import com.metamatrix.query.processor.proc.BreakInstruction;
import com.metamatrix.query.processor.proc.ContinueInstruction;
import com.metamatrix.query.processor.proc.ErrorInstruction;
import com.metamatrix.query.processor.proc.ExecDynamicSqlInstruction;
import com.metamatrix.query.processor.proc.ExecSqlInstruction;
import com.metamatrix.query.processor.proc.IfInstruction;
import com.metamatrix.query.processor.proc.LoopInstruction;
import com.metamatrix.query.processor.proc.ProcedureEnvironment;
import com.metamatrix.query.processor.proc.ProcedurePlan;
import com.metamatrix.query.processor.proc.WhileInstruction;
import com.metamatrix.query.processor.program.Program;
import com.metamatrix.query.processor.program.ProgramInstruction;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.ProcedureContainer;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProcedurePlanner
implements CommandPlanner {
    public void generateCanonical(CommandTreeNode rootNode, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
    }

    public ProcessorPlan optimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Command procCommand = node.getCommand();
        List childNodes = node.getChildren();
        ChildIndexHolder childIndex = new ChildIndexHolder();
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n####################################################");
            analysisRecord.println("PROCEDURE COMMAND: " + node.getCommand());
        }
        if (!(procCommand instanceof CreateUpdateProcedureCommand)) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("ProcedurePlanner.wrong_type", procCommand.getType()));
        }
        Block block = ((CreateUpdateProcedureCommand)procCommand).getBlock();
        Program programBlock = this.planBlock((CreateUpdateProcedureCommand)procCommand, block, metadata, childNodes, debug, childIndex, idGenerator, capFinder);
        if (debug) {
            analysisRecord.println("\n####################################################");
        }
        ProcedureEnvironment env = new ProcedureEnvironment();
        env.getProgramStack().push(programBlock);
        ProcedurePlan plan = new ProcedurePlan(env);
        ProcedureContainer container = (ProcedureContainer)((CreateUpdateProcedureCommand)procCommand).getUserCommand();
        if (container != null) {
            Map params = container.getProcedureParameters();
            plan.setParams(params);
            plan.setMetadata(metadata);
        }
        env.initialize((ProcessorPlan)plan);
        env.setUpdateProcedure(((CreateUpdateProcedureCommand)procCommand).isUpdateProcedure());
        env.setOutputElements(((CreateUpdateProcedureCommand)procCommand).getProjectedSymbols());
        if (debug) {
            analysisRecord.println("####################################################");
            analysisRecord.println("PROCEDURE PLAN :" + (Object)((Object)plan));
            analysisRecord.println("####################################################");
        }
        return plan;
    }

    private Program planBlock(CreateUpdateProcedureCommand parentProcCommand, Block block, QueryMetadataInterface metadata, List childNodes, boolean debug, ChildIndexHolder childIndex, IDGenerator idGenerator, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Iterator stmtIter = block.getStatements().iterator();
        Program programBlock = new Program();
        while (stmtIter.hasNext()) {
            Statement statement = (Statement)stmtIter.next();
            Object instruction = null;
            try {
                instruction = this.planStatement(parentProcCommand, statement, metadata, childNodes, debug, childIndex, idGenerator, capFinder);
            }
            catch (QueryResolverException err) {
                throw new QueryPlannerException((Throwable)err, err.getMessage());
            }
            if (instruction instanceof ProgramInstruction) {
                programBlock.addInstruction((ProgramInstruction)instruction);
                continue;
            }
            ProgramInstruction[] insts = (ProgramInstruction[])instruction;
            for (int i = 0; i < insts.length; ++i) {
                programBlock.addInstruction(insts[i]);
            }
        }
        return programBlock;
    }

    private Object planStatement(CreateUpdateProcedureCommand parentProcCommand, Statement statement, QueryMetadataInterface metadata, List childNodes, boolean debug, ChildIndexHolder childIndex, IDGenerator idGenerator, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException, QueryResolverException {
        int stmtType = statement.getType();
        Object instruction = null;
        switch (stmtType) {
            case 3: 
            case 4: 
            case 5: {
                ErrorInstruction assignInstr = null;
                if (stmtType == 4) {
                    assignInstr = new ErrorInstruction();
                } else if (stmtType == 5 || stmtType == 3) {
                    assignInstr = new AssignmentInstruction();
                }
                instruction = assignInstr;
                AssignmentStatement assignStmt = (AssignmentStatement)statement;
                assignInstr.setVariable(assignStmt.getVariable());
                ProcessorPlan assignPlan = null;
                if (assignStmt.hasCommand()) {
                    List references = ReferenceCollectorVisitor.getReferences((LanguageObject)assignStmt.getCommand());
                    assignPlan = ((CommandTreeNode)childNodes.get(childIndex.getChildIndex())).getProcessorPlan();
                    childIndex.incrementChildIndex();
                    assignInstr.setProcessPlan(assignPlan);
                    assignInstr.setReferences((Collection)references);
                } else if (assignStmt.hasExpression()) {
                    Expression asigExpr = assignStmt.getExpression();
                    assignInstr.setExpression(asigExpr);
                    List references = ReferenceCollectorVisitor.getReferences((LanguageObject)asigExpr);
                    assignInstr.setReferences((Collection)references);
                }
                if (!debug) break;
                System.out.println("\t" + instruction.toString() + "\n" + statement);
                if (assignPlan == null) break;
                System.out.println("\t\tASSIGNMENT COMMAND PROCESS PLAN:\n " + assignPlan);
                break;
            }
            case 2: {
                Into into;
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command command = cmdStmt.getCommand();
                GroupSymbol intoGroup = null;
                if (command instanceof Query && (into = ((Query)command).getInto()) != null) {
                    intoGroup = into.getGroup();
                }
                List references = ReferenceCollectorVisitor.getReferences((LanguageObject)command);
                ProcessorPlan commandPlan = ((CommandTreeNode)childNodes.get(childIndex.getChildIndex())).getProcessorPlan();
                childIndex.incrementChildIndex();
                instruction = command.getType() == 10 ? new ExecDynamicSqlInstruction(parentProcCommand, (DynamicCommand)command, references, metadata, idGenerator, capFinder) : new ExecSqlInstruction(commandPlan, references, intoGroup);
                if (!debug) break;
                System.out.println("\tCOMMAND STATEMENT:\n " + statement);
                System.out.println("\t\tSTATEMENT COMMAND PROCESS PLAN:\n " + commandPlan);
                break;
            }
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Program ifProgram = this.planBlock(parentProcCommand, ifStmt.getIfBlock(), metadata, childNodes, debug, childIndex, idGenerator, capFinder);
                Program elseProgram = null;
                if (ifStmt.hasElseBlock()) {
                    elseProgram = this.planBlock(parentProcCommand, ifStmt.getElseBlock(), metadata, childNodes, debug, childIndex, idGenerator, capFinder);
                }
                instruction = new IfInstruction(ifStmt.getCondition(), ifProgram, elseProgram);
                if (!debug) break;
                System.out.println("\tIF STATEMENT:\n" + statement);
                break;
            }
            case 9: {
                if (debug) {
                    System.out.println("\tBREAK STATEMENT:\n" + statement);
                }
                instruction = new BreakInstruction();
                break;
            }
            case 8: {
                if (debug) {
                    System.out.println("\tCONTINUE STATEMENT:\n" + statement);
                }
                instruction = new ContinueInstruction();
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                if (debug) {
                    System.out.println("\tLOOP STATEMENT:\n" + statement);
                }
                String rsName = loopStmt.getCursorName();
                ProcessorPlan commandPlan = ((CommandTreeNode)childNodes.get(childIndex.getChildIndex())).getProcessorPlan();
                childIndex.incrementChildIndex();
                Command command = loopStmt.getCommand();
                List references = ReferenceCollectorVisitor.getReferences((LanguageObject)command);
                Program loopProgram = this.planBlock(parentProcCommand, loopStmt.getBlock(), metadata, childNodes, debug, childIndex, idGenerator, capFinder);
                instruction = new LoopInstruction(loopProgram, rsName, commandPlan, (Collection)references);
                break;
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Program whileProgram = this.planBlock(parentProcCommand, whileStmt.getBlock(), metadata, childNodes, debug, childIndex, idGenerator, capFinder);
                if (debug) {
                    System.out.println("\tWHILE STATEMENT:\n" + statement);
                }
                instruction = new WhileInstruction(whileProgram, whileStmt.getCondition());
                break;
            }
            default: {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("ProcedurePlanner.bad_stmt", stmtType));
            }
        }
        return instruction;
    }

    static class ChildIndexHolder {
        private int childIndex;

        ChildIndexHolder() {
        }

        int getChildIndex() {
            return this.childIndex;
        }

        void incrementChildIndex() {
            ++this.childIndex;
        }
    }
}

