/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connector;

import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.util.ConfigurationImportExportUtility;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.xml.XmlUtil;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.connector.ImportWizardConfirmationPanel;
import com.metamatrix.console.ui.views.connector.ImportWizardConnectorIDPanel;
import com.metamatrix.console.ui.views.connector.ImportWizardControllerInterface;
import com.metamatrix.console.ui.views.connector.ImportWizardDuplicatesPanel;
import com.metamatrix.console.ui.views.connector.ImportWizardFileSelectorPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JDialog;

public class ImportWizardController
extends WizardInterfaceImpl
implements ImportWizardControllerInterface {
    public static final int CALLED_FOR_CONNECTOR_TYPE = 1;
    public static final int CALLED_FOR_CONNECTOR_BINDING = 2;
    protected static final int FILE_SELECTOR_PAGE_NUM = 0;
    protected static final int CONNECTOR_ID_PAGE_NUM = 1;
    protected static final int DUPLICATE_PAGE_NUM = 2;
    protected static final int CONFIRMATION_PAGE_NUM = 3;
    protected ImportWizardConnectorIDPanel itemIDPanel;
    protected ImportWizardFileSelectorPanel fileSelectorPanel;
    protected ImportWizardConfirmationPanel confirmPanel;
    protected ImportWizardDuplicatesPanel duplicatesPanel;
    protected JDialog dialog;
    protected int currentPage = -1;
    private ButtonWidget nextButton;
    private ButtonWidget cancelButton;
    private ButtonWidget finishButton;
    private TreeMap connectorTypesToImport;
    private ConfigurationImportExportUtility cieuImportUtil;
    protected DirectoryEntry directoryEntry = null;
    protected boolean bFinishPressed = false;
    private ConfigurationAdminAPI api;
    protected ConfigurationManager manager;
    protected ConnectorManager connectorManager;
    private ConnectionInfo conn;
    protected String dialogTitle;
    private ExtensionModule[] extModulesToImport;

    public ImportWizardController(ConnectionInfo conn) {
        this.conn = conn;
        this.api = ModelManager.getConfigurationAPI((ConnectionInfo)conn);
        this.manager = ModelManager.getConfigurationManager((ConnectionInfo)conn);
        this.connectorManager = ModelManager.getConnectorManager((ConnectionInfo)conn);
    }

    public boolean runWizard() {
        this.loadWizard();
        this.dialog = new JDialog((Frame)ConsoleMainFrame.getInstance(), this.dialogTitle);
        this.dialog.setModal(true);
        this.cancelButton = this.getCancelButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImportWizardController.this.cancelPressed();
            }
        });
        this.nextButton = this.getNextButton();
        this.finishButton = this.getFinishButton();
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImportWizardController.this.finishPressed();
            }
        });
        this.dialog.getContentPane().add((Component)((Object)this));
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                ImportWizardController.this.cancelPressed();
            }
        });
        this.dialog.pack();
        ImportWizardController.setLocationOn(this.dialog);
        this.dialog.show();
        return this.bFinishPressed;
    }

    protected void loadWizard() {
        this.fileSelectorPanel = new ImportWizardFileSelectorPanel((ImportWizardControllerInterface)this, (WizardInterface)this, 1);
        this.addPage((Component)this.fileSelectorPanel);
        this.itemIDPanel = new ImportWizardConnectorIDPanel((WizardInterface)this, 1);
        this.addPage((Component)this.itemIDPanel);
        this.duplicatesPanel = new ImportWizardDuplicatesPanel(this, (WizardInterface)this);
        this.addPage((Component)((Object)this.duplicatesPanel));
        this.confirmPanel = new ImportWizardConfirmationPanel(this, (WizardInterface)this, 1);
        this.addPage((Component)this.confirmPanel);
        this.dialogTitle = "Import Connector Type Wizard";
        this.currentPage = 0;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    private void cancelPressed() {
        this.dialog.dispose();
    }

    public void importFileSelected() {
        this.nextButton.setEnabled(true);
    }

    protected void finishPressed() {
        this.bFinishPressed = true;
        if (this.saveNewItemToServer() && this.connectorTypesToImport != null && !this.connectorTypesToImport.isEmpty()) {
            Iterator i = this.connectorTypesToImport.keySet().iterator();
            while (i.hasNext()) {
                this.connectorManager.reportConnectorDetails((ComponentType)this.connectorTypesToImport.get(i.next()));
            }
        }
        this.dialog.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNextPage() {
        int numPagesForward = 0;
        try {
            StaticUtilities.startWait((Component)this.getDialog().getContentPane());
            numPagesForward = this.goingToNextPage();
        }
        catch (Exception e) {
            String msgText = "Failed testing new connector name for uniqueness";
            ExceptionUtility.showMessage((String)msgText, (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)this.getDialog().getContentPane());
        }
        for (int i = 0; i < numPagesForward; ++i) {
            super.showNextPage();
        }
    }

    public void showPreviousPage() {
        int numPagesBackward = this.goingToPreviousPage();
        for (int i = 0; i < numPagesBackward; ++i) {
            super.showPreviousPage();
        }
    }

    public int goingToNextPage() throws Exception {
        int numPagesForward = 0;
        switch (this.currentPage) {
            case 0: {
                this.directoryEntry = this.fileSelectorPanel.getSelection();
                if (this.isImportingCDK()) {
                    this.loadCDK(this.directoryEntry);
                } else {
                    this.loadCAF(this.directoryEntry);
                }
                this.itemIDPanel.setExtensionModules(this.extModulesToImport);
                this.itemIDPanel.setConnectorTypes(this.directoryEntry, (Map)this.connectorTypesToImport);
                numPagesForward = 1;
                break;
            }
            case 1: {
                this.connectorTypesToImport = this.itemIDPanel.getConnectorTypes();
                ServerAdmin admin = this.conn.getServerAdmin();
                String[] duplicateConnectorTypes = this.checkForExistingConnectorTypes(admin, this.connectorTypesToImport);
                String[] duplicateExtensionModules = this.checkForExistingExtensionModules(admin, this.extModulesToImport);
                String errorWhy = this.checkVDBAssosiations(admin, duplicateConnectorTypes);
                admin.close();
                this.duplicatesPanel.setDuplicateConnectorTypes(duplicateConnectorTypes);
                this.duplicatesPanel.setDuplicateExtensionModules(duplicateExtensionModules);
                this.duplicatesPanel.setErrorText(errorWhy);
                this.duplicatesPanel.setStepNumber(3);
                numPagesForward = 1;
                break;
            }
            case 2: {
                this.confirmPanel.setConnectorTypes(this.connectorTypesToImport);
                this.confirmPanel.setExtensionModules(this.extModulesToImport);
                this.confirmPanel.setStepNumber(4);
                numPagesForward = 1;
                break;
            }
        }
        this.currentPage += numPagesForward;
        return numPagesForward;
    }

    private String checkVDBAssosiations(ServerAdmin admin, String[] duplicateConnectorTypes) throws Exception {
        if (duplicateConnectorTypes != null && duplicateConnectorTypes.length > 0) {
            StringBuffer text = new StringBuffer();
            Collection bindings = admin.getConnectorBindings("*");
            Iterator bindingsIter = bindings.iterator();
            while (bindingsIter.hasNext()) {
                ConnectorBinding binding = (ConnectorBinding)bindingsIter.next();
                for (int i = 0; i < duplicateConnectorTypes.length; ++i) {
                    if (!duplicateConnectorTypes[i].equalsIgnoreCase(binding.getConnectorTypeName())) continue;
                    text.append("\n{");
                    text.append(duplicateConnectorTypes[i]);
                    text.append("} in use by : ");
                    text.append(binding.getIdentifier());
                    text.append("\n");
                }
            }
            return text.toString();
        }
        return null;
    }

    public int goingToPreviousPage() {
        int numPagesBackward = 1;
        this.currentPage -= numPagesBackward;
        return numPagesBackward;
    }

    protected ConfigurationImportExportUtility getImportExportUtility() {
        if (this.cieuImportUtil == null) {
            try {
                this.cieuImportUtil = new XMLConfigurationImportExportUtility();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage((String)"Failed to get import utility", (Throwable)e);
            }
        }
        return this.cieuImportUtil;
    }

    public static String stripFileExtensionFromName(String sName) {
        String period = ".";
        int iMarkerPos = sName.indexOf(period);
        if (iMarkerPos > -1) {
            return sName.substring(0, iMarkerPos);
        }
        return sName;
    }

    protected ConfigurationObjectEditor getNewItemEditor() throws MetaMatrixRuntimeException {
        try {
            return this.api.createEditor();
        }
        catch (Exception e) {
            String msg = "Import Error: Failed to create editor";
            ExceptionUtility.showMessage((String)msg, (Throwable)e);
            throw new MetaMatrixRuntimeException(msg);
        }
    }

    private void loadCDK(DirectoryEntry deFile) {
        try {
            ConfigurationObjectEditor editor = this.getNewItemEditor();
            Collection cTypes = this.getImportExportUtility().importComponentTypes(deFile.getInputStream(), editor);
            editor.getDestination().popActions();
            this.extModulesToImport = null;
            this.connectorTypesToImport = new TreeMap(new HashMap(cTypes.size()));
            Iterator it = cTypes.iterator();
            while (it.hasNext()) {
                ConnectorBindingType t = (ConnectorBindingType)it.next();
                this.connectorTypesToImport.put(t.getFullName(), t);
            }
        }
        catch (IOException ioe) {
            String msg = "Failed while importing a connector type(s)";
            String comment = "Error importing connector type(s), verify the file is a valid CDK or CAF file.";
            ExceptionUtility.showMessage((String)msg, (String)comment, (Throwable)ioe);
        }
        catch (InvalidConfigurationElementException ice) {
            String msg = "Failed while importing a connector type(s)";
            String comment = "Error importing connector type(s), verify the file is a valid CDK or CAF file.";
            ExceptionUtility.showMessage((String)msg, (String)comment, (Throwable)ice);
        }
        catch (Exception e) {
            String msg = "Failed while importing a connector type.";
            ExceptionUtility.showMessage((String)msg, (String)e.getMessage(), (Throwable)e);
        }
    }

    private void loadCAF(DirectoryEntry deFile) {
        try {
            ConfigurationObjectEditor editor = this.getNewItemEditor();
            ConnectorArchive newArchive = this.getImportExportUtility().importConnectorArchive(deFile.getInputStream(), editor);
            editor.getDestination().popActions();
            this.extModulesToImport = this.getAllExtensionModules(newArchive);
            this.connectorTypesToImport = new TreeMap();
            ConnectorBindingType[] types = newArchive.getConnectorTypes();
            for (int i = 0; i < types.length; ++i) {
                ConnectorBindingType type = types[i];
                this.connectorTypesToImport.put(type.getFullName(), type);
            }
        }
        catch (IOException ioe) {
            String msg = "Failed while importing a connector type(s)";
            String comment = "Error importing connector type(s), verify the file is a valid CDK or CAF file.";
            ExceptionUtility.showMessage((String)msg, (String)comment, (Throwable)ioe);
        }
        catch (InvalidConfigurationElementException ice) {
            String msg = "Failed while importing a connector type(s)";
            String comment = "Error importing connector type(s), verify the file is a valid CDK or CAF file.";
            ExceptionUtility.showMessage((String)msg, (String)comment, (Throwable)ice);
        }
        catch (Exception e) {
            String msg = "Failed while importing a connector type.";
            ExceptionUtility.showMessage((String)msg, (String)e.getMessage(), (Throwable)e);
        }
    }

    private ExtensionModule[] getAllExtensionModules(ConnectorArchive archive) {
        HashSet<ExtensionModule> set = new HashSet<ExtensionModule>();
        ConnectorBindingType[] types = archive.getConnectorTypes();
        for (int i = 0; i < types.length; ++i) {
            ExtensionModule[] modules = archive.getExtensionModules(types[i]);
            for (int m = 0; m < modules.length; ++m) {
                set.add(modules[m]);
            }
        }
        return set.toArray(new ExtensionModule[set.size()]);
    }

    private String[] checkForExistingExtensionModules(ServerAdmin admin, ExtensionModule[] modules) throws Exception {
        if (modules != null && modules.length > 0) {
            ArrayList<String> duplicateModuleNames = new ArrayList<String>();
            for (int i = 0; i < modules.length; ++i) {
                ExtensionModule module = modules[i];
                Collection results = admin.getExtensionModules(module.getFullName());
                if (results.isEmpty()) continue;
                duplicateModuleNames.add(module.getFullName());
            }
            return duplicateModuleNames.toArray(new String[duplicateModuleNames.size()]);
        }
        return null;
    }

    private String[] checkForExistingConnectorTypes(ServerAdmin admin, Map connectorTypesMap) throws Exception {
        if (connectorTypesMap != null && !connectorTypesMap.isEmpty()) {
            ArrayList<String> duplicateConnectorTypes = new ArrayList<String>();
            Iterator i = connectorTypesMap.keySet().iterator();
            while (i.hasNext()) {
                String typename = (String)i.next();
                Collection results = admin.getConnectorTypes(typename);
                if (results == null || results.isEmpty()) continue;
                duplicateConnectorTypes.add(typename);
            }
            return duplicateConnectorTypes.toArray(new String[duplicateConnectorTypes.size()]);
        }
        return null;
    }

    protected boolean saveNewItemToServer() {
        try {
            this.addConnectorTypes();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Failed attempting to save connector types.", (Throwable)e);
            return false;
        }
        boolean overwriteExtJars = this.duplicatesPanel.isOverwriteExtJarsPressed();
        try {
            this.addExtensionModules(overwriteExtJars);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Failed attempting to save extension modules.", (Throwable)e);
            return false;
        }
        this.manager.refresh();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectorTypes() throws Exception {
        if (this.connectorTypesToImport != null) {
            ServerAdmin admin = this.conn.getServerAdmin();
            try {
                Iterator i = this.connectorTypesToImport.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    ConnectorBindingType type = (ConnectorBindingType)this.connectorTypesToImport.get(name);
                    Collection types = admin.getConnectorTypes(name);
                    if (types != null && !types.isEmpty()) {
                        admin.deleteConnectorType(name);
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                    this.getImportExportUtility().exportConnector((OutputStream)bos, (ComponentType)type, this.getExportProperties());
                    char[] contents = new String(bos.toByteArray()).toCharArray();
                    admin.addConnectorType(name, contents);
                }
            }
            finally {
                admin.close();
            }
        }
    }

    private Properties getExportProperties() throws Exception {
        String userName = UserCapabilities.getLoggedInUser((ConnectionInfo)this.conn).getName();
        String version = StaticProperties.getVersions() + ":" + StaticProperties.getBuild();
        Properties props = new Properties();
        props.put("ApplicationCreatedBy", DeployPkgUtils.getString((String)"dmp.console.name"));
        props.put("ApplicationVersion", version);
        props.put("UserCreatedBy", userName);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionModules(boolean overwriteDuplicateExtJars) throws Exception {
        if (this.extModulesToImport != null) {
            List duplicateExtensionJars = this.duplicatesPanel.getDuplicateExtensionModules();
            ServerAdmin admin = this.conn.getServerAdmin();
            try {
                for (int i = 0; i < this.extModulesToImport.length; ++i) {
                    ExtensionModule module = this.extModulesToImport[i];
                    String moduleName = module.getFullName();
                    if (duplicateExtensionJars.contains(moduleName)) {
                        if (!overwriteDuplicateExtJars) continue;
                        admin.deleteExtensionModule(moduleName);
                        admin.addExtensionModule(module.getModuleType(), moduleName, module.getFileContents(), module.getDescription());
                        continue;
                    }
                    admin.deleteExtensionModule(moduleName);
                    admin.addExtensionModule(module.getModuleType(), moduleName, module.getFileContents(), module.getDescription());
                }
            }
            finally {
                admin.close();
            }
        }
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame((Dimension)comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isImportingCDK() {
        InputStream is = null;
        try {
            is = this.directoryEntry.getInputStream();
            String contents = ObjectConverterUtil.convertToString((InputStream)is);
            boolean bl = XmlUtil.containsValidCharacters((String)contents) == null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    TreeMap getLoadedTypes() {
        return this.connectorTypesToImport;
    }
}

