/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.xa.arjuna;

import com.arjuna.ats.arjuna.common.Configuration;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.MMXid;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.internal.transaction.TransactionProvider;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.xa.arjuna.XAConnectorRecovery;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.resource.spi.XATerminator;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class ArjunaTransactionProvider
implements TransactionProvider {
    private static final String NO = "NO";
    private XATerminatorImple terminator = new XATerminatorImple();
    private RecoveryManager recoveryManager;
    static /* synthetic */ Class class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionSynchronizationRegistryImple;
    static /* synthetic */ Class class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionManagerImple;
    static /* synthetic */ Class class$com$arjuna$ats$internal$jta$transaction$arjunacore$UserTransactionImple;

    public void init(Properties props) throws XATransactionException {
        String vmName = props.getProperty("metamatrix.xatxnmgr.vmname");
        String txnMgrUniqueName = "txnmgr_" + props.getProperty("metamatrix.xatxnmgr.hostname", "").replace('.', '_') + "_" + vmName;
        String baseDir = props.getProperty("metamatrix.xatxnmgr.txnstore_dir", TransactionService.DEFAULT_TXN_STORE_DIR);
        Configuration.setObjectStoreRoot((String)(baseDir + File.separator + "MetaMatrixTxnStore" + File.separator + txnMgrUniqueName));
        this.configureLogging(txnMgrUniqueName, props);
        arjPropertyManager.propertyManager.setProperty("com.arjuna.ats.arjuna.xa.nodeIdentifier", txnMgrUniqueName);
        arjPropertyManager.propertyManager.setProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerPort", props.getProperty("metamatrix.xatxnmgr.txnstatus_port", "0"));
        jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTSRImplementation", (class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionSynchronizationRegistryImple == null ? (class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionSynchronizationRegistryImple = ArjunaTransactionProvider.class$("com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple")) : class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionSynchronizationRegistryImple).getName());
        jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.supportSubtransactions", NO);
        jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTMImplementation", (class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionManagerImple == null ? (class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionManagerImple = ArjunaTransactionProvider.class$("com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple")) : class$com$arjuna$ats$internal$jta$transaction$arjunacore$TransactionManagerImple).getName());
        jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaUTImplementation", (class$com$arjuna$ats$internal$jta$transaction$arjunacore$UserTransactionImple == null ? (class$com$arjuna$ats$internal$jta$transaction$arjunacore$UserTransactionImple = ArjunaTransactionProvider.class$("com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple")) : class$com$arjuna$ats$internal$jta$transaction$arjunacore$UserTransactionImple).getName());
        jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.xaRecoveryNode", "*");
        jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.recovery.XAResourceRecoveryMM", "com.metamatrix.xa.arjuna.XAConnectorRecovery");
        int timeout = Integer.parseInt(props.getProperty("metamatrix.xatxnmgr.max_timeout", "120"));
        TxControl.setDefaultTimeout((int)timeout);
        boolean startRecovery = Boolean.valueOf(props.getProperty("metamatrix.xatxnmgr.enable_recovery", "true"));
        if (startRecovery) {
            RecoveryManager.delayRecoveryManagerThread();
            this.recoveryManager = RecoveryManager.manager();
            this.recoveryManager.startRecoveryManagerThread();
        }
    }

    private void configureLogging(String uniqueName, Properties props) throws XATransactionException {
        MMLogAppender appender = null;
        if (Boolean.valueOf(props.getProperty("metamatrix.xatxnmgr.separate_log", "false")).booleanValue()) {
            RollingFileAppender fileAppender;
            try {
                String baseDir = props.getProperty("metamatrix.xatxnmgr.log_base_dir");
                File directory = new File(baseDir);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                String filename = baseDir + "/" + uniqueName + ".log";
                fileAppender = new RollingFileAppender((Layout)new PatternLayout("%d [%t] %-5p %c - %m%n"), filename, true);
                fileAppender.setMaxFileSize(props.getProperty("metamatrix.xatxnmgr.max_log_filesize_in_mb", "10") + "MB");
                fileAppender.setMaxBackupIndex(Integer.parseInt(props.getProperty("metamatrix.xatxnmgr.max_rolled_log_files", "10")));
            }
            catch (IOException e) {
                throw new XATransactionException(e);
            }
            appender = fileAppender;
        } else {
            appender = new MMLogAppender();
        }
        appender.setThreshold((Priority)Level.DEBUG);
        Logger root = Logger.getLogger((String)"com.arjuna");
        root.addAppender((Appender)appender);
    }

    public XATerminator getXATerminator() {
        return this.terminator;
    }

    public TransactionManager getTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    public Transaction importTransaction(MMXid xid, int timeout) throws XAException {
        TransactionImple arjunaTx = TxImporter.importTransaction((Xid)xid, (int)timeout);
        LogManager.logDetail((String)"XA_TXN", (String)("Imported transaction:\nMM Xid: " + xid + "\nArjuna transaction ID: " + arjunaTx.get_uid().stringForm()));
        return arjunaTx;
    }

    public TransactionID getTransactionID(Transaction tx) {
        com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple arjunaTx = (com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple)tx;
        return new TransactionID(arjunaTx.get_uid().stringForm());
    }

    public void shutdown() {
        if (this.recoveryManager != null) {
            this.recoveryManager.stop();
        }
    }

    public void registerRecoverySource(String name, XAConnector connector) {
        XAConnectorRecovery.addConnector((String)name, (XAConnector)connector);
    }

    public void removeRecoverySource(String name) {
        XAConnectorRecovery.removeConnector((String)name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MMLogAppender
    extends AppenderSkeleton {
        MMLogAppender() {
        }

        protected void append(LoggingEvent event) {
            int level = 2;
            switch (event.getLevel().toInt()) {
                case 10000: {
                    level = 5;
                    break;
                }
                case 20000: {
                    level = 4;
                    break;
                }
                case 30000: {
                    level = 3;
                    break;
                }
                case 40000: {
                    level = 2;
                    break;
                }
                case 50000: {
                    level = 1;
                }
            }
            if (event.getThrowableInformation() != null) {
                LogManager.log((int)level, (String)"XA_TXN", (Throwable)event.getThrowableInformation().getThrowable(), (String)event.getRenderedMessage());
            } else {
                LogManager.log((int)level, (String)"XA_TXN", (String)event.getRenderedMessage());
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

