/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry.event;

import com.metamatrix.platform.vm.controller.VMControllerID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;

public class RegistryEvent
extends EventObject {
    private int eventType;
    private transient Object eventObj;
    private VMControllerID id;
    private byte[] rawEventObj;
    public static final int REGISTRY_ALIVE_EVENT = 0;
    public static final int REGISTRY_STATE_EVENT = 1;
    public static final int REGISTRY_SERVICE_FAILED_EVENT = 2;
    public static final int REGISTRY_VMCONTROLLER_REMOVED_EVENT = 3;

    public RegistryEvent(Object source, int eventType, VMControllerID id) {
        super(source);
        this.eventType = eventType;
        this.id = id;
    }

    public RegistryEvent(Object source, int eventType, VMControllerID id, Object eventObj) {
        this(source, eventType, id);
        this.eventObj = eventObj;
        if (this.eventObj != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(this.eventObj);
                this.rawEventObj = os.toByteArray();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }

    public int getEventType() {
        return this.eventType;
    }

    public Object getEventObject() {
        if (this.eventObj == null && this.rawEventObj != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(this.rawEventObj);
                ObjectInputStream oin = new ObjectInputStream(is);
                this.eventObj = oin.readObject();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
        return this.eventObj;
    }

    public VMControllerID getID() {
        return this.id;
    }
}

