/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function.aggregate;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.function.aggregate.AggregateFunction;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Sum
implements AggregateFunction {
    protected static final int LONG = 0;
    protected static final int DOUBLE = 1;
    protected static final int BIG_INTEGER = 2;
    protected static final int BIG_DECIMAL = 3;
    protected int accumulatorType = 0;
    private Object sum = null;

    protected int getAccumulatorType() {
        return this.accumulatorType;
    }

    public void initialize(Class dataType) {
        this.accumulatorType = dataType.equals(DataTypeManager.DefaultDataClasses.INTEGER) || dataType.equals(DataTypeManager.DefaultDataClasses.LONG) || dataType.equals(DataTypeManager.DefaultDataClasses.BYTE) || dataType.equals(DataTypeManager.DefaultDataClasses.SHORT) ? 0 : (dataType.equals(DataTypeManager.DefaultDataClasses.FLOAT) || dataType.equals(DataTypeManager.DefaultDataClasses.DOUBLE) ? 1 : (dataType.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER) ? 2 : 3));
    }

    public void reset() {
        this.sum = null;
    }

    public void addInput(Object input) throws FunctionExecutionException, ExpressionEvaluationException, MetaMatrixComponentException {
        if (this.sum == null) {
            switch (this.accumulatorType) {
                case 0: {
                    this.sum = new Long(0L);
                    break;
                }
                case 1: {
                    this.sum = new Double(0.0);
                    break;
                }
                case 2: {
                    this.sum = new BigInteger(String.valueOf(0));
                    break;
                }
                case 3: {
                    this.sum = new BigDecimal(String.valueOf(0));
                }
            }
        }
        switch (this.accumulatorType) {
            case 0: {
                this.sum = new Long((Long)this.sum + ((Number)input).longValue());
                break;
            }
            case 1: {
                this.sum = new Double((Double)this.sum + ((Number)input).doubleValue());
                break;
            }
            case 2: {
                this.sum = ((BigInteger)this.sum).add((BigInteger)input);
                break;
            }
            case 3: {
                if (input instanceof BigInteger) {
                    BigInteger bigIntegerInput = (BigInteger)input;
                    this.sum = ((BigDecimal)this.sum).add(new BigDecimal(bigIntegerInput));
                    break;
                }
                this.sum = ((BigDecimal)this.sum).add((BigDecimal)input);
            }
        }
    }

    public Object getResult() throws FunctionExecutionException, ExpressionEvaluationException, MetaMatrixComponentException {
        return this.sum;
    }
}

