/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.rewriter;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.api.exception.query.InvalidFunctionException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.function.FunctionMethods;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.rewriter.VariableSubstitutionVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CommandContainer;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.ProcedureContainer;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.PostOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.CorrelatedVariableSubstitutionVisitor;
import com.metamatrix.query.sql.visitor.CriteriaTranslatorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class QueryRewriter {
    public static final CompareCriteria TRUE_CRITERIA = new CompareCriteria((Expression)new Constant((Object)new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER), 1, (Expression)new Constant((Object)new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria FALSE_CRITERIA = new CompareCriteria((Expression)new Constant((Object)new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER), 1, (Expression)new Constant((Object)new Integer(0), DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria UNKNOWN_CRITERIA = new CompareCriteria((Expression)new Constant(null, DataTypeManager.DefaultDataClasses.STRING), 2, (Expression)new Constant(null, DataTypeManager.DefaultDataClasses.STRING));
    private static final Timestamp EXAMPLE_TIMESTAMP = Timestamp.valueOf("2001-02-03 13:04:05.01");
    private static final Time EXAMPLE_TIME = Time.valueOf("13:04:05");
    private static final java.sql.Date EXAMPLE_DATE = java.sql.Date.valueOf("2001-02-03");
    private static Integer INTEGER_ZERO = new Integer(0);
    private static Double DOUBLE_ZERO = new Double(0.0);
    private static Float FLOAT_ZERO = new Float(0.0f);
    private static Long LONG_ZERO = new Long(0L);
    private static BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
    private static BigDecimal BIG_DECIMAL_ZERO = new BigDecimal("0");
    private static Short SHORT_ZERO = new Short(0);
    private static Byte BYTE_ZERO = new Byte(0);
    private static String SUB_QUERY_DEFAULT_NAME = "_Foo";
    static /* synthetic */ Class class$java$util$Date;

    private QueryRewriter() {
    }

    public static Command rewrite(Command command, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        return QueryRewriter.rewriteCommand(command, procCommand, metadata, context);
    }

    private static Command rewriteCommand(Command command, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        CorrelatedVariableSubstitutionVisitor.substituteVariables((LanguageObject)command);
        switch (command.getType()) {
            case 1: {
                if (command instanceof Query) {
                    command = QueryRewriter.rewriteQuery((Query)command, procCommand, metadata, context);
                    break;
                }
                command = QueryRewriter.rewriteSetQuery((SetQuery)command, procCommand, metadata, context);
                break;
            }
            case 6: {
                command = QueryRewriter.rewriteExec((StoredProcedure)((Object)command), procCommand, metadata, context);
                break;
            }
            case 2: {
                command = QueryRewriter.rewriteInsert((Insert)((Object)command), procCommand, context, metadata);
                break;
            }
            case 3: {
                command = QueryRewriter.rewriteUpdate((Update)((Object)command), procCommand, context, metadata);
                break;
            }
            case 4: {
                command = QueryRewriter.rewriteDelete((Delete)((Object)command), procCommand, context, metadata);
                break;
            }
            case 7: {
                procCommand = command;
                command = QueryRewriter.rewriteUpdateProcedure((CreateUpdateProcedureCommand)((Object)command), metadata, context);
            }
        }
        if (command instanceof CommandContainer) {
            List subCommands = ((CommandContainer)command).getContainedCommands();
            for (int i = 0; i < subCommands.size(); ++i) {
                Command subCommand = (Command)subCommands.get(i);
                if (command instanceof ProcedureContainer) {
                    Map variables = null;
                    try {
                        variables = QueryResolver.getVariableValues((Command)command, (QueryMetadataInterface)metadata);
                    }
                    catch (QueryMetadataException err) {
                        throw new QueryValidatorException((Throwable)err, err.getMessage());
                    }
                    catch (QueryResolverException err) {
                        throw new QueryValidatorException((Throwable)err, err.getMessage());
                    }
                    catch (MetaMatrixComponentException err) {
                        throw new QueryValidatorException((Throwable)err, err.getMessage());
                    }
                    VariableSubstitutionVisitor.substituteVariables((LanguageObject)subCommand, variables, command.getType());
                }
                subCommand = QueryRewriter.rewriteCommand(subCommand, procCommand, metadata, context);
                subCommands.set(i, subCommand);
            }
        }
        return QueryRewriter.removeProceduralWrapper(command, metadata);
    }

    private static Option mergeOptions(Option sourceOption, Option targetOption) {
        if (sourceOption == null) {
            return targetOption;
        }
        if (sourceOption.getPlanOnly()) {
            targetOption.setPlanOnly(true);
        }
        if (sourceOption.getDebug()) {
            targetOption.setDebug(true);
        }
        if (sourceOption.getShowPlan()) {
            targetOption.setShowPlan(true);
        }
        return targetOption;
    }

    private static Command removeProceduralWrapper(Command command, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (!(command instanceof StoredProcedure)) {
            return command;
        }
        StoredProcedure container = (StoredProcedure)command;
        if (container.isProcedureRelational()) {
            return command;
        }
        if (!(container.getSubCommand() instanceof CreateUpdateProcedureCommand)) {
            return command;
        }
        CreateUpdateProcedureCommand subCommand = (CreateUpdateProcedureCommand)container.getSubCommand();
        if (subCommand == null) {
            return command;
        }
        Iterator iter = container.getInputParameters().iterator();
        while (iter.hasNext()) {
            SPParameter param = (SPParameter)iter.next();
            Expression expr = param.getExpression();
            if (!EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)expr, (boolean)true)) {
                return command;
            }
            try {
                Object value = ExpressionEvaluator.evaluate((Expression)expr, null, null);
                if (value == null && metadata.elementSupports(param.getMetadataID(), 4)) continue;
            }
            catch (ExpressionEvaluationException err) {
            }
            catch (BlockedException err) {
            }
            catch (MetaMatrixComponentException err) {
            }
            catch (QueryMetadataException err) {}
        }
        Block block = subCommand.getBlock();
        if (block.getStatements().size() != 1) {
            return command;
        }
        Statement statement = (Statement)block.getStatements().get(0);
        if (statement.getType() != 2) {
            return command;
        }
        Command child = ((CommandStatement)statement).getCommand();
        if (child != null && child.getType() != 10) {
            if (child.getOption() == null) {
                child.setOption(command.getOption());
            } else {
                Option merged = QueryRewriter.mergeOptions(command.getOption(), child.getOption());
                child.setOption(merged);
            }
            return child;
        }
        return command;
    }

    private static Command rewriteUpdateProcedure(CreateUpdateProcedureCommand procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        Block block = QueryRewriter.rewriteBlock(procCommand.getBlock(), procCommand, context, metadata);
        procCommand.setBlock(block);
        return procCommand;
    }

    private static Block rewriteBlock(Block block, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        List statements = block.getStatements();
        Iterator stmtIter = statements.iterator();
        ArrayList<Object> newStmts = new ArrayList<Object>(statements.size());
        while (stmtIter.hasNext()) {
            Statement stmnt = (Statement)stmtIter.next();
            Object newStmt = QueryRewriter.rewriteStatement(stmnt, procCommand, context, metadata);
            if (newStmt instanceof Statement) {
                newStmts.add(newStmt);
                continue;
            }
            if (!(newStmt instanceof List)) continue;
            newStmts.addAll((List)newStmt);
        }
        block.setStatements(newStmts);
        return block;
    }

    private static Object rewriteStatement(Statement statement, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        int stmtType = statement.getType();
        switch (stmtType) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                Criteria evalCrit = QueryRewriter.rewriteCriteria(ifCrit, procCommand, context, metadata);
                evalCrit = QueryRewriter.evaluateCriteria(evalCrit);
                ifStmt.setCondition(evalCrit);
                if (evalCrit.equals(TRUE_CRITERIA)) {
                    Block ifblock = QueryRewriter.rewriteBlock(ifStmt.getIfBlock(), procCommand, context, metadata);
                    return ifblock.getStatements();
                }
                if (evalCrit.equals(FALSE_CRITERIA) || evalCrit.equals(UNKNOWN_CRITERIA)) {
                    if (ifStmt.hasElseBlock()) {
                        Block elseBlock = QueryRewriter.rewriteBlock(ifStmt.getElseBlock(), procCommand, context, metadata);
                        return elseBlock.getStatements();
                    }
                    return null;
                }
                Block ifblock = QueryRewriter.rewriteBlock(ifStmt.getIfBlock(), procCommand, context, metadata);
                ifStmt.setIfBlock(ifblock);
                if (ifStmt.hasElseBlock()) {
                    Block elseBlock = QueryRewriter.rewriteBlock(ifStmt.getElseBlock(), procCommand, context, metadata);
                    ifStmt.setElseBlock(elseBlock);
                }
                return ifStmt;
            }
            case 3: 
            case 4: 
            case 5: {
                AssignmentStatement assStmt = (AssignmentStatement)statement;
                if (assStmt.hasExpression()) {
                    Expression expr = assStmt.getExpression();
                    expr = QueryRewriter.rewriteExpression(expr, procCommand, context, metadata);
                    assStmt.setExpression(expr);
                } else if (assStmt.hasCommand()) {
                    Update update;
                    QueryRewriter.rewriteSubqueryContainer((SubqueryContainer)assStmt, procCommand, context, metadata);
                    if (assStmt.getCommand().getType() == 3 && (update = (Update)assStmt.getCommand()).getChangeList().isEmpty()) {
                        assStmt.setExpression((Expression)new Constant((Object)INTEGER_ZERO));
                    }
                }
                return assStmt;
            }
            case 2: {
                Update update;
                CommandStatement cmdStmt = (CommandStatement)statement;
                QueryRewriter.rewriteSubqueryContainer((SubqueryContainer)cmdStmt, procCommand, context, metadata);
                if (cmdStmt.getCommand().getType() == 3 && (update = (Update)cmdStmt.getCommand()).getChangeList().isEmpty()) {
                    return null;
                }
                return statement;
            }
            case 6: {
                LoopStatement loop = (LoopStatement)statement;
                QueryRewriter.rewriteSubqueryContainer((SubqueryContainer)loop, procCommand, context, metadata);
                QueryRewriter.rewriteBlock(loop.getBlock(), procCommand, context, metadata);
                if (loop.getBlock().getStatements().isEmpty()) {
                    return null;
                }
                return loop;
            }
            case 7: {
                WhileStatement whileStatement = (WhileStatement)statement;
                Criteria crit = whileStatement.getCondition();
                Criteria evalCrit = QueryRewriter.evaluateCriteria(crit);
                whileStatement.setCondition(evalCrit);
                if (evalCrit.equals(TRUE_CRITERIA)) {
                    throw new QueryValidatorException(QueryExecPlugin.Util.getString("QueryRewriter.infinite_while"));
                }
                if (evalCrit.equals(FALSE_CRITERIA) || evalCrit.equals(UNKNOWN_CRITERIA)) {
                    return null;
                }
                whileStatement.setBlock(QueryRewriter.rewriteBlock(whileStatement.getBlock(), procCommand, context, metadata));
                if (whileStatement.getBlock().getStatements().isEmpty()) {
                    return null;
                }
                return whileStatement;
            }
        }
        return statement;
    }

    private static void rewriteSubqueryContainer(SubqueryContainer container, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (container.getCommand() != null && metadata != null) {
            container.setCommand(QueryRewriter.rewriteCommand(container.getCommand(), procCommand, metadata, context));
        }
    }

    private static Criteria rewriteCriteria(HasCriteria hasCrit, Command procCommand, CommandContext context, QueryMetadataInterface metadata) {
        int selectorType;
        Criteria userCrit = null;
        Command userCommand = ((CreateUpdateProcedureCommand)procCommand).getUserCommand();
        int cmdType = userCommand.getType();
        switch (cmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
            default: {
                return FALSE_CRITERIA;
            }
        }
        if (userCrit == null) {
            return FALSE_CRITERIA;
        }
        CriteriaSelector selector = hasCrit.getSelector();
        List hasCritElmts = null;
        if (selector.hasElements()) {
            hasCritElmts = selector.getElements();
            Collection userElmnts = ElementCollectorVisitor.getElements((LanguageObject)userCrit, (boolean)true);
            if (!userElmnts.containsAll(hasCritElmts)) {
                return FALSE_CRITERIA;
            }
        }
        if ((selectorType = selector.getSelectorType()) == 0) {
            return TRUE_CRITERIA;
        }
        Iterator criteriaIter = PredicateCollectorVisitor.getPredicates((LanguageObject)userCrit).iterator();
        block10: while (criteriaIter.hasNext()) {
            CompareCriteria compCrit;
            Criteria predicateCriteria = (Criteria)criteriaIter.next();
            Collection predElmnts = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, (boolean)true);
            if (selector.hasElements()) {
                Iterator hasIter = hasCritElmts.iterator();
                boolean containsElmnt = false;
                while (hasIter.hasNext()) {
                    ElementSymbol hasElmnt = (ElementSymbol)hasIter.next();
                    if (!predElmnts.contains(hasElmnt)) continue;
                    containsElmnt = true;
                }
                if (!containsElmnt) continue;
            }
            switch (selectorType) {
                case 8: {
                    if (!(predicateCriteria instanceof SetCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 7: {
                    if (!(predicateCriteria instanceof MatchCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 9: {
                    if (!(predicateCriteria instanceof IsNullCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 10: {
                    if (!(predicateCriteria instanceof BetweenCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
            }
            if (!(predicateCriteria instanceof CompareCriteria) || (compCrit = (CompareCriteria)predicateCriteria).getOperator() != selectorType) continue;
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private static Criteria rewriteCriteria(TranslateCriteria transCrit, Command queryCommand, Command command, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Criteria translatedCriteria = null;
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
        Command userCmd = procCommand.getUserCommand();
        int cmdType = userCmd.getType();
        Criteria userCriteria = null;
        switch (cmdType) {
            case 4: {
                userCriteria = ((Delete)userCmd).getCriteria();
                break;
            }
            case 3: {
                userCriteria = ((Update)userCmd).getCriteria();
                break;
            }
            default: {
                return FALSE_CRITERIA;
            }
        }
        if (userCriteria == null) {
            return FALSE_CRITERIA;
        }
        cmdType = queryCommand.getType();
        HashSet<GroupSymbol> sourceGroups = new HashSet<GroupSymbol>();
        switch (cmdType) {
            case 4: {
                sourceGroups.add(((Delete)queryCommand).getGroup());
                break;
            }
            case 3: {
                sourceGroups.add(((Update)queryCommand).getGroup());
                break;
            }
            case 1: {
                sourceGroups.addAll(((Query)queryCommand).getFrom().getGroups());
            }
        }
        CriteriaTranslatorVisitor translateVisitor = new CriteriaTranslatorVisitor(procCommand.getSymbolMaps(), sourceGroups);
        CriteriaSelector selector = transCrit.getSelector();
        HasCriteria hasCrit = new HasCriteria(selector);
        Criteria result = QueryRewriter.rewriteCriteria(hasCrit, (Command)procCommand, context, metadata);
        if (result.equals(FALSE_CRITERIA)) {
            return FALSE_CRITERIA;
        }
        translateVisitor.setCriteriaSelector(selector);
        if (transCrit.hasTranslations()) {
            translateVisitor.setTranslations(transCrit.getTranslations());
        }
        Criteria userClone = (Criteria)userCriteria.clone();
        PreOrderNavigator.doVisit((LanguageObject)userClone, (LanguageVisitor)translateVisitor);
        translatedCriteria = translateVisitor.getTranslatedCriteria();
        translatedCriteria = QueryRewriter.rewriteCriteria(translatedCriteria, null, context, metadata);
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)translatedCriteria, (QueryMetadataInterface)metadata);
        }
        catch (Exception ex) {
            throw new QueryValidatorException((Throwable)ex, "ERR.015.009.0002", QueryExecPlugin.Util.getString("ERR.015.009.0002", (Object)translatedCriteria));
        }
        return translatedCriteria;
    }

    private static Query rewriteQuery(Query query, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        Criteria having;
        Criteria crit;
        From from;
        if (query.getInto() != null) {
            QueryRewriter.rewriteSelectInto(query, metadata);
        }
        if ((from = query.getFrom()) != null) {
            ArrayList<FromClause> clauses = new ArrayList<FromClause>(from.getClauses().size());
            Iterator clauseIter = from.getClauses().iterator();
            while (clauseIter.hasNext()) {
                clauses.add(QueryRewriter.rewriteFromClause(query, (FromClause)clauseIter.next(), procCommand, metadata, context));
            }
            from.setClauses(clauses);
        }
        if ((crit = query.getCriteria()) != null && !query.getIsXML()) {
            crit = QueryRewriter.rewriteCriteria(crit, (Command)query, procCommand, context, false, metadata);
            query.setCriteria(crit);
            if (query.getCriteria() != null) {
                Criteria evalCrit = QueryRewriter.evaluateCriteria(query.getCriteria());
                if (evalCrit == TRUE_CRITERIA) {
                    query.setCriteria(null);
                } else {
                    query.setCriteria(evalCrit);
                }
            }
        }
        if (query.getGroupBy() != null) {
            boolean hasExpression = false;
            Iterator iterator = query.getGroupBy().getSymbols().iterator();
            while (!hasExpression && iterator.hasNext()) {
                hasExpression = iterator.next() instanceof ExpressionSymbol;
            }
            if (hasExpression) {
                Select select = query.getSelect();
                GroupBy groupBy = query.getGroupBy();
                query.setGroupBy(null);
                Criteria having2 = query.getHaving();
                query.setHaving(null);
                OrderBy orderBy = query.getOrderBy();
                query.setOrderBy(null);
                Limit limit = query.getLimit();
                query.setLimit(null);
                Into into = query.getInto();
                query.setInto(null);
                HashSet<Expression> newSelectColumns = new HashSet<Expression>();
                newSelectColumns.addAll(groupBy.getSymbols());
                HashSet aggs = new HashSet();
                aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)select, (boolean)true));
                if (having2 != null) {
                    aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)having2, (boolean)true));
                }
                Iterator iter = aggs.iterator();
                while (iter.hasNext()) {
                    AggregateSymbol aggregateSymbol = (AggregateSymbol)iter.next();
                    if (aggregateSymbol.getExpression() == null) continue;
                    newSelectColumns.add(aggregateSymbol.getExpression());
                }
                Select innerSelect = new Select();
                int index = 0;
                Iterator iter2 = newSelectColumns.iterator();
                while (iter2.hasNext()) {
                    Expression expr = (Expression)iter2.next();
                    if (expr instanceof SingleElementSymbol) {
                        innerSelect.addSymbol((SelectSymbol)((SingleElementSymbol)expr.clone()));
                        continue;
                    }
                    innerSelect.addSymbol((SelectSymbol)new ExpressionSymbol("EXPR" + index++, expr));
                }
                query.setSelect(innerSelect);
                Query outerQuery = null;
                try {
                    outerQuery = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), (QueryCommand)query, metadata);
                }
                catch (QueryMetadataException err) {
                    throw new QueryValidatorException((Throwable)err, err.getMessage());
                }
                catch (QueryResolverException err) {
                    throw new QueryValidatorException((Throwable)err, err.getMessage());
                }
                catch (MetaMatrixComponentException err) {
                    throw new QueryValidatorException((Throwable)err, err.getMessage());
                }
                Iterator iter3 = outerQuery.getSelect().getProjectedSymbols().iterator();
                HashMap expressionMap = new HashMap();
                Iterator iter1 = query.getSelect().getProjectedSymbols().iterator();
                while (iter1.hasNext()) {
                    SingleElementSymbol expr = (SingleElementSymbol)iter1.next();
                    if (expr instanceof AliasSymbol) {
                        expr = ((AliasSymbol)expr).getSymbol();
                    }
                    if (expr instanceof ExpressionSymbol && !(expr instanceof AggregateSymbol)) {
                        expr = ((ExpressionSymbol)expr).getExpression();
                    }
                    expressionMap.put(expr.clone(), iter3.next());
                }
                ExpressionMappingVisitor.mapExpressions((LanguageObject)groupBy, expressionMap, true);
                outerQuery.setGroupBy(groupBy);
                ExpressionMappingVisitor.mapExpressions((LanguageObject)having2, expressionMap, true);
                outerQuery.setHaving(having2);
                ExpressionMappingVisitor.mapExpressions((LanguageObject)orderBy, expressionMap, true);
                outerQuery.setOrderBy(orderBy);
                outerQuery.setLimit(limit);
                ExpressionMappingVisitor.mapExpressions((LanguageObject)select, expressionMap, true);
                outerQuery.setSelect(select);
                outerQuery.setInto(into);
                outerQuery.setOption(query.getOption());
                query = outerQuery;
                QueryRewriter.rewriteExpressions((LanguageObject)innerSelect, procCommand, metadata, context);
            }
        }
        if ((having = query.getHaving()) != null) {
            query.setHaving(QueryRewriter.rewriteCriteria(having, procCommand, context, metadata));
        }
        if (query.getLimit() != null) {
            query.setLimit(QueryRewriter.rewriteLimitClause(query.getLimit()));
        }
        QueryRewriter.rewriteSelect(procCommand, metadata, context, query);
        QueryRewriter.rewriteOrderBy((QueryCommand)query);
        return query;
    }

    private static Query createInlineViewQuery(GroupSymbol group, QueryCommand nested, QueryMetadataInterface metadata) throws QueryValidatorException, QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        List actualSymbols = nested.getProjectedSymbols();
        Query query = new Query();
        Select select = new Select();
        query.setSelect(select);
        From from = new From();
        GroupSymbol inlineGroup = new GroupSymbol(group.getName().replace('.', '_') + "_1");
        from.addClause((FromClause)new UnaryFromClause(inlineGroup));
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        QueryCommand firstProject = nested;
        while (firstProject instanceof SetQuery) {
            firstProject = (QueryCommand)((SetQuery)firstProject).getQueries().get(0);
        }
        QueryRewriter.makeSelectUnique((Query)firstProject);
        store.addTempGroup(inlineGroup.getName(), nested.getProjectedSymbols());
        inlineGroup.setMetadataID((Object)store.getTempGroupID(inlineGroup.getName()));
        ArrayList<Class> actualTypes = new ArrayList<Class>(nested.getProjectedSymbols().size());
        Iterator i = actualSymbols.iterator();
        while (i.hasNext()) {
            SingleElementSymbol ses = (SingleElementSymbol)i.next();
            actualTypes.add(ses.getType());
        }
        select.setSymbols(SetQuery.getTypedProjectedSymbols((List)ResolverUtil.resolveElementsInGroup((GroupSymbol)inlineGroup, (QueryMetadataInterface)tma), actualTypes));
        query.setFrom(from);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)tma);
        query.setOption(nested.getOption());
        from.getClauses().clear();
        SubqueryFromClause sqfc = new SubqueryFromClause(inlineGroup.getName());
        sqfc.setCommand((Command)nested);
        sqfc.getGroupSymbol().setMetadataID(inlineGroup.getMetadataID());
        from.addClause((FromClause)sqfc);
        query.getTemporaryMetadata().putAll(store.getData());
        return query;
    }

    public static void makeSelectUnique(Query query) {
        query.getSelect().setSymbols(query.getSelect().getProjectedSymbols());
        List symbols = query.getSelect().getSymbols();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < symbols.size(); ++i) {
            String baseName;
            SingleElementSymbol symbol = (SingleElementSymbol)symbols.get(i);
            String name = baseName = symbol.getShortCanonicalName();
            int exprID = 0;
            while (!uniqueNames.add(name)) {
                name = baseName + '_' + exprID++;
            }
            boolean hasAlias = false;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                hasAlias = true;
            }
            if ((!(symbol instanceof ExpressionSymbol) || hasAlias) && name.equalsIgnoreCase(baseName)) continue;
            symbols.set(i, new AliasSymbol(name, symbol));
        }
    }

    private static void rewriteExpressions(LanguageObject obj, final Command procCommand, final QueryMetadataInterface metadata, final CommandContext context) throws QueryValidatorException {
        if (obj == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(null){

            public Expression replaceExpression(Expression element) {
                try {
                    return QueryRewriter.rewriteExpression(element, procCommand, context, metadata);
                }
                catch (QueryValidatorException err) {
                    throw new MetaMatrixRuntimeException((Throwable)err);
                }
            }
        };
        try {
            PostOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        }
        catch (MetaMatrixRuntimeException err) {
            if (err.getChild() instanceof QueryValidatorException) {
                throw (QueryValidatorException)err.getChild();
            }
            throw err;
        }
    }

    private static void rewriteOrderBy(QueryCommand query) {
        OrderBy orderBy = query.getOrderBy();
        if (orderBy != null && orderBy.getResolvedVariables() != null) {
            OrderBy newOrderBy = new OrderBy();
            for (int i = 0; i < orderBy.getVariableCount(); ++i) {
                SingleElementSymbol originalSymbol;
                SingleElementSymbol symbol = originalSymbol = (SingleElementSymbol)orderBy.getResolvedVariables().get(i);
                boolean hasAlias = false;
                if (symbol instanceof AliasSymbol) {
                    symbol = ((AliasSymbol)symbol).getSymbol();
                    hasAlias = true;
                }
                if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                    ExpressionSymbol es = (ExpressionSymbol)symbol;
                    if (query instanceof Query && EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)es.getExpression(), (boolean)true)) {
                        continue;
                    }
                } else if (symbol instanceof ElementSymbol && ((ElementSymbol)symbol).isExternalReference()) {
                    if (hasAlias || query instanceof Query) continue;
                    newOrderBy.addVariable((SingleElementSymbol)new AliasSymbol(symbol.getShortName(), symbol), orderBy.getOrderType(i).booleanValue());
                    continue;
                }
                newOrderBy.addVariable(originalSymbol, orderBy.getOrderType(i).booleanValue());
            }
            if (newOrderBy.getVariableCount() == 0) {
                query.setOrderBy(null);
            } else {
                query.setOrderBy(newOrderBy);
            }
        }
    }

    private static void rewriteSelect(Command procCommand, QueryMetadataInterface metadata, CommandContext context, Query query) throws QueryValidatorException {
        List symbols = query.getSelect().getSymbols();
        for (int i = 0; i < symbols.size(); ++i) {
            Object symbol = symbols.get(i);
            boolean hasAlias = false;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                hasAlias = true;
            }
            if (!(symbol instanceof ExpressionSymbol)) continue;
            ExpressionSymbol es = (ExpressionSymbol)symbol;
            if (symbol instanceof AggregateSymbol) {
                AggregateSymbol aggr;
                if (!(es.getExpression() instanceof Constant) || (aggr = (AggregateSymbol)symbol).getAggregateFunction().equals("COUNT") || aggr.getAggregateFunction().equals("SUM")) continue;
                symbols.set(i, new ExpressionSymbol("EXPR", es.getExpression()));
                continue;
            }
            es.setExpression(QueryRewriter.rewriteExpression(es.getExpression(), procCommand, context, metadata));
            if (hasAlias || es.getExpression() instanceof Constant || !EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)es.getExpression())) continue;
            symbols.set(i, new AliasSymbol(es.getShortName(), (SingleElementSymbol)es));
        }
    }

    private static void rewriteSelectInto(Query query, QueryMetadataInterface metadata) throws QueryValidatorException {
        Into into = query.getInto();
        List allIntoElements = null;
        try {
            allIntoElements = ResolverUtil.resolveElementsInGroup((GroupSymbol)into.getGroup(), (QueryMetadataInterface)metadata);
        }
        catch (QueryMetadataException err) {
            throw new QueryValidatorException((Throwable)err, err.getMessage());
        }
        catch (QueryResolverException err) {
            throw new QueryValidatorException((Throwable)err, err.getMessage());
        }
        catch (MetaMatrixComponentException err) {
            throw new QueryValidatorException((Throwable)err, err.getMessage());
        }
        ArrayList<Class> actualTypes = new ArrayList<Class>(allIntoElements.size());
        Iterator i = allIntoElements.iterator();
        while (i.hasNext()) {
            SingleElementSymbol ses = (SingleElementSymbol)i.next();
            actualTypes.add(ses.getType());
        }
        QueryRewriter.correctProjectedTypes(actualTypes, query);
    }

    private static void correctProjectedTypes(List actualSymbolTypes, Query query) throws QueryValidatorException {
        List symbols = query.getSelect().getProjectedSymbols();
        List newSymbols = SetQuery.getTypedProjectedSymbols((List)symbols, (List)actualSymbolTypes);
        query.getSelect().setSymbols(newSymbols);
    }

    private static SetQuery rewriteSetQuery(SetQuery setQuery, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        if (setQuery.getLimit() != null) {
            setQuery.setLimit(QueryRewriter.rewriteLimitClause(setQuery.getLimit()));
        }
        QueryRewriter.rewriteOrderBy((QueryCommand)setQuery);
        if (setQuery.getProjectedTypes() != null) {
            Iterator i = setQuery.getQueries().iterator();
            while (i.hasNext()) {
                QueryCommand command = (QueryCommand)i.next();
                if (!(command instanceof Query)) continue;
                QueryRewriter.correctProjectedTypes(setQuery.getProjectedTypes(), (Query)command);
            }
            setQuery.setProjectedTypes(null);
        }
        return setQuery;
    }

    private static FromClause rewriteFromClause(Query parent, FromClause clause, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        if (clause instanceof JoinPredicate) {
            return QueryRewriter.rewriteJoinPredicate(parent, (JoinPredicate)clause, procCommand, metadata, context);
        }
        if (clause instanceof UnaryFromClause) {
            QueryRewriter.rewriteUnaryFromClause(parent, (UnaryFromClause)clause, metadata, context);
        } else if (clause instanceof SubqueryFromClause) {
            QueryRewriter.rewriteSubqueryContainer((SubqueryFromClause)clause, procCommand, context, metadata);
        }
        return clause;
    }

    private static void rewriteUnaryFromClause(Query parent, UnaryFromClause ufc, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        Command nestedCommand = ufc.getExpandedCommand();
        if (nestedCommand == null) {
            return;
        }
        ufc.setExpandedCommand(QueryRewriter.rewriteCommand(nestedCommand, null, metadata, context));
    }

    private static JoinPredicate rewriteJoinPredicate(Query parent, JoinPredicate predicate, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        List joinCrits = predicate.getJoinCriteria();
        if (joinCrits != null && joinCrits.size() > 0) {
            CompoundCriteria criteria = new CompoundCriteria(new ArrayList(joinCrits));
            joinCrits.clear();
            criteria = QueryRewriter.rewriteCriteria((Criteria)criteria, procCommand, context, metadata);
            if (criteria instanceof CompoundCriteria && criteria.getOperator() == 0) {
                joinCrits.addAll(criteria.getCriteria());
            } else {
                joinCrits.add(criteria);
            }
            predicate.setJoinCriteria(joinCrits);
        }
        if (predicate.getJoinType() == JoinType.JOIN_UNION) {
            predicate.setJoinType(JoinType.JOIN_FULL_OUTER);
            predicate.setJoinCriteria(Arrays.asList(FALSE_CRITERIA));
        } else if (predicate.getJoinType() == JoinType.JOIN_RIGHT_OUTER) {
            predicate.setJoinType(JoinType.JOIN_LEFT_OUTER);
            FromClause leftClause = predicate.getLeftClause();
            predicate.setLeftClause(predicate.getRightClause());
            predicate.setRightClause(leftClause);
        }
        predicate.setLeftClause(QueryRewriter.rewriteFromClause(parent, predicate.getLeftClause(), procCommand, metadata, context));
        predicate.setRightClause(QueryRewriter.rewriteFromClause(parent, predicate.getRightClause(), procCommand, metadata, context));
        return predicate;
    }

    public static Criteria rewriteCriteria(Criteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        return QueryRewriter.rewriteCriteria(criteria, procCommand, context, false, metadata);
    }

    private static Criteria rewriteCriteria(Criteria criteria, Command procCommand, CommandContext context, boolean preserveUnknown, QueryMetadataInterface metadata) throws QueryValidatorException {
        return QueryRewriter.rewriteCriteria(criteria, null, procCommand, context, preserveUnknown, metadata);
    }

    private static Criteria rewriteCriteria(Criteria criteria, Command command, Command procCommand, CommandContext context, boolean preserveUnknown, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (criteria instanceof CompoundCriteria) {
            return QueryRewriter.rewriteCriteria((CompoundCriteria)criteria, command, procCommand, context, true, preserveUnknown, metadata);
        }
        if (criteria instanceof NotCriteria) {
            criteria = QueryRewriter.rewriteCriteria((NotCriteria)criteria, procCommand, context, metadata);
        } else if (criteria instanceof CompareCriteria) {
            criteria = QueryRewriter.rewriteCriteria((CompareCriteria)criteria, procCommand, context, metadata);
        } else if (criteria instanceof SubqueryCompareCriteria) {
            criteria = QueryRewriter.rewriteCriteria((SubqueryCompareCriteria)criteria, procCommand, context, metadata);
        } else if (criteria instanceof MatchCriteria) {
            criteria = QueryRewriter.rewriteCriteria((MatchCriteria)criteria, procCommand, context, metadata);
        } else if (criteria instanceof SetCriteria) {
            criteria = QueryRewriter.rewriteCriteria((SetCriteria)criteria, procCommand, context, metadata);
        } else if (criteria instanceof IsNullCriteria) {
            criteria = QueryRewriter.rewriteCriteria((IsNullCriteria)criteria, procCommand, context, metadata);
        } else {
            if (criteria instanceof BetweenCriteria) {
                return QueryRewriter.rewriteCriteria((BetweenCriteria)criteria, procCommand, context, preserveUnknown, metadata);
            }
            if (criteria instanceof HasCriteria) {
                criteria = QueryRewriter.rewriteCriteria((HasCriteria)criteria, procCommand, context, metadata);
            } else if (criteria instanceof TranslateCriteria) {
                criteria = QueryRewriter.rewriteCriteria((TranslateCriteria)criteria, command, procCommand, context, metadata);
            } else if (criteria instanceof ExistsCriteria || criteria instanceof SubquerySetCriteria) {
                QueryRewriter.rewriteSubqueryContainer((SubqueryContainer)criteria, procCommand, context, metadata);
            }
        }
        return QueryRewriter.evaluateCriteria(criteria);
    }

    public static Criteria optimizeCriteria(CompoundCriteria criteria) {
        try {
            return QueryRewriter.rewriteCriteria(criteria, null, null, null, false, false, null);
        }
        catch (QueryValidatorException err) {
            return criteria;
        }
    }

    private static Criteria rewriteCriteria(CompoundCriteria criteria, Command command, Command procCommand, CommandContext context, boolean rewrite, boolean preserveUnknown, QueryMetadataInterface metadata) throws QueryValidatorException {
        List crits = criteria.getCriteria();
        int operator = criteria.getOperator();
        LinkedHashSet newCrits = new LinkedHashSet(crits.size());
        Iterator critIter = crits.iterator();
        while (critIter.hasNext()) {
            CompoundCriteria other;
            Criteria converted = (Criteria)critIter.next();
            if (rewrite) {
                converted = QueryRewriter.rewriteCriteria(converted, command, procCommand, context, preserveUnknown, metadata);
                converted = QueryRewriter.evaluateCriteria(converted);
            } else if (converted instanceof CompoundCriteria) {
                converted = QueryRewriter.rewriteCriteria((CompoundCriteria)converted, command, null, null, false, preserveUnknown, metadata);
            }
            if (converted == TRUE_CRITERIA) {
                if (operator != 1) continue;
                return converted;
            }
            if (converted == FALSE_CRITERIA) {
                if (operator != 0) continue;
                return converted;
            }
            if (converted instanceof CompoundCriteria && (other = (CompoundCriteria)converted).getOperator() == criteria.getOperator()) {
                Iterator i = other.getCriteria().iterator();
                while (i.hasNext()) {
                    newCrits.add(i.next());
                }
                continue;
            }
            if (!preserveUnknown && converted == UNKNOWN_CRITERIA) {
                if (operator != 0) continue;
                return FALSE_CRITERIA;
            }
            newCrits.add(converted);
        }
        if (newCrits.size() == 0) {
            if (operator == 0) {
                return TRUE_CRITERIA;
            }
            return FALSE_CRITERIA;
        }
        if (newCrits.size() == 1) {
            return (Criteria)newCrits.iterator().next();
        }
        criteria.getCriteria().clear();
        criteria.getCriteria().addAll(newCrits);
        return criteria;
    }

    private static Criteria evaluateCriteria(Criteria crit) throws QueryValidatorException {
        if (EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)crit, (boolean)true)) {
            try {
                Boolean eval = CriteriaEvaluator.evaluateTVL((Criteria)crit, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST);
                if (eval == null) {
                    return UNKNOWN_CRITERIA;
                }
                if (Boolean.TRUE.equals(eval)) {
                    return TRUE_CRITERIA;
                }
                return FALSE_CRITERIA;
            }
            catch (CriteriaEvaluationException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0001", QueryExecPlugin.Util.getString("ERR.015.009.0001", (Object)crit));
            }
            catch (MetaMatrixComponentException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0001", QueryExecPlugin.Util.getString("ERR.015.009.0001", (Object)crit));
            }
        }
        return crit;
    }

    private static Criteria rewriteCriteria(NotCriteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Criteria innerCrit = QueryRewriter.rewriteCriteria(criteria.getCriteria(), procCommand, context, true, metadata);
        if ((innerCrit = QueryRewriter.evaluateCriteria(innerCrit)) == TRUE_CRITERIA) {
            return FALSE_CRITERIA;
        }
        if (innerCrit == FALSE_CRITERIA) {
            return TRUE_CRITERIA;
        }
        if (innerCrit == UNKNOWN_CRITERIA) {
            return UNKNOWN_CRITERIA;
        }
        if (innerCrit instanceof NotCriteria) {
            return ((NotCriteria)innerCrit).getCriteria();
        }
        criteria.setCriteria(innerCrit);
        return criteria;
    }

    private static Criteria rewriteCriteria(BetweenCriteria criteria, Command procCommand, CommandContext context, boolean preserveUnknown, QueryMetadataInterface metadata) throws QueryValidatorException {
        CompareCriteria lowerCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 3 : 6, criteria.getLowerExpression());
        CompareCriteria upperCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 4 : 5, criteria.getUpperExpression());
        CompoundCriteria newCriteria = new CompoundCriteria(criteria.isNegated() ? 1 : 0, (Criteria)lowerCriteria, (Criteria)upperCriteria);
        return QueryRewriter.rewriteCriteria((Criteria)newCriteria, procCommand, context, preserveUnknown, metadata);
    }

    private static Criteria rewriteCriteria(CompareCriteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Expression leftExpr = QueryRewriter.rewriteExpression(criteria.getLeftExpression(), procCommand, context, metadata);
        Expression rightExpr = QueryRewriter.rewriteExpression(criteria.getRightExpression(), procCommand, context, metadata);
        if (!EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)rightExpr) && EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)leftExpr)) {
            criteria.setLeftExpression(rightExpr);
            criteria.setRightExpression(leftExpr);
            switch (criteria.getOperator()) {
                case 3: {
                    criteria.setOperator(4);
                    break;
                }
                case 5: {
                    criteria.setOperator(6);
                    break;
                }
                case 4: {
                    criteria.setOperator(3);
                    break;
                }
                case 6: {
                    criteria.setOperator(5);
                }
            }
        } else {
            criteria.setLeftExpression(leftExpr);
            criteria.setRightExpression(rightExpr);
        }
        if (criteria.getLeftExpression() instanceof Function && EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)criteria.getRightExpression())) {
            criteria = QueryRewriter.simplifyWithInverse(criteria);
        }
        if (QueryRewriter.isNull(criteria.getLeftExpression()) || QueryRewriter.isNull(criteria.getRightExpression())) {
            return UNKNOWN_CRITERIA;
        }
        Criteria modCriteria = QueryRewriter.simplifyTimestampMerge(criteria);
        if (modCriteria instanceof CompareCriteria) {
            modCriteria = QueryRewriter.simplifyTimestampMerge2((CompareCriteria)modCriteria);
        }
        return modCriteria;
    }

    public static boolean isNull(Expression expr) {
        return expr instanceof Constant && ((Constant)expr).isNull();
    }

    private static Criteria rewriteCriteria(SubqueryCompareCriteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Expression leftExpr = QueryRewriter.rewriteExpression(criteria.getLeftExpression(), procCommand, context, metadata);
        if (QueryRewriter.isNull(leftExpr)) {
            return UNKNOWN_CRITERIA;
        }
        criteria.setLeftExpression(leftExpr);
        if (criteria.getPredicateQuantifier() == 3) {
            criteria.setPredicateQuantifier(2);
        }
        QueryRewriter.rewriteSubqueryContainer((SubqueryContainer)criteria, procCommand, context, metadata);
        return criteria;
    }

    private static CompareCriteria simplifyWithInverse(CompareCriteria criteria) throws QueryValidatorException {
        Expression leftExpr = criteria.getLeftExpression();
        Function leftFunction = (Function)leftExpr;
        if (QueryRewriter.isSimpleMathematicalFunction(leftFunction)) {
            return QueryRewriter.simplifyMathematicalCriteria(criteria);
        }
        if (criteria.getOperator() == 1 || criteria.getOperator() == 2) {
            if (criteria.getRightExpression() instanceof Constant && FunctionLibrary.isConvert((Function)leftFunction)) {
                return QueryRewriter.simplifyConvertFunction(criteria);
            }
            return QueryRewriter.simplifyParseFormatFunction(criteria);
        }
        return criteria;
    }

    private static boolean isSimpleMathematicalFunction(Function function) {
        Expression[] args;
        String funcName = function.getName();
        return !(!funcName.equals("+") && !funcName.equals("-") && !funcName.equals("*") && !funcName.equals("/") || !((args = function.getArgs())[0] instanceof Constant) && !(args[1] instanceof Constant));
    }

    private static CompareCriteria simplifyMathematicalCriteria(CompareCriteria criteria) throws QueryValidatorException {
        Object value;
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function function = (Function)leftExpr;
        String funcName = function.getName();
        Expression[] args = function.getArgs();
        Constant const1 = null;
        Expression expr = null;
        if (args[1] instanceof Constant) {
            const1 = (Constant)args[1];
            expr = args[0];
        } else if (funcName.equals("+") || funcName.equals("*")) {
            const1 = (Constant)args[0];
            expr = args[1];
        } else {
            return criteria;
        }
        int operator = criteria.getOperator();
        String oppFunc = null;
        switch (funcName.charAt(0)) {
            case '+': {
                oppFunc = "-";
                break;
            }
            case '-': {
                oppFunc = "+";
                break;
            }
            case '*': {
                oppFunc = "/";
                break;
            }
            case '/': {
                oppFunc = "*";
            }
        }
        Function combinedConst = null;
        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(oppFunc, new Class[]{rightExpr.getType(), const1.getType()});
        if (descriptor == null) {
            return criteria;
        }
        if (rightExpr instanceof Constant) {
            Constant const2 = (Constant)rightExpr;
            try {
                Object result = funcLib.invokeFunction(descriptor, new Object[]{const2.getValue(), const1.getValue()});
                combinedConst = new Constant(result, descriptor.getReturnType());
            }
            catch (InvalidFunctionException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0003", QueryExecPlugin.Util.getString("ERR.015.009.0003", (Object)e.getMessage()));
            }
            catch (FunctionExecutionException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0003", QueryExecPlugin.Util.getString("ERR.015.009.0003", (Object)e.getMessage()));
            }
        } else {
            Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, const1});
            conversion.setType(leftExpr.getType());
            conversion.setFunctionDescriptor(descriptor);
            combinedConst = conversion;
        }
        if (operator != 1 && operator != 2 && (oppFunc.equals("*") || oppFunc.equals("/")) && (value = const1.getValue()) != null) {
            Class type = const1.getType();
            Number comparisonObject = null;
            if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
                comparisonObject = INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
                comparisonObject = DOUBLE_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
                comparisonObject = FLOAT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
                comparisonObject = LONG_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
                comparisonObject = BIG_INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                comparisonObject = BIG_DECIMAL_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
                comparisonObject = SHORT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
                comparisonObject = BYTE_ZERO;
            } else {
                return criteria;
            }
            if (comparisonObject.compareTo(value) > 0) {
                switch (operator) {
                    case 5: {
                        operator = 6;
                        break;
                    }
                    case 3: {
                        operator = 4;
                        break;
                    }
                    case 6: {
                        operator = 5;
                        break;
                    }
                    case 4: {
                        operator = 3;
                    }
                }
            }
        }
        criteria.setLeftExpression(expr);
        criteria.setRightExpression((Expression)combinedConst);
        criteria.setOperator(operator);
        if (expr instanceof Function) {
            return QueryRewriter.simplifyWithInverse(criteria);
        }
        return criteria;
    }

    private static CompareCriteria simplifyConvertFunction(CompareCriteria crit) throws QueryValidatorException {
        Function leftFunction = (Function)crit.getLeftExpression();
        Constant rightConstant = (Constant)crit.getRightExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        if (leftExpr.getType() == DataTypeManager.DefaultDataClasses.NULL || rightConstant.getType() != DataTypeManager.DefaultDataClasses.STRING) {
            return crit;
        }
        Transform transform = DataTypeManager.getTransform((String)leftExprTypeName, (String)"string");
        if (transform.isNarrowing()) {
            return crit;
        }
        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findTypedConversionFunction(rightConstant.getType(), leftExpr.getType());
        if (descriptor == null) {
            return crit;
        }
        try {
            Object result = funcLib.invokeFunction(descriptor, new Object[]{rightConstant.getValue(), leftExprTypeName});
            crit.setRightExpression((Expression)new Constant(result, descriptor.getReturnType()));
            crit.setLeftExpression(leftExpr);
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryExecPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            if (crit.getOperator() == 1) {
                return FALSE_CRITERIA;
            }
            return TRUE_CRITERIA;
        }
        if (leftExpr instanceof Function) {
            return QueryRewriter.simplifyWithInverse(crit);
        }
        return crit;
    }

    private static SetCriteria simplifyConvertFunction(SetCriteria crit) throws QueryValidatorException {
        Function leftFunction = (Function)crit.getExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression targetType = leftFunction.getArgs()[1];
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        Iterator i = crit.getValues().iterator();
        ArrayList<Constant> newValues = new ArrayList<Constant>(crit.getNumberOfValues());
        boolean success = true;
        try {
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof Constant) {
                    Constant rightConstant = (Constant)next;
                    Class rightConstantType = rightConstant.getType();
                    if (targetType.getType().equals(rightConstantType) && targetType.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
                        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
                        FunctionDescriptor descriptor = funcLib.findTypedConversionFunction(rightConstantType, leftExpr.getType());
                        if (descriptor != null) {
                            Object result = funcLib.invokeFunction(descriptor, new Object[]{rightConstant.getValue(), leftExprTypeName});
                            newValues.add(new Constant(result, descriptor.getReturnType()));
                            continue;
                        }
                        success = false;
                    } else {
                        success = false;
                    }
                } else {
                    success = false;
                }
                break;
            }
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryExecPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            return crit;
        }
        if (success) {
            crit.setExpression(leftExpr);
            crit.setValues(newValues);
        }
        return crit;
    }

    private static CompareCriteria simplifyParseFormatFunction(CompareCriteria crit) throws QueryValidatorException {
        String type;
        Function leftFunction = (Function)crit.getLeftExpression();
        String funcName = leftFunction.getName().toLowerCase();
        String inverseFunction = null;
        if (funcName.startsWith("parse")) {
            type = funcName.substring(5);
            inverseFunction = "format" + type;
        } else if (funcName.startsWith("format")) {
            type = funcName.substring(6);
            inverseFunction = "parse" + type;
        } else {
            return crit;
        }
        Expression rightExpr = crit.getRightExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression formatExpr = leftFunction.getArgs()[1];
        if (!(formatExpr instanceof Constant)) {
            return crit;
        }
        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(inverseFunction, new Class[]{rightExpr.getType(), formatExpr.getType()});
        if (descriptor == null) {
            return crit;
        }
        String format = (String)((Constant)formatExpr).getValue();
        try {
            Expression dateExpression = null;
            FunctionDescriptor forwardFunction = null;
            FunctionDescriptor reverseFunction = null;
            boolean parseFunction = false;
            boolean checkExpression = true;
            if ((class$java$util$Date == null ? (class$java$util$Date = QueryRewriter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(leftExpr.getType())) {
                dateExpression = leftExpr;
                forwardFunction = leftFunction.getFunctionDescriptor();
                reverseFunction = descriptor;
            } else if ((class$java$util$Date == null ? (class$java$util$Date = QueryRewriter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(rightExpr.getType())) {
                dateExpression = rightExpr;
                forwardFunction = descriptor;
                reverseFunction = leftFunction.getFunctionDescriptor();
                parseFunction = true;
            }
            if (dateExpression != null) {
                Object example = EXAMPLE_TIMESTAMP;
                if (DataTypeManager.DefaultDataClasses.DATE.equals(dateExpression.getType())) {
                    example = EXAMPLE_DATE;
                } else if (DataTypeManager.DefaultDataClasses.TIME.equals(dateExpression.getType())) {
                    example = EXAMPLE_TIME;
                }
                if (parseFunction) {
                    if (rightExpr instanceof Constant) {
                        example = ((Constant)rightExpr).getValue();
                    } else {
                        checkExpression = false;
                    }
                }
                if (checkExpression) {
                    Object result = funcLib.invokeFunction(forwardFunction, new Object[]{example, format});
                    if (!example.equals(result = funcLib.invokeFunction(reverseFunction, new Object[]{result, format}))) {
                        if (parseFunction) {
                            if (crit.getOperator() == 1) {
                                return FALSE_CRITERIA;
                            }
                            return TRUE_CRITERIA;
                        }
                        return crit;
                    }
                }
            }
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryExecPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            String errorMsg = QueryExecPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        try {
            if (rightExpr instanceof Constant) {
                Object result = funcLib.invokeFunction(descriptor, new Object[]{((Constant)rightExpr).getValue(), format});
                crit.setRightExpression((Expression)new Constant(result, descriptor.getReturnType()));
                crit.setLeftExpression(leftExpr);
            } else {
                Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, formatExpr});
                conversion.setType(leftExpr.getType());
                conversion.setFunctionDescriptor(descriptor);
                crit.setRightExpression((Expression)conversion);
                crit.setLeftExpression(leftExpr);
            }
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryExecPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            return crit;
        }
        if (leftExpr instanceof Function) {
            return QueryRewriter.simplifyWithInverse(crit);
        }
        return crit;
    }

    private static Criteria simplifyTimestampMerge2(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function tsCreateFunction = null;
        Constant timestampConstant = null;
        if (leftExpr instanceof Function && rightExpr instanceof Constant) {
            tsCreateFunction = (Function)leftExpr;
            timestampConstant = (Constant)rightExpr;
        } else if (leftExpr instanceof Constant && rightExpr instanceof Function) {
            tsCreateFunction = (Function)rightExpr;
            timestampConstant = (Constant)leftExpr;
        } else {
            return criteria;
        }
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP) || timestampConstant.getValue() == null) {
            return criteria;
        }
        if (!tsCreateFunction.getName().equalsIgnoreCase("timestampCreate")) {
            return criteria;
        }
        Timestamp ts = (Timestamp)timestampConstant.getValue();
        String tsStr = ts.toString();
        java.sql.Date date = java.sql.Date.valueOf(tsStr.substring(0, 10));
        Time time = Time.valueOf(tsStr.substring(11, 19));
        Expression[] args = tsCreateFunction.getArgs();
        CompareCriteria dateCrit = new CompareCriteria(args[0], 1, (Expression)new Constant((Object)date, DataTypeManager.DefaultDataClasses.DATE));
        CompareCriteria timeCrit = new CompareCriteria(args[1], 1, (Expression)new Constant((Object)time, DataTypeManager.DefaultDataClasses.TIME));
        CompoundCriteria compCrit = new CompoundCriteria(0, (Criteria)dateCrit, (Criteria)timeCrit);
        return compCrit;
    }

    private static Criteria simplifyTimestampMerge(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function concatFunction = null;
        Constant timestampConstant = null;
        if (leftExpr instanceof Function && rightExpr instanceof Constant) {
            concatFunction = (Function)leftExpr;
            timestampConstant = (Constant)rightExpr;
        } else if (leftExpr instanceof Constant && rightExpr instanceof Function) {
            concatFunction = (Function)rightExpr;
            timestampConstant = (Constant)leftExpr;
        } else {
            return criteria;
        }
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.STRING) || timestampConstant.getValue() == null) {
            return criteria;
        }
        if (!concatFunction.getName().equalsIgnoreCase("concat") && !concatFunction.getName().equals("||")) {
            return criteria;
        }
        Expression[] args = concatFunction.getArgs();
        if (!(args[0] instanceof Function) || !(args[1] instanceof Function)) {
            return criteria;
        }
        Function formatDateFunction = (Function)args[0];
        Function formatTimeFunction = (Function)args[1];
        if (!formatDateFunction.getName().equalsIgnoreCase("formatdate") || !formatTimeFunction.getName().equalsIgnoreCase("formattime")) {
            return criteria;
        }
        if (!(formatDateFunction.getArgs()[1] instanceof Constant) || !(formatTimeFunction.getArgs()[1] instanceof Constant)) {
            return criteria;
        }
        String dateFormat = (String)((Constant)formatDateFunction.getArgs()[1]).getValue();
        String timeFormat = (String)((Constant)formatTimeFunction.getArgs()[1]).getValue();
        if (dateFormat == null || timeFormat == null) {
            return criteria;
        }
        String timestampValue = (String)timestampConstant.getValue();
        if (timestampValue.length() != dateFormat.length() + timeFormat.length()) {
            return criteria;
        }
        try {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat(dateFormat + timeFormat);
            Date parsedTimestamp = timestampFormatter.parse(timestampValue);
            Constant dateConstant = new Constant((Object)TimestampWithTimezone.createDate((Date)parsedTimestamp));
            CompareCriteria dateCompare = new CompareCriteria(formatDateFunction.getArgs()[0], 1, (Expression)dateConstant);
            Constant timeConstant = new Constant((Object)TimestampWithTimezone.createTime((Date)parsedTimestamp));
            CompareCriteria timeCompare = new CompareCriteria(formatTimeFunction.getArgs()[0], 1, (Expression)timeConstant);
            CompoundCriteria compCrit = new CompoundCriteria(0, (Criteria)dateCompare, (Criteria)timeCompare);
            return compCrit;
        }
        catch (ParseException e) {
            return criteria;
        }
    }

    private static Criteria rewriteCriteria(MatchCriteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Constant constant;
        criteria.setLeftExpression(QueryRewriter.rewriteExpression(criteria.getLeftExpression(), procCommand, context, metadata));
        criteria.setRightExpression(QueryRewriter.rewriteExpression(criteria.getRightExpression(), procCommand, context, metadata));
        if (QueryRewriter.isNull(criteria.getLeftExpression()) || QueryRewriter.isNull(criteria.getRightExpression())) {
            return UNKNOWN_CRITERIA;
        }
        Expression rightExpr = criteria.getRightExpression();
        if (rightExpr instanceof Constant && (constant = (Constant)rightExpr).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            String value = (String)constant.getValue();
            char escape = criteria.getEscapeChar();
            if (escape != '\u0000' && value.indexOf(escape) < 0) {
                criteria.setEscapeChar('\u0000');
            }
            if (value.equals(String.valueOf('%'))) {
                return criteria.isNegated() ? FALSE_CRITERIA : TRUE_CRITERIA;
            }
            if (DataTypeManager.DefaultDataClasses.STRING.equals(criteria.getLeftExpression().getType()) && value.indexOf(escape) < 0 && value.indexOf(95) < 0 && value.indexOf(37) < 0) {
                return QueryRewriter.rewriteCriteria(new CompareCriteria(criteria.getLeftExpression(), criteria.isNegated() ? 2 : 1, criteria.getRightExpression()), procCommand, context, metadata);
            }
        }
        return criteria;
    }

    private static Criteria rewriteCriteria(SetCriteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Function leftFunction;
        criteria.setExpression(QueryRewriter.rewriteExpression(criteria.getExpression(), procCommand, context, metadata));
        if (QueryRewriter.isNull(criteria.getExpression())) {
            return UNKNOWN_CRITERIA;
        }
        List vals = criteria.getValues();
        LinkedHashSet<Expression> newVals = new LinkedHashSet<Expression>(vals.size());
        Iterator valIter = vals.iterator();
        while (valIter.hasNext()) {
            newVals.add(QueryRewriter.rewriteExpression((Expression)valIter.next(), procCommand, context, metadata));
        }
        criteria.setValues(newVals);
        if (newVals.size() == 1) {
            Expression value = (Expression)newVals.iterator().next();
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)value).size() == 0) {
                return QueryRewriter.rewriteCriteria(new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 2 : 1, value), procCommand, context, metadata);
            }
        } else if (newVals.size() == 0) {
            return FALSE_CRITERIA;
        }
        if (criteria.getExpression() instanceof Function && FunctionLibrary.isConvert((Function)(leftFunction = (Function)criteria.getExpression()))) {
            Iterator i = criteria.getValues().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof Constant) continue;
                return criteria;
            }
            criteria = QueryRewriter.simplifyConvertFunction(criteria);
        }
        return criteria;
    }

    private static Criteria rewriteCriteria(IsNullCriteria criteria, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        criteria.setExpression(QueryRewriter.rewriteExpression(criteria.getExpression(), procCommand, context, metadata));
        return criteria;
    }

    private static Expression rewriteExpression(Expression expression, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (expression instanceof Function) {
            return QueryRewriter.rewriteFunction((Function)expression, procCommand, context, metadata);
        }
        if (expression instanceof CaseExpression) {
            return QueryRewriter.rewriteCaseExpression((CaseExpression)expression, procCommand, context, metadata);
        }
        if (expression instanceof SearchedCaseExpression) {
            return QueryRewriter.rewriteCaseExpression((SearchedCaseExpression)expression, procCommand, context, metadata);
        }
        if (expression instanceof ScalarSubquery) {
            QueryRewriter.rewriteSubqueryContainer((SubqueryContainer)((ScalarSubquery)expression), procCommand, context, metadata);
            return expression;
        }
        return expression;
    }

    private static Expression rewriteFunction(Function function, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (function.getName().equalsIgnoreCase("CONCAT2")) {
            FunctionDescriptor descriptor;
            Expression[] args = function.getArgs();
            Function[] newArgs = new Function[args.length];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = new Function("NVL", new Expression[]{args[i], new Constant((Object)"")});
                newArgs[i].setType(args[i].getType());
                Assertion.assertTrue((args[i].getType() == DataTypeManager.DefaultDataClasses.STRING ? 1 : 0) != 0);
                descriptor = FunctionLibraryManager.getFunctionLibrary().findFunction("NVL", new Class[]{args[i].getType(), DataTypeManager.DefaultDataClasses.STRING});
                newArgs[i].setFunctionDescriptor(descriptor);
            }
            Function concat = new Function("CONCAT", (Expression[])newArgs);
            concat.setType(DataTypeManager.DefaultDataClasses.STRING);
            descriptor = FunctionLibraryManager.getFunctionLibrary().findFunction("CONCAT", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
            concat.setFunctionDescriptor(descriptor);
            List<Criteria> when = Arrays.asList(new CompoundCriteria(0, (Criteria)new IsNullCriteria(args[0]), (Criteria)new IsNullCriteria(args[1])));
            Constant nullConstant = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
            List<Expression> then = Arrays.asList(nullConstant);
            SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
            caseExpr.setElseExpression((Expression)concat);
            caseExpr.setType(DataTypeManager.DefaultDataClasses.STRING);
            return QueryRewriter.rewriteExpression((Expression)caseExpr, procCommand, context, metadata);
        }
        Expression[] args = function.getArgs();
        Expression[] newArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = QueryRewriter.rewriteExpression(args[i], procCommand, context, metadata);
            if (!QueryRewriter.isNull(newArgs[i]) || function.getFunctionDescriptor().isNullDependent()) continue;
            return new Constant(null, function.getType());
        }
        function.setArgs(newArgs);
        if (FunctionLibrary.isConvert((Function)function) && newArgs[1] instanceof Constant) {
            Class srcType = newArgs[0].getType();
            String tgtTypeName = (String)((Constant)newArgs[1]).getValue();
            Class tgtType = DataTypeManager.getDataTypeClass((String)tgtTypeName);
            if (srcType != null && tgtType != null && srcType.equals(tgtType)) {
                return newArgs[0];
            }
        }
        if (function.getName().equalsIgnoreCase("decodestring") || function.getName().equalsIgnoreCase("decodeinteger")) {
            return QueryRewriter.convertDecodeFunction(function);
        }
        if (EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)function, (boolean)true)) {
            try {
                Object result = null;
                result = context == null ? ExpressionEvaluator.evaluate((Expression)function, null, null) : ExpressionEvaluator.evaluate((Expression)function, null, null, null, (CommandContext)context);
                Constant constant = new Constant(result, function.getType());
                return constant;
            }
            catch (ExpressionEvaluationException e) {
                String funcName = function.getName();
                if (FunctionLibrary.isConvert((Function)function)) {
                    Expression expr = newArgs[0];
                    String sourceType = DataTypeManager.getDataTypeName((Class)newArgs[0].getType());
                    String targetType = (String)((Constant)newArgs[1]).getValue();
                    throw new QueryValidatorException((Throwable)e, "ERR.015.009.0004", QueryExecPlugin.Util.getString("ERR.015.009.0004", new Object[]{funcName, expr, sourceType, targetType}));
                }
                throw new QueryValidatorException((Throwable)e, e.getMessage());
            }
            catch (MetaMatrixComponentException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0005", QueryExecPlugin.Util.getString("ERR.015.009.0005", (Object)function));
            }
        }
        return function;
    }

    private static Expression convertDecodeFunction(Function function) {
        Expression[] exprs = function.getArgs();
        String decodeString = (String)((Constant)exprs[1]).getValue();
        String decodeDelimiter = ",";
        if (exprs.length == 3) {
            decodeDelimiter = (String)((Constant)exprs[2]).getValue();
        }
        ArrayList<Constant> newWhens = new ArrayList<Constant>();
        ArrayList<Constant> newThens = new ArrayList<Constant>();
        Constant elseConst = null;
        StringTokenizer tokenizer = new StringTokenizer(decodeString, decodeDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String compareString = FunctionMethods.convertString((String)tokenizer.nextToken().trim());
            if (tokenizer.hasMoreTokens()) {
                String resultString = FunctionMethods.convertString((String)tokenizer.nextToken().trim());
                newWhens.add(new Constant((Object)compareString));
                newThens.add(new Constant((Object)resultString));
                continue;
            }
            elseConst = new Constant((Object)compareString);
        }
        CaseExpression newCaseExpr = new CaseExpression(exprs[0], newWhens, newThens);
        if (elseConst != null) {
            newCaseExpr.setElseExpression((Expression)elseConst);
        } else {
            newCaseExpr.setElseExpression(exprs[0]);
        }
        newCaseExpr.setType(function.getType());
        return newCaseExpr;
    }

    private static Expression rewriteCaseExpression(CaseExpression expr, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Expression rewrittenExpr = QueryRewriter.rewriteExpression(expr.getExpression(), procCommand, context, metadata);
        expr.setExpression(rewrittenExpr);
        int whenCount = expr.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        boolean tryToSimplify = EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)rewrittenExpr, (boolean)true);
        for (int i = 0; i < whenCount; ++i) {
            Expression rewrittenWhen = QueryRewriter.rewriteExpression(expr.getWhenExpression(i), procCommand, context, metadata);
            if (tryToSimplify && EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)rewrittenWhen, (boolean)true)) {
                CompareCriteria crit = new CompareCriteria(rewrittenExpr, 1, rewrittenWhen);
                try {
                    boolean eval = CriteriaEvaluator.evaluate((Criteria)crit, null, null);
                    if (!eval) continue;
                    return QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context, metadata);
                }
                catch (Exception e) {
                    tryToSimplify = false;
                }
            } else {
                tryToSimplify = false;
            }
            whens.add(rewrittenWhen);
            thens.add(QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context, metadata));
        }
        return QueryRewriter.simplifyCaseExpression((AbstractCaseExpression)expr, procCommand, context, whenCount, whens, thens, metadata);
    }

    private static Expression simplifyCaseExpression(AbstractCaseExpression expr, Command procCommand, CommandContext context, int whenCount, ArrayList whens, ArrayList thens, QueryMetadataInterface metadata) throws QueryValidatorException {
        expr.setElseExpression(QueryRewriter.rewriteExpression(expr.getElseExpression(), procCommand, context, metadata));
        Expression elseExpr = expr.getElseExpression();
        if (whens.size() == 0) {
            if (elseExpr == null) {
                return new Constant(null, expr.getType());
            }
            return elseExpr;
        }
        expr.setWhen((List)whens, (List)thens);
        if (elseExpr != null) {
            boolean bAllMatch = true;
            for (int i = 0; i < whenCount; ++i) {
                if (thens.get(i).equals(elseExpr)) continue;
                bAllMatch = false;
                break;
            }
            if (bAllMatch) {
                return elseExpr;
            }
        }
        return expr;
    }

    private static Expression rewriteCaseExpression(SearchedCaseExpression expr, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        int whenCount = expr.getWhenCount();
        ArrayList<Criteria> whens = new ArrayList<Criteria>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            Criteria rewrittenWhen = QueryRewriter.rewriteCriteria(expr.getWhenCriteria(i), procCommand, context, metadata);
            if (EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)rewrittenWhen, (boolean)true)) {
                try {
                    boolean eval = CriteriaEvaluator.evaluate((Criteria)rewrittenWhen, null, null);
                    if (!eval) continue;
                    return QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context, metadata);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            whens.add(rewrittenWhen);
            thens.add(QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context, metadata));
        }
        return QueryRewriter.simplifyCaseExpression((AbstractCaseExpression)expr, procCommand, context, whenCount, whens, thens, metadata);
    }

    private static Command rewriteExec(StoredProcedure storedProcedure, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        storedProcedure.setDisplayNamedParameters(false);
        Iterator i = storedProcedure.getInputParameters().iterator();
        while (i.hasNext()) {
            SPParameter param = (SPParameter)i.next();
            param.setExpression(QueryRewriter.rewriteExpression(param.getExpression(), procCommand, context, metadata));
        }
        return storedProcedure;
    }

    private static Command rewriteInsert(Insert insert, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (insert.getQuery() != null) {
            Query query = null;
            Command obj = insert.getQuery();
            if (obj instanceof SetQuery) {
                query = new Query();
                Select select = new Select();
                AllSymbol allSymbol = new AllSymbol();
                select.addSymbol((SelectSymbol)allSymbol);
                query.setSelect(select);
                From from = new From();
                SubqueryFromClause sqfc = new SubqueryFromClause(SUB_QUERY_DEFAULT_NAME);
                sqfc.setCommand(insert.getQuery());
                from.addClause((FromClause)sqfc);
                query.setFrom(from);
                query.setOption(insert.getQuery().getOption());
                try {
                    QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)metadata);
                }
                catch (Exception err) {
                    throw new QueryValidatorException(err.getMessage());
                }
            } else {
                query = (Query)insert.getQuery();
                query.setOption(insert.getOption());
            }
            query.setInto(new Into(insert.getGroup()));
            return QueryRewriter.rewrite((Command)query, procCommand, metadata, context);
        }
        List expressions = insert.getValues();
        ArrayList<Expression> evalExpressions = new ArrayList<Expression>(expressions.size());
        Iterator expIter = expressions.iterator();
        while (expIter.hasNext()) {
            Expression exp = (Expression)expIter.next();
            evalExpressions.add(QueryRewriter.rewriteExpression(exp, procCommand, context, metadata));
        }
        insert.setValues(evalExpressions);
        return insert;
    }

    private static Update rewriteUpdate(Update update, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Criteria crit;
        List changeList = update.getChangeList();
        Iterator changeIter = changeList.iterator();
        while (changeIter.hasNext()) {
            crit = (CompareCriteria)changeIter.next();
            crit.setRightExpression(QueryRewriter.rewriteExpression(crit.getRightExpression(), procCommand, context, metadata));
        }
        crit = update.getCriteria();
        if (crit != null) {
            update.setCriteria(QueryRewriter.rewriteCriteria(crit, (Command)update, procCommand, context, false, metadata));
        }
        return update;
    }

    private static Delete rewriteDelete(Delete delete, Command procCommand, CommandContext context, QueryMetadataInterface metadata) throws QueryValidatorException {
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            delete.setCriteria(QueryRewriter.rewriteCriteria(crit, (Command)delete, procCommand, context, false, metadata));
        }
        return delete;
    }

    private static Limit rewriteLimitClause(Limit limit) {
        try {
            if (limit.getOffset() != null && EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)limit.getOffset(), (boolean)true)) {
                limit.setOffset((Expression)new Constant(ExpressionEvaluator.evaluate((Expression)limit.getOffset(), (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST)));
            }
            if (limit.getRowLimit() != null && EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)limit.getRowLimit(), (boolean)true)) {
                limit.setRowLimit((Expression)new Constant(ExpressionEvaluator.evaluate((Expression)limit.getRowLimit(), (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST)));
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return limit;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

