/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.log.Logger;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.core.extension.XAttribute;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.metamodels.core.extension.XEnum;
import com.metamatrix.metamodels.core.extension.XEnumLiteral;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.jdbc.relational.JdbcImporter;
import com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.impl.JdbcFactoryImpl;
import com.metamatrix.modeler.jdbc.metadata.Includes;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcDatabaseImpl;
import com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin;
import com.metamatrix.modeler.jdbc.relational.RelationalModelProcessor;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.modeler.modelgenerator.xml.jdbc.ui.util.JdbcUiUtil;
import com.metamatrix.modeler.modelgenerator.xml.model.ConnectionImpl;
import com.metamatrix.modeler.modelgenerator.xml.model.DatabaseMetaDataImpl;
import com.metamatrix.modeler.modelgenerator.xml.model.UserSettings;
import com.metamatrix.modeler.modelgenerator.xml.wizards.DimensionExtensionOperation;
import com.metamatrix.modeler.modelgenerator.xml.wizards.IntroductionPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.JdbcImportObjectsPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.JdbcImportOptionsPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.JdbcShowDifferencesPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.PreferencePage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.RequestSelectionPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.ResponseSelectionPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.RootElementsPage;
import com.metamatrix.modeler.modelgenerator.xml.wizards.StateManager;
import com.metamatrix.modeler.modelgenerator.xml.wizards.jdbc.XmlImporterJdbcDriver;
import com.metamatrix.modeler.modelgenerator.xml.wizards.jdbc.XmlSchemaAsRelationalModelProcessor;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.processing.RelationshipProcessor;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.wizard.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class XsdAsRelationalImportWizard
extends AbstractWizard
implements IImportWizard {
    protected static final String WIZARD_TITLE = "title";
    protected static final String XML_FILE_EXTENSION_NAME = "XMLFileExtension";
    protected static final String XML_HTTP_EXTENSION_NAME = "XMLHTTPExtension";
    protected static final String XML_ACS_EXTENSION_NAME = "XMLACSExtension";
    protected static final String TABLES_CLASS_NAME = "RelTables";
    protected static final String CATALOGS_CLASS_NAME = "RelCatalogs";
    protected static final String COLUMNS_CLASS_NAME = "RelColumns";
    protected static final String NAMESPACEPREFIXES_ATTRIBUTE_NAME = "NamespacePrefixes";
    protected static final String COLUMNROLE_ATTRIBUTE_NAME = "Role";
    protected static final String COLUMN_INPUT_PARAM_ATTRIBUTE_NAME = "IsInputParameter";
    protected static final String ACS_URI_SCHEME_RESPONSE = "ACSResponse";
    protected static final String ACS_URI_SCHEME_REQUEST = "ACSRequest";
    protected static final String XPATH_ROOT_FOR_INPUT_ATTRIBUTE_NAME = "XPathRootForInput";
    public static final String RESPONSE_ID_IN_COL_NAME = "ResponseIn";
    public static final String RESPONSE_ID_OUT_COL_NAME = "ResponseOut";
    public static final String COLUMN_ROLE_ENUM = "ColumnRole";
    public static final String RESPONSE_IN_ROLE_ENUM_VALUE = "Response In";
    public static final String RESPONSE_OUT_ROLE_ENUM_VALUE = "Response Out";
    public static final int NO_CATALOG_VAL = 1;
    public static final int NAMESPACE_CATALOG_VAL = 2;
    public static final int FILENAME_CATALOG_VAL = 3;
    public static final int CUSTOM_CATALOG_VAL = 4;
    StateManager manager;
    IntroductionPage introductionPage;
    ResponseSelectionPage responseSelectionPage;
    RequestSelectionPage requestSelectionPage;
    RootElementsPage rootElementsPage;
    JdbcShowDifferencesPage diffsPg;
    JdbcImportOptionsPage optionsPg;
    JdbcImportObjectsPage importObjectsPg;
    UserSettings userSettings;
    RelationshipProcessor relationshipProcessor;
    JdbcFactory jdbcFactory;
    ConnectionImpl jdbcConnection;
    private static XAttribute tableNamespacePrefixesAttribute = null;
    private static XAttribute catalogNamespacePrefixesAttribute = null;
    private static XAttribute columnRoleAttribute = null;
    private static XAttribute xpathRootForInputAttribute = null;
    private static XAttribute columnInputParamAttribute = null;
    private static XClass tableClass = null;
    private static XClass columnClass = null;
    private static XClass catalogClass = null;
    private static XPackage extensionPackage = null;
    private static XEnum columnRoleEnum = null;
    private static XEnumLiteral responseInRoleEnumValue = null;
    private static XEnumLiteral responseOutRoleEnumValue = null;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(XsdAsRelationalImportWizard.class);
    private static final ImageDescriptor IMAGE = XmlImporterUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importDatabase.gif");
    private PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    private String TITLE = this.getString("title");
    private String NOT_LICENCED_PAGE_TITLE = this.getString("notLicencedPageTitle");
    protected String COPY_ERROR_MESSAGE = this.getString("copyErrorMessage");
    private String IMPORT_ERROR_MESSAGE = this.getString("importErrorMessage");
    private String NOT_LICENSED_MSG = this.getString("notLicensedMessage");
    private static boolean importLicensed = false;
    private JdbcImporter importer;
    private IContainer folder;
    private String modelName;
    private IStatus status;
    private DifferenceReport drDifferenceReport;
    private ProcessorPack ppProcessorPack;
    private IOverwriteQuery YES = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "YES";
        }
    };

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (!this.checkLicence()) {
            this.badLicence();
            return;
        }
        this.createState();
        if (selection != null && !selection.isEmpty()) {
            List acsPreLoadValues;
            Object obj = selection.getFirstElement();
            if (obj instanceof IProject || obj instanceof IFile) {
                IContainer folder = ModelUtil.getContainer((Object)obj);
                try {
                    if (folder != null && folder.getProject().getNature("com.metamatrix.modeler.core.modelNature") != null) {
                        this.folder = folder;
                    }
                }
                catch (CoreException err) {
                    this.util.log((Throwable)err);
                    WidgetUtil.showError((Throwable)err);
                }
            } else if (obj instanceof String && ((String)obj).equals("acsMode") && (String)(acsPreLoadValues = selection.toList()).get(0) == "acsMode") {
                String opaquePart = (String)acsPreLoadValues.get(1) + ":" + (String)acsPreLoadValues.get(2);
                this.manager.setACSMode(true);
                this.manager.setCatalogType(4);
                this.manager.setCustomCatalogName((String)acsPreLoadValues.get(2));
                URI acsURI = URI.createGenericURI((String)ACS_URI_SCHEME_RESPONSE, (String)opaquePart, (String)((String)acsPreLoadValues.get(4)));
                this.manager.addSchema(ACS_URI_SCHEME_RESPONSE, acsURI);
                this.setModelName((String)acsPreLoadValues.get(1) + "_" + (String)acsPreLoadValues.get(2));
            }
        }
        this.importer = new JdbcImporter();
        this.introductionPage = new IntroductionPage(this);
        if (!this.manager.getACSMode()) {
            this.addPage((IWizardPage)this.introductionPage);
        } else {
            this.userSettings.setSourceType(4);
        }
        this.responseSelectionPage = new ResponseSelectionPage(this, this.util);
        if (!this.manager.getACSMode()) {
            this.addPage((IWizardPage)this.responseSelectionPage);
        }
        this.requestSelectionPage = new RequestSelectionPage(this, this.util);
        this.rootElementsPage = new RootElementsPage(this);
        this.addPage((IWizardPage)this.rootElementsPage);
        this.importObjectsPg = new JdbcImportObjectsPage();
        this.addPage((IWizardPage)this.importObjectsPg);
        this.optionsPg = new JdbcImportOptionsPage();
        this.addPage((IWizardPage)this.optionsPg);
        this.diffsPg = new JdbcShowDifferencesPage(this);
        this.addPage((IWizardPage)this.diffsPg);
        if (this.importer.getUpdatedModel() != null) {
            this.optionsPg.setPageComplete(false);
        }
        String wizardTitle = this.getString(WIZARD_TITLE);
        this.setWindowTitle(wizardTitle);
    }

    private void createState() {
        this.userSettings = new UserSettings((Object)this);
        new PreferencePage();
        IPreferenceStore prefs = XmlImporterUiPlugin.getDefault().getPreferenceStore();
        int cThreshold = prefs.getInt("c_Threshold");
        int pThreshold = prefs.getInt("p_Threshold");
        int fThreshold = prefs.getInt("f_Threshold");
        this.userSettings.set_C_threshold(cThreshold);
        this.userSettings.set_P_threshold(pThreshold);
        this.userSettings.set_F_threshold(fThreshold);
        this.manager = new StateManager(this.userSettings, (Logger)this.util);
        String requestTableLocalName = prefs.getString("requestTable");
        this.userSettings.setRequestTableLocalName(requestTableLocalName);
        String mergedChildSep = prefs.getString("mergedChildSep");
        this.userSettings.setMergedChildSep(mergedChildSep);
        String xsdLibrary = prefs.getString("xsdLibrary");
        this.userSettings.setXsdLibrary(mergedChildSep);
        this.jdbcFactory = new JdbcFactoryImpl();
        this.jdbcConnection = new ConnectionImpl(this.manager, this.userSettings, (Object)this);
    }

    private void badLicence() {
        WizardPage page = new WizardPage(ClassUtil.getSimpleClassName(XsdAsRelationalImportWizard.class), this.NOT_LICENCED_PAGE_TITLE, null){

            public void createControl(Composite parent) {
                this.setControl((Control)XsdAsRelationalImportWizard.this.createEmptyPageControl(parent));
            }
        };
        page.setMessage(this.NOT_LICENSED_MSG, 3);
        page.setPageComplete(false);
        this.addPage((IWizardPage)page);
    }

    private boolean checkLicence() {
        return true;
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    public RelationshipProcessor getRelationshipProcessor() {
        return this.relationshipProcessor;
    }

    void setUseSchemaTypes(boolean useSchemaTypes) {
        this.userSettings.setUseSchemaTypes(useSchemaTypes);
    }

    void schemaChanged(SchemaModel model) {
        this.jdbcConnection.changed();
        try {
            String validatedName;
            String dbName = this.jdbcConnection.getCatalog();
            if (dbName == null || dbName.equals("")) {
                Object oFirstURI;
                Iterator iter = this.manager.getSchemaURIs().iterator();
                Object v0 = oFirstURI = iter.hasNext() ? this.manager.getSchemaURIs().iterator().next() : null;
                if (oFirstURI instanceof URI) {
                    URI firstURI = oFirstURI;
                    String lastSegment = firstURI.lastSegment();
                    int dot = lastSegment.indexOf(46);
                    dbName = dot > 0 ? lastSegment.substring(0, dot) : lastSegment;
                }
            }
            if (null != (validatedName = CoreValidationRulesUtil.getValidString((String)dbName, null, (int)-1))) {
                dbName = validatedName;
            }
            JdbcDatabaseImpl db = new JdbcDatabaseImpl((Connection)this.jdbcConnection, dbName);
            this.setDatabase((JdbcDatabase)db);
            JdbcSource source = this.jdbcFactory.createJdbcSource();
            source.setDriverClass(XmlImporterJdbcDriver.class.getName());
            source.setDriverName(XmlImporterJdbcDriver.class.getName());
            Includes includes = db.getIncludes();
            includes.setApproximateIndexes(false);
            includes.setIncludeForeignKeys(true);
            includes.setIncludeIndexes(false);
            includes.setIncludeProcedures(false);
            includes.setUniqueIndexesOnly(false);
            String[] tableTypeNames = DatabaseMetaDataImpl.getTableTypeNames();
            includes.setIncludedTableTypes(tableTypeNames);
            JdbcImportSettings importSettings = this.jdbcFactory.createJdbcImportSettings();
            importSettings.setIncludeApproximateIndexes(false);
            importSettings.setIncludeForeignKeys(true);
            importSettings.setIncludeIndexes(true);
            importSettings.setIncludeProcedures(false);
            importSettings.setIncludeUniqueIndexes(false);
            EList tableTypes = importSettings.getIncludedTableTypes();
            for (int i = 0; i < tableTypeNames.length; ++i) {
                String tableType = tableTypeNames[i];
                tableTypes.add(tableType);
            }
            source.setImportSettings(importSettings);
            source.setJdbcDriver(null);
            source.setJdbcSourceContainer(null);
            String location = null;
            StringBuffer url = new StringBuffer();
            url.append("xsd:");
            boolean first = true;
            for (Object o : this.manager.getSchemaURIs()) {
                URI uri = (URI)o;
                location = this.manager.getACSMode() ? uri.trimFragment().toString() : uri.toString();
                if (!first) {
                    url.append("&");
                }
                first = false;
                url.append(location);
            }
            source.setUrl(url.toString());
            source.setUsername("");
            this.setSource(source);
            this.processModelName((JdbcDatabase)db);
        }
        catch (Exception err) {
            JdbcUiUtil.showError(err, this.COPY_ERROR_MESSAGE);
        }
    }

    public static XAttribute getCatalogNamespacePrefixesAttribute() {
        return catalogNamespacePrefixesAttribute;
    }

    public static XAttribute getTableNamespacePrefixesAttribute() {
        return tableNamespacePrefixesAttribute;
    }

    public static XAttribute getColumnRoleAttribute() {
        return columnRoleAttribute;
    }

    public static XAttribute getColumnInputParamAttribute() {
        return columnInputParamAttribute;
    }

    public static XClass getCatalogClass() {
        return catalogClass;
    }

    public static XClass getTableClass() {
        return tableClass;
    }

    public static XClass getColumnClass() {
        return columnClass;
    }

    public static XEnum getColumnRoleEnum() {
        return columnRoleEnum;
    }

    public static XEnumLiteral getResponseInRoleEnumValue() {
        return responseInRoleEnumValue;
    }

    public static XEnumLiteral getResponseOutRoleEnumValue() {
        return responseOutRoleEnumValue;
    }

    public XPackage getExtensionPackage(ModelAnnotation modelAnnotation) throws Exception {
        this.ensureExtensionObjects(modelAnnotation);
        return this.internalGetExtensionPackage();
    }

    public XPackage internalGetExtensionPackage() {
        return extensionPackage;
    }

    public void setCatalogNamespacePrefixesAttribute(XAttribute xattribute) {
        catalogNamespacePrefixesAttribute = xattribute;
    }

    public void setTableNamespacePrefixesAttribute(XAttribute xattribute) {
        tableNamespacePrefixesAttribute = xattribute;
    }

    public void setColumnRoleAttribute(XAttribute xattribute) {
        columnRoleAttribute = xattribute;
    }

    public void setColumnInputParamAttribute(XAttribute xattribute) {
        columnInputParamAttribute = xattribute;
    }

    public void setCatalogClass(XClass xclass) {
        catalogClass = xclass;
    }

    public void setTableClass(XClass xclass) {
        tableClass = xclass;
    }

    public void setColumnClass(XClass xclass) {
        columnClass = xclass;
    }

    public void setExtensionPackage(XPackage xpackage) {
        extensionPackage = xpackage;
    }

    public static XAttribute getXPathRootForInputAttribute() {
        return xpathRootForInputAttribute;
    }

    public void setXPathRootForInputAttribute(XAttribute xattribute) {
        xpathRootForInputAttribute = xattribute;
    }

    public void setColumnRoleEnum(XEnum xEnum) {
        columnRoleEnum = xEnum;
    }

    public void setResponseInRoleEnumValue(XEnumLiteral xEnumLiteral) {
        responseInRoleEnumValue = xEnumLiteral;
    }

    public void setResponseOutRoleEnumValue(XEnumLiteral xEnumLiteral) {
        responseOutRoleEnumValue = xEnumLiteral;
    }

    private void ensureExtensionObjects(ModelAnnotation modelAnnotation) {
        XClassAndXAttribute xClassAndXAttribute;
        XPackage xpackage;
        if (this.internalGetExtensionPackage() == null || !this.internalGetExtensionPackage().equals(this.getExtensionName())) {
            EClassifier type = CorePackage.eINSTANCE.getModelAnnotation_ExtensionPackage().getEType();
            Collection xpackages = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)modelAnnotation, (EClassifier)type);
            for (Object oPackage : xpackages) {
                XPackage xpackage2;
                String packageName;
                if (!(oPackage instanceof XPackage) || !(packageName = (xpackage2 = (XPackage)oPackage).getName()).equals(this.getExtensionName())) continue;
                this.util.log(1, "Setting xpackage to " + packageName);
                this.setExtensionPackage(xpackage2);
                break;
            }
        }
        if ((xpackage = this.internalGetExtensionPackage()) == null) {
            return;
        }
        if (XsdAsRelationalImportWizard.getCatalogClass() == null || XsdAsRelationalImportWizard.getCatalogNamespacePrefixesAttribute() == null) {
            xClassAndXAttribute = this.findClassAndAttribute(xpackage, CATALOGS_CLASS_NAME, NAMESPACEPREFIXES_ATTRIBUTE_NAME);
            this.setCatalogClass(xClassAndXAttribute.xClass);
            this.setCatalogNamespacePrefixesAttribute(xClassAndXAttribute.xAttribute);
        }
        if (XsdAsRelationalImportWizard.getTableClass() == null || XsdAsRelationalImportWizard.getTableNamespacePrefixesAttribute() == null) {
            xClassAndXAttribute = this.findClassAndAttribute(xpackage, TABLES_CLASS_NAME, NAMESPACEPREFIXES_ATTRIBUTE_NAME);
            this.setTableClass(xClassAndXAttribute.xClass);
            this.setTableNamespacePrefixesAttribute(xClassAndXAttribute.xAttribute);
        }
        if (!(extensionPackage.getName().equals(XML_FILE_EXTENSION_NAME) || XsdAsRelationalImportWizard.getTableClass() != null && XsdAsRelationalImportWizard.getXPathRootForInputAttribute() != null)) {
            xClassAndXAttribute = this.findClassAndAttribute(xpackage, TABLES_CLASS_NAME, XPATH_ROOT_FOR_INPUT_ATTRIBUTE_NAME);
            this.setTableClass(xClassAndXAttribute.xClass);
            this.setXPathRootForInputAttribute(xClassAndXAttribute.xAttribute);
        }
        if (XsdAsRelationalImportWizard.getColumnClass() == null || XsdAsRelationalImportWizard.getColumnRoleAttribute() == null) {
            xClassAndXAttribute = this.findClassAndAttribute(xpackage, COLUMNS_CLASS_NAME, COLUMNROLE_ATTRIBUTE_NAME);
            this.setColumnClass(xClassAndXAttribute.xClass);
            this.setColumnRoleAttribute(xClassAndXAttribute.xAttribute);
        }
        if (XsdAsRelationalImportWizard.getColumnRoleEnum() == null || XsdAsRelationalImportWizard.getResponseInRoleEnumValue() == null || XsdAsRelationalImportWizard.getResponseOutRoleEnumValue() == null) {
            XEnum xEnum = this.findEnum(xpackage, COLUMN_ROLE_ENUM);
            this.setColumnRoleEnum(xEnum);
            XEnumLiteral xEnumLiteral = this.findEnumLiteral(xEnum, RESPONSE_IN_ROLE_ENUM_VALUE);
            this.setResponseInRoleEnumValue(xEnumLiteral);
            xEnumLiteral = this.findEnumLiteral(xEnum, RESPONSE_OUT_ROLE_ENUM_VALUE);
            this.setResponseOutRoleEnumValue(xEnumLiteral);
        }
        if (XsdAsRelationalImportWizard.getColumnInputParamAttribute() == null) {
            xClassAndXAttribute = this.findClassAndAttribute(xpackage, COLUMNS_CLASS_NAME, COLUMN_INPUT_PARAM_ATTRIBUTE_NAME);
            this.setColumnInputParamAttribute(xClassAndXAttribute.xAttribute);
        }
    }

    protected String getExtensionName() {
        String modelExtension = new String();
        modelExtension = 0 == this.userSettings.getSourceType() ? XML_FILE_EXTENSION_NAME : (4 == this.userSettings.getSourceType() ? XML_ACS_EXTENSION_NAME : XML_HTTP_EXTENSION_NAME);
        return modelExtension;
    }

    private XClassAndXAttribute findClassAndAttribute(XPackage xmlFilePackage, String desiredClassName, String desiredAttributeName) {
        for (Object oClass : xmlFilePackage.eContents()) {
            XClass xclass;
            String className;
            if (!(oClass instanceof XClass) || !(className = (xclass = (XClass)oClass).getName()).equals(desiredClassName)) continue;
            for (Object oAttr : xclass.eContents()) {
                XAttribute xattribute;
                String attrName;
                if (!(oAttr instanceof XAttribute) || !(attrName = (xattribute = (XAttribute)oAttr).getName()).equals(desiredAttributeName)) continue;
                XClassAndXAttribute retval = new XClassAndXAttribute(xclass, xattribute);
                return retval;
            }
        }
        return new XClassAndXAttribute(null, null);
    }

    private XEnum findEnum(XPackage xmlFilePackage, String desiredEnumName) {
        XEnum retval = null;
        for (Object oEnum : xmlFilePackage.eContents()) {
            XEnum xenum;
            String enumName;
            if (!(oEnum instanceof XEnum) || !(enumName = (xenum = (XEnum)oEnum).getName()).equals(desiredEnumName)) continue;
            retval = xenum;
            break;
        }
        return retval;
    }

    private XEnumLiteral findEnumLiteral(XEnum xEnum, String desiredLiteralName) {
        if (xEnum == null) {
            return null;
        }
        XEnumLiteral retval = null;
        for (Object olit : xEnum.eContents()) {
            XEnumLiteral xEnumLiteral;
            String litName;
            if (!(olit instanceof XEnumLiteral) || !(litName = (xEnumLiteral = (XEnumLiteral)olit).getName()).equals(desiredLiteralName)) continue;
            retval = xEnumLiteral;
            break;
        }
        return retval;
    }

    private String getString(String id) {
        return this.util.getString(I18N_PREFIX + id);
    }

    private String getString(String id, Object[] params) {
        return this.util.getString(I18N_PREFIX + id, params);
    }

    public XsdAsRelationalImportWizard() {
        super((AbstractUIPlugin)XmlImporterUiPlugin.getDefault(), "", IMAGE);
        super.setWindowTitle(this.TITLE);
    }

    private Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            super.createPageControls(pageContainer);
        }
    }

    public boolean finish() {
        boolean result = false;
        Object rootContext = XmlImporterUiPlugin.getRootContext();
        if (XmlImporterUiPlugin.isDimension()) {
            try {
                this.util.log(1, "Creating DimensionExtensionOperation");
                DimensionExtensionOperation operation = new DimensionExtensionOperation(this.getExtensionName(), rootContext, (Logger)this.util);
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)operation);
            }
            catch (Throwable t) {
                JdbcUiUtil.showError(t, this.IMPORT_ERROR_MESSAGE);
            }
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    if (XsdAsRelationalImportWizard.this.ppProcessorPack == null) {
                        JdbcSource src = XsdAsRelationalImportWizard.this.getSource();
                        RelationalModelProcessor processor = JdbcRelationalPlugin.createRelationalModelProcessor((JdbcSource)src);
                        processor.setMoveRatherThanCopyAdds(!XsdAsRelationalImportWizard.this.isUpdatedModel());
                        ((XmlSchemaAsRelationalModelProcessor)processor).setACSMode(XsdAsRelationalImportWizard.this.manager.getACSMode());
                        IFile modelFile = XsdAsRelationalImportWizard.this.getFolder().getFile((IPath)new Path(XsdAsRelationalImportWizard.this.getModelName()));
                        ModelResource resrc = ModelerCore.create((IFile)modelFile);
                        ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
                        XPackage xPackage = XsdAsRelationalImportWizard.this.getExtensionPackage(modelAnnotation);
                        if (xPackage == null) {
                            XsdAsRelationalImportWizard.this.util.log(2, "xPackage is null");
                        } else {
                            modelAnnotation.setExtensionPackage(xPackage);
                        }
                        if (resrc instanceof ModelResourceImpl) {
                            ((ModelResourceImpl)resrc).setModelType(ModelType.PHYSICAL_LITERAL);
                        }
                        XsdAsRelationalImportWizard.this.status = processor.execute(resrc, XsdAsRelationalImportWizard.this.getDatabase(), src.getImportSettings(), monitor);
                        XsdAsRelationalImportWizard.this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                    } else {
                        XsdAsRelationalImportWizard.this.status = XsdAsRelationalImportWizard.this.ppProcessorPack.getProcessor().execute(XsdAsRelationalImportWizard.this.ppProcessorPack.getModelResource(), XsdAsRelationalImportWizard.this.getDatabase(), XsdAsRelationalImportWizard.this.ppProcessorPack.getJdbcSource().getImportSettings(), monitor);
                    }
                    if (XsdAsRelationalImportWizard.this.status.getSeverity() != 4) {
                        List objs = XsdAsRelationalImportWizard.this.ppProcessorPack.getModelResource().getAllRootEObjects();
                        Iterator iter = objs.iterator();
                        while (iter.hasNext()) {
                            if (!(iter.next() instanceof JdbcSource)) continue;
                            iter.remove();
                            break;
                        }
                        XsdAsRelationalImportWizard.this.ppProcessorPack.getJdbcSource().setJdbcDriver(null);
                        objs.add(XsdAsRelationalImportWizard.this.ppProcessorPack.getJdbcSource());
                        XsdAsRelationalImportWizard.this.ppProcessorPack.getModelResource().save(monitor, true);
                        XsdAsRelationalImportWizard.this.getFolder().refreshLocal(2, monitor);
                        ModelEditorManager.activate((IFile)XsdAsRelationalImportWizard.this.ppProcessorPack.getModelFile(), (boolean)true);
                    }
                }
                catch (OperationCanceledException err) {
                }
                catch (Exception err) {
                    throw new InvocationTargetException(err);
                }
                finally {
                    monitor.done();
                    XsdAsRelationalImportWizard.this.ppProcessorPack = null;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            switch (this.status.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.util.log(this.status);
                    WidgetUtil.showError((String)this.IMPORT_ERROR_MESSAGE);
                }
            }
            result = true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            JdbcUiUtil.showError(err, this.IMPORT_ERROR_MESSAGE);
        }
        return result;
    }

    public boolean canFinish() {
        boolean bCanFinish = false;
        boolean bUpdateSelected = false;
        boolean bDiffsDisplayed = false;
        if (this.diffsPg != null) {
            bDiffsDisplayed = this.diffsPg.isVisible();
        }
        boolean bUpdateStepsPending = false;
        if (bUpdateSelected && !bDiffsDisplayed) {
            bUpdateStepsPending = true;
        }
        bCanFinish = super.canFinish() && this.getDatabase() != null && this.getSource() != null && this.getFolder() != null && this.getModelName() != null && !bUpdateStepsPending;
        return bCanFinish;
    }

    public void dispose() {
        if (importLicensed) {
            try {
                this.importer.disconnect();
            }
            catch (SQLException err) {
                JdbcUiUtil.showAccessError(err);
            }
        }
        super.dispose();
    }

    protected void setSource(JdbcSource source) {
        this.importer.setSource(source);
    }

    protected void setDatabase(JdbcDatabase database) {
        this.importer.setDatabase(database);
    }

    JdbcSource getSource() {
        return this.importer.getSource();
    }

    JdbcDatabase getDatabase() {
        return this.importer.getDatabase();
    }

    IContainer getFolder() {
        return this.folder;
    }

    String getModelName() {
        return this.modelName;
    }

    boolean isUpdatedModel() {
        return this.importer.getUpdatedModel() != null;
    }

    void setFolder(IContainer folder) {
        ArgCheck.isNotNull((Object)folder);
        this.folder = folder;
    }

    void setModelName(String name) {
        ArgCheck.isNotEmpty((String)name);
        this.modelName = name;
    }

    public DifferenceReport getDifferenceReport() {
        if (this.drDifferenceReport == null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        JdbcSource src = XsdAsRelationalImportWizard.this.getSource();
                        RelationalModelProcessor processor = JdbcRelationalPlugin.createRelationalModelProcessor((JdbcSource)src);
                        processor.setMoveRatherThanCopyAdds(!XsdAsRelationalImportWizard.this.isUpdatedModel());
                        IFile modelFile = XsdAsRelationalImportWizard.this.getFolder().getFile((IPath)new Path(XsdAsRelationalImportWizard.this.getModelName()));
                        ModelResource resrc = ModelerCore.create((IFile)modelFile);
                        ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
                        if (resrc instanceof ModelResourceImpl) {
                            ((ModelResourceImpl)resrc).setModelType(ModelType.PHYSICAL_LITERAL);
                        }
                        if (processor != null && processor instanceof RelationalModelProcessorImpl) {
                            XsdAsRelationalImportWizard.this.drDifferenceReport = ((RelationalModelProcessorImpl)processor).generateDifferenceReport(resrc, XsdAsRelationalImportWizard.this.getDatabase(), src.getImportSettings(), monitor);
                        }
                        XsdAsRelationalImportWizard.this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                    }
                    catch (OperationCanceledException err) {
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    err = ((InvocationTargetException)err).getTargetException();
                }
                JdbcUiUtil.showError(err, this.IMPORT_ERROR_MESSAGE);
            }
        }
        return this.drDifferenceReport;
    }

    protected void processModelName(JdbcDatabase db) throws ModelWorkspaceException {
        if (this.getModelName() == null) {
            String modelName = CoreValidationRulesUtil.getValidString((String)db.getName(), null, (int)-1);
            if (modelName == null) {
                modelName = db.getName();
            }
            if (!StringUtil.isEmpty((String)(modelName = FileUtils.toFileNameWithExtension((String)modelName, (String)".xmi"))) && ResourcesPlugin.getWorkspace().validateName(modelName, 1).isOK()) {
                ModelResource model;
                IResource resrc;
                this.setModelName(modelName);
                if (this.folder != null && (resrc = this.folder.findMember(modelName)) != null && (model = JdbcRelationalUtil.getPhysicalModifiableRelationalModel((Object)resrc)) != null) {
                    this.importer.setUpdatedModel(model);
                }
            }
        }
    }

    public StateManager getStateManager() {
        return this.manager;
    }

    class ProcessorPack {
        private RelationalModelProcessor rmpProcessor;
        private JdbcSource src;
        private IFile modelFile;
        private ModelResource resrc;

        public ProcessorPack() {
        }

        public ProcessorPack(RelationalModelProcessor rmpProcessor, JdbcSource src, IFile modelFile, ModelResource resrc) {
            this.rmpProcessor = rmpProcessor;
            this.src = src;
            this.modelFile = modelFile;
            this.resrc = resrc;
        }

        public void setProcessor(RelationalModelProcessor rmpProcessor) {
            this.rmpProcessor = rmpProcessor;
        }

        public RelationalModelProcessor getProcessor() {
            return this.rmpProcessor;
        }

        public void setJdbcSource(JdbcSource src) {
            this.src = src;
        }

        public JdbcSource getJdbcSource() {
            return this.src;
        }

        public void setModelFile(IFile modelFile) {
            this.modelFile = modelFile;
        }

        public IFile getModelFile() {
            return this.modelFile;
        }

        public void setModelResource(ModelResource resrc) {
            this.resrc = resrc;
        }

        public ModelResource getModelResource() {
            return this.resrc;
        }
    }

    private static class XClassAndXAttribute {
        XClass xClass;
        XAttribute xAttribute;

        XClassAndXAttribute(XClass xClass, XAttribute xAttribute) {
            this.xClass = xClass;
            this.xAttribute = xAttribute;
        }
    }
}

